<?php
/* Inferno Quiz Auto Installer */


// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: install_vbchat.php,v $ - $Revision: 1.0 $');
define('NO_REGISTER_GLOBALS', 1);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

require_once('./global.php');
require_once('./includes/adminfunctions_template.php');

function xml_import_quiz($xml = false, $styleid = -1, $parentid = -1, $title = '', $anyversion = 0, $displayorder = 1, $userselect = 1)
{
	global $DB_site, $vboptions, $curtag, $counter, $arr, $styleinfo, $vbphrase;


	// initialize vars
	$intemplate = 0;
	$counter = 0;
	$curtag = '';
	$arr = array();

	// create parser
	$parser = xml_parser_create();

	// set parser options
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	xml_set_element_handler($parser, 'xml_parse_style_otag', 'xml_parse_style_ctag');
	xml_set_character_data_handler($parser, 'xml_parse_style_cdata');

	// parse the XML
	if (!@xml_parse($parser, $xml))
	{
		print_dots_stop();
		print_stop_message('xml_error_x_at_line_y', xml_error_string(xml_get_error_code($parser)), xml_get_current_line_number($parser));
	}

	// free the parser
	xml_parser_free($parser);

	if (empty($arr))
	{
		print_dots_stop();
		print_stop_message('invalid_or_empty_style_file');
	}

	$version = $styleinfo['vbversion'];
	$title = iif(empty($title), $styleinfo['title'], $title);


	




	$querybits = array();
	$querytemplates = 0;

	require_once('./includes/functions_xml.php');
	foreach($arr AS $title => $template)
	{
		$title = addslashes($title);
		$template['template'] = addslashes(xml_unescape_cdata($template['template']));
		$template['username'] = addslashes(xml_unescape_cdata($template['username']));

		if ($template['templatetype'] != 'template')
		{
			// template is a special template
			$querybits[] = "($styleid, '$template[templatetype]', '$title', '$template[template]', '', $template[dateline], '$template[username]', '" . addslashes($template['version']) . "')";
		}
		else
		{
			// template is a standard template
			$querybits[] = "($styleid, '$template[templatetype]', '$title', '" . addslashes(compile_template(stripslashes($template['template']))) . "', '$template[template]', $template[dateline], '$template[username]', '" . addslashes($template['version']) . "')";
		}
	}

	// insert any remaining templates
	if (!empty($querybits))
	{
		$DB_site->query("
			REPLACE INTO " . TABLE_PREFIX . "template
			(styleid, templatetype, title, template, template_un, dateline, username, version)
			VALUES
			" . implode(',', $querybits) . "
		");
	}


}

class SystemRoutine{
var $options = array(
			'Fresh'     => '   ',
			'Upgrade_1' => '  (  v1.x  v2.0 )',
			'Uninstall' => '   ( v2.0  )',
			'Template' => '     ',
		);
var $queries = array();

	function buildQueries(){
	$this->queries[] = array(
			'type'      => array('Fresh'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz` (
`qid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`q_name` VARCHAR( 255 ) NOT NULL default '0',
`q_state` TINYINT( 2 ) NOT NULL default '0',
`q_perms` text not null,
`q_start` int(15) not null default '0',
`q_end` int(15) not null default '0',
`q_autoend` tinyint(2) not null default '0',
`q_timelimit` int(8) not null default '0',
`q_viewanswer` tinyint(2) not null default '0',
PRIMARY KEY ( `qid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz",
			);
	$this->queries[] = array(
			'type'      => array('Fresh'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_questions` (
`qqid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`q_question` text NOT NULL default '',
`q_type` varchar(255) NOT NULL default '',
`q_params` text not null,
`q_forquiz` int(15) not null default '0',
PRIMARY KEY ( `qqid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_questions",
			);
	$this->queries[] = array(
			'type'      => array('Fresh'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_results` (
`rid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`r_data` text NOT NULL default '',
`r_userid` int(15) not null default '0',
`r_score` int(4) not null default '0',
`r_forquiz` int(15) not null default '0',
PRIMARY KEY ( `rid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_results",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "alter table {TABLE_PREFIX}quiz
add `q_image` varchar(255) not null default ''",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "alter table {TABLE_PREFIX}quiz
add `q_desc` varchar(255) not null default ''",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "alter table {TABLE_PREFIX}quiz
add `q_forcat` int(15) not null default '0'",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "update {TABLE_PREFIX}quiz set q_forcat = 1",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_category` (
`cid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`c_name` VARCHAR( 255 ) NOT NULL default '',
`c_desc` VARCHAR( 255 ) NOT NULL default '',
`c_num` int(15) not null default '0',
PRIMARY KEY ( `cid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_category",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_submissions` (
`sid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`s_from` INT( 15 ) NOT NULL default '0',
`s_name` VARCHAR( 255 ) NOT NULL default '',
`s_desc` VARCHAR( 255 ) NOT NULL default '',
`s_image` VARCHAR( 255 ) NOT NULL default '',
`s_data` mediumtext not null default '',
`s_cat` INT( 15 ) NOT NULL default '0',
PRIMARY KEY ( `sid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_submissions",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "insert into {TABLE_PREFIX}quiz_category (`cid`,`c_name`,`c_desc`) values (1,' ','   ')",
			'uninstall' => "",
			);
	}

	function killQuizTemplates($DB,$TablePrefix){
	$DB->query("delete from `{$TablePrefix}template` where `title` LIKE '%quiz%'");
	}

	function installQuizTemplates($DB,$TablePrefix,$XML){

	$All_Styles = $DB->query("select styleid from {$TablePrefix}style where parentid < 0"); // Grab master styles only

		while($SID = $DB->fetch_array($All_Styles)){
		$ID[] = $SID['styleid'];
		}

		foreach($ID as $StyleID){
		xml_import_quiz($XML,$StyleID);
		}

	define('NO_POST_EDITOR_BUILD', true);
	build_all_styles();
	}

	function runQueries($DB,$Type,$Action,$TablePrefix){
	$this->buildQueries();

	$OurQueries = array();

		foreach($this->queries as $Q){
			if(in_array($Type,$Q['type'])){
				if(trim($Q[$Action]) != ''){
				$DB->query(trim(str_replace('{TABLE_PREFIX}',$TablePrefix,$Q[$Action])));
				}
			}
		}
	}

	function run_Fresh($DB,$Type,$XML,$TablePrefix){
	$this->installQuizTemplates($DB,$TablePrefix,$XML);
	$this->runQueries($DB,$Type,'install',$TablePrefix);
	}

	function run_Upgrade_1($DB,$Type,$XML,$TablePrefix){
	$this->killQuizTemplates($DB,$TablePrefix);
	$this->installQuizTemplates($DB,$TablePrefix,$XML);
	$this->runQueries($DB,$Type,'install',$TablePrefix);
	}

	function run_Uninstall($DB,$Type,$XML,$TablePrefix){
	$this->killQuizTemplates($DB,$TablePrefix);
	$this->runQueries($DB,'Fresh','uninstall',$TablePrefix);
	}

	function run_Template($DB,$Type,$XML,$TablePrefix){
	$this->killQuizTemplates($DB,$TablePrefix);
	$this->installQuizTemplates($DB,$TablePrefix,$XML);
	}

}

$Engine = new SystemRoutine;

print_cp_header(" ");

$Options = "";

	foreach($Engine->options as $val => $Opt){
	$Options .= "<option value='{$val}'>{$Opt}</option>\n";
	}

if ($_POST['do']==""){
	print_form_header('install_quiz', 'install_type');
	print_table_header(" ");
	print_description_row("
	     ...       .
	<select name='itype' class='button'>
	{$Options}
	</select>
	");
	print_submit_row("", 0);
	
}

// #############################################################################
// Install Type
if ($_POST['do']=="install_type"){

	if($Engine->options[$_POST['itype']]){

	$Type = $Engine->options[$_POST['itype']];

		print_form_header('install_quiz', '');
		print_table_header(" ");
		echo "<input type='hidden' value='{$_POST['itype']}' name='type' />";
		print_description_row("   '{$Type}'.    ");
		print_submit_row("", 0);
	} else {
		print_form_header('install_quiz', '');
		print_table_header("");
		print_description_row("   ...    ");
		print_submit_row("", 0);
	}

}

// #############################################################################
// step 1
if($_POST['do'] == ""){
require_once("./includes/adminfunctions_template.php");



	print_form_header('', '');
	print_table_header(" ");
	print_description_row("   ...   .");

		if(!($xml = file_read('./'.$admincpdir.'/quiz.xml'))){
		echo " - /{$admincpdir}/quiz.xml   -     .";
		exit;
		}

	$Type = $_POST[type];

		switch($Type){

		case 'Fresh':
		$Engine->run_Fresh($DB_site,$Type,$xml,TABLE_PREFIX);
		break;

		case 'Upgrade_1':
		$Engine->run_Upgrade_1($DB_site,$Type,$xml,TABLE_PREFIX);
		break;

		case 'Uninstall':
		$Engine->run_Uninstall($DB_site,$Type,$xml,TABLE_PREFIX);
		break;

		case 'Template':
		$Engine->run_Template($DB_site,$Type,$xml,TABLE_PREFIX);
		break;

		default:
		print_description_row("<i>   </i>");
		break;
		}

	print_description_row("<b>  </b>");
}
?>