<?php
/*======================================================================*\
|| #################################################################### ||
|| # Inferno Quiz v2.1 By Zero Tolerance [http://gzevolution.net]	||
|| #################################################################### ||
\*======================================================================*/

// ######################### ERROR REPORTING #############################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'admin_quiz');

require_once('./global.php');
require_once('./includes/functions_misc.php');
require_once('./includes/functions_bbcodeparse.php');

// ----------------------------
// What? It's easier to type...
// ----------------------------

$DB=$DB_site;

// ----------------------------
// Call System Engine
// ----------------------------

require_once("./includes/engine.quiz.php");

$Engine = new Quiz_Engine;

// ----------------------------
// Globalize CP Header
// ----------------------------

$cp_header_title = " ";

	if($_POST['do'] != "do_download_export"){
	print_cp_header($cp_header_title);
	}

// ----------------------------
// Globalize Functions
// ----------------------------


function Print_My_DDM($text="",$select_name="",$the_array="",$field_value="",$id=""){

// Build Up Menu
$Menu="";
	if(is_array($the_array)){ // Array Isn't Empty
		foreach($the_array as $menu){
			if($menu[0]==$field_value){
			$Menu.="<option value='{$menu[0]}' selected>{$menu[1]}</option>";
			} else {
			$Menu.="<option value='{$menu[0]}'>{$menu[1]}</option>";
			}		
		}
	}
// Output Menu
print_label_row("{$text}", '<select name="'.$select_name.'" class="bginput" id="'.$id.'">'.$Menu.'</select>');
}

function Print_Deletion_Confirmation($action="",$title="",$id=0,$text=""){

	print_form_header(THIS_SCRIPT, $action);
	print_table_header($title);
	echo "<input type='hidden' name='id' value='{$id}'>";
	print_yes_no_row("{$text}<dfn>     </dfn>", 'verify','');
	print_submit_row(" ", 0);
	print_cp_footer();
	exit;

}

	// ---------------------------------------------------
	// Start Globalized Function - SendPM
	// ---------------------------------------------------

	function SendPM($message,$title,$to,$from){
	global $DB;

	// Parse It Out
	$title   = addslashes(htmlspecialchars_uni(fetch_censored_text($title)));
	$message = addslashes(fetch_censored_text($message));
	$to      = $DB->query_first("select * from ".TABLE_PREFIX."user where userid='{$to}'");   // Grab Member Its Going TO
	$from    = $DB->query_first("select * from ".TABLE_PREFIX."user where userid='{$from}'"); // Grab Member Its Coming FROM

	// Insert The Message
	$to_string["$to[userid]"] = $to['username'];
	$now=time();


	$DB->query("insert into ".TABLE_PREFIX."pmtext (fromuserid,fromusername,title,message,touserarray,iconid,dateline,showsignature,allowsmilie) values ('{$from['userid']}','".addslashes($from['username'])."','{$title}','{$message}','".addslashes(serialize($to_string))."','4','{$now}','1','1')");

	// id thingy
	$DB->query("insert into ".TABLE_PREFIX."pm (pmtextid, userid) values (".$DB->insert_id().", '{$to['userid']}')");
	// Update pm count
	$DB->shutdown_query("update ".TABLE_PREFIX."user set pmtotal=pmtotal+'1',pmunread=pmunread+'1' WHERE userid='{$to['userid']}'");
	}

	// ---------------------------------------------------
	// End Globalized Function - SendPM
	// ---------------------------------------------------

	function encQuote($Text = ""){
	return str_replace('&quot;','"',$Text);
	}

// ###################### Main Quiz Settings ########################
if ($_GET['do'] == "quiz_settings") {

require_once('./includes/settings.quiz.php');

$_SETTINGS['AllowedUsergroups'] = explode(',',$_SETTINGS['AllowedUsergroups']);

	// ----------------------------
	// Engine And Permissions Ignitation
	// ----------------------------

	$Engine->getUsergroups();

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_quiz_settings');
	print_table_header("  ");

	// ----------------------------
	// Table Content
	// ----------------------------

	$UBuild = "";

		if(is_array($Engine->Usergroups)){
			foreach($Engine->Usergroups as $U){
			$UBuild .= "<tr>
			<td align='right'><input type='checkbox' class='bginput' name='allowsubmit[{$U['usergroupid']}]' ".iif(@in_array($U['usergroupid'],$_SETTINGS['AllowedUsergroups']),'checked="checked"')." /></td>
			<td align='right' width='100%' nowrap><b>{$U['title']}</b></td>
			</tr>";
			}
		}

	print_description_row("<center>
	<b>      </b><br />
	<table width='100%' border='0' cellpadding='3' cellspacing='0'>
	{$UBuild}
	</table>
	</center>");


	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("", 0);
	print_cp_footer();
	exit;

}


// ###################### Do Main Quiz Settings ########################
if ($_POST['do'] == "do_quiz_settings") {

require_once('./includes/settings.quiz.php');

	if(is_array($_POST['allowsubmit'])){
	$Data = implode(',',array_keys($_POST['allowsubmit']));
	} else {
	$Data = "";
	}

$Find    = "\$_SETTINGS['AllowedUsergroups'] = \"".$_SETTINGS['AllowedUsergroups']."\";";
$Replace = "\$_SETTINGS['AllowedUsergroups'] = \"".$Data."\";";

$CurrentData = $Engine->openSettingsFile('./includes/settings.quiz.php');

	if(!strpos($CurrentData,$Find)){
	echo "        settings.quiz.php ,     includes  777    settings.quiz.php  666 .";
	exit;
	}

$CurrentData = str_replace($Find,$Replace,$CurrentData);

$Engine->saveSettingsFile('./includes/settings.quiz.php',$CurrentData);

	$Engine->Redirect(
	"  ",
		array(
			array("   ","?do=quiz_settings"),
		)
	);

}

// ###################### Inferno Quiz Submissions Moderation ########################
if ($_GET['do'] == "submissions") {

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_table_start();
	print_table_header("  ",6);

	// ----------------------------
	// Table Content
	// ----------------------------

	print_cells_row(array(
	"<b> </b>",
	"<b>   </b>",
	"<b></b>",
	"<b></b>",
	"<b>{$vbphrase[delete]}</b>",
	),'thead','','',1);

	$Any = false;

	$GSub = $DB->query("select s.*,u.username from ".TABLE_PREFIX."quiz_submissions s left join ".TABLE_PREFIX."user u on(u.userid=s.s_from)");

		while($Sub = $DB->fetch_array($GSub)){
		$Any = true;
		print_cells_row(array(
		"<b>{$Sub['s_name']}</b>",
		"<a href='{$vboptions['bburl']}/member.php?u={$Sub['s_from']}' target='_blank'>{$Sub['username']}</a>",
		"<a href='?do=allowsub&id={$Sub['sid']}'></a>",
		"<a href='?do=viewsub&id={$Sub['sid']}'> </a>",
		"<a href='?do=deletesub&id={$Sub['sid']}'>{$vbphrase[delete]}</a>",
		),'','','',1);
		}


		if(!$Any){
		print_description_row("<center><i>    </i></center>",0,5);
		}


	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_table_footer();
	print_cp_footer();
	exit;
}

// ###################### Inferno Quiz View Submission Details ########################
if ($_GET['do'] == "viewsub") {

	// ----------------------------
	// Assume The Submission Exists
	// ----------------------------

	if(!$sub = $DB->query_first("select s.*,c.c_name from ".TABLE_PREFIX."quiz_submissions s left join ".TABLE_PREFIX."quiz_category c on(c.cid=s.s_cat) where s.sid = '".intval($_GET['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_table_start();
	print_table_header("  : {$sub['s_name']}");

	// ----------------------------
	// Table Content
	// ----------------------------

	$Image = ($sub['s_image'] != '')? " - <a href='{$vboptions['bburl']}/images/quiz/{$sub['s_image']}' target='_blank'></a>" : "";

	$Build = "
	<table width='100%' border='0' cellspacing='0' cellpadding='3'>
	<tr>
	<td width='100%'><b>  :</b></td>
	<td style='white-space:nowrap'>{$sub['s_name']}</td>
	</tr>
	<tr>
	<td width='100%'><b>   :</b></td>
	<td style='white-space:nowrap'>{$sub['s_desc']}</td>
	</tr>
	<tr>
	<td width='100%'><b> :</b></td>
	<td style='white-space:nowrap'>{$sub['c_name']}</td>
	</tr>
	<tr>
	<td width='100%'><b>  :</b></td>
	<td style='white-space:nowrap'>{$Image}</td>
	</tr>
	<%{QUESTION_DATA}%>
	</table>
	";

	$QFT['TextBox'] = ' ';
	$QFT['Radio'] = '    ';
	$QFT['Multi'] = '    ';

	// Parse Questions Into View And Replace Macro With Data
	$Q     = unserialize($sub['s_data']);
	$QData = "";

	

		if(is_array($Q)){
			foreach($Q as $key => $Question){
			$QData .= "<tr>
			<td colspan='2' align='center'><b> {$key}</b></td>
			</tr>
			<tr>
			<td colspan='2'>
				<fieldset>
				<legend> : {$Question['Q']}</legend>
				<table width='100%' border='0' cellspacing='0' cellpadding='3'>
				<tr>
				<td width='100%'><b> :</b></td>
				<td style='white-space:nowrap'>{$QFT[$Question['Type']]}</td>
				</tr>
				<tr>
				<td width='100%'><b>  :</b> (     )</td>
				<td style='white-space:nowrap'>".@implode(', ',explode("\n",$Question['Options']))."</td>
				</tr>
				<tr>
				<td width='100%'><b>  :</b></td>
				<td style='white-space:nowrap'>".@implode(', ',explode("\n",$Question['Answer']))."</td>
				</tr>
				<tr>
				<td width='100%'><b>   </b></td>
				<td style='white-space:nowrap'>".iif($Question['QA'],'Yes','No')."</td>
				</tr>
				</table>
				</fieldset>
			</td>
			</tr>
			";
			}
		}

	// Swap Macro
	$Build = str_replace("<%{QUESTION_DATA}%>",$QData,$Build);

	print_description_row($Build);

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_table_footer();
	print_cp_footer();
	exit;

}


// ###################### Inferno Quiz Allow Submission Details ########################
if ($_GET['do'] == "allowsub") {

	// ----------------------------
	// Assume The Submission Exists
	// ----------------------------

	if(!$sub = $DB->query_first("select s.*,c.c_name from ".TABLE_PREFIX."quiz_submissions s left join ".TABLE_PREFIX."quiz_category c on(c.cid=s.s_cat) where s.sid = '".intval($_GET['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// Insert Quiz
	$DB->query("insert into ".TABLE_PREFIX."quiz
	(q_name,q_state,q_desc,q_forcat,q_image)
	values
	('".addslashes($sub['s_name'])."',0,'". addslashes($sub['s_desc'])."',{$sub['s_cat']},'{$sub['s_image']}')");


	$ID        = $DB->insert_id();
	$Q         = unserialize($sub['s_data']);
	$QueryBits = array();

	if(is_array($Q)){
		foreach($Q as $Question){

			if($Question['Type'] == 'TextBox'){
			$Params = array(
					'answer'      => $Question['Answer'],
					'part_answer' => $Question['QA'],
				);
			} else if($Question['Type'] == 'Radio'){
			$Params = array(
					'options' => $Question['Options'],
					'answer'  => $Question['Answer'],
				);
			} else {
			$Params = array(
					'options' => $Question['Options'],
					'answers' => $Question['Answer'],
				);
			}

		$QueryBits[] = "('".addslashes($Question['Q'])."','".addslashes($Question['Type'])."','".addslashes(serialize($Params))."',$ID)";
		}
	}

	// Insert Questions
	$DB->query("insert into ".TABLE_PREFIX."quiz_questions
	(q_question,q_type,q_params,q_forquiz)
	values
	".implode(',',$QueryBits)."");

	// Delete submission entry
	$DB->query("delete from ".TABLE_PREFIX."quiz_submissions where sid='{$sub['sid']}'");

	$Engine->Redirect(
	"    ",
		array(
			array(" ","?do=editquiz&id={$ID}"),
		)
	);

}

// ###################### Inferno Quiz Delete Quiz Submission ########################
if ($_GET['do'] == "deletesub") {

	// ----------------------------
	// Assume The Submission Exists
	// ----------------------------

	if(!$sub = $DB->query_first("select s.*,c.c_name from ".TABLE_PREFIX."quiz_submissions s left join ".TABLE_PREFIX."quiz_category c on(c.cid=s.s_cat) where s.sid = '".intval($_GET['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Deletion Confirmation
	// ----------------------------

	Print_Deletion_Confirmation("do_delete_sub","   : <b>{$sub['s_name']}</b>",$sub['sid'],"         ");

}

// ###################### Inferno Quiz Delete Quiz Submission ########################
if ($_POST['do'] == "do_delete_sub") {

	// ----------------------------
	// Assume The Submission Exists
	// ----------------------------

	if(!$sub = $DB->query_first("select s.*,c.c_name from ".TABLE_PREFIX."quiz_submissions s left join ".TABLE_PREFIX."quiz_category c on(c.cid=s.s_cat) where s.sid = '".intval($_POST['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Did we want to delete?
	// ----------------------------

	if($_POST['verify']){

	// ----------------------------
	// Yes we did...
	// ----------------------------

	$DB->query("delete from ".TABLE_PREFIX."quiz_submissions where sid='{$sub['sid']}'");
	@unlink(str_replace( '\\', '/', getcwd() ) . "/images/quiz/{$sub['s_image']}");

	$Engine->Redirect(
	"   ",
		array(
			array("      ","?do=submissions"),
		)
	);

	} else {

	// ----------------------------
	// No we didn't...
	// ----------------------------

	$Engine->Redirect(
	"   ",
		array(
			array("   ","?do=viewsub&id={$sub['sid']}"),
			array("      ","?do=submissions"),
		)
	);

	}
}

// ###################### Inferno Quiz Category ########################
if ($_GET['do'] == "cat") {

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'add_cat');
	print_table_header("  ",6);

	// ----------------------------
	// Table Content
	// ----------------------------

	print_cells_row(array(
	"<b> </b>",
	"<b>  </b>",
	"<b>{$vbphrase[edit]}</b>",
	"<b>{$vbphrase[delete]}</b>",
	),'thead','','',1);

	$Engine->getQuizCategories();

		if(is_array($Engine->QuizCat) && !empty($Engine->QuizCat)){
			foreach($Engine->QuizCat as $id => $Cat){
			print_cells_row(array(
			"<b>{$Cat[1]}</b>",
			"{$Cat[3]}",
			"<a href='?do=editcat&id={$id}'>{$vbphrase[edit]}</a>",
			"<a href='?do=deletecat&id={$id}'>{$vbphrase[delete]}</a>",
			),'','','',1);
			}

		} else {
		print_description_row("<center><i>   </i></center>",0,5);
		}


	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("  ",0,6);
	print_cp_footer();
	exit;
}



// ###################### Do Inferno Add Category ########################
if ($_POST['do'] == "add_cat" || $_GET['do'] == "add_cat") {

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_add_cat');
	print_table_header(" ");

	// ----------------------------
	// Table Content
	// ----------------------------

	print_input_row(" ", 'c_name','');
	print_input_row("  ", 'c_desc','');

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row(" ", 0);
	print_cp_footer();
	exit;

}

// ###################### Do Add Quiz Category ########################
if ($_POST['do'] == "do_add_cat") {

	globalize($_POST,
		array(
			'c_name' => STR_NOHTML,
			'c_desc' => STR_NOHTML,
		)
	);

	$c_name  = trim(addslashes($c_name));
	$c_desc  = trim(addslashes($c_desc));

	$DB->query("insert into ".TABLE_PREFIX."quiz_category
	(c_name,c_desc)
	values
	('{$c_name}','{$c_desc}')");

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=add_cat"),
			array("   ","?do=add_quiz"),
			array("  ","?do=cat"),
		)
	);

}

// ###################### Inferno Quiz Edit Category ########################
if ($_GET['do'] == "editcat") {

	// ----------------------------
	// Assume The Category Exists
	// ----------------------------

	if(!$cat = $DB->query_first("select * from ".TABLE_PREFIX."quiz_category where cid = '".intval($_GET['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_edit_cat');
	echo "<input type='hidden' name='id' value='{$cat['cid']}' />";
	print_table_header(" ");

	// ----------------------------
	// Table Content
	// ----------------------------

	print_input_row(" ", 'c_name',encQuote($cat['c_name']));
	print_input_row("  ", 'c_desc',encQuote($cat['c_desc']));

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("", 0);
	print_cp_footer();
	exit;

}


// ###################### Do Edit Quiz Category ########################
if ($_POST['do'] == "do_edit_cat") {

	globalize($_POST,
		array(
			'c_name' => STR_NOHTML,
			'c_desc' => STR_NOHTML,
			'id'     => INT,
		)
	);

	// ----------------------------
	// Assume The Category Exists
	// ----------------------------

	if(!$cat = $DB->query_first("select * from ".TABLE_PREFIX."quiz_category where cid = '{$id}'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	$c_name  = trim(addslashes($c_name));
	$c_desc  = trim(addslashes($c_desc));

	$DB->query("update ".TABLE_PREFIX."quiz_category
	set c_name='{$c_name}',c_desc='{$c_desc}'
	where cid='{$id}'");

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=editcat&id={$id}"),
			array("  ","?do=add_cat"),
			array("   ","?do=add_quiz"),
			array("  ","?do=cat"),
		)
	);

}

// ###################### Inferno Quiz Delete Category ########################
if ($_GET['do'] == "deletecat") {

	// ----------------------------
	// Assume The Category Exists
	// ----------------------------

	if(!$cat = $DB->query_first("select * from ".TABLE_PREFIX."quiz_category where cid = '".intval($_GET['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	$OtherCats = $DB->query("select * from ".TABLE_PREFIX."quiz_category where cid <> $cat[cid] order by c_name");
	$ShowOpt   = false;

		while($Cat = $DB->fetch_array($OtherCats)){
		$Cats[] = $Cat;
		}

		if(is_array($Cats)){
		$ShowOpt = true;
		$Build = "";

			foreach($Cats as $OC){
			$Build .= "<option value='{$OC['cid']}'>{$OC['c_name']}</option>\n";
			}

		$Build = "<select name='move_to' class='bginput'>{$Build}</select>";
		}

	// ----------------------------
	// Deletion Confirmation
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_delete_cat');
	print_table_header("  : {$cat['c_name']}");
	echo "<input type='hidden' name='id' value='{$cat['cid']}'>";
	print_yes_no_row("       ?<dfn>     </dfn>", 'verify','');

		if($ShowOpt){
		print_cells_row(array(
		"      ",
		"<select name='manage' class='bginput'><option value='move'>    </option><option value='delete'>      </option></select>",
		),'','','',1);
		print_cells_row(array(
		"       <dfn>      </dfn>",
		"{$Build}",
		),'','','',1);
		} else {
		print_description_row("       .            !");
		}

	print_submit_row("", 0);
	print_cp_footer();
	exit;

}


// ###################### Inferno Quiz Delete Category ########################
if ($_POST['do'] == "do_delete_cat") {

	// ----------------------------
	// Assume The Category Exists
	// ----------------------------

	if(!$cat = $DB->query_first("select * from ".TABLE_PREFIX."quiz_category where cid = '".intval($_POST['id'])."'")){
	echo "       [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Did we want to delete?
	// ----------------------------

	if($_POST['verify']){

	// ----------------------------
	// Yes we did...
	// ----------------------------

		if($_POST['manage'] == 'move'){
			if(!$MoveTo = $DB->query_first("select * from ".TABLE_PREFIX."quiz_category where cid = '".intval($_POST['move_to'])."'")){
			echo "       [<a href='javascript:history.go(-1);'></a>]";
			exit;
			}

		// Move Quizzes
		$DB->query("update ".TABLE_PREFIX."quiz set q_forcat='{$MoveTo['cid']}' where q_forcat='{$cat['cid']}'");

		} else {
		$Quizzes = $DB->query("select qid from ".TABLE_PREFIX."quiz where q_forcat='{$cat['cid']}'");

			while($QuizDel = $DB->fetch_array($Quizzes)){
			$ToDel[] = $QuizDel['qid'];
			}

			if(is_array($ToDel)){
			$Engine->DeleteQuiz($ToDel);
			}

		}

	$DB->query("delete from ".TABLE_PREFIX."quiz_category where cid='{$cat['cid']}'");

	$Engine->rebuildCatStats();

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=add_cat"),
			array("  ","?do=cat"),
		)
	);

	} else {

	// ----------------------------
	// No we didn't...
	// ----------------------------

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=editcat&id={$cat['cid']}"),
			array("  ","?do=add_cat"),
			array("   ","?do=add_quiz"),
			array("  ","?do=cat"),
		)
	);

	}
}


// ###################### Inferno Quiz Main ########################
if ($_POST['do'] == "" && $_GET['do'] == "") {

echo "
<script type='text/javascript'>
<!--
	function doFastMod(){
		if(confirm('     ')){
		document.forms['cpform'].getElementsByTagName('input')[0].value = 'quiz_fast_mod'
		document.forms['cpform'].getElementsByTagName('input')[1].value = document.getElementById('fm').options[document.getElementById('fm').options.selectedIndex].value
		document.forms['cpform'].submit(true)
		} else {
		return false
		}
	}
-->
</script>

";

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'add_quiz');
	echo "<input type='hidden' name='fast_mod' />";
	print_table_header("  ",6);

	// ----------------------------
	// Table Content
	// ----------------------------

	print_cells_row(array(
	"<b>  </b>",
	"<b></b>",
	"<b> </b>",
	"<b>{$vbphrase[edit]}</b>",
	"<b>{$vbphrase[delete]}</b>",
	"",
	),'thead','','',1);

	$added = false;

	$Get_Quiz = $DB->query("select * from ".TABLE_PREFIX."quiz order by qid");

		while($Quiz = $DB->fetch_array($Get_Quiz)){
		$added = true;

			if($Quiz['q_state']){
			$Quiz['q_state'] = " ";
			} else {
			$Quiz['q_state'] = " ";
			}

			if($Quiz['q_autoend']){
			$Quiz['q_autoend'] = date('F',$Quiz['q_end']) . " " . date('j',$Quiz['q_end']) . " " . date('Y',$Quiz['q_end']);
			} else {
			$Quiz['q_autoend'] = " ";
			}

			if($Quiz['q_image'] != ''){
			$Quiz['q_image'] = "<img src='{$vboptions[bburl]}/images/quiz/{$Quiz['q_image']}' alt='{$Quiz['q_name']}' /> ";
			}

		print_cells_row(array(
		"{$Quiz['q_image']}<b>{$Quiz['q_name']}</b>",
		"{$Quiz['q_state']}",
		"{$Quiz['q_autoend']}",
		"<a href='?do=editquiz&id={$Quiz['qid']}'>{$vbphrase[edit]}</a>",
		"<a href='?do=deletequiz&id={$Quiz['qid']}'>{$vbphrase[delete]}</a>",
		"<input type='checkbox' name='fastmod[{$Quiz[qid]}]' value='{$Quiz[qid]}' />",
		),'','','',1);

		}

		if(!$added){
		print_description_row("<center><i>  </i></center>",0,5);
		}


	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row(" ",0,6);

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_table_start();
	print_table_header("  ",5);

	// ----------------------------
	// Table Content
	// ----------------------------

	print_cells_row(array(
	"",
	"<b></b>",
	),'thead','','',1);

	$fastmod[] = array('open',' ');
	$fastmod[] = array('close',' ');
	$fastmod[] = array('delete',' ');

	$Display  = '<input type="button" class="button" tabindex="1" value="" accesskey="s" onclick="doFastMod();" />';

	Print_My_DDM('   ','fast_mod',$fastmod,-1,'fm');
	print_description_row($Display, 0, 2, 'tfoot','center');

	print_table_footer();

	print_cp_footer();
	exit;
}


// ###################### Quiz Quick Moderation ########################
if ($_POST['do'] == "quiz_fast_mod") {

	globalize($_POST,
		array(
			'fastmod',
			'fast_mod' => STR,
		)
	);

	if(!is_array($fastmod)){
	echo "     [<a href='javascript:history.go(-1)'></a>]";
	exit;
	}

	if($fast_mod == 'open'){
	$DB->query("update ".TABLE_PREFIX."quiz set q_state = 1 where qid IN(".implode(',',$fastmod).")");
	$Msg = "  ";
	} else if($fast_mod == 'close'){
	$DB->query("update ".TABLE_PREFIX."quiz set q_state = 0 where qid IN(".implode(',',$fastmod).")");
	$Msg = "  ";
	} else {
	$Engine->DeleteQuiz($fastmod);
	$Msg = "   ";
	$Engine->rebuildCatStats();
	}

	$Engine->Redirect(
	"$Msg",
		array(
			array(" ","?do=add_quiz"),
			array(" ","?"),
		)
	);

}


// ###################### Do Inferno Quiz Add Quiz ########################
if ($_POST['do'] == "add_quiz" || $_GET['do'] == "add_quiz") {

	// ----------------------------
	// Engine And Permissions Ignitation
	// ----------------------------

	$Engine->getQuizCategories();
	$Engine->getUsergroups();
	$Engine->Build_Perm_JS_Engine();
	$Particpate  = $Engine->Admin_Quiz_Perms($Engine->Usergroups);
	$ViewResults = $Engine->Admin_Quiz_Perms($Engine->Usergroups,"Results");
	$TimeEnd     = $Engine->Admin_Quiz_End(time());

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_add_quiz',1, 1);
	print_table_header(" ");

	// ----------------------------
	// Table Content
	// ----------------------------

	$state = array();

	$state[] = array("0"," ");
	$state[] = array("1"," ");

	$autoend = array();

	$autoend[] = array("1","");
	$autoend[] = array("0","");

	$viewanswer = array();

	$viewanswer[] = array("0","");
	$viewanswer[] = array("1","");

	print_input_row(" ", 'q_name','');
	print_input_row("  ", 'q_desc','');
	Print_My_DDM("","q_forcat",$Engine->QuizCat,-1);
	print_upload_row(" <dfn> -    : .gif, .bmp  .png  .jpg  .jpeg</dfn>", 'q_image', 999999999);
	Print_My_DDM(" <dfn>          </dfn>","q_state",$state,-1);

	print_description_row("<center>
	<b>      </b><br />
	{$Particpate}
	</center>");

	print_description_row("<center>
	<b>     </b><br />
	{$ViewResults}
	</center>");

	Print_My_DDM("  ","q_autoend",$autoend,-1);

	print_label_row("  <dfn>       </dfn>", $TimeEnd);
	print_input_row("    <dfn>                  </dfn>", 'q_timelimit','0');
	Print_My_DDM("        ","q_viewanswer",$viewanswer,-1);

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("", 0);
	print_cp_footer();
	exit;

}

// ###################### Do Inferno Quiz Add Quiz ########################
if ($_POST['do'] == "do_add_quiz") {

	globalize($_POST,
		array(
			'q_name'             => STR_NOHTML,
			'q_desc'             => STR_NOHTML,
			'q_forcat'           => INT,
			'q_image',
			'q_state'            => INT,
			'Participate_groups' => STR_NOHTML,
			'Results_groups'     => STR_NOHTML,
			'q_autoend'          => INT,
			'end_month'          => INT,
			'end_day'            => INT,
			'end_year'           => INT,
			'q_timelimit'        => INT,
			'q_viewanswer'       => INT,
		)
	);

	$Image = $_FILES['q_image'];

	if($Image['name'] != ''){

	print_table_start();
	print_table_header(" ",5);

	print_cells_row(array(
	"<b></b>",
	"<b></b>",
	),'thead','','',1);

	$Allowed = array('gif','bmp','png','jpg','jpeg');

	$Ext = explode('.',$Image['name']);
	$Ext = $Ext[count($Ext) - 1];

		if(!in_array($Ext,$Allowed)){
		print_cells_row(array(
		"  : {$Ext}",
		"<font color='red'></font>",
		),'','','',1);
		print_table_footer();
		exit;
		}

	print_cells_row(array(
	"  : {$Ext}",
	"<font color='green'></font>",
	),'','','',1);

	$TargetDir = str_replace( '\\', '/', getcwd() ) . "/images/quiz/";

		if(!is_dir($TargetDir)){
		print_cells_row(array(
		"  {$TargetDir}",
		"<font color='red'> </font>",
		),'','','',1);
		print_table_footer();
		exit;
		}

		if(!@move_uploaded_file($Image['tmp_name'],$TargetDir.$Image['name'])){
		print_cells_row(array(
		" ",
		"<font color='red'></font>",
		),'','','',1);

			if(!@chmod(str_replace( '\\', '/', getcwd() ) . "/images/",0777)){
			print_cells_row(array(
			"CHMOD Directory (0777) ".str_replace( '\\', '/', getcwd() ) . "/images/",
			"<font color='red'></font>",
			),'','','',1);
			}

			if(!@chmod(str_replace( '\\', '/', getcwd() ) . "/images/quiz/",0777)){
			print_cells_row(array(
			"CHMOD Directory (0777) ".str_replace( '\\', '/', getcwd() ) . "/images/quiz/",
			"<font color='red'></font>",
			),'','','',1);
			print_table_footer();
			exit;
			}

			if(!@move_uploaded_file($Image['tmp_name'],$TargetDir.$Image['name'])){
			print_cells_row(array(
			"   ",
			"<font color='red'></font>",
			),'','','',1);
			print_table_footer();
			exit;
			}

		}

	print_cells_row(array(
	"   ",
	"<font color='green'></font>",
	),'','','',1);

		if(!@chmod($TargetDir.$Image['name'],0777)){
		print_cells_row(array(
		"CHMOD Image (0777)",
		"<font color='red'></font>",
		),'','','',1);
		print_table_footer();
		exit;
		}

	print_cells_row(array(
	"CHMOD Image (0777)",
	"<font color='green'></font>",
	),'','','',1);

	print_table_footer();
	
	$q_image = $Image['name'];
	} else {
	$q_image = '';
	}

	$q_name  = trim(addslashes($q_name));
	$q_desc  = trim(addslashes($q_desc));
	$q_image = trim(addslashes($q_image));

	$Perms = array(
		'Participate' => explode(",",$Participate_groups),
		'Results'     => explode(",",$Results_groups),
		);

	$Perms = serialize($Perms);

	$End_Time = mktime(0,0,0,$end_month+1,$end_day,$end_year);

	$DB->query("insert into ".TABLE_PREFIX."quiz
	(q_name,q_state,q_perms,q_start,q_end,q_autoend,q_timelimit,q_viewanswer,q_desc,q_forcat,q_image)
	values
	('{$q_name}',{$q_state},'{$Perms}',".time().",{$End_Time},{$q_autoend},{$q_timelimit},{$q_viewanswer},'{$q_desc}',$q_forcat,'{$q_image}')");

	$Engine->rebuildCatStats();

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=add_quiz"),
			array(" ","?do=add_question"),
			array(" ","?"),
		)
	);

}

// ###################### Inferno Quiz Edit Quiz ########################
if ($_GET['do'] == "editquiz") {

	// ----------------------------
	// Assume The Quiz Exists
	// ----------------------------

	if(!$quiz = $DB->query_first("select * from ".TABLE_PREFIX."quiz where qid = '".intval($_GET['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	$Perms = unserialize($quiz['q_perms']);

	// ----------------------------
	// Engine And Permissions Ignitation
	// ----------------------------

	$Engine->getQuizCategories();
	$Engine->getUsergroups();
	$Engine->Build_Perm_JS_Engine();
	$Particpate  = $Engine->Admin_Quiz_Perms($Engine->Usergroups,"Participate",$Perms);
	$ViewResults = $Engine->Admin_Quiz_Perms($Engine->Usergroups,"Results",$Perms);
	$TimeEnd     = $Engine->Admin_Quiz_End($quiz['q_end']);

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_edit_quiz',1,1);
	print_table_header(" ");

	echo "<input type='hidden' name='qid' value='{$quiz['qid']}' />";

	// ----------------------------
	// Table Content
	// ----------------------------

	$state = array();

	$state[] = array("0"," ");
	$state[] = array("1"," ");

	$autoend = array();

	$autoend[] = array("1","");
	$autoend[] = array("0","");

	$viewanswer = array();

	$viewanswer[] = array("0","");
	$viewanswer[] = array("1","");

	print_input_row(" ", 'q_name',encQuote($quiz['q_name']));
	print_input_row("  ", 'q_desc',encQuote($quiz['q_desc']));
	Print_My_DDM("","q_forcat",$Engine->QuizCat,$quiz['q_forcat']);
		if($quiz['q_image'] != ''){
		print_yes_no_row("   <dfn>        </dfn><br /><img src='{$vboptions[bburl]}/images/quiz/{$quiz['q_image']}' alt='' />", "q_delete",0);
		}
	print_upload_row(" <dfn> -     : .gif  .bmp  .png  .jpg  .jpeg</dfn>", 'q_image', 999999999);
	Print_My_DDM(" <dfn>          </dfn>","q_state",$state,$quiz['q_state']);

	print_description_row("<center>
	<b>      </b><br />
	{$Particpate}
	</center>");

	print_description_row("<center>
	<b>     </b><br />
	{$ViewResults}
	</center>");

	Print_My_DDM("      ","q_autoend",$autoend,$quiz['q_autoend']);

	print_label_row(" <dfn>         </dfn>", $TimeEnd);
	print_input_row("    <dfn>               </dfn>", 'q_timelimit',$quiz['q_timelimit']);
	Print_My_DDM("           ","q_viewanswer",$viewanswer,$quiz['q_viewanswer']);

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("", 0);
	print_cp_footer();
	exit;

}

// ###################### Do Inferno Quiz Edit Quiz ########################
if ($_POST['do'] == "do_edit_quiz") {

	// ----------------------------
	// Assume The Quiz Exists
	// ----------------------------

	if(!$quiz = $DB->query_first("select * from ".TABLE_PREFIX."quiz where qid = '".intval($_POST['qid'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	globalize($_POST,
		array(
			'q_name'             => STR_NOHTML,
			'q_desc'             => STR_NOHTML,
			'q_forcat'           => INT,
			'q_image',
			'q_delete'           => INT,
			'q_state'            => INT,
			'Participate_groups' => STR_NOHTML,
			'Results_groups'     => STR_NOHTML,
			'q_autoend'          => INT,
			'end_month'          => INT,
			'end_day'            => INT,
			'end_year'           => INT,
			'q_timelimit'        => INT,
			'q_viewanswer'       => INT,
		)
	);

	$Image = $_FILES['q_image'];

		if(($q_delete || $Image['name'] != '') && $quiz['q_image'] != ''){
			if(!@unlink(str_replace( '\\', '/', getcwd() ) . "/images/quiz/{$quiz['q_image']}")){
			echo "   -        777";
			exit;
			}

		$quiz['q_image'] = '';
		}


	if($Image['name'] != ''){

	print_table_start();
	print_table_header(" ",5);

	print_cells_row(array(
	"<b></b>",
	"<b></b>",
	),'thead','','',1);

	$Allowed = array('gif','bmp','png','jpg','jpeg');

	$Ext = explode('.',$Image['name']);
	$Ext = $Ext[count($Ext) - 1];

		if(!in_array($Ext,$Allowed)){
		print_cells_row(array(
		"  : {$Ext}",
		"<font color='red'> </font>",
		),'','','',1);
		print_table_footer();
		exit;
		}

	print_cells_row(array(
	"  : {$Ext}",
	"<font color='green'></font>",
	),'','','',1);

	$TargetDir = str_replace( '\\', '/', getcwd() ) . "/images/quiz/";

		if(!is_dir($TargetDir)){
		print_cells_row(array(
		"  {$TargetDir}",
		"<font color='red'> </font>",
		),'','','',1);
		print_table_footer();
		exit;
		}

		if(!@move_uploaded_file($Image['tmp_name'],$TargetDir.$Image['name'])){
		print_cells_row(array(
		" ",
		"<font color='red'></font>",
		),'','','',1);

			if(!@chmod(str_replace( '\\', '/', getcwd() ) . "/images/",0777)){
			print_cells_row(array(
			"CHMOD Directory (0777) ".str_replace( '\\', '/', getcwd() ) . "/images/",
			"<font color='red'></font>",
			),'','','',1);
			}

			if(!@chmod(str_replace( '\\', '/', getcwd() ) . "/images/quiz/",0777)){
			print_cells_row(array(
			"CHMOD Directory (0777) ".str_replace( '\\', '/', getcwd() ) . "/images/quiz/",
			"<font color='red'></font>",
			),'','','',1);
			print_table_footer();
			exit;
			}

			if(!@move_uploaded_file($Image['tmp_name'],$TargetDir.$Image['name'])){
			print_cells_row(array(
			"   ",
			"<font color='red'></font>",
			),'','','',1);
			print_table_footer();
			exit;
			}

		}

	print_cells_row(array(
	"   ",
	"<font color='green'></font>",
	),'','','',1);

		if(!@chmod($TargetDir.$Image['name'],0777)){
		print_cells_row(array(
		"CHMOD Image (0777)",
		"<font color='red'></font>",
		),'','','',1);
		print_table_footer();
		exit;
		}

	print_cells_row(array(
	"CHMOD Image (0777)",
	"<font color='green'></font>",
	),'','','',1);

	print_table_footer();
	
	$q_image = $Image['name'];
	} else {
	$q_image = $quiz['q_image'];
	}

	$q_name = trim(addslashes($q_name));
	$q_desc = trim(addslashes($q_desc));

	$Perms = array(
		'Participate' => explode(",",$Participate_groups),
		'Results'     => explode(",",$Results_groups),
		);

	$Perms = serialize($Perms);

	$End_Time = mktime(0,0,0,$end_month+1,$end_day,$end_year);

	$DB->query("update ".TABLE_PREFIX."quiz
	set q_name='{$q_name}',q_state={$q_state},q_perms='{$Perms}',q_end={$End_Time},q_autoend={$q_autoend},q_timelimit={$q_timelimit},q_viewanswer={$q_viewanswer},q_desc='{$q_desc}',q_forcat=$q_forcat,q_image='{$q_image}'
	where qid='{$quiz['qid']}'");

	$Engine->rebuildCatStats();

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=add_quiz"),
			array("  ","?do=editquiz&id={$quiz['qid']}"),
			array(" ","?do=add_question"),
			array("  ","?"),
		)
	);

}

// ###################### Inferno Quiz Delete Quiz ########################
if ($_GET['do'] == "deletequiz") {

	// ----------------------------
	// Assume The Quiz Exists
	// ----------------------------

	if(!$quiz = $DB->query_first("select * from ".TABLE_PREFIX."quiz where qid = '".intval($_GET['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Deletion Confirmation
	// ----------------------------

	Print_Deletion_Confirmation("do_delete_quiz","  : <b>{$quiz['q_name']}</b>",$quiz['qid'],"         ");

}

// ###################### Inferno Quiz Delete Quiz ########################
if ($_POST['do'] == "do_delete_quiz") {

	// ----------------------------
	// Assume The Quiz Exists
	// ----------------------------

	if(!$quiz = $DB->query_first("select * from ".TABLE_PREFIX."quiz where qid = '".intval($_POST['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Did we want to delete?
	// ----------------------------

	if($_POST['verify']){

	// ----------------------------
	// Yes we did...
	// ----------------------------

	$Engine->DeleteQuiz(array(intval($_POST['id'])));

	$Engine->rebuildCatStats();

	$Engine->Redirect(
	"   ",
		array(
			array(" ","?do=add_quiz"),
			array("  ","?"),
		)
	);

	} else {

	// ----------------------------
	// No we didn't...
	// ----------------------------

	$Engine->Redirect(
	"   ",
		array(
			array(" ","?do=add_quiz"),
			array("  ","?do=editquiz&id={$quiz['qid']}"),
			array(" ","?do=add_question"),
			array("  ","?"),
		)
	);

	}
}


// ###################### Inferno Quiz Questions Main ########################
if ($_GET['do'] == "questions") {

	$Engine->ExpandCollapseJS();

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'add_question');
	print_table_header("  ",4);

	// ----------------------------
	// Table Content
	// ----------------------------

	$QFT = array();

	$QFT['TextBox'] = ' ';
	$QFT['Radio'] = '    ';
	$QFT['Multi'] = '    ';

	$Counter = 0;

		// -------------------------------------------------------------------------------------------------------------------- //
		// QUERY LIMITATION : Output Mass Data In 2 Queries                                                                     //
                //                                                                                                                      //
		                                                                                                                        //
		// Pre-Cache All Quizs                                                                                                  //
		$Get_Quizs = $DB->query("select * from ".TABLE_PREFIX."quiz order by qid");                                             //
		while($quiz = $DB->fetch_array($Get_Quizs)){                                                                            //
		$Quizs[$quiz['qid']] = $quiz;                                                                                           //
		}                                                                                                                       //
                                                                                                                                        //
		// Pre-Cache All Quiz Questions                                                                                         //
		$Get_Questions = $DB->query("select qqid,q_question,q_forquiz,q_type from ".TABLE_PREFIX."quiz_questions order by qqid"); //
		while($question = $DB->fetch_array($Get_Questions)){                                                                    //
		$Questions[$question['qqid']] = $question;                                                                              //
		}                                                                                                                       //
                                                                                                                                        //
		//                                                                                                                      //
		// QUERY LIMITATION : Output Mass Data In 2 Queries                                                                     //
		// -------------------------------------------------------------------------------------------------------------------- //

		if(is_array($Quizs)){
			foreach($Quizs as $tServ){
			$tServ['added'] = false;
			$Counter++;

			print_description_row($Engine->ExpandCollapse($Counter)."<center>{$tServ['q_name']}</center>",0,4,'thead');

			echo "<tbody id='Control_{$Counter}' style='display:none'>";

				if(is_array($Questions)){
				print_cells_row(array(
				"<b></b>",
				"<b> </b>",
				"<b></b>",
				"<b></b>",
				),'thead','','',1);
					foreach($Questions as $tQuest){
						if($tQuest['q_forquiz'] == $tServ['qid']){

						$tQuest['q_question'] = parse_bbcode2(encQuote($tQuest['q_question']), 0, 0, 0, 1);

						$tServ['added'] = true;
						print_cells_row(array(
						"{$tQuest['q_question']}",
						"{$QFT[$tQuest['q_type']]}",
						"<a href='?do=editquestion&id={$tQuest['qqid']}'></a>",
						"<a href='?do=deletequestion&id={$tQuest['qqid']}'></a>",
						),'','','',1);
						}
					}
				}
				if(!$tServ['added']){
				print_description_row("<center><i>  </i></center>",0,4);
				}

			echo "</tbody>";

			}
		}


	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("  ",0,4);
	print_cp_footer();
	exit;
}

// ###################### Inferno Quiz Edit Question ########################
if ($_POST['do'] == "add_question" || $_GET['do'] == "add_question") {

		// Pre-Cache All Quizs
		$Get_Quizs = $DB->query("select * from ".TABLE_PREFIX."quiz order by qid");
		while($quiz = $DB->fetch_array($Get_Quizs)){
		$Quizs[] = array($quiz['sid'],"{$quiz['s_name']}");
		}

		if(!is_array($Quizs)){
		echo "      . [<a href='javascript:history.go(-1);'></a>]";
		exit;
		}

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'add_question_b');
	print_table_header(" ");

	// ----------------------------
	// Table Content
	// ----------------------------

	$QFT = array();

	$QFT[] = array('TextBox',' ');
	$QFT[] = array('Radio','    ');
	$QFT[] = array('Multi','    ');

	Print_My_DDM("  :","format",$QFT,-1);

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("", 0);
	print_cp_footer();
	exit;

}


// ###################### Inferno Quiz Edit Question ########################
if ($_POST['do'] == "add_question_b") {

		// Pre-Cache All Quizs
		$Get_Quizs = $DB->query("select * from ".TABLE_PREFIX."quiz order by qid");
		while($quiz = $DB->fetch_array($Get_Quizs)){
		$Quizs[] = array($quiz['qid'],"{$quiz['q_name']}");
		}

		if(!is_array($Quizs)){
		echo "      . [<a href='javascript:history.go(-1);'></a>]";
		exit;
		}

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_add_question');
	print_table_header(" ");

	echo "<input type='hidden' name='q_type' value='{$_POST['format']}' />";

	// ----------------------------
	// Table Content
	// ----------------------------

	Print_My_DDM("    <dfn>     </dfn>","q_forquiz",$Quizs,-1);
	print_input_row("<dfn>   BB</dfn>", 'q_question','');

	$Engine->Admin_Question_Params($_POST['format']);	

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row(" ", 0);
	print_cp_footer();
	exit;

}


// ###################### Do Inferno Quiz Add Quiz Question ########################
if ($_POST['do'] == "do_add_question") {

	globalize($_POST,
		array(
			'q_question'   => STR_NOHTML,
			'q_forquiz'    => INT,
			'q_type'       => STR_NOTHTML,
			'q_params',
		)
	);

	$q_question = trim(addslashes($q_question));

	$q_params = $Engine->Parse_Answer_Format($q_type,$q_params);

	$DB->query("insert into ".TABLE_PREFIX."quiz_questions
	(q_question,q_forquiz,q_type,q_params)
	values
	('{$q_question}','{$q_forquiz}','{$q_type}','{$q_params}')");

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=add_quiz"),
			array("  ","?do=add_question"),
			array("  ","?do=questions"),
		)
	);

}


// ###################### Inferno Quiz Edit Question ########################
if ($_GET['do'] == "editquestion") {

		// Pre-Cache All Quizs
		$Get_Quizs = $DB->query("select * from ".TABLE_PREFIX."quiz order by qid");
		while($quiz = $DB->fetch_array($Get_Quizs)){
		$Quizs[] = array($quiz['qid'],"{$quiz['q_name']}");
		}

	// ----------------------------
	// Assume The Question Exists
	// ----------------------------

	if(!$question = $DB->query_first("select * from ".TABLE_PREFIX."quiz_questions where qqid = '".intval($_GET['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	$question[q_params] = unserialize($question[q_params]);

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_edit_question');
	print_table_header("  : {$question['q_question']}");

	// ----------------------------
	// Table Content
	// ----------------------------

	echo "<input type='hidden' name='id' value='{$question['qqid']}' />";

	Print_My_DDM("    <dfn>       </dfn>","q_forquiz",$Quizs,$question['q_forquiz']);
	print_input_row("<dfn>   BB</dfn>", 'q_question',encQuote($question['q_question']));

	$Engine->Admin_Question_Params($question['q_type'],$question[q_params]);

	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row(" ", 0);
	print_cp_footer();
	exit;

}

// ###################### Do Inferno Quiz Add Quiz ########################
if ($_POST['do'] == "do_edit_question") {

	// ----------------------------
	// Assume The Question Exists
	// ----------------------------

	if(!$question = $DB->query_first("select * from ".TABLE_PREFIX."quiz_questions where qqid = '".intval($_POST['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	globalize($_POST,
		array(
			'q_question'   => STR_NOHTML,
			'q_forquiz'    => INT,
			'q_params',
		)
	);

	$q_question = trim(addslashes($q_question));

	$q_params = $Engine->Parse_Answer_Format($question['q_type'],$q_params);

	$DB->query("update ".TABLE_PREFIX."quiz_questions
	set q_question='{$q_question}',q_forquiz='{$q_forquiz}',q_params='{$q_params}'
	where qqid='{$question['qqid']}'");

	$Engine->Redirect(
	"   ",
		array(
			array(" ","?do=add_question"),
			array("  ","?do=editquestion&id={$question['qqid']}"),
			array("  ","?do=questions"),
		)
	);


}

// ###################### Inferno Quiz Delete Question ########################
if ($_GET['do'] == "deletequestion") {

	// ----------------------------
	// Assume The Question Exists
	// ----------------------------

	if(!$question = $DB->query_first("select * from ".TABLE_PREFIX."quiz_questions where qqid = '".intval($_GET['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Deletion Confirmation
	// ----------------------------

	Print_Deletion_Confirmation("do_delete_question","  : <b>{$question['q_question']}</b>",$question['qqid'],"        ");

}

// ###################### Do Inferno Quiz Delete Question ########################
if ($_POST['do'] == "do_delete_question") {

	// ----------------------------
	// Assume The Question Exists
	// ----------------------------

	if(!$question = $DB->query_first("select * from ".TABLE_PREFIX."quiz_questions where qqid = '".intval($_POST['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Did we want to delete?
	// ----------------------------

	if($_POST['verify']){

	// ----------------------------
	// Yes we did...
	// ----------------------------

	// Delete Question

	$DB->query("delete from ".TABLE_PREFIX."quiz_questions where qqid = ".intval($_POST['id'])."");

	$Engine->Redirect(
	"   ",
		array(
			array(" ","?do=add_quiz"),
			array("  ","?do=questions"),
		)
	);

	} else {

	// ----------------------------
	// No we didn't...
	// ----------------------------

	$Engine->Redirect(
	"   ",
		array(
			array(" ","?do=add_quiz"),
			array("  ","?do=editquestion&id={$question['qqid']}"),
			array("  ","?do=questions"),
		)
	);

	}



}



// ###################### Inferno Quiz Results Moderation ########################
if ($_GET['do'] == "results") {


	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'moderate_results');
	print_table_header("  ",5);

	// ----------------------------
	// Table Content
	// ----------------------------

	print_cells_row(array(
	"<b> </b>",
	"<b></b>",
	),'thead','','',1);

	$added = false;

	$Get_Quiz = $DB->query("select * from ".TABLE_PREFIX."quiz order by qid");
	$Select   = "";

		while($Quiz = $DB->fetch_array($Get_Quiz)){
		$added = true;

		$Select .= "<option value='{$Quiz['qid']}'>{$Quiz['q_name']}</option>\n";

		}

		if(!$added){
		print_description_row("<center><i>  </i></center>",0,5);
		} else {
		print_cells_row(array(
		"<b>     </b>",
		"<select class='bginput' name='id'>{$Select}</select>",
		),'','','',1);
		}


	// ----------------------------
	// Submit + Table End
	// ----------------------------	

	print_submit_row("",0,5);
	print_cp_footer();
	exit;
}

// ###################### Inferno Quiz Results Moderation ########################
if ($_POST['do'] == "moderate_results") {

	// ----------------------------
	// Assume The Quiz Exists
	// ----------------------------

	if(!$quiz = $DB->query_first("select * from ".TABLE_PREFIX."quiz where qid = '".intval($_POST['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	echo "
	<script type='text/javascript'>
	<!--
		function viewAs(View,Hide){
		document.getElementById(View).style.display = ''
		document.getElementById(Hide).style.display = 'none'

		return false
		}

		function renderURL(URL){
		ID  = document.getElementById('result')
		ID  = ID.options[ID.options.selectedIndex].value
		URL = URL + ID

		window.location.href = URL
		
		return false
		}
	-->
	</script>
	";

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'moderate_results');
	print_table_header("    : {$quiz['q_name']}",5);

	// ----------------------------
	// Table Content
	// ----------------------------

	$Get_Results = $DB->query("
	select u.username,
	r.r_userid,r.r_score,r.rid
	from ".TABLE_PREFIX."quiz_results r
	left join ".TABLE_PREFIX."user u on(u.userid=r.r_userid)
	where r.r_forquiz = '{$quiz['qid']}'
	");

	print_description_row("<center>
	<a href='#' onclick='return viewAs(\"ddm\",\"list\")'>  </a>
	|
	<a href='#' onclick='return viewAs(\"list\",\"ddm\")'> </a>
	</center>",0,5);

	$Options = "";

	echo "<tbody id='list'>";

	print_cells_row(array(
	"<b> </b>",
	"<b>{$vbphrase[edit]}</b>",
	"<b>{$vbphrase[delete]}</b>",
	),'thead','','',1);

		while($Result = $DB->fetch_array($Get_Results)){
		$Options .= "<option value='{$Result['rid']}'>{$Result['username']}</option>\n";
		print_cells_row(array(
		"<b>{$Result['username']}</b>",
		"<a href='?do=moderate_user_results&id={$Result['rid']}'>{$vbphrase[edit]}</a>",
		"<a href='?do=delete_user_results&id={$Result['rid']}'>{$vbphrase[delete]}</a>",
		),'','','',1);
		}

	echo "</tbody>";

	echo "<tbody id='ddm' style='display:none'>";

	print_cells_row(array(
	"<b> </b>",
	"<b></b>",
	"<b></b>",
	),'thead','','',1);

		print_cells_row(array(
		"<select class='bginput' id='result'>{$Options}</select>",
		"<a href='#' onclick='return renderURL(\"?do=moderate_user_results&id=\")'>{$vbphrase[edit]}</a>",
		"<a href='#' onclick='return renderURL(\"?do=delete_user_results&id=\")'>{$vbphrase[delete]}</a>",
		),'','','',1);

	echo "</tbody>";

	// ----------------------------
	// Table End
	// ----------------------------	

	print_table_footer();
	print_cp_footer();
	exit;
}


// ###################### Inferno Quiz Results Moderation ########################
if ($_GET['do'] == "moderate_user_results") {

	// ----------------------------
	// Assume The Result Exists
	// ----------------------------

	if(!$result = $DB->query_first("select u.username,r.* from ".TABLE_PREFIX."quiz_results r left join ".TABLE_PREFIX."user u on(u.userid=r.r_userid) where r.rid = '".intval($_GET['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_form_header(THIS_SCRIPT, 'do_moderate_user_results');
	print_table_header("   : {$result['username']}",5);

	echo "<input type='hidden' name='rid' value='{$result['rid']}' />";

	// ----------------------------
	// Table Content
	// ----------------------------

	print_cells_row(array(
	"<b></b>",
	"<b> </b>",
	),'thead','','',1);

	$Questions = $DB->query("select * from ".TABLE_PREFIX."quiz_questions where q_forquiz='{$result['r_forquiz']}' order by qqid");

		while($Question = $DB->fetch_array($Questions)){
		$Q[$Question['qqid']] = $Question;
		}

	$Answers = unserialize($result['r_data']);

		if(is_array($Q)){
			foreach($Q as $id => $Quest){
			$Quest['q_question'] = parse_bbcode2(encQuote($Quest['q_question']), 0, 0, 0, 1);
			$Engine->Admin_Result_Moderation($Quest,$Answers[$id]);
			}
		}

	// ----------------------------
	// Table End
	// ----------------------------	

	print_submit_row("",0,5);
	print_cp_footer();
	exit;
}

// ###################### Do Inferno Quiz Moderation ########################
if ($_POST['do'] == "do_moderate_user_results") {

	// ----------------------------
	// Assume The Result Exists
	// ----------------------------

	if(!$result = $DB->query_first("select u.username,u.userid,r.* from ".TABLE_PREFIX."quiz_results r left join ".TABLE_PREFIX."user u on(u.userid=r.r_userid) where r.rid = '".intval($_POST['rid'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	$NewResults = addslashes(serialize($_POST['question']));

	$Questions = $DB->query("select * from ".TABLE_PREFIX."quiz_questions where q_forquiz='{$result['r_forquiz']}' order by qqid");

	$Count = 1;
	$Score = 0;

		while($Question = $DB->fetch_array($Questions)){
		$Q[$Question['qqid']] = $Question;
		}

		if(is_array($Q)){
			foreach($Q as $id => $Quest){
			$Result = $Engine->Compile_Answer($Quest,$_POST['question'][$id]);
			$Score += $Result[0];
			$Count++;
			}
		}

	$Overall = floor($Score / ($Count - 1));

	$DB->query("update ".TABLE_PREFIX."quiz_results set r_data='{$NewResults}',r_score='{$Overall}' where rid='{$result['rid']}'");

	$PM = "  {$result['username']},\n         [url={$vboptions[bburl]}/quiz.php?do=UserStat&userid={$result['userid']}&id={$result['r_forquiz']}] [/url] .";

	// Send PM
	SendPM($PM,"  ",$result['userid'],$result['userid']);


	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=moderate_user_results&id={$result['rid']}"),
			array("  ","?do=results"),
		)
	);


}



// ###################### Inferno Quiz Delete Result ########################
if ($_GET['do'] == "delete_user_results") {

	// ----------------------------
	// Assume The Result Exists
	// ----------------------------

	if(!$result = $DB->query_first("select u.username,r.* from ".TABLE_PREFIX."quiz_results r left join ".TABLE_PREFIX."user u on(u.userid=r.r_userid) where r.rid = '".intval($_GET['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Deletion Confirmation
	// ----------------------------

	Print_Deletion_Confirmation("do_delete_result","   : <b>{$result['username']}</b>",$result['rid'],"        ");

}


// ###################### Do Inferno Quiz Delete Result ########################
if ($_POST['do'] == "do_delete_result") {

	// ----------------------------
	// Assume The Result Exists
	// ----------------------------

	if(!$result = $DB->query_first("select u.username,r.* from ".TABLE_PREFIX."quiz_results r left join ".TABLE_PREFIX."user u on(u.userid=r.r_userid) where r.rid = '".intval($_POST['id'])."'")){
	echo "      [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// ----------------------------
	// Did we want to delete?
	// ----------------------------

	if($_POST['verify']){

	// ----------------------------
	// Yes we did...
	// ----------------------------

	// Delete Result

	$DB->query("delete from ".TABLE_PREFIX."quiz_results where rid = ".intval($_POST['id'])."");

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=results"),
		)
	);

	} else {

	// ----------------------------
	// No we didn't...
	// ----------------------------

	$Engine->Redirect(
	"   ",
		array(
			array("  ","?do=moderate_user_results&id={$_POST['id']}"),
			array("  ","?do=results"),
		)
	);

	}



}

// ###################### Inferno Quiz Export ########################
if ($_GET['do'] == "export") {

	$Quizzes = $DB->query("select q_name,qid from ".TABLE_PREFIX."quiz order by qid");

		while($Quiz = $DB->fetch_array($Quizzes)){
		$AllQ[$Quiz['qid']] = $Quiz['q_name'];
		}

		if(!is_array($AllQ)){
		echo "   ";
		exit;
		}

	echo "
	<div style='display:none'>
	<iframe name='export_frame'></iframe>
	<textarea id='export_output'></textarea>
	</div>

	<script type='text/javascript'>
	<!--
		function initExport(){
		ID = document.getElementById('quiz')
		ID = ID.options[ID.options.selectedIndex].value
		window.frames['export_frame'].location.href = 'admin_quiz.php?do=init_export&id='+ID

		Table = document.getElementById('export_table')
		Table.deleteRow(0)
		Table.deleteRow(0)

		nRow = Table.insertRow(-1)
		nRow = nRow.insertCell(-1)
		nRow.align     = 'center'
		nRow.width     = '100%'
		nRow.innerHTML = '<table cellspacing=\"1\" bgcolor=\"#000000\" width=\"100%\"><tr><td width=\"100%\" bgcolor=\"#ffffff\" align=\"left\"><img src=\"{$vboptions['bburl']}/images/quiz_loader.gif\" height=\"30\" width=\"0%\" id=\"export_loader\" /></td></tr></table><div id=\"message\">    </div>'
		}

		function exportCompleted(){
		Value = document.getElementById('export_output').value
		Value = Value.replace(/{L-BA}/g,\"\\n\")
		Value = Value.replace(/{L-BB}/g,\"\\r\")

		Table = document.getElementById('export_table')
		document.getElementById('message').style.display = 'none'

		nRow = Table.insertRow(-1)
		nRow = nRow.insertCell(-1)
		nRow.align     = 'center'
		nRow.width     = '100%'
		nRow.innerHTML = '<form action=\"admin_quiz.php\" name=\"cpform\" method=\"post\"><input type=\"hidden\" name=\"do\" value=\"do_download_export\" /><div style=\"display:none\"><textarea name=\"export_output\">'+Value+'</textarea></div><div align=\"center\"><input type=\"submit\" value=\" \" class=\"button\"></div></form>'
		}

	-->
	</script>
	";

	// ----------------------------
	// From + Table Header
	// ----------------------------

	print_table_start();
	print_table_header(" ");

	// ----------------------------
	// Table Content
	// ----------------------------



	$UBuild = "";

		if(is_array($AllQ)){
			foreach($AllQ as $id => $Quiz){
			$UBuild .= "<option value='{$id}'>{$Quiz}</option>\n";
			}
		}

	print_description_row("
	<table width='100%' border='0' id='export_table'>
	<tr>
	<td width='100%'>   </td>
	<td width='1%'><select id='quiz' class='bginput'>{$UBuild}</select></td>
	</tr>
	<tr>
	<td colspan='2' align='center'><input type='button' class='button' value='' onclick='initExport()' /></td>
	</tr>
	</table>
	");


	// ----------------------------
	// Table End
	// ----------------------------	
	print_table_footer();
	print_cp_footer();
	exit;

}

// ###################### Inferno Quiz Export ########################
if ($_GET['do'] == "init_export") {

	function exportParse($data){
	return str_replace("&quot;","{QUOTATION}",htmlspecialchars_uni(trim(preg_replace(array("/\n/","/\r/"),array("{P-SN}","{P-SR}"),$data))));
	}

// Require XML Functions
require_once('./includes/functions_xml.php');

$GAllQuestions = $DB->query("select * from ".TABLE_PREFIX."quiz_questions where q_forquiz='".intval($_GET['id'])."'");
$Amount        = 0;

	while($Q = $DB->fetch_array($GAllQuestions)){
	$Question[] = $Q;
	$Amount++;
	}

	if(!$_GET['done_quiz']){
	$Quiz = $DB->query_first("select * from ".TABLE_PREFIX."quiz where qid='".intval($_GET['id'])."'");
	$XML  = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>{L-BA}{L-BB}<quiz_export>{L-BA}{L-BB}";
	$XML .= "<quiz q_name=\"".exportParse($Quiz['q_name'])."\" q_desc=\"".exportParse($Quiz['q_desc'])."\"><![CDATA[]]></quiz>";
	$Done = 1;
	$newloc = "admin_quiz.php?do=init_export&done_quiz=1&do_q=0&id={$_GET['id']}";
	} else if($_GET['do_q'] > -1){
		if($Question[$_GET['do_q']]){
		$Done = ($_GET['do_q'] + 1);
		$Q = $Question[$_GET['do_q']];
		$XML = "{L-BA}{L-BB}<question q_question=\"".exportParse($Q['q_question'])."\" q_type=\"".exportParse($Q['q_type'])."\" q_params=\"".exportParse($Q['q_params'])."\"><![CDATA[]]></question>";
		$newloc = "admin_quiz.php?do=init_export&done_quiz=1&id={$_GET['id']}&do_q={$Done}";
		} else {
		// I guess we have finished
		$newloc = "";
		$Done = ($Amount + 1);
		$XML = "{L-BA}{L-BB}</quiz_export>";
		}
	}

$Amount++;
$Completed = ((100 / $Amount) * $Done);

	if($Completed < 1){
	$Completed = 1;
	}

	echo "
	<script type='text/javascript'>
	<!--

		function doLocate(){
			if('{$newloc}' != ''){
			location.href = \"{$newloc}\"
			} else {
			parent.exportCompleted();
			}
		}

	parent.document.getElementById('export_output').value += '".preg_replace(array("/\n/","/\r/"),array("{L-BA}","{L-BB}"),addslashes($XML))."'
	NewImage = '<img src=\"{$vboptions['bburl']}/images/quiz_loader.gif\" height=\"30\" width=\"{$Completed}%\" id=\"export_loader\" />'
	parent.document.getElementById('export_loader').parentNode.innerHTML = NewImage
	setTimeout('doLocate()',250)
	-->
	</script>
	";

}

// ###################### Inferno Quiz Export Download ########################
if ($_POST['do'] == "do_download_export") {

// Require File Functions
require_once('./includes/functions_file.php');

file_download($_POST['export_output'], 'quiz.xml', 'text/xml');

}


// ###################### Inferno Quiz Import ########################
if ($_GET['do'] == "import") {

print_form_header(THIS_SCRIPT, 'do_import', 1, 1);
print_table_header(" ", 2);

print_upload_row("     ", 'inffile', 99999999999999);
print_submit_row("", 0);

	// ----------------------------
	// Table End
	// ----------------------------	
	print_table_footer();
	print_cp_footer();
	exit;

}

// ###################### Inferno Quiz Import ########################
if ($_POST['do'] == "do_import") {

require_once('./includes/functions_xml.php');

	globalize($_POST, array(
		'inffile' => FILE,
	));

	if(file_exists($inffile['tmp_name'])){
	$xml = file_read($inffile['tmp_name']);
	} else {
	echo "    [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	$li = 0;
	$lc = 0;
	$curtag = '';
	$arr = array();

	$parser = xml_parser_create();

	// Set The XML Parse Functions
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	xml_set_element_handler($parser, 'xml_parse_quiz','xml_do_nothing');
	xml_set_character_data_handler($parser, 'xml_parse_quiz_cdata');

	if(!@xml_parse($parser, $xml)){
	echo "   [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// Grab Quiz Data (Name/Desc)
	$Quiz_Data = $arr['quiz'][0];

	if(!$Quiz_Data){
	echo "    [<a href='javascript:history.go(-1);'></a>]";
	exit;
	}

	// Gather Questions
	$Questions = $arr['question'];

		if(!is_array($Questions)){
		echo "    [<a href='javascript:history.go(-1);'></a>]";
		exit;
		}

	// Insert Quiz

	$DB->query("insert into ".TABLE_PREFIX."quiz
	(q_name,q_state,q_desc)
	values
	('".ParseIncommingImport($Quiz_Data['q_name'])."',0,'".ParseIncommingImport($Quiz_Data['q_desc'])."')");

	// Get ID
	$ID = $DB->insert_id();

	$QueryBits = array();

	foreach($Questions as $Q){
	$QueryBits[] = "($ID,'".ParseIncommingImport($Q['q_question'])."','".ParseIncommingImport($Q['q_type'])."','".ParseIncommingImport($Q['q_params'])."')";
	}

	// Insert Questions

	$DB->query("insert into ".TABLE_PREFIX."quiz_questions
	(q_forquiz,q_question,q_type,q_params)
	values
	".implode(',',$QueryBits)."");


	$Engine->Redirect(
	"   ",
		array(
			array(" ","?do=editquiz&id={$ID}"),
		)
	);

}

function xml_parse_quiz($parser, $name, $attrs){
global $curtag, $arr, $li, $lc;

$arr[$name][] = $attrs; // Simple and easy, shove it in
}

function xml_parse_quiz_cdata($parser, $data){
// I leave the cdata blank, so this is useless
}

function ParseIncommingImport($Data){
return trim(str_replace(array("{QUOTATION}","{P-SN}","{P-SR}"),array('"',"\n","\r"),addslashes($Data)));
}

?>