<?php
// ++=========================================================================++
// || vBadvanced CMPS v2.0 RC1 - 6700
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 09:39, Sat Jun 4th 2005
// || 
// ++ ========================================================================++

function construct_page_structure($pageinfo, $parent = 0)
{
	global $pagecounter;
	if ($pageinfo)
	{
		foreach ($pageinfo AS $pageid => $page)
		{
			if ($page['parentid'] == $parent)
			{
				$pagecounter++;
				$page['level'] = $pagecounter;
				$pagearray["$pageid"] = $page;

				if ($subpage = construct_page_structure($pageinfo, $pageid))
				{
					foreach ($subpage AS $thispageid => $values)
					{
						$subpageid = $thispageid;
						$pagearray["$subpageid"] = $subpage["$subpageid"];
					}
				}
				$pagecounter--;
			}
		}
	}
	return $pagearray;
}

// Get the structure
$navpagecache = array();
$getpages = $DB_site->query("SELECT pageid, title, name, parentid, userperms FROM " . TABLE_PREFIX . "adv_pages WHERE active = 1");
while ($npage = $DB_site->fetch_array($getpages))
{
	$navpages["$npage[pageid]"] = $npage;
}

$navpages = construct_page_structure($navpages);

$mod_options['portal_navigation_excludepages'] = explode(',', $mod_options['portal_navigation_excludepages']);

$navigationbits = '';

if (!empty($navpages))
{
	foreach ($navpages AS $npageid => $npage)
	{
		if (in_array($npageid, $mod_options['portal_navigation_excludepages']))
		{
			continue;
		}

		$showpage = false;

		$npage['userperms'] = explode(',', $npage['userperms']);

		if (!empty($npage['userperms']));
		{
			foreach ($bbuserinfo['usergrouparray'] AS $gid)
			{
				if (in_array($gid, $npage['userperms']))
				{
					$showpage = true;
				}
			}
		}

		if (!$showpage)
		{
			continue;
		}

		if ($npage['level'] == 1)
		{
			$navmark = $mod_options['portal_navigation_mark1'];
		}
		else
		{
			$navmark = str_repeat('&nbsp;', ($npage['level'] - 1)) . $mod_options['portal_navigation_mark2'];
		}
	
		$link = $vba_options['portal_homeurl'] . '?' . $vba_options['portal_pagevar'] . '=' . $npage['name'];
		$title = $npage['title'];
	
		eval('$navigationbits .= "' . fetch_template('adv_portal_navigationbits') . '";');
	}
}

// Additional pages
$customnavigationbits = '';

$mod_options['portal_navigation_addpages'] = unserialize($mod_options['portal_navigation_addpages']);

if (!empty($mod_options['portal_navigation_addpages']))
{
	foreach ($mod_options['portal_navigation_addpages'] AS $key => $navlinks)
	{
		$link = $navlinks['link'];
		$title = $navlinks['text'];
		$navmark = iif($navlinks['level'] == 1, $mod_options['portal_navigation_mark1'], str_repeat('&nbsp;', ($navlinks['level'] - 1)) . $mod_options['portal_navigation_mark2']);

		eval('$customnavigationbits .= "' . fetch_template('adv_portal_navigationbits') . '";');
	}
}

eval('$home["$mods[modid]"][\'content\'] = "' . fetch_template('adv_portal_navigation') . '";');


?>