<?php
// ++=========================================================================++
// || vBadvanced CMPS v2.0 RC1 - 5840
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 13:15, Sat Jun 4th 2005
// || 
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ######################### Update Module Cache ###########################
function update_module_cache()
{
	global $DB_site;

	$module = array();
	$mods = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE active = 1 ORDER BY modcol, displayorder");
	while ($mod = $DB_site->fetch_array($mods))
	{
		$module[] = $mod;
	}
	build_datastore('adv_modules', serialize($module));
}

// ########################### Update Page Cache ##############################
function update_page_cache()
{
	global $DB_site;

	$pagecache = array();
	$getpages = $DB_site->query("SELECT pageid, title, name, parentid FROM " . TABLE_PREFIX . "adv_pages");
	while ($page = $DB_site->fetch_array($getpages))
	{
		$pagecache["$page[pageid]"]['title'] = $page['title'];
		$pagecache["$page[pageid]"]['name'] = $page['name'];
		$pagecache["$page[pageid]"]['parentid'] = $page['parentid'];
	}

	$DB_site->free_result($getpages);
	unset($page);

	build_datastore('adv_portal_page', iif(!empty($pagecache), serialize($pagecache)));
}

// ############################# Build Settings ###############################
function build_adv_settings()
{
	global $DB_site;

	$vba_options = array();
	$settings = $DB_site->query("SELECT varname, value, grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%' OR grouptitle = 'adv_global'");
	while ($setting = $DB_site->fetch_array($settings))
	{
		$vba_options["$setting[grouptitle]"]["$setting[varname]"] = $setting['value'];
	}

	$DB_site->free_result($settings);
	build_datastore('adv_portal_opts', serialize($vba_options));
}

// ########################## Print Module Columns ############################
function print_module_columns($type, $dosettings = false)
{
	global $DB_site, $vbphrase;

	$columns = array();
	$modules = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_modules ORDER BY modcol, displayorder");
	while ($module = $DB_site->fetch_array($modules))
	{
		$columns["$module[modcol]"][] = $module;
	}

	print_cells_row(array($vbphrase['left_column'], $vbphrase['center_column'], $vbphrase['right_column']), 1, 'thead', -2);

	echo '<tr class="alt2">';

	print_column_row($columns['0'], $vbphrase['left_column'], $type);
	print_column_row($columns['1'], $vbphrase['center_column'], $type);
	print_column_row($columns['2'], $vbphrase['right_column'], $type);
}

// ########################## Print Module Columns ############################
function print_column_row($colarray, $coltitle, $type)
{
	global $page, $_REQUEST, $vbphrase;

	echo '<td width="33%" valign="top">';
	print_table_start(false, '100%');

	if ($type != 'page')
	{
		$cell = array();
		$cell[] = $vbphrase['module_name'];
		if ($type != 'download')
		{
			$cell[] = $vbphrase['order'];
		}
		print_cells_row($cell, 1);
	}
	
	if (!empty($colarray))
	{
		foreach ($colarray AS $key => $column)
		{
			switch($type)
			{ 
				// Edit / add page
				case 'page':
					echo '<tr><td class="alt1"><label for="' . $column['modid'] . '"><input ' . iif($_REQUEST['do'] == 'addpage' OR in_array($column['modid'], explode(',', $page['modules'])), 'checked="checked" ') . iif(!$column['active'], 'disabled="disabled" ') . 'id="' . $column['modid'] . '" name="enablemod[]" type="checkbox" value="' . $column['modid'] . '" /> <span class="smallfont">' . $column['title'] . '</span></label></td></tr>';
					break;
				// Download module
				case 'download':
					echo '<tr><td class="alt1"><label for="' . $column['modid'] . '"><input id="' . $column['modid'] . '" name="modid" type="radio" value="' . $column['modid'] . '" /> <span class="smallfont">' . $column['title'] . '</span></label></td></tr>';
					break;
				// Edit modules
				default:
				print_input_row('<span class="smallfont"><strong><a href="vba_cmps_admin.php?do=editmodule&amp;modid=' . $column['modid'] . '">' . $column['title'] . '</a></strong></span>' . iif(!$column['active'], ' <div style="color:red;font-size:9px;font-weight:normal;">(' . $vbphrase['inactive'] . ')</div>') . '<div class="smallfont" style="margin-top:5px">' . $vbphrase['move_to'] . ': ' . 
				iif($column['modcol'] == 0, ' [<a href="vba_cmps_admin.php?do=movemodule&amp;modid=' . $column['modid'] . '&amp;col=2" title="' . $vbphrase['right_column'] . '">-&raquo;</a>] [<a href="vba_cmps_admin.php?do=movemodule&amp;modid=' . $column['modid'] . '&amp;col=1" title="' . $vbphrase['center_column'] . '"">-&rsaquo;</a>]') . 
				iif($column['modcol'] == 1, ' [<a href="vba_cmps_admin.php?do=movemodule&amp;modid=' . $column['modid'] . '&amp;col=0" title="' . $vbphrase['left_column'] . '">&lsaquo;-</a>] [<a href="vba_cmps_admin.php?do=movemodule&amp;modid=' . $column['modid'] . '&amp;col=2" title="' . $vbphrase['right_column'] . '">-&rsaquo;</a>]') . 
				iif($column['modcol'] == 2, ' [<a href="vba_cmps_admin.php?do=movemodule&amp;modid=' . $column['modid'] . '&amp;col=1" title="' . $vbphrase['center_column'] . '">&lsaquo;-</a>] [<a href="vba_cmps_admin.php?do=movemodule&amp;modid=' . $column['modid'] . '&amp;col=0" title="' . $vbphrase['left_column'] . '">&laquo;-</a>]')
		
		, 'modorder[' . $column['modid'] . ']', $column['displayorder'], 1, 1, '', '', iif(!$column['active'], 'bginput" disabled="disabled"', ''));
			}
		}
		unset($column);
	}
	else
	{
		print_label_row($vbphrase['no_modules']);
	}
	print_table_footer(true, '', '', false);
	echo '</td>';
}		

// ############################## Rebuild Parents #############################
function rebuild_parents($pageid = 0)
{
	global $DB_site, $parentlist;

	$pages = array();

	$getpages = $DB_site->query("SELECT pageid, parentid FROM " . TABLE_PREFIX . "adv_pages ORDER BY parentid");
	while ($pageinfo = $DB_site->fetch_array($getpages))
	{
		$pages[] = $pageinfo;
	}
	
	$DB_site->free_result($getpages);
	unset($pageinfo);

	foreach($pages AS $page)
	{
		if ($pageid != 0 AND $page['pageid'] != $pageid)
		{
			continue;
		}
		$parentlist = array();
		$parentlist[] = $page['pageid'];
		construct_parents($pages, $page['parentid']);
		$plist = implode(',', $parentlist);

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET parentlist = '$plist' WHERE pageid = '$page[pageid]'");
	}
}

// ########################## Construct Parents ###############################
function construct_parents($pageinfo, $pageid)
{
	global $parentlist;

	foreach ($pageinfo AS $pages)
	{
		if ($pages['pageid'] == $pageid)
		{
			$parentlist[] = $pages['pageid'];
			construct_parents($pageinfo, $pages['parentid']);
		}
	}
	return $parentlist;
}

// ########################### Construct Settings #############################
function construct_adv_page_settings()
{
	global $DB_site, $setting, $usedefault;
	$defsettings = $DB_site->query("
			SELECT *
			FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
			WHERE grouptitle LIKE 'adv_portal%'
	");

	while ($defsetting = $DB_site->fetch_array($defsettings))
	{
		if (!empty($setting))
		{
			foreach ($setting AS $varname => $value)
			{
				if (is_array($value))
				{
					$setting["$varname"] = implode(',', $value);
				}

				if ($varname == $defsetting['varname'] AND $value != $defsetting['value'] AND !$usedefault[$varname])
				{
					$adv_setting["$varname"] = $value;
				}
			}
		}
	}
	$DB_site->free_result($defsettings);
	unset($defsetting, $setting);

	if (!empty($adv_setting))
	{
		$adv_setting = serialize($adv_setting);
	}
	else
	{
		$adv_setting = '';
	}
	return $adv_setting;
}

// ############################# Print Settings ###############################
function print_adv_setting_group($type, $grouptitle = '')
{
	global $DB_site, $vboptions, $debug, $session, $vbphrase, $stylevar, $forumcache, $page, $module, $pagesettings, $adv_opts;


	// Set setting phrase cache
	$settingphrase = array();
	$getphrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE phrasetypeid = 5000 ORDER BY languageid ASC");
	while($phrases = $DB_site->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = $phrases['text'];
	}

	if (in_array($type, array('page', 'mainsettings', 'mainsettings_all')))
	{
		// Construct settings
		$grouptitlecache['adv_global'] = $settingphrase['settinggroup_adv_global'];
		$grouptitlecache['adv_portal_main'] = $settingphrase['settinggroup_adv_portal_main'];
		$grouptitlecache['adv_portal_style'] = $settingphrase['settinggroup_adv_portal_style'];

		if ($type != 'mainsettings')
		{
			// Get module titles
			$getmods = $DB_site->query("SELECT title, identifier, options FROM " . TABLE_PREFIX . "adv_modules WHERE inctype = 'php_file' AND active = 1 ORDER BY modcol, displayorder");
			while ($mods = $DB_site->fetch_array($getmods))
			{
				$grouptitlecache["adv_portal_$mods[identifier]"] = $mods['title'];
			}
		}
	}

	// Construct settings for pages
	if ($type == 'page')
	{
		$tidentcache = array();
	
		// Get setting options
		$optioncache = array();
		$get_advsettings = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%' ORDER BY displayorder");
		while ($adv_set = $DB_site->fetch_array($get_advsettings))
		{
			if (in_array($adv_set['grouptitle'], array('adv_portal_main', 'adv_portal_style')))
			{
				if (isset($adv_opts["$adv_set[grouptitle]"]["$adv_set[varname]"]))
				{
					$adv_set['default'] = false;
					$adv_set['value'] = $adv_opts["$adv_set[grouptitle]"]["$adv_set[varname]"];
				}
				else
				{
					$adv_set['default'] = true;
				}
			}
			else if (isset($adv_opts["$adv_set[grouptitle]"]["$adv_set[varname]"]))
			{
				$adv_set['value'] = $adv_opts["$adv_set[grouptitle]"]["$adv_set[varname]"];
				$adv_set['default'] = false;
			}
			else
			{
				$adv_set['default'] = true;
			}
			$settingscache["$adv_set[grouptitle]"]["$adv_set[varname]"] = $adv_set;
	
			if ($adv_set['varname'] == 'portal_threadids')
			{
				$adv_set['value'] = unserialize($adv_set['value']);
				if (!empty($adv_set['value']))
				{
					foreach ($adv_set['value'] AS $tid => $pid)
					{
						$tidentcache["$tid"] = $adv_set['grouptitle'];
					}
				}
			}
		}

		$tids = array_keys($tidentcache);
	}
	else
	{
		// Construct normal settings

		if ($type == 'module')
		{
			$settingquery = 'grouptitle = \'' . $grouptitle . '\'';
			$grouptitlecache["$grouptitle"] = $module['title'];
		}
		else if ($type == 'mainsettings')
		{
			$settingquery = 'grouptitle IN(\'adv_portal_main\', \'adv_portal_style\', \'adv_global\')';
		}
		else
		{
			$settingquery = 'grouptitle LIKE \'adv_portal%\' OR grouptitle = \'adv_global\'';
		}

		$settings = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE $settingquery ORDER BY displayorder");
		while ($setting = $DB_site->fetch_array($settings))
		{
			$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		}

		$tids = array();
		$gtcache = array();
		if (!empty($settingscache))
		{
			foreach ($settingscache AS $gtitle => $gtsettings)
			{
				$tarray = unserialize($settingscache["$gtitle"]['portal_threadids']['value']);
				if (!empty($tarray))
				{
					$tids = array_keys($tarray);
					foreach (array_keys($tarray) AS $threadid)
					{
						$gtcache["$threadid"] = $gtitle;
					}
				}
			}
		}
	}

	// Get info for threadselect options
	$threadidcache = array();
	if (!empty($tids))
	{
		$threads = $DB_site->query("SELECT threadid, title FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', $tids) . ")");
		while ($thread = $DB_site->fetch_array($threads))
		{
			$grouptitle = $gtcache["$thread[threadid]"];
			$threadidcache["$grouptitle"]["$thread[threadid]"] = $thread['title'];
		}
	}

	// Construct the settings
	if (!empty($grouptitlecache))
	{
		foreach ($grouptitlecache AS $grouptitle => $texttitle)
		{
			if (!empty($settingscache["$grouptitle"]))
			{
				$identifier = substr($grouptitle, 11);
			
				print_description_row(construct_phrase($vbphrase['x_options'], $grouptitlecache["$grouptitle"]) . iif($debug AND $type != 'page', '<span class="normal">' . construct_link_code($vbphrase['add_setting'], "vba_cmps_admin.php?$session[sessionurl]do=addsetting&amp;identifier=$identifier&amp;modid=$modid") . '</span>'),
					0, 2, 'thead', 'center'
				);

				foreach ($settingscache["$grouptitle"] AS $settingid => $setting)
				{
					if (($setting['varname'] == 'portal_pagevar' AND $type == 'page') OR $setting['varname'] == 'portal_version')
					{
						continue;
					}

					if ($type == 'page')
					{
						$jsdefault = 'js_check_default(\'' . $grouptitle . '\', \'' . $setting['varname'] . '\');';
					}

					print_description_row(
						'<div class="smallfont" style="float:' . $stylevar['right'] . '">' . 
						iif($debug AND $type != 'page', construct_link_code($vbphrase['edit'], "vba_cmps_admin.php?$session[sessionurl]do=editsetting&varname=$setting[varname]&amp;identifier=$identifier&amp;modid=$modid") . construct_link_code($vbphrase['delete'], "vba_cmps_admin.php?$session[sessionurl]do=removesetting&varname=$setting[varname]&amp;grouptitle=$grouptitle")) . ' ' . iif($type == 'page', '&nbsp; &nbsp; ' . $vbphrase['use_default'] . ' <input ' . iif($setting['default'], 'checked="checked"') . ' type="checkbox" name="usedefault[' . $grouptitle . '][' . $setting['varname'] . ']" value="1" />') . '</div>
						<div>' . iif($setting['optioncode'] == 'threadselect', $texttitle . ' ') . $settingphrase["setting_$setting[varname]_title"] . '<a name="' . $setting['varname'] . '"></a></div>',
						0, 2, 'optiontitle" title="$vba_options[' . $setting['varname'] . ']"'
					);
			
					$description = '<div class="smallfont" title="' . $vboptions["$setting[varname]"]. '">' . $settingphrase["setting_$setting[varname]_desc"] . '</div>';
			
					if (!empty($pagesettings["$grouptitle"]["$setting[varname]"]))
					{
						$description .= '<div class="smallfont" style="margin-top:4px"><b>' . $vbphrase['setting_customized_pages'] . '</b><br /><select name="pageid">';
						foreach ($pagesettings["$grouptitle"]["$setting[varname]"] AS $spageid => $pagetitle)
						{
							$description .= '<option value="' . $spageid . '">' . $pagetitle . '</option>';
						}
						$description .= '</select></div>';
					}
			
					$name = 'setting[' . $grouptitle . '][' . $setting['varname'] . ']';
			
					switch ($setting['optioncode'])
					{
						// Text input
						case '':
							print_input_row($description, $name, $setting['value'], 1, 40, '', '', iif($type == 'page', 'bginput" onfocus="' . $jsdefault));
						break;
			
						// Textarea
						case 'textarea':
							print_textarea_row($description, $name, $setting['value'], 8, 40, '', '', '', iif($type == 'page', 'bginput" onfocus="' . $jsdefault));
						break;
			
						// Yes / No row
						case 'yesno':
							print_yes_no_row($description, $name, $setting['value'], iif($type == 'page', $jsdefault));
							break;
			
						// Forum select box
						case 'forumselect':
						case 'forumselect_random':
			
							$selectbox = '<select name="' . $name . '[]" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"'). ' multiple="multiple" style="width:275px" size="' . iif(sizeof($forumcache) > 10, 10, sizeof($forumcache)) . '">';
			
							$setting['value'] = explode(',', $setting['value']);
							foreach ($forumcache AS $forum)
							{
								$selectbox .= '<option value="' . $forum['forumid'] . '" ' . iif(in_array($forum['forumid'], $setting['value']), 'selected="selected"') . '>' . str_repeat('--', $forum['depth']) . $forum['title'] . '</option>';
							}
							$selectbox .= '</select>';
							
							print_label_row($description, $selectbox);
							
						break;
			
						// Calendar select box
						case 'calendarselect':
							$selectbox = '<select name="' . $name . '" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '>';
		
							$getcalendars = $DB_site->query("SELECT calendarid, title FROM " . TABLE_PREFIX . "calendar");
							while ($calendar = $DB_site->fetch_array($getcalendars))
							{
								$selectbox .= '<option value="' . $calendar['calendarid'] . '">' . $calendar['title'] . '</option>';
							}
							$selectbox .= '</select>';
			
							print_label_row($description, $selectbox);
						break;
			
						// Thread select link
						case 'threadselect':
							$right = '';
			
							if (!empty($threadidcache["$grouptitle"]))
							{
								foreach ($threadidcache["$grouptitle"] AS $threadid => $threadtitle)
								{
									$right .= '<div class="smallfont"><a href="' . $vboptions['bburl'] . '/showthread.php?t=' . $threadid . '">' . fetch_trimmed_title($threadtitle, 50) . '</a></div>';
								}
							}
			
							$right .= '<div class="smallfont" style="margin-top:8px"><a href="vba_cmps_admin.php?do=listforums&amp;identifier=' . $identifier . '&amp;pageid=' . $page['pageid'] . '" target="_blank" ' .  iif($type == 'page', 'onclick="' . $jsdefault . '"') . '><b>' . $vbphrase['edit_threads'] . '</b></a></div>';
			
							print_label_row($description, $right, '', 'top', $name);
						break;
			
						// Page select box
						case 'pageselect':
							$pagecache = array();
							$getpages = $DB_site->query("SELECT pageid, title, parentid FROM " . TABLE_PREFIX . "adv_pages");
							while ($pages = $DB_site->fetch_array($getpages))
							{
								$pagecache["$pages[pageid]"] = $pages;
							}
			
							$pagecache = construct_page_structure($pagecache);
			
							$pageselect = array();
							foreach ($pagecache AS $pid => $pinfo)
							{
								$pageselect["$pid"] = str_repeat('- - ', ($pinfo['level'] - 1)) . $pinfo['title'];
							}
			
							$setting['value'] = explode(',', $setting['value']);
			
							$selectbox = '<select name="' . $name . '[]" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . ' multiple="multiple" style="width:275px" size="' . iif(sizeof($pageselect) > 10, 10, sizeof($pageselect)) . '">';
			
							foreach ($pagecache AS $spageid => $page)
							{
								$selectbox .= '<option value="' . $page['pageid'] . '" ' . iif(in_array($spageid, $setting['value']), 'selected="selected"') . '>' . str_repeat('--', $page['level']) . $page['title'] . '</option>';
							}
							$selectbox .= '</select>';
							
							print_label_row($description, $selectbox);
						break;
			
						// Additional page inputs
						case 'pageselect_add':
			
							$pagecount = 0;
			
							$setting['value'] = unserialize($setting['value']);
			
							$inputs = '';
							if (!empty($setting['value']))
							{
								foreach ($setting['value'] AS $key => $navlinks)
								{
									$pagecount++;
									$inputs .= '<tr><td><input class="bginput" name="' . $name . '[' . $pagecount . '][order]" value="' . $navlinks['order'] . '" size="1" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td><td><input class="bginput" name="' . $name . '[' . $pagecount . '][level]" value="' . $navlinks['level'] . '" size="1" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td><td><input class="bginput" name="' . $name . '[' . $pagecount . '][link]" value="' . $navlinks['link'] . '" size="20" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td><td><input class="bginput" name="' . $name . '[' . $pagecount . '][text]" value="' . $navlinks['text'] . '" size="20" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td></tr>';
								}
							}
			
							$curcount = $pagecount + 3;
			
							while ($curcount > $pagecount)
							{
								$pagecount++;
								$inputs .= '<tr><td><input class="bginput" name="' . $name . '[' . $pagecount . '][order]" value="" size="1" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td><td><input class="bginput" name="' . $name . '[' . $pagecount . '][level]" value="" size="1" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td><td><input class="bginput" name="' . $name . '[' . $pagecount . '][link]" value="" size="20" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td><td><input class="bginput" name="' . $name . '[' . $pagecount . '][text]" value="" size="20" ' . iif($type == 'page', 'onclick="' . $jsdefault . '"') . '/></td></tr>';
							}
			
							print_description_row($description . '<br /><table align="center" cellpadding="4" cellspacing="0" class="tborder"><tr><td class="thead">' . $vbphrase['order'] . '</td><td class="thead">' . $vbphrase['level'] . '</td><td class="thead">' . $vbphrase['link'] . '</td><td class="thead">' . $vbphrase['text'] . '</td></tr>' . $inputs . '</table>');
						break;
			
						// Default label row
						default:
							eval("\$right = \"$setting[optioncode]\";");
							print_label_row($description, $right, '', 'top', $name);
					}
				}
				print_table_break();
			}
		}
	}
}

// ########################### Construct Pages ################################
function construct_page_structure($pageinfo, $parent = 0)
{
	global $pagecounter;
	if ($pageinfo)
	{
		foreach ($pageinfo AS $pageid => $page)
		{
			if ($page['parentid'] == $parent)
			{
				$pagecounter++;
				$page['level'] = $pagecounter;
				$pagearray["$pageid"] = $page;

				if ($subpage = construct_page_structure($pageinfo, $page['pageid']))
				{
					foreach ($subpage AS $thispageid => $values)
					{
						$subpageid = $thispageid;
						$pagearray["$subpageid"] = $subpage["$subpageid"];
					}
				}
				$pagecounter--;
			}
		}
	}
	return $pagearray;
}

// ############################ Fetch Page Data ###############################
function fetch_page_data($table)
{
	global $DB_site, $vba_options, $condition, $wherequery, $bbuserinfo, $vboptions;

  $pagedata = $DB_site->query_first("
  		SELECT COUNT(*) AS count 
  		FROM " . TABLE_PREFIX . $table . "
  		" . iif($condition[join], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (' . $condition['joinusing'] . ')') . "
  		" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
  ");

	$pagedata['pagenumber'] = intval($_REQUEST['page']);

	// Work out pages & limits
	if (!$pagedata['pagenumber'])
	{
		$pagedata['pagenumber'] = 1;
	}

	if (!intval($pagedata['perpage']))
	{
	  $pagedata['perpage'] = $vboptions['maxthreads'];
	}

	$pagedata['minlimit'] = intval(($pagedata['pagenumber'] - 1) * $pagedata['perpage'] + 1);
	$pagedata['maxlimit'] = intval($pagedata['pagenumber'] * $pagedata['perpage']);

	if ($pagedata['maxlimit'] > $pagedata['count'])
	{
		$pagedata['maxlimit'] = $pagedata['count'];
		if ($pagedata['minlimit'] > $pagedata['count'])
		{
		  $pagedata['minlimit'] = $pagedata['count'] - $pagedata['perpage'];
		}
	}
	if ($pagedata['minlimit'] <= 0)
	{
	  $pagedata['minlimit'] = 1;
	}

	$pagedata['pagecount'] = ceil($pagedata['count'] / $pagedata['perpage']);

	return $pagedata;
}

// ############################ Fetch threadids ###############################
function fetch_module_threadids($identifier)
{
	global $DB_site;

	$set = $DB_site->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$identifier' AND varname = 'portal_threadids'");
	return unserialize($set['value']);
}

// ############################ Construct Settings ############################
function construct_cmps_settings($type = 'main')
{
	global $DB_site, $setting, $module;
	$adv_setting = array();

	$gtitlearray = array();
	foreach ($setting AS $gtitle => $sgroups)
	{
		$gtitlearray[] = $gtitle;
	}

	$oldsettings = $DB_site->query("SELECT varname, value, grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle IN('" . implode('\',\'', $gtitlearray) . "') AND varname NOT IN('portal_threadids', 'portal_version')");
	while ($oldsetting = $DB_site->fetch_array($oldsettings))
	{
		$adv_setting["$oldsetting[grouptitle]"]["$oldsetting[varname]"] = $oldsetting['value'];
	}

	// Module settings
	if (!empty($setting))
	{
		$lcount = 0;

		foreach ($adv_setting AS $grouptitle => $settings)
		{
			foreach ($settings AS $varname => $value)
			{
				$value = $setting["$grouptitle"]["$varname"];

				if ($varname == 'portal_navigation_addpages')
				{
					if ($value)
					{
						$pagelinks = array();
						foreach ($value AS $key => $array)
						{
							if ($array['text'])
							{
								foreach ($array AS $akey => $avalue)
								{
									$pagelinks["$key"]["$akey"] = $avalue;
								}
							}
						}
					}
					function order_nav($a, $b) 
					{
						return ($a['order'] < $b['order']) ? -1 : 1;
					}
			
					usort($pagelinks, 'order_nav'); 

					$value = serialize($pagelinks);
				}
				else if (is_array($value))
				{
					$value = implode(',', $value);
				}
				else if ($varname != 'portal_threadids')
				{
					$value = $value;
				}

				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . addslashes($value) . "' WHERE varname = '$varname' AND grouptitle = '$grouptitle'");
			}
		}
		build_adv_settings();
	}
}

?>