<?php
// ++=========================================================================++
// || vBadvanced CMPS v2.0 RC1 - 5840
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 13:15, Sat Jun 4th 2005
// || 
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$specialtemplates = array(
	'adv_portal_opts',
	'forumcache',
	'bbcodecache'
);

if ($_REQUEST['do'] == 'menu')
{
	$phrasegroups = array('cphome');
}
else
{
	$phrasegroups = array('adv_portal_cp');
	if (in_array($_REQUEST['do'], array('editmodule', 'addmodule', 'copymodule', 'addpage', 'editpage', 'copypage')))
	{
		$phrasegroups[] = 'posting';
	}
}

require_once('./global.php');
require_once('./includes/adminfunctions_vba_cmps.php');

// Redirect to the proper place when changing moudle type
if (isset($_REQUEST['chtype']))
{
	$type = substr($_REQUEST['chtype'], 7);
	$chtype = true;

	if ($_REQUEST['chtype'] == 'noaction')
	{
		$_REQUEST['do'] = 'noaction';
	}
	else if (isset($_POST['pageid']))
	{
		$_REQUEST['do'] = 'editpage';
		$pageid = $_REQUEST['pageid'];
	}
	else
	{
		$_REQUEST['do'] = 'editmodule';
		$modid = $_REQUEST['modid'];
	}
}

if (!isset($_REQUEST['do']))
{
  $_REQUEST['do'] = 'frameset';
}


if ($_REQUEST['do'] == 'masssetting')
{
	$getphrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase ORDER BY languageid ASC");
	while($phrases = $DB_site->fetch_array($getphrases))
	{
		$settingphrase[$phrases['varname']] = $phrases['text'];
	}

	$settinggroups = array();
	$groups = $DB_site->query("
			SELECT grouptitle 
			FROM " . TABLE_PREFIX . "adv_settinggroup 
			WHERE grouptitle LIKE 'adv_portal%' 
			ORDER BY displayorder
	");
	while ($group = $DB_site->fetch_array($groups))
	{
		$settinggroups[$group['grouptitle']] = $settingphrase["settinggroup_$group[grouptitle]"];
	}

	print_form_header('vba_cmps_admin', 'domasssetting');
	print_table_header(iif($_REQUEST['do'] == 'editsetting', $vbphrase['edit_setting'] . ': ' . $varname, $vbphrase['add_setting']));

	$settings = $DB_site->query("
			SELECT adv_setting.* 
			FROM " . TABLE_PREFIX . "adv_setting 
			LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE adv_settinggroup.grouptitle = 'adv_portal_$_REQUEST[identifier]' 
			ORDER BY adv_settinggroup.grouptitle, adv_setting.displayorder");
	while ($setting = $DB_site->fetch_array($settings))
	{
		construct_hidden_code('setting[' . $setting['varname'] . '][varname]', $setting['varname']);
		print_label_row($vbphrase['varname'], '<b>' . $setting['varname'] . '</b>');

		$phrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE varname IN ('setting_$setting[varname]_title', 'setting_$setting[varname]_desc') AND phrasetypeid = '5000'");
		while ($phrase = $DB_site->fetch_array($phrases))
		{
			if ($phrase['varname'] == "setting_$setting[varname]_title")
			{
				$setting['title'] = $phrase['text'];
			}
			else
			{
				$setting['description'] = $phrase['text'];
			}
		}

		print_input_row($vbphrase['title'] . ':', 'setting[' . $setting['varname'] . '][title]', $setting['title']);
		print_select_row($vbphrase['setting_group'], 'setting[' . $setting['varname'] . '][grouptitle]', $settinggroups, iif($_REQUEST['do'] == 'addsetting', $_REQUEST['grouptitle'], $setting['grouptitle']));
		print_textarea_row($vbphrase['description'] . ':', 'setting[' . $setting['varname'] . '][description]', $setting['description']);
		print_textarea_row($vbphrase['option_code'] . ':', 'setting[' . $setting['varname'] . '][optioncode]', $setting['optioncode'], 4, 50);
		print_textarea_row($vbphrase['default'], 'setting[' . $setting['varname'] . '][defaultvalue]', $setting['defaultvalue'], 4, 50);
		print_input_row($vbphrase['display_order'], 'setting[' . $setting['varname'] . '][displayorder]', $setting['displayorder']);
		print_table_break();
	}

	print_submit_row();

}	

if ($_REQUEST['do'] == 'domasssetting')
{

	foreach ($_REQUEST['setting'] AS $varname => $setting)
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET defaultvalue = '$setting[defaultvalue]', optioncode = '" . addslashes($setting['optioncode']) . "', displayorder = '$setting[displayorder]' WHERE varname = '$setting[varname]' AND grouptitle = '$setting[grouptitle]'");
	
		$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($setting['description']) . "' WHERE varname = 'setting_" . $setting['varname'] . "_desc' AND phrasetypeid = '5000'");
	
		$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($setting['title']) . "' WHERE varname = 'setting_" . $setting['varname'] . "_title' AND phrasetypeid = '5000'");
	}

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=modifysettings", 0);
}



// ############################# Build frameset ###############################
if ($_REQUEST['do'] == 'frameset')
{
	$navframe = '<frame src="vba_cmps_admin.php?do=menu" name="nav" scrolling="yes" border="no" />';
	$mainframe = '<frame src="vba_cmps_admin.php?do=main" name="main" scrolling="yes" border="no" />';

	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
	<html dir="' . $stylevar['textdirection'] . '" lang="'. $stylevar['languagecode'] . '">
	<head>
		<title>' . $vboptions['gallerytitle'] . ' ' . $vbphrase['admin_control_panel'] . '</title>
		<script type="text/javascript">
		<!-- //
		if (self.parent.frames.length != 0)
		{
			document.write(\'Get me out of this frame set!\');
			self.parent.location.replace(document.location.href);
		}
		// -->
		</script>
	</head>
	<frameset cols="' . iif($stylevar['textdirection'] == 'ltr', '195,*', '*,195') . '"  framespacing="0" border="0" frameborder="0" frameborder="no" border="0">
			' . iif($stylevar['textdirection'] == 'ltr', $navframe . $mainframe, $mainframe . $navframe);
	exit;
}

// ################################# Nav menu #################################
if ($_REQUEST['do'] == 'menu')
{
	require_once('./includes/adminfunctions_navpanel.php');
	print_cp_header();

	echo '<div><img alt="" border="" src="../cpstyles/' . $vboptions['cpstylefolder'] . '/vba_cp_logo.gif" title="' . $vbphrase['admin_control_panel'] . '" hspace="4" vspace="4" /></div><div style="width:168px; padding:4px">';

	echo '<br /><div class="navtitle">' . $vbphrase['vba_cmps'] . '</div><div class="navgroup">';

	construct_nav_option($vbphrase['default_settings'], 'vba_cmps_admin.php?do=modifysettings');
	construct_nav_option($vbphrase['edit_modules'], 'vba_cmps_admin.php?do=listmodules');
	construct_nav_option($vbphrase['add_module'], 'vba_cmps_admin.php?do=newmodule');
	construct_nav_option($vbphrase['edit_pages'], 'vba_cmps_admin.php?do=listpages');
	construct_nav_option($vbphrase['add_page'], 'vba_cmps_admin.php?do=newpage');
	construct_nav_option($vbphrase['download_upload_module'], 'vba_cmps_admin.php?do=download');
	construct_nav_option($vbphrase['quick_permissions_editor'], 'vba_cmps_admin.php?do=permissions');

	foreach ($options AS $links)
	{
		echo $links;
	}
	exit;
}

// ########################### Download Module ################################
if ($_REQUEST['do'] == 'downloadmodule')
{
	globalize($_REQUEST, array('modid' => INT));

	$module = $DB_site->query_first("SELECT title, identifier, filename, inctype, parent, templatelist, colspan, formcode, cleanoutput, options, useshell, link FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$modid'");

	$moduleinfo['module'] = serialize($module);

	if (($module['inctype'] == 'php_file' AND $module['filename']) OR $module['templatelist'] OR $module['filename'] AND $module['inctype'] == 'template')
	{
		$tnames = iif($module['templatelist'], explode(',', str_replace(' ', '', $module['templatelist'])), array('adv_portal_' . $module['filename']));

		if (!empty($tnames))
		{
			$template = array();
			$templates = $DB_site->query("SELECT title, template_un FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("', '", $tnames) . "')");
			while ($temp = $DB_site->fetch_array($templates))
			{
				$template["$temp[title]"] = stripslashes($temp['template_un']);
			}
		}

		if (!empty($template))
		{
			$moduleinfo['templates'] = serialize($template);
		}

		if ($fp = @fopen('./modules/' . $module['filename'], 'r'))
		{
			$moduleinfo['file'] = fread($fp, filesize('./modules/' . $module['filename']));
			fclose($fp);
		}
	}

	if ($module['inctype'] == 'template')
	{
		$getphrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE phrasetypeid = 5000 ORDER BY languageid ASC");
		while($phrases = $DB_site->fetch_array($getphrases))
		{
			$settingphrase["$phrases[varname]"] = $phrases['text'];
		}

		$modsettings = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$module[identifier]'");
		while ($setting = $DB_site->fetch_array($modsettings))
		{
			$moduleinfo['settings']["$setting[varname]"] = $setting;
			$moduleinfo['settings']["$setting[varname]"]['title'] = $settingphrase["setting_$setting[varname]_title"];
			$moduleinfo['settings']["$setting[varname]"]['description'] = $settingphrase["setting_$setting[varname]_desc"];
		}
	}

	$moduleinfo = serialize($moduleinfo);

	header('Content-Type: application/octetstream');
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Content-Disposition: attachment; filename="' . strtolower(preg_replace("/[^a-z_0-9]/i", '' , $module['title'])) . '.module"');
	header('Content-Length: ' . strlen($moduleinfo));
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');

	echo $moduleinfo;
	exit;
}

// Print Admin Header
print_cp_header($vbphrase['vbadvanced_cmps'], iif (in_array($_REQUEST['do'], array('addmodule', 'editmodule', 'copymodule', 'addpage', 'editpage', 'copypage')), 'editInit();'));

$vba_options = unserialize($datastore['adv_portal_opts']);


// Main admin page
if ($_REQUEST['do'] == 'main')
{
	$cversion = @file_get_contents('http://license.vbadvanced.com/?p=4', 'r');

	print_form_header('', '');
	print_table_header($vbphrase['welcome_to_vba_cmps_control_panel']);
	print_description_row(iif($cversion, construct_phrase($vbphrase['currently_running_latest_available'], $vba_options['portal_version'], $cversion, iif($cversion == $vba_options['portal_version'], $vbphrase['your_vba_version_up_to_date'], $vbphrase['newer_version_available'])), $vbphrase['version_info_unavailable']));
	print_table_footer();

}

if ($_REQUEST['do'] == 'noaction')
{
	print_stop_message('invalid_action_specified');
}

// ######################## Modify Settings ###########################
if ($_REQUEST['do'] == 'modifysettings')
{
	globalize($_REQUEST, array('showall' => INT));
	
	echo '<div align="center">' . construct_link_code(iif($showall, $vbphrase['hide_module_settings'], $vbphrase['show_module_settings']), 'vba_cmps_admin.php?do=modifysettings&amp;showall=' . iif($showall, 0, 1)) . '</div>';

	print_form_header('vba_cmps_admin', 'saveopts');

	print_adv_setting_group('mainsettings' . iif($showall, '_all'));
	construct_hidden_code('showall', $showall);

	print_submit_row();
}

// ####################### Save Settings ############################
if ($_POST['do'] == 'saveopts')
{
	globalize($_POST, array('setting'));

	construct_cmps_settings();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=modifysettings&showall=$_POST[showall]", 0);
}

// ######################## Add / Edit Setting ###########################
if (in_array($_REQUEST['do'], array('addsetting', 'editsetting')))
{
	globalize($_REQUEST, array('varname' => STR, 'identifier' => STR));

	print_form_header('vba_cmps_admin', 'do' . $_REQUEST['do']);
	print_table_header(iif($_REQUEST['do'] == 'editsetting', $vbphrase['edit_setting'] . ': ' . $varname, $vbphrase['add_setting']));
	construct_hidden_code('modid', $_REQUEST['modid']);

	if ($_REQUEST['do'] == 'editsetting')
	{
		$setting = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$_REQUEST[varname]'");

		construct_hidden_code('setting[varname]', $setting['varname']);
		print_label_row($vbphrase['varname'], '<b>' . $setting['varname'] . '</b>');

		$phrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE varname IN ('setting_$setting[varname]_title', 'setting_$setting[varname]_desc') AND phrasetypeid = '5000'");
		while ($phrase = $DB_site->fetch_array($phrases))
		{
			if ($phrase['varname'] == "setting_$setting[varname]_title")
			{
				$setting['title'] = $phrase['text'];
			}
			else
			{
				$setting['description'] = $phrase['text'];
			}
		}
	}
	else
	{
		print_input_row($vbphrase['varname'], 'setting[varname]', $setting['varname']);
	}
	print_input_row($vbphrase['title'], 'setting[title]', $setting['title']);
	construct_hidden_code('setting[identifier]', $identifier);
	print_textarea_row($vbphrase['description'], 'setting[description]', $setting['description']);
	print_textarea_row($vbphrase['option_code'], 'setting[optioncode]', $setting['optioncode'], 4, 50);
	print_textarea_row($vbphrase['default'], 'setting[defaultvalue]', $setting['defaultvalue'], 4, 50);
	print_input_row($vbphrase['display_order'], 'setting[displayorder]', $setting['displayorder']);
	print_submit_row();
}

// ######################## Do Add Setting ###########################
if ($_POST['do'] == 'doaddsetting')
{
	globalize($_POST, array('setting', 'modid' => INT));

	if (!$checkphrase = $DB_site->query_first("SELECT varname FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $setting['varname'] . "_title' OR varname = 'setting_" . $setting['varname'] . "_desc'"))
	{
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, text, phrasetypeid) VALUES ('0', 'setting_" . $setting['varname'] . "_title', '" . addslashes(htmlspecialchars($setting['title'])) ."', '5000')");
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, text, phrasetypeid) VALUES ('0',  'setting_" . $setting['varname'] . "_desc', '" . addslashes($setting['description']) . "', '5000')");
	}

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_setting (varname, grouptitle, value, defaultvalue, optioncode, displayorder) VALUES ('$setting[varname]', 'adv_portal_$setting[identifier]', '$setting[defaultvalue]', '$setting[defaultvalue]', '" . addslashes($setting['optioncode']) . "', '$setting[displayorder]')");

	build_adv_settings();

	print_cp_redirect('vba_cmps_admin.php?' . $session['sessionurl'] . iif($modid, 'do=editmodule&modid=' . $modid, 'modifysettings'), 0);

}	

// ######################## Do Edit Setting ###########################
if ($_POST['do'] == 'doeditsetting')
{
	globalize($_POST, array('setting'));

	$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET defaultvalue = '$setting[defaultvalue]', optioncode = '" . addslashes($setting['optioncode']) . "', displayorder = '$setting[displayorder]' WHERE varname = '$setting[varname]' AND grouptitle = '$setting[grouptitle]'");

	$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($setting['description']) . "' WHERE varname = 'setting_" . $setting['varname'] . "_desc' AND phrasetypeid = 5000");

	$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($setting['title']) . "' WHERE varname = 'setting_" . $setting['varname'] . "_title' AND phrasetypeid = 5000");

	print_cp_redirect('vba_cmps_admin.php?' . $session['sessionurl'] . 'do=editmodule&modid=' . $_POST['modid'], 0);
}

// ########################## Remove Setting ###########################
if ($_REQUEST['do'] == 'removesetting')
{
	globalize($_REQUEST, array('varname' => STR_NOHTML, 'grouptitle' => STR_NOHTML));

	print_form_header('vba_cmps_admin', 'doremovesetting');
	construct_hidden_code('varname', $varname);
	construct_hidden_code('grouptitle', $grouptitle);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'], $vbphrase['setting'], $varname, $vbphrase['varname'], $varname, ''));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ######################### Do Remove Setting ############################
if ($_POST['do'] == 'doremovesetting')
{
	globalize($_POST, array('varname' => STR_NOHTML, 'grouptitle' => STR_NOHTML));

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	$dupecheck = $DB_site->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
	if (!$dupecheck['varname'])
	{
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_desc'");
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_title'");
	}

	build_adv_settings();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=modifysettings", 0);
}	

// ##################### List Modules #########################
if ($_REQUEST['do'] == 'listmodules')
{
	print_form_header('vba_cmps_admin', 'updatemodorder');
	print_table_header($vbphrase['edit_modules'], 3);

	print_module_columns('module');

	print_table_break();

	print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 3);
	print_table_footer();

}

// ##################### Update Modual Order #####################
if ($_POST['do'] == 'updatemodorder')
{
	globalize($_POST, array('modorder'));

  foreach ($modorder AS $key => $disorder)
  {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET displayorder = '$disorder' WHERE modid = '$key'");
  }
	update_module_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listmodules", 0);
	
}

// ########################## Move Module ##########################
if ($_REQUEST['do'] == 'movemodule')
{
	globalize($_REQUEST, array('col' => INT, 'modid' => INT));

	$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET modcol = '$col' WHERE modid = '$modid'");

	update_module_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listmodules", 0);
}

// ############################ New Module ###############################
if (in_array($_REQUEST['do'], array('newmodule', 'newpage')))
{
	if ($_REQUEST['do'] == 'newmodule')
	{
		$type =  'module';
		$allowphrase = 'this_module';
	}
	else
	{
		$type = 'page';
		$allowphrase = 'your_custom_content';
	}
	
	print_form_header('vba_cmps_admin', 'add' . $type, false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase["$type" . _type . ""]);

	print_description_row(construct_phrase($vbphrase['please_select_type_of_x_to_add'], $vbphrase["$type"]), '', 2, 'thead');
	if ($type == 'page')
	{
		print_label_row(construct_link_code($vbphrase['module'], 'vba_cmps_admin.php?do=addpage&amp;type=module'), $vbphrase['module_allows_module'], 0, 'middle');
	}

	print_label_row(construct_link_code($vbphrase['bb_code'], 'vba_cmps_admin.php?do=add' . $type . '&amp;type=bb_code'), construct_phrase($vbphrase['bbcode_allows_bbcode'], $vbphrase["$type"], $vbphrase["$allowphrase"]), 0, 'middle');
	print_label_row(construct_link_code($vbphrase['template'], 'vba_cmps_admin.php?do=add' . $type . '&amp;type=template'), construct_phrase($vbphrase['template_allows_template'], $vbphrase["$type"], $vbphrase["$allowphrase"]), 0, 'middle');
	print_label_row(construct_link_code($vbphrase['php_file'], 'vba_cmps_admin.php?do=add' . $type . '&amp;type=php_file'), construct_phrase($vbphrase['file_allows_file'], $vbphrase["$type"], $vbphrase["$allowphrase"]), 0, 'middle');

	if ($type == 'page')
	{
		$bgclass = exec_switch_bg();
		echo '<tr><td class="' . $bgclass . '" nowrap="nowrap">' . construct_link_code($vbphrase['html_file'], 'vba_cmps_admin.php?do=addpage&amp;type=html_file') . '</td><td class="' . $bgclass . '">' . $vbphrase['html_allows_html'] . '</td></tr>';
	}

	print_table_footer();
}

// ######################## Add / Edit Module #########################
if (in_array($_REQUEST['do'], array('addmodule', 'editmodule', 'copymodule')))
{

	globalize($_REQUEST, array('modid' => STR, 'type' => STR_NOHTML, 'module'));

	require_once('./includes/adminfunctions_template.php');

	if (in_array($_REQUEST['do'], array('editmodule', 'copymodule')))
	{
		$module = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$modid'");
		$headertitle = iif($_REQUEST['do'] == 'editmodule', $vbphrase['edit_module'], $vbphrase['copy']) . ': ' . $module['title'];

		if (!$module['modid'])
		{
			print_stop_message('invalid_x_specified', $vbphrase['module']);
		}

		$modopts = unserialize($module['options']);

		if ($chtype)
		{
			$module['filename'] = '';
		}
		else
		{
			$type = $module['inctype'];
		}
	}
	else
	{
		$headertitle = iif(empty($module), $vbphrase['add_module'], $vbphrase['copy'] . ': ' . $module['title']);
		$module['active'] = 1;
		$module['useshell'] = 1;
	}

	// Module tools
	if ($_REQUEST['do'] == 'editmodule')
	{
		print_table_start();
		print_table_header($headertitle);

		if ($module['identifier'] == 'custompage')
		{
			print_description_row($vbphrase['custom_page_content_description']);
			print_table_footer();
		}
		else if ($chtype)
		{
			print_description_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['module']), 0, 2, 'thead');
			print_description_row(construct_phrase($vbphrase['change_x_type_note'], $vbphrase['module'], $vbphrase["$module[inctype]"], $vbphrase["$type"]));
			print_table_footer();
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['x_tools'], $vbphrase['module']), 0, 2, 'thead');
			echo '<form action="vba_cmps_admin.php"><input type="hidden" name="modid" value="' . $module['modid'] . '" />';
			print_label_row($vbphrase['select_an_action'], '<select name="do">' . construct_select_options(array('noaction' => $vbphrase['please_select_one'], 'copymodule' => $vbphrase['copy'], 'removemodule' => $vbphrase['delete'])) . ' <input type="submit" value="' . $vbphrase['go'] . '" />', '', 'top', '', true);
			echo '</form>';

			$modtypes = array(
				'noaction' => $vbphrase['please_select_one'], 
				'chtype_php_file' => $vbphrase['file'], 
				'chtype_template' => $vbphrase['template'], 
				'chtype_bb_code' => $vbphrase['bb_code']
			);

			unset($modtypes["chtype_$type"]);

			echo '<form action="vba_cmps_admin.php"><input type="hidden" name="do" value="editmodule" /><input type="hidden" name="modid" value="' . $module['modid'] . '" />';
			print_label_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['module']), '<select name="chtype">' . construct_select_options($modtypes) . ' <input type="submit" value="' . $vbphrase['go'] . '" />');
			echo '</form>';
			print_table_footer();
		}
	}

	// Main options
	echo '<form action="vba_cmps_admin.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return validatePost(this, 0, 0, 0);"') . '><input type="hidden" name="do" value="do' . iif($_REQUEST['do'] == 'editmodule', 'editmodule', 'addmodule') . '" />';

	print_table_start();
	construct_hidden_code('modid', $module['modid']);
	print_table_header($vbphrase['main_options']);
	print_input_row($vbphrase['module_title'], 'module[title]', $module['title']);
	print_select_row($vbphrase['column'], 'module[modcol]', array(0 => $vbphrase['left_column'], 2 => $vbphrase['right_column'], 1 => $vbphrase['center_column']), $module['modcol']);

	print_input_row($vbphrase['display_order'], 'module[displayorder]', $module['displayorder']);

	construct_hidden_code('module[inctype]', $type);

	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', $module['active']);

	if (in_array($_REQUEST['do'], array('addmodule', 'copymodule')))
	{
		print_yes_no_row($vbphrase['update_all_pages'], 'updateall', 1);
	}

	print_table_break();

	if ($type != 'custom')
	{
		print_table_header(construct_phrase($vbphrase['x_y_options'], $vbphrase['module'], $vbphrase["$type"]));

		switch ($type)
		{
			// File module
			case 'php_file':
				$filenames['none'] = $vbphrase['choose_a_file'];
				$filenames['dash'] = '--------------------';
			
				$directory = opendir('./modules'); 
				while ($modfile = readdir($directory))
				{ 
					if (ereg('[^.]+', $modfile))
					{ 
						$filenames["$modfile"] = $modfile;
					}
				} 
			
				closedir($directory);
				asort($filenames);
				print_select_row($vbphrase['file_to_include'], 'module[filename]', $filenames, $module['filename']);

				$modselcache = array();
				$modselcache[''] = $vbphrase['none'];
				$getmodules = $DB_site->query("SELECT identifier, title FROM " . TABLE_PREFIX . "adv_modules WHERE identifier != '' ORDER BY modcol, displayorder");
				while ($modules = $DB_site->fetch_array($getmodules))
				{
					$modselcache["$modules[identifier]"] = $modules['title'];
				}

				$DB_site->free_result($getmodules);
				unset($modules);

				print_select_row($vbphrase['module_parent'], 'module[parent]', $modselcache, $module['parent']);

				if (in_array($_REQUEST['do'], array('addmodule', 'copymodule')))
				{
					if ($_REQUEST['do'] == 'copymodule')
					{
						$modidents = array();
						$modids = $DB_site->query("SELECT identifier FROM " . TABLE_PREFIX . "adv_modules WHERE identifier LIKE '$module[identifier]%'");
						while ($modident = $DB_site->fetch_array($modids))
						{
							$modidents[] = $modident['identifier'];
						}
			
						$idcount = 1;
						$oldident = $module['identifier'];
						construct_hidden_code('oldident', $oldident);
						while (!$foundident)
						{
							$idcount++;
							if (!in_array($module['identifier'] . $idcount, $modidents))
							{
								$module['identifier'] = $module['identifier'] . $idcount;
								$foundident = true;
							}
						}
					}
					print_input_row($vbphrase['identifier'], 'module[identifier]', $module['identifier']);
				}
				else
				{
					construct_hidden_code('module[identifier]', $module['identifier']);
				}
				print_textarea_row($vbphrase['templates_used'], 'module[templatelist]', $module['templatelist'], 4, 40, 1, 0);
				print_yes_no_row($vbphrase['clean_file_output'], 'module[cleanoutput]', $module['cleanoutput']);
				break;
	
			// Template module
			case 'template':
	
				echo '<tr><td class="alt2" width="100%">' . $vbphrase['template_to_include'] . '</td><td align="' . $stylevar['left'] . '" class="alt2"><span class="smallfont">adv_portal_</span><input type="text" class="bginput" name="module[filename]" id="it_module[filename]" value="' . $module['filename'] . '" size="24" /></td></tr>';
	
				if ($_REQUEST['do'] == 'addmodule')
				{
					print_style_chooser_row('styleid', 1, '', $vbphrase['style'], 1);
					print_textarea_row(construct_phrase($vbphrase['template_content'], $vbphrase['module']), 'template', '', 20, 60, true, true, 'ltr', 'code');
				}
	
				break;
	
			// BB code module
			case 'bb_code':
				if ($_REQUEST['do'] == 'addmodule')
				{
					$modopts['allow_html'] = 1;
					$modopts['allow_smilies'] = 1;
					$modopts['allow_image_code'] = 1;
				}

				require_once('./includes/functions_editor.php');
				$textareacols = fetch_textarea_width();

				$gettemp = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "template WHERE styleid = '-1'");
				while ($temp = $DB_site->fetch_array($gettemp))
				{
					$templatecache["$temp[title]"] = $temp['template'];
				}

				$style = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = '$vboptions[styleid]'");
				$stylevar = unserialize($style['stylevars']);

				$stycolor = unserialize($style['csscolors']);
				
				echo '<style type="text/css"><!-- 
					.wysiwyg
					{
						background-color: ' . $stycolor['wysiwyg_bgcolor'] . ';
						color: ' . $stycolor['wysiwyg_fgcolor'] . ';
						font: 10pt verdana, geneva, lucida, \'lucida grande\', arial, helvetica, sans-serif;
					}
				-->
				</style>';

				// Editor & message area
				construct_edit_toolbar(htmlspecialchars($module['filename']), 0, 0, 1);

				print_description_row(str_replace('"clientscript', '"' . $vboptions['bburl'] . '/clientscript', $messagearea));
				print_yes_no_row($vbphrase['allow_html'], 'setting[allow_html]', $modopts['allow_html']);
				print_yes_no_row($vbphrase['allow_smilies'], 'setting[allow_smilies]', $modopts['allow_smilies']);
				print_yes_no_row($vbphrase['allow_image_code'], 'setting[allow_image_code]', $modopts['allow_image_code']);
		}
	
		print_table_break();

		// Module shell options
		print_table_header($vbphrase['module_shell_template_options']);
		print_description_row('<span class="smallfont">' . $vbphrase['options_apply_to_module_shell'] . '</span>', 0, 2, 'thead');
		print_yes_no_row(construct_phrase($vbphrase['use_module_shell_template'], $vbphrase['module']), 'module[useshell]', $module['useshell']);
		print_input_row(construct_phrase($vbphrase['x_link'], $vbphrase['module']), 'module[link]', $module['link']);
		print_input_row($vbphrase['title_row_colspan'], 'module[colspan]', $module['colspan']);
		print_textarea_row($vbphrase['form_code'], 'module[formcode]', $module['formcode']);
	
		print_table_break();
	
		// Usergroups 
		print_table_header($vbphrase['usergroups']);
		print_description_row($vbphrase['here_specify_which_usergroups_view_module'], '', 2, 'thead', 'center');
	
		$module['userperms'] = explode(',', $module['userperms']);
	
		$usergroups = $DB_site->query("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
		while ($usergroup = $DB_site->fetch_array($usergroups))
		{
			print_yes_no_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', iif(in_array($usergroup['usergroupid'], $module['userperms']) OR $_REQUEST['do'] == 'addmodule', 1, 0));
		}
		print_table_break();

		// Module Settings
		if (in_array($_REQUEST['do'], array('editmodule', 'copymodule')) AND $type == 'php_file')
		{
			if ($_REQUEST['do'] == 'copymodule')
			{
				$module['identifier'] = $oldident;
			}
	
			// Get settings for each page
			if (!$oldident)
			{
				$getpagesettings = $DB_site->query("SELECT pageid, title, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE advanced != ''");
				while ($psetting = $DB_site->fetch_array($getpagesettings))
				{
					$psetting['advanced'] = unserialize($psetting['advanced']);
		
					if (!empty($psetting['advanced']))
					{
						$pagesetting["$psetting[pageid]"]['title'] = $psetting['title'];
						foreach ($psetting['advanced'] AS $varname => $value)
						{
							foreach ($value AS $vname => $settings)
							{
								$pagesettings["$varname"]["$vname"]["$psetting[pageid]"] = $psetting['title']	;
							}
						}
					}
				}
	
				$DB_site->free_result($getpagesettings);
				unset($psetting);
			}

			print_adv_setting_group('module', 'adv_portal_' . $module['identifier']);
	
			print_table_break();
		}
	}

	if ($_REQUEST['do'] == 'editmodule' AND $type == 'php_file' AND $debug)
	{
		echo '<div align="center" style="margin-bottom:6px">'  . construct_link_code($vbphrase['add_setting'], "vba_cmps_admin.php?$session[sessionurl]do=addsetting&amp;identifier=$module[identifier]") . '</center>';
	}

	print_submit_row();	

}

// ##################### Do Add / Edit Module ##########################
if (in_array($_POST['do'], array('doaddmodule', 'doeditmodule')))
{
	globalize($_POST, array('modid' => INT, 'module', 'userperms', 'setting', 'template', 'styleid' => INT, 'oldident' => STR_NOHTML));

	if (!$module['title'])
	{
		print_stop_message('adv_portal_must_choose_title_for_module');
	}

	if ($module['inctype'] == 'bb_code')
	{
		$module['filename'] = $_POST['message'];
		if ($_POST['WYSIWYG_HTML'])
		{
			require_once('./includes/functions_wysiwyg.php');
			$module['filename'] = convert_wysiwyg_html_to_bbcode($_POST['WYSIWYG_HTML']);
		}
	}

	if ((!$module['filename'] AND $module['identifier'] != 'custompage' AND $module['inctype'] != 'bb_code') OR ($module['inctype'] == 'php_file' AND in_array($module['filename'], array('none', 'dashes'))))
	{
		print_stop_message('adv_portal_must_choose_' . $module['inctype'] . '_include');
	}

	if ($module['inctype'] == 'php_file' AND $_REQUEST['do'] == 'doaddmodule')
	{
		if ($checkidentifier = $DB_site->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = '$module[identifier]'"))
		{
			print_stop_message('adv_portal_duplicate_identifier', $vbphrase['module'], $module['identifier']);
		}
	}

	// Insert new template
	if (trim($template))
	{
		if ($checkexist = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "template WHERE title = 'adv_portal_$module[filename]' AND styleid = '$styleid'"))
		{
			print_stop_message('adv_portal_template_exists', 'adv_portal_' . $module['filename']);		
		}

		require_once('./includes/adminfunctions_template.php');

	  $DB_site->query("INSERT INTO " . TABLE_PREFIX . "template (templateid, title, template, template_un, styleid, templatetype, dateline, username, version) VALUES (NULL, 'adv_portal_$module[filename]', '" . addslashes(compile_template($template)) . "', '" . addslashes($template) ."', '$styleid', 'template', '" . time() . "', '$bbuserinfo[userid]', '$vboptions[templateversion]')");

		build_all_styles(0, 0, 'vba_cmps_admin.php?do=editmodules');
	}

	// Usergroup permissions
	if (!empty($userperms))
	{
		$ugperms = array();
		foreach ($userperms AS $usergroupid => $allow)
		{
			if ($allow)
			{
				$ugperms[] = $usergroupid;
			}
		}
		$module['userperms'] = implode(',', $ugperms);
	}

	// Duplicate the settings if copying
	if ($oldident)
	{
		$repsettings = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$oldident'");
		while ($repsetting = $DB_site->fetch_array($repsettings))
		{
			$repsetting['grouptitle'] = 'adv_portal_' . $module['identifier'];
			$DB_site->query(fetch_query_sql($repsetting, 'adv_setting'));
		}
	}

	construct_cmps_settings('module');

	if ($_POST['do'] == 'doaddmodule')
	{
		// Insert module
		$DB_site->query(fetch_query_sql($module, 'adv_modules'));
		$modid = $DB_site->insert_id();

		if ($_POST['updateall'])
		{
			$pages = $DB_site->query("SELECT pageid, modules FROM " . TABLE_PREFIX . "adv_pages");
			while ($page = $DB_site->fetch_array($pages))
			{
				$pagemodules = explode(',', $page['modules']);
				$pagemodules[] = $modid;
				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET modules = '" . implode(',', $pagemodules) . "' WHERE pageid = '$page[pageid]'");
			}
		}
	}
	else
	{
		// Update module
		$DB_site->query(fetch_query_sql($module, 'adv_modules', 'WHERE modid = ' . $modid));
	}

	update_module_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listmodules", 0);
}

// ######################## Remove Module ############################
if ($_REQUEST['do'] == 'removemodule')
{
	$module = $DB_site->query_first("SELECT modid, title FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$_REQUEST[modid]'");
	print_form_header('vba_cmps_admin', 'doremovemodule');
	construct_hidden_code('modid', $_REQUEST['modid']);
	print_table_header($vbphrase['confirm_deletion']);

	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_module_called_x'], $module['title']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ######################## Do Remove Module ############################
if ($_POST['do'] == 'doremovemodule')
{
	$module = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$_POST[modid]'");
	if ($module['inctype'] == 'php_file')
	{
		$killphrase = array();
		$varnames = array();

		$modsettings = $DB_site->query("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$module[identifier]'");
		while ($modsetting = $DB_site->fetch_array($modsettings))
		{
			$varnames[] = $modsetting['varname'];
		}

		if (!empty($varnames))
		{
			$dupevar = array();
			$checkdupe = $DB_site->query("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle != 'adv_portal_$module[identifier]' AND varname IN('" . implode("', '", $varnames) . "')");
			while ($dupes = $DB_site->fetch_array($checkdupe))
			{
				$dupevar[] = $dupes['varname'];
			}
	
			$varnames = array_diff($varnames, $dupevar);
	
			if (!empty($varnames))
			{
				foreach ($varnames AS $pvarname)
				{
					$killphrase[] = 'setting_' . $pvarname . '_title';
					$killphrase[] = 'setting_' . $pvarname . '_desc';
				}
	
				$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname IN('" . implode("', '", $varnames) . "')");
				$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN('" . implode("', '", $killphrase) . "')");
			}
		}
	}

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$_POST[modid]'");
	update_module_cache();
	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listmodules", 0);
}

// ##################### List Pages #########################
if ($_REQUEST['do'] == 'listpages')
{
	print_form_header('vba_cmps_admin', 'doupdatepages');
	print_table_header($vbphrase['edit_pages'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['identifier'], $vbphrase['page_type'], $vbphrase['options']), 1);

	?>
	<script type="text/javascript">
	function js_page_jump(pageid)
	{
		action = eval("document.cpform.p" + pageid + ".options[document.cpform.p" + pageid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit': 
				page = 'vba_cmps_admin.php?do=editpage&pageid=';
				break;
			case 'remove': 
				page = 'vba_cmps_admin.php?do=removepage&pageid=';
				break;
		}
		document.cpform.reset();

		window.location = page + pageid + "&s=<?php echo $session['sessionhash']; ?>";
	}
	</script>

	<?php

	$diroptions = array(
		'edit' => $vbphrase['edit'],
		'remove' => $vbphrase['delete']
	);

	$pagecache = array();
	$pages = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_pages");
	while ($page = $DB_site->fetch_array($pages))
	{
		$pagecache["$page[pageid]"] = $page;
	}
	$DB_site->free_result($pages);
	unset($page);

	$pages = construct_page_structure($pagecache, 0);

	foreach ($pages AS $pageid => $page)
	{
		$cells = array();
		$cells[] = '<b>' . str_repeat('- - ', ($page['level'] - 1)) . '<a href="vba_cmps_admin.php?do=editpage&amp;pageid=' . $page['pageid'] . '">' . $page['title'] . '</a></b>' . iif(!$page['active'], ' <span style="color:red;font-size:9px;font-weight:normal;">(' . $vbphrase['inactive'] . ')</span></div>');
		$cells[] = $page['name'];
		$cells[] = $vbphrase["$page[type]"];
		$cells[] = '<select name="p' . $page['pageid'] . '" onchange="js_page_jump(' . $page['pageid'] . ');" class="bginput">' . construct_select_options($diroptions) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_jump(' . $page['pageid'] . ');" />';

		print_cells_row($cells);
	}

	print_table_footer();

}

// ########################## Build Modules ######################
if ($_REQUEST['do'] == 'buildmods')
{
	update_module_cache();
}

// ######################## Add / Edit Page #########################
if (in_array($_REQUEST['do'], array('addpage', 'editpage', 'copypage')))
{

	globalize($_REQUEST, array('type' => STR_NOHTML));

	?>
	<script type="text/javascript">
	<!--
	function js_check_default(grouptitle, varname)
	{
		document.cpform[ "usedefault[" + grouptitle + "][" + varname + "]" ].checked=false
	}
	// -->
	</script>

	<script language="Javascript">
	
	function checkAll(allbox)
	{
		var	allInputs	=	allbox.form.getElementsByTagName("input")	
		var	allUsedefaults = new Array()
		for	(var i = 0;	i	<	allInputs.length;	i++)
		{	
			if (allInputs[i].type	!= 'checkbox')	
			continue;	
			if (allInputs[i].name.match(/usedefault\[[^\]]+\]/))
			{	
				allUsedefaults.push(allInputs[i])
			}
		}
		for	(var i = 0;	i	<	allUsedefaults.length; i++)
		{	
			allUsedefaults[i].checked	=	allbox.checked
		}
	}

	</script>
	
	<?php

	globalize($_REQUEST, array('pageid' => INT));

	$getpages = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_pages");
	while ($pages = $DB_site->fetch_array($getpages))
	{
		$pagecache["$pages[pageid]"] = $pages;
	}

	$DB_site->free_result($getpages);
	unset($pages);

	$pages = construct_page_structure($pagecache, 0);

	if ($_REQUEST['do'] == 'addpage')
	{
		$page['active'] = 1;
		$page['useshell'] = 1;
		$adv_opts['custompage']['allow_html'] = 1;
		$adv_opts['custompage']['allow_smilies'] = 1;
		$adv_opts['custompage']['allow_image_code'] = 1;
	}
	else
	{
		$page = $pagecache["$pageid"];
		if (!isset($type))
		{
			$type = $page['type'];
		}

		// Page Settings
		$adv_opts = unserialize($page['advanced']);
	}

	require_once('./includes/adminfunctions_template.php');

	// Page tools
	if ($_REQUEST['do'] == 'editpage')
	{
		print_form_header('vba_cmps_admin', '', false, true, 'toolsform');
		construct_hidden_code('pageid', $page['pageid']);
		print_table_header($vbphrase['edit_page'] . ': ' . $page['title']);

		if ($chtype)
		{
			$page['template'] = '';
			print_description_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['page']), 0, 2, 'thead');
			print_description_row(construct_phrase($vbphrase['change_x_type_note'], $vbphrase['page'], $vbphrase["$page[type]"], $vbphrase["$type"]));
			print_table_footer();
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['x_tools'], $vbphrase['page']), 0, 2, 'thead');
			print_label_row($vbphrase['select_an_action'], '<select name="do">' . construct_select_options(array('' => $vbphrase['please_select_one'], 'copypage' => $vbphrase['copy'], 'removepage' => $vbphrase['delete'])) . ' <input type="submit" value="' . $vbphrase['go'] . '" />', '', 'top', '', true);

			$pagetypes = array(
				'' => $vbphrase['please_select_one'], 
				'chtype_module' => $vbphrase['module'],
				'chtype_php_file' => $vbphrase['file'], 
				'chtype_template' => $vbphrase['template'], 
				'chtype_bb_code' => $vbphrase['bb_code']
			);

			unset($pagetypes["chtype_$type"]);

			print_label_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['page']), '<select name="chtype">' . construct_select_options($pagetypes) . ' <input type="submit" value="' . $vbphrase['go'] . '" />');
			print_table_footer();
		}
	}

	if ($_REQUEST['do'] == 'copypage')
	{
		$pagenames = array();
		$getpages = $DB_site->query("SELECT name FROM " . TABLE_PREFIX . "adv_pages WHERE name LIKE '$page[name]%'");
		while ($npages = $DB_site->fetch_array($getpages))
		{
			$pagenames[] = $npages['identifier'];
		}

		$namecount = 1;
		while (!$foundname)
		{
			$namecount++;
			if (!in_array($page['name'] . $namecount, $pagenames))
			{
				$page['name'] = $page['name'] . $namecount;
				$foundname = true;
			}
		}
	}

	// Template options
	if ($_REQUEST['do'] == 'editpage' AND $type == 'template' AND !$chtype)
	{
		cache_styles();

		$styles = array();
		$gettemp = $DB_site->query("SELECT templateid, styleid FROM " . TABLE_PREFIX . "template WHERE title = '$page[template]' AND styleid != '-1'");
		while ($temp = $DB_site->fetch_array($gettemp))
		{
			$styles["$temp[templateid]"] = $stylecache["$temp[styleid]"]['title'];
		}

		if (!empty($styles))
		{
			print_form_header('template', 'edit');
			print_table_header($vbphrase['edit_template']);
			print_select_row($vbphrase['edit_template_in_style'], 'templateid', $styles);
			print_submit_row($vbphrase['go'], '');
		}
	}

	echo '<form action="vba_cmps_admin.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return validatePost(this, 0, 0, 0);"') . '><input type="hidden" name="do" value="' . iif($_REQUEST['do'] == 'editpage', 'doeditpage', 'doaddpage') . '" />';

	print_table_start();
	construct_hidden_code('pageid', $page['pageid']);

	print_table_header($vbphrase['main_options']);
	construct_hidden_code('page[type]', $type);

	print_input_row($vbphrase['page_title'], 'page[title]', $page['title']);

	if ($page['name'] == 'home')
	{
		construct_hidden_code('page[name]', 'home');
	}
	else
	{
		print_input_row($vbphrase['page_identifier'] . '<div class="smallfont">' . construct_phrase($vbphrase['page_identifier_example'], $vba_options['portal_homeurl'], $vba_options['portal_pagevar']), 'page[name]', $page['name']);
	}

	$pageselect = array();
	$pageselect['0'] = $vbphrase['none'];
	$pageselect['-'] = '----------------';

	foreach ($pages AS $apageid => $pageinfo)
	{
		$pageselect["$pageinfo[pageid]"] = str_repeat('- - ', ($pageinfo['level'] - 1)) . $pageinfo['title'];
	}

	print_select_row($vbphrase['parent_page'], 'page[parentid]', $pageselect, $page['parentid']);

	print_style_chooser_row('page[styleid]', $page['styleid'], $vbphrase['use_default_style'], $vbphrase['custom_style_for_this_page'], 1);

	print_yes_no_row($vbphrase['page_active'], 'page[active]', $page['active']);

	print_table_break();

	if ($type AND $type != 'module')
	{
		print_table_header(construct_phrase($vbphrase['x_y_options'], $vbphrase['page'], $vbphrase["$type"]));
		switch ($type)
		{
			// BB code file
			case 'bb_code':
				require_once('./includes/functions_editor.php');
				$textareacols = fetch_textarea_width();

				$gettemp = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "template WHERE styleid = '-1'");
				while ($temp = $DB_site->fetch_array($gettemp))
				{
					$templatecache["$temp[title]"] = $temp['template'];
				}

				$style = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = '$vboptions[styleid]'");

				$stylevar = array_merge(unserialize($style['stylevars']), $stylevar);
				$stycolor = unserialize($style['csscolors']);
				
				echo '<style type="text/css"><!-- 
					.wysiwyg
					{
						background-color: ' . $stycolor['wysiwyg_bgcolor'] . ';
						color: ' . $stycolor['wysiwyg_fgcolor'] . ';
						font: 10pt verdana, geneva, lucida, \'lucida grande\', arial, helvetica, sans-serif;
					}
				-->
				</style>';

				// Editor & message area
				construct_edit_toolbar(htmlspecialchars($page['template']), 0, 0, 1);

				print_description_row(str_replace('"clientscript', '"' . $vboptions['bburl'] . '/clientscript', $messagearea));
				print_yes_no_row($vbphrase['allow_html'], 'setting[custompage][allow_html]', $adv_opts['custompage']['allow_html']);
				print_yes_no_row($vbphrase['allow_smilies'], 'setting[custompage][allow_smilies]', $adv_opts['custompage']['allow_smilies']);
				print_yes_no_row($vbphrase['allow_image_code'], 'setting[custompage][allow_image_code]', $adv_opts['custompage']['allow_image_code']);
			break;
			// Template file
			case 'template':
				print_input_row($vbphrase['template_title'], 'page[template]', $page['template']);
			break;
			// PHP file
			case 'php_file':
				print_input_row($vbphrase['path_to_file'], 'page[template]', $page['template']);
				print_yes_no_row($vbphrase['clean_file_output'], 'page[cleanoutput]', $page['cleanoutput']);
			break;
			// HTML file
			case 'html_file':
				print_input_row($vbphrase['path_to_file'], 'page[template]', $page['template']);
				construct_hidden_code('page[cleanoutput]', 0);
			break;			

		}

		print_table_break();

		print_table_header($vbphrase['module_shell_template_options']);
		print_description_row('<span class="smallfont">' . $vbphrase['options_apply_to_module_shell'] . '</span>', 0, 2, 'thead');
		print_yes_no_row(construct_phrase($vbphrase['use_module_shell_template'], $vbphrase['page']), 'page[useshell]', $page['useshell']);
		print_input_row($vbphrase['custom_content_title'], 'page[custom_title]', $page['custom_title']);
		print_input_row($vbphrase['title_row_colspan'], 'page[colspan]', $page['colspan']);
		print_textarea_row($vbphrase['form_code'], 'page[formcode]', $page['formcode']);

		print_table_break();
	}

	// Page modules
	print_table_header($vbphrase['modules_enabled'], 3);
	print_module_columns('page', true);	

	print_table_break();

	print_table_header($vbphrase['usergroups']);
	print_description_row($vbphrase['here_specify_which_usergroups_access_page'], '', 2, 'thead', 'center');

	$usergroups = $DB_site->query("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $DB_site->fetch_array($usergroups))
	{
		if ((trim($page['userperms']) AND in_array($usergroup['usergroupid'], explode(',', $page['userperms']))) OR $_REQUEST['do'] == 'addpage')
		{
			$usergroup['checked'] = 1;
		}
		print_checkbox_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', $usergroup['checked']);
	}

	print_table_break();
	print_table_break();

	print_table_header('<span style="float:' . $stylevar['right'] . '"><label for="allbox">' . $vbphrase['all_default'] . ' <input id="allbox" name="allbox" onclick="checkAll(this);" type="checkbox" /></label></span> ' . $vbphrase['advanced_options']);
	print_description_row($vbphrase['advanced_options_description']);

	print_table_break();

	$pageid = $page['pageid'];

	print_adv_setting_group('page');

	print_submit_row();
}

// ##################### Do Add / Edit Page ##########################
if (in_array($_POST['do'], array('doaddpage', 'doeditpage')))
{
	globalize($_POST, array('page', 'enablemod', 'setting', 'usedefault', 'userperms', 'pageid' => INT));

	if ($_POST['do'] == 'doaddpage')
	{
		if ($checkidentifier = $DB_site->query_first("SELECT pageid FROM " . TABLE_PREFIX . "adv_pages WHERE name = '$page[name]'"))
		{
			print_stop_message('adv_portal_duplicate_identifier', $vbphrase['page'], $page['name']);
		}
	}

	if ($page['type'] == 'bb_code')
	{
		$page['template'] = $_POST['message'];
		if ($_POST['WYSIWYG_HTML'])
		{
			require_once('./includes/functions_wysiwyg.php');
			$page['template'] = convert_wysiwyg_html_to_bbcode($_POST['WYSIWYG_HTML']);
		}
	}

	$adv_opts = array();

	$getadv_settings = $DB_site->query("SELECT varname, value, grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%'");
	while ($adv_settings = $DB_site->fetch_array($getadv_settings))
	{
		$adv_opts["$adv_settings[identifier]"]["$varname"] = $value;
	}

	$pageadv = $DB_site->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
	$pageadv['advanced'] = unserialize($pageadv['advanced']);
	
	if (!empty($pageadv['advanced']))
	{
		foreach ($pageadv['advanced'] AS $modident => $modopt)
		{
			if (!empty($modopt))
			{
				foreach ($modopt AS $mvar => $mvalue)
				{
					if ($mvar == 'portal_threadids' AND !$usedefault["$modident"]["$mvar"])
					{
						$adv_setting["$modident"]["$mvar"] = $mvalue;
					}
				}
			}
		}
	}

	if (!empty($adv_opts))
	{
		foreach ($setting AS $identifier => $modopts)
		{
			if (is_array($modopts))
			{
				foreach ($modopts AS $varname => $value)
				{
					if (!$usedefault["$identifier"]["$varname"] AND $adv_opts["$identifier"]["$varname"] != $value)
					{
						if ($varname == 'portal_navigation_addpages')
						{
							$pagelinks = array();
							if ($value)
							{
								foreach ($value AS $k => $v)
								{
									if (substr($k, 0, 4) == 'link' AND $v)
									{
										$lcount++;
										$pagelinks["$v"] = $value["text$lcount"];
									}
								}
							}
							$adv_setting["$identifier"]["$varname"] = serialize($pagelinks);
						}
						else if (is_array($value))
						{
							$adv_setting["$identifier"]["$varname"] = implode(',', $value);
						}
						else if ($varname != 'portal_threadids')
						{
							$adv_setting["$identifier"]["$varname"] = $value;
						}
					}
				}					
			}
		}
	}

	$page['advanced'] = serialize($adv_setting);

	if (!trim($page['title']))
	{
		print_stop_message('adv_portal_must_enter_x_for_page', $vbphrase['title']);
	}

	if (!trim($page['name']))
	{
		print_stop_message('adv_portal_must_enter_x_for_page', $vbphrase['identifier']);
	}

	$page['modules'] = implode(',', $enablemod);

	$page['userperms'] = implode(',', array_keys($userperms));

	$DB_site->query(fetch_query_sql($page, 'adv_pages', iif($_POST['do'] == 'doeditpage', 'WHERE pageid = ' . $pageid)));

	if ($_POST['do'] == 'doaddpage')
	{
		$pageid = $DB_site->insert_id();
	}

	rebuild_parents($pageid);

	update_page_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listpages", 0);
}

// ######################## Remove Page ############################
if ($_REQUEST['do'] == 'removepage')
{
	$page = $DB_site->query_first("SELECT pageid, title, name FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$_REQUEST[pageid]'");
	if ($page['name'] == 'home')
	{
		print_stop_message('adv_portal_cant_remove_default');
	}
	print_form_header('vba_cmps_admin', 'doremovepage');
	construct_hidden_code('pageid', $page['pageid']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_page_called_x'], $page['title']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################## Do Remove Page ##############################
if ($_POST['do'] == 'doremovepage')
{
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$_POST[pageid]'");

	update_page_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listpages", 0);
}

// ######################### Download / Upload Module #########################
if ($_REQUEST['do'] == 'download')
{
	require_once('./includes/adminfunctions_template.php');

	print_form_header('vba_cmps_admin', 'uploadmodule', true);

	// Upload module
	print_table_header($vbphrase['upload_module']);
	print_description_row($vbphrase['main_options'], 0, 2, 'thead');
	print_upload_row($vbphrase['select_module_upload'], 'modfile');

	print_select_row($vbphrase['column'], 'module[modcol]', array(0 => $vbphrase['left_column'], 2 => $vbphrase['right_column'], 1 => $vbphrase['center_column']), $module['modcol']);
	print_input_row($vbphrase['display_order'], 'module[displayorder]', $module['displayorder']);
	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', 1);
	print_yes_no_row($vbphrase['update_all_pages'], 'updateall', 0);

	cache_styles();

	$styles = array();
	$styles[''] = $vbphrase['please_select_one'];

	foreach($stylecache AS $style)
	{
		$styles["$style[styleid]"] = construct_depth_mark($style['depth'], '--', iif($displaytop, '--')) . ' ' . $style['title'];
	}

	print_select_row($vbphrase['style_to_install_to'], 'styleid', $styles);

	print_description_row($vbphrase['usergroups'], 0, 2, 'thead');
	$usergroups = $DB_site->query("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $DB_site->fetch_array($usergroups))
	{
		print_yes_no_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', 1);
	}


	print_submit_row($vbphrase['submit'], '');

	// Download module
	print_form_header('vba_cmps_admin', 'downloadmodule');
	print_table_header($vbphrase['download_module'], 3);
	print_description_row($vbphrase['tool_downloads_module'], '', 3, 'alt1');
	print_module_columns('download');
	print_submit_row($vbphrase['download'], '', 3);
}

// ############################## Upload Module ###############################
if ($_POST['do'] == 'uploadmodule')
{
	globalize($_POST, array('module', 'styleid' => INT, 'identifier' => STR_NOHTML, 'filename' => STR_NOHTML, 'haderrors' => INT, 'modulefilename' => STR_NOHTML, 'updateall' => INT, 'userperms'));

	globalize($_FILES, array('modfile'));

	if (!is_writable('./modules/'))
	{
		print_stop_message('adv_portal_moddir_notwritable');
	}

	if (!$haderrors)
	{
		@chmod('./modules', 0777);
		@move_uploaded_file($modfile['tmp_name'], './modules/' . $modfile['name']);
	}
	else
	{
		$moduleinfo['module'] = $module;
		$modfile['name'] = $modulefilename;
	}

	if (substr($modfile['name'], -7) != '.module')
	{
		@unlink('./modules/' . $modfile['name']);
		print_stop_message('adv_portal_invalid_modfile');
	}

	if ($fp = fopen('./modules/' . $modfile['name'], 'r'))
	{
		$moduleinfo = unserialize(fread($fp, filesize('./modules/' . $modfile['name'])));
		fclose($fp);
	}

	if (empty($moduleinfo['module']))
	{
		@unlink('./modules/' . $modfile['name']);
		print_stop_message('adv_portal_invalid_modfile');
	}

	$module = array_merge(unserialize($moduleinfo['module']), $module);

	if ($identifier)
	{
		$module['identifier'] = $identifier;
	}

	if ($filename)
	{
		$module['filename'] = $filename;
	}

	$moderrors = array();

	if ($module['inctype'] == 'php_file')
	{
		if (is_file('./modules/' . $module['filename']) AND $moduleinfo['file'])
		{
			$moderrors['duplicate_filename'] = $module['filename'];
		}
		if ($checkidentifier = $DB_site->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = '$module[identifier]'"))
		{
			$moderrors['duplicate_module_identifier'] = $module['identifier'];
		}
	}

	// Usergroup permissions
	if (!empty($userperms))
	{
		$ugperms = array();
		foreach ($userperms AS $usergroupid => $allow)
		{
			if ($allow)
			{
				$ugperms[] = $usergroupid;
			}
		}
		$module['userperms'] = implode(',', $ugperms);
	}

	$moduleinfo['templates'] = unserialize($moduleinfo['templates']);

	if (!empty($moduleinfo['templates']) AND !isset($_REQUEST['overwrite']))
	{
		if (!$styleid)
		{
			print_stop_message('adv_portal_choose_style');
		}
		
		$currenttemplates = array();
		$checktemps = $DB_site->query("SELECT title FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "') AND styleid = '$styleid'");
		while ($template = $DB_site->fetch_array($checktemps))
		{
			$currenttemplates[] = $template['title'];
		}
		$DB_site->free_result($checktemps);
		unset($template);
		
		foreach ($moduleinfo['templates'] AS $title => $template)
		{
			if (in_array($title, $currenttemplates))
			{
				$moderrors['overwrite_templates'][] = $title;
			}
		}
	}

	// Got errros
	if (sizeof($moderrors) > 0)
	{
		$_REQUEST['do'] = 'uploaderrors';
	}
	else
	{
		// No errors, so let's process the module

		// Process templates
		if ($moduleinfo['templates'] AND (!isset($_REQUEST['overwrite']) OR $_REQUEST['overwrite'] == 1))
		{
			require_once('./includes/adminfunctions_template.php');

			$DB_site->query("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "') AND styleid = '$styleid'");

			foreach ($moduleinfo['templates'] AS $title => $template)
			{
			  $DB_site->query("INSERT INTO " . TABLE_PREFIX . "template (title, template, template_un, styleid, templatetype, dateline, username, version) VALUES ('$title', '" . addslashes(compile_template($template)) . "', '" . addslashes($template) ."', '$styleid', 'template', '" . time() . "', '$bbuserinfo[username]', '$vboptions[version]')");

			}
		}

		// Insert module
		$DB_site->query(fetch_query_sql($module, 'adv_modules'));
		$modid = $DB_site->insert_id();

		// Update all pages
		if ($updateall)
		{
			$pages = $DB_site->query("SELECT pageid, modules FROM " . TABLE_PREFIX . "adv_pages");
			while ($page = $DB_site->fetch_array($pages))
			{
				$pagemodules = explode(',', $page['modules']);
				$pagemodules[] = $modid;
				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET modules = '" . implode(',', $pagemodules) . "' WHERE pageid = '$page[pageid]'");
			}
		}

		// Write module file
		if ($fp = fopen('./modules/' . $module['filename'], "w"))
		{
			fputs ($fp, $moduleinfo['file']);
			fclose($fp);
		}

		// Module settings
		if (!empty($moduleinfo['settings']))
		{
			$currentsettings = array();
			$getsettings = $DB_site->query("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname IN('" . implode('\',\'', array_keys($moduleinfo['settings'])) . "')");
			while ($setting = $DB_site->fetch_array($getsettings))
			{
				$currentsettings[] = $setting['varname'];
			}
			
			$DB_site->free_result($getsettings);
			unset($setting);
			
			foreach ($moduleinfo['settings'] AS $varname => $setting)
			{
				if (!in_array($varname, $currentsettings))
				{
					$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, text, phrasetypeid) VALUES (0, 'setting_" . $varname . "_title', '" . addslashes($setting['title']) ."', 5000)");
					$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, text, phrasetypeid) VALUES (0,  'setting_" . $varname . "_desc', '" . addslashes($setting['description']) . "', 5000)");
				}
				
				$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_setting (varname, grouptitle, value, defaultvalue, optioncode, displayorder) VALUES ('$varname', 'adv_portal_$module[identifier]', '$setting[value]', '$setting[defaultvalue]', '" . addslashes($setting['optioncode']) . "', '$setting[displayorder]')");
			}
		}
		// Delete the .module file
		unlink('./modules/' . $modfile['name']);

		update_module_cache();

		print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]&do=listmodules", 0);
	}
}

// ############################# Upload Errors ################################
if ($_REQUEST['do'] == 'uploaderrors')
{
	print_form_header('vba_cmps_admin', 'uploadmodule');
	construct_hidden_code('styleid', $styleid);
	construct_hidden_code('haderrors', 1);
	construct_hidden_code('modulefilename', $modfile['name']);
	construct_hidden_code('updateall', $updateall);

	if (isset($identifier) AND !in_array('duplicate_module_identifier', array_keys($moderrors)))
	{
		construct_hidden_code('identifier', $identifier);
	}

	if (isset($filename) AND !in_array('duplicate_filename', array_keys($moderrors)))
	{
		construct_hidden_code('filename', $filename);
	}

	if (isset($_REQUEST['overwrite']))
	{
		construct_hidden_code('overwrite', $_REQUEST['overwrite']);
	}

	$errornames = array_keys($moderrors);

	foreach ($module AS $varname => $value)
	{
		construct_hidden_code('module[' . $varname . ']', $value);
	}

	print_table_header($vbphrase['error']);


	foreach ($moderrors AS $phrase => $value)
	{
		print_description_row($vbphrase["$phrase"], '', 2, 'thead');

		switch ($phrase)
		{
			case 'overwrite_templates':
				$templatenames = array();
				foreach ($value AS $tempname)
				{
					$templatenames[] = '<b>' . $tempname . '</b>';
				}
				print_yes_no_row(construct_phrase($vbphrase["$phrase" . _desc . ""], implode(', ', $templatenames)), 'overwrite', 0);
				break;
			
			case 'duplicate_filename':
				print_input_row(construct_phrase($vbphrase["$phrase" . _desc . ""], $value), 'filename', $value);
				break;
			
			case 'duplicate_module_identifier':
				print_input_row(construct_phrase($vbphrase["$phrase" . _desc . ""], $value), 'identifier', $value);
				break;

		}
	}
	print_submit_row();
}	

// ############################## Edit News Posts #############################
if ($_REQUEST['do'] == 'listforums')
{
	globalize($_REQUEST, array('identifier' => STR_NOHTML, 'pageid' => INT));

	if ($pageid)
	{
		$page = $DB_site->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
		$page['advanced'] = unserialize($page['advanced']);
		$threadids = unserialize($page['advanced']["adv_portal_$identifier"]['portal_threadids']);
	}
	if (!$pageid OR empty($threadids))
	{
		$threadids = fetch_module_threadids($identifier);
	}

	if (!empty($threadids))
	{
		print_form_header('vba_cmps_admin', 'removethreads');
		construct_hidden_code('identifier', $identifier);
		construct_hidden_code('pageid', $pageid);
		print_table_header($vbphrase['current_selected_threads'], 3);
		print_cells_row(array($vbphrase['remove'], $vbphrase['title'], $vbphrase['forum']), 1, '', -2);

		$getthreads = $DB_site->query("SELECT threadid, title, forumid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")");
		while ($thread = $DB_site->fetch_array($getthreads))
		{
			$class = exec_switch_bg();
			echo '<tr><td align="center" class="' . $class . '" width="40"><input name="threadids[]" value="' . $thread['threadid'] . '" type="checkbox"></td><td class="' . $class . '"><a href="' . $vboptions['bburl'] . '/showthread.php?' . $session['sessionurl'] . 't=' . $thread['threadid'] . '" target="_blank">' . $thread['title'] . '</a></td><td class="' . $class . '" width="250"><a href="' . $vboptions['bburl'] . '/forumdisplay.php?' . $session['sessionurl'] . 'f=' . $thread['forumid'] . '" target="_blank">' . $forumcache["$thread[forumid]"]['title'] . '</a></td></tr>';
		}
		print_submit_row($vbphrase['remove'], '', 3);
	}

	print_form_header('', '');
	print_table_header($vbphrase['select_new_threads']);
	print_description_row($vbphrase['to_begin_selecting_threads'], 0, 2, 'thead');
	foreach ($forumcache AS $forum)
	{
		$forumoptions = array();
		foreach($_FORUMOPTIONS AS $optname => $optval)
		{
			$forumoptions["$optname"] = iif(($forum['options'] & $optval), 1, 0);
		}

		if (!$forumoptions['cancontainthreads'])
		{
			print_description_row('<i>' . str_repeat('--', $forum['depth']) . $forum['title'] . '</i>', 0, 2, 'alt1');
		}
		else
		{
			print_description_row(str_repeat('--', $forum['depth']) . ' <a href="vba_cmps_admin.php?do=threadids&amp;identifier=' . $identifier . '&amp;forumid=' . $forum['forumid'] . '&amp;pageid=' . $pageid . '">' . $forum['title'] . '</a>', 0, 2, 'alt2');
		}
	}
	
	print_table_footer();
}

// ############################# News Threads #################################
if ($_REQUEST['do'] == 'threadids')
{
	globalize($_REQUEST, array('forumid' => INT, 'page' => INT, 'identifier' => STR_NOHTML, 'pageid' => INT, 'threadids', 'gotopagenumber' => STR, 'currentpage' => INT));

	// Do submit threadids
	if ($_POST['dosubmit'])
	{
		// Updating for specific page only
		if ($pageid)
		{
			$page = $DB_site->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
			$page['options'] = unserialize($page['advanced']);

			$threadarray = array();

			if (!empty($threadids))
			{
				$posts = $DB_site->query("SELECT threadid, firstpostid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")");
				while ($post = $DB_site->fetch_array($posts))
				{
					$threadarray["$post[threadid]"] = $post['firstpostid'];
				}
			}

			$page['options']["adv_portal_$identifier"]['portal_threadids'] = serialize($threadarray);		

			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($page['options']) . "' WHERE pageid = '$pageid'");
		}
		else
		{
			// Updating the module
			$threadarray = fetch_module_threadids($identifier);

			$threadarray = array();
			$posts = $DB_site->query("SELECT threadid, firstpostid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")");
			while ($post = $DB_site->fetch_array($posts))
			{
				$threadarray["$post[threadid]"] = $post['firstpostid'];
			}

			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . serialize($threadarray) . "' WHERE grouptitle = 'adv_portal_$identifier' AND varname = 'portal_threadids'");

			update_module_cache();
		}

		print_cp_redirect('vba_cmps_admin.php?do=listforums&identifier=' . $identifier . '&amp;pageid=' . $pageid);

	}
	else
	{
		// Browsing forum for threads
		$wherequery = array('forumid = ' . $forumid);
	  $pagedata = fetch_page_data('thread');
	
		print_form_header('vba_cmps_admin', 'threadids');
		construct_hidden_code('forumid', $forumid);
		construct_hidden_code('identifier', $identifier);
		construct_hidden_code('pageid', $pageid);

		if ($gotopagenumber)
		{
			switch ($gotopagenumber)
			{
				case $vbphrase['last'] . ' ':
					$page = $pagedata['pagecount'];
					break;
				case ' ' . $vbphrase['first']:
					$page = 1;
					break;
				case '< ' . $vbphrase['prev']:
					$page = $currentpage - 1;
					break;
				case $vbphrase['next'] . ' >':
					$page = $currentpage + 1;
			}
		  $pagedata = fetch_page_data('thread');
		}
		construct_hidden_code('currentpage', $pagedata['pagenumber']);

		// Construct the pagenav
		if ($pagedata['pagecount'] > 1)
		{
			if ($pagedata['pagenumber'] != 1)
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&laquo; ' . $vbphrase['first'] . '" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&lt; ' . $vbphrase['prev'] . '" /> ';
			}
	
			$i = 0;
			$thispage = $pagedata['pagenumber'] - 5;
	
			if ($pagedata['pagenumber'] + 5 > $pagedata['pagecount'])
			{
				$thispage = $pagedata['pagecount'] - 9;
			}
	
			if ($thispage < 0)
			{
				$thispage = 0;
			}
			
			$pageprint = iif($pagedata['pagecount'] >= 9, 9, $pagedata['pagecount']);
	
			while ($i++ < $pageprint)
			{
				$thispage++;
				$pagenav .= '<input class="button" name="page" type="submit" value="' . iif($thispage > 9, $thispage, ' ' . $thispage . ' ') . '"' . iif($pagedata['pagenumber'] == $thispage, ' disabled="disabled"') . ' /> ';
			}
	
			if ($pagedata['pagenumber'] != $pagedata['pagecount'])
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['next'] . ' &gt;" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['last'] . ' &raquo;" />';
			}
		}

		print_table_header('<span style="float:' . $stylevar['right'] . '">' . $pagenav . '</span>' . $forumcache["$forumid"]['title'], 2, 0, '', $stylevar['left']);

		$selectedthreads = array();

		if (!$page)
		{
			if ($pageid)
			{
				$page = $DB_site->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
				$page['advanced'] = unserialize($page['advanced']);
				$keyoptions = unserialize($page['advanced']["adv_portal_$identifier"]['portal_threadids']);
			}

			if (!isset($keyoptions))
			{
				$keyoptions = fetch_module_threadids($identifier);
			}

			if (!empty($keyoptions))
			{
				$curthreads = array_keys($keyoptions);
	
				$getthreads = $DB_site->query("SELECT threadid, title, forumid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', $curthreads) . ")");
				while ($thread = $DB_site->fetch_array($getthreads))
				{
					$selectedthreads[] = $thread['threadid'];
					$threadids["$thread[threadid]"] = $thread['firstpostid'];
				}
			}
		}

		unset($threadid);

		$tids = array();
		$getthreadids = $DB_site->query("SELECT threadid FROM " . TABLE_PREFIX . "thread WHERE forumid = $forumid LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]");
		while ($threadid = $DB_site->fetch_array($getthreadids))
		{
			$tids[] = $threadid['threadid'];
		}
	
		if (!empty($tids))
		{
			// Get selected ids
			if (!empty($threadids))
			{
				foreach ($threadids AS $threadid => $firstpostid)
				{
					$selectedthreads[] = $threadid;
				}
			}

			$getthreads = $DB_site->query("SELECT threadid, title, postusername, firstpostid, pollid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', $tids) . ")");
			while ($thread = $DB_site->fetch_array($getthreads))
			{
				unset($threadids["$thread[threadid]"]);
				$class = exec_switch_bg();
				echo '<tr><td align="center" class="' . $class . '"><input ' . iif(in_array($thread['threadid'], $selectedthreads), 'checked="checked"') . ' type="checkbox" name="threadids[' . $thread['threadid'] . ']" value="' . $thread['firstpostid'] . '" /></td><td class="' . $class . '" width="100%">' . iif($thread['pollid'], $vbphrase['poll'] . ': ') . construct_link_code(stripslashes($thread['title']), $vboptions['bburl'] . '/showthread.php?t=' . $thread['threadid'], 1) . '</td></tr>';
			}

			// Print hidden inputs for any not listed above
			if (!empty($threadids))
			{
				foreach ($threadids AS $threadid => $firstpostid)
				{
					$selectedthreads[] = $threadid;
					construct_hidden_code('threadids[' . $threadid . ']', $firstpostid);
				}
			}

			print_table_footer(2, '<input type="submit" name="dosubmit" value="' . $vbphrase['submit'] . '" />');
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['threads']));
			print_table_footer();
		}
	}
}

// ############################## Remove Threads ##############################
if ($_POST['do'] == 'removethreads')
{
	globalize($_POST, array('threadids', 'identifier' => STR, 'pageid' => INT));

	if ($pageid)
	{
		$page = $DB_site->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
		$page['advanced'] = unserialize($page['advanced']);

		if (!isset($page['advanced']["adv_portal_$identifier"]['portal_threadids']))
		{
			$ptids = unserialize($page['advanced']["adv_portal_$identifier"]['portal_threadids']);
			$ptids = fetch_module_threadids($identifier);
		}

		foreach ($threadids AS $threadid)
		{
			unset($ptids["$threadid"]);
		}

		$page['advanced']["adv_portal_$identifier"]['portal_threadids'] = serialize($ptids);

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($page['advanced']) . "'");
	}
	else
	{
		$curthreads = fetch_module_threadids($identifier);

		foreach ($threadids AS $threadid)
		{
			unset($curthreads["$threadid"]);
		}
		
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . serialize($curthreads) . "' WHERE grouptitle = 'adv_portal_$identifier' AND varname = 'portal_threadids'");
	}

	build_adv_settings();

	print_cp_redirect('vba_cmps_admin.php?do=listforums&identifier=' . $identifier . '&amp;pageid=' . $pageid);
}

// ################################ Quick Permissions #########################
if ($_REQUEST['do'] == 'permissions')
{
	print_form_header('vba_cmps_admin', 'dopermissions');
	print_table_header($vbphrase['pages']);

	// Pages
	$ppcache = array();
	$pageperms = $DB_site->query("SELECT pageid, title, parentid, userperms FROM " . TABLE_PREFIX . "adv_pages");
	while ($page = $DB_site->fetch_array($pageperms))
	{
		$ppcache["$page[pageid]"] = $page;
	}
	
	$DB_site->free_result($pageperms);
	unset($page);
	
	$ppcache = construct_page_structure($ppcache);
	
	foreach ($ppcache AS $pid => $page)
	{
		print_description_row($page['title'], 0, 2, 'thead');
		foreach ($usergroupcache AS $ugroup)
		{
			print_checkbox_row($ugroup['title'], 'pageperms[' . $pid . '][' . $ugroup['usergroupid'] . ']', iif(in_array($ugroup['usergroupid'], explode(',', $page['userperms'])), 1));
		}
	}

	print_table_break();
	print_table_break();

	// Modules	
	print_table_header($vbphrase['modules']);

	$modcache = array();
	$getmods = $DB_site->query("SELECT modid, title, userperms FROM " . TABLE_PREFIX . "adv_modules ORDER BY modcol, displayorder");
	while ($mods = $DB_site->fetch_array($getmods))
	{
		$modcache["$mods[modid]"] = $mods;
	}

	foreach ($modcache AS $modid => $mod)
	{
		print_description_row($mod['title'], 0, 2, 'thead');
		foreach ($usergroupcache AS $ugroup)
		{
			print_checkbox_row($ugroup['title'], 'modperms[' . $modid . '][' . $ugroup['usergroupid'] . ']', iif(in_array($ugroup['usergroupid'], explode(',', $mod['userperms'])), 1));
		}
	}

	print_submit_row();

}

// ######################## Save Quick Permissions ############################
if ($_POST['do'] == 'dopermissions')
{
	globalize($_POST, array('pageperms', 'modperms'));

	$getpages = $DB_site->query("SELECT pageid FROM " . TABLE_PREFIX . "adv_pages");
	while ($page = $DB_site->fetch_array($getpages))
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET userperms = '" . implode(',', array_keys($pageperms["$page[pageid]"])) . "' WHERE pageid = '$page[pageid]'");
	}
	
	$getmods = $DB_site->query("SELECT modid FROM " . TABLE_PREFIX . "adv_modules");
	while ($mod = $DB_site->fetch_array($getmods))
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($modperms["$mod[modid]"])) . "' WHERE modid = '$mod[modid]'");
	}

	print_cp_redirect('vba_cmps_admin.php?do=permissions');

}

// ############################## Rebuild Parents #############################
if ($_REQUEST['do'] == 'rebuildparents')
{
	rebuild_parents(0);
}

// Print footer
if ($_REQUEST['do'] != 'downloadmodule')
{
	print_cp_footer();
}

?>