<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
/* title: vCard PRO Upgrader Script
 * author: Belchior Foundry
 * date: 2003-05-01
*/
define('IN_UPGRADE_SCRIPT',1);
define('VCARD_ROOT_PATH','./../');
define('CURR_FILE','upgrade.php');
set_magic_quotes_runtime(0);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
//error_reporting(E_ALL);

include(VCARD_ROOT_PATH.'config.inc.php');
include(VCARD_ROOT_PATH.'include/grab.inc.php');
include(VCARD_ROOT_PATH.'include/constant.inc.php');
include(VCARD_ROOT_PATH.'include/class/db_mysql.inc.php');
include(VCARD_ROOT_PATH.'include/class/html.inc.php');
include(VCARD_ROOT_PATH.'include/sql_parse.inc.php');

function parse_query_from_file($file,$table_prefix='vcard_',$delimiter=';',$delimiter_basic=';') {
	global $DB_site;
	
	$sql_query = @fread(@fopen($file, 'rb'), @filesize($file));
	$sql_query = preg_replace('/vcard_/', $table_prefix, $sql_query);
	$sql_query = remove_remarks($sql_query);
	$sql_query = split_sql_file($sql_query, $delimiter_basic);
	$k = sizeof($sql_query);
	for($i = 0; $i<$k; $i++)
	{
		if (trim($sql_query[$i]) != '')
		{
			//echo $sql_query[$i].'<hr>';
			$DB_site->query($sql_query[$i]);
		}
	}
}

$up_cfg = array(
		'last_version' => '3.1',
		'last_upgradeid' => 18
		);
$up_ids = array(
			'2.3' => 11,
			'2.4' => 12,
			'2.5' => 13,
			'2.6' => 14,
			'2.7' => 15,
			'2.8' => 16,
			'2.9' => 17,
			'3.0' => 18
		);
$up_ids_inv = array(
			11 => '2.3',
			12 => '2.4',
			13 => '2.5',
			14 => '2.6',
			15 => '2.7',
			16 => '2.8',
			17 => '2.9',
			18 => '3.0'
		);

$dbms = 'mysql';
$available_dbms = array(
		'mysql'=> array(
			'LABEL'			=> 'MySQL 3.x',
			'SCHEMA'		=> 'mysql', 
			'DELIM'			=> ';',
			'DELIM_BASIC'	=> ';',
			'COMMENTS'		=> 'remove_remarks'
		),
		'mysql4' => array(
			'LABEL'			=> 'MySQL 4.x',
			'SCHEMA'		=> 'mysql', 
			'DELIM'			=> ';', 
			'DELIM_BASIC'	=> ';',
			'COMMENTS'		=> 'remove_remarks'
		)
);
$delimiter = $available_dbms[$dbms]['DELIM']; 
$delimiter_basic = $available_dbms[$dbms]['DELIM_BASIC'];

$DB_site = new DB_Sql_vc;
$DB_site->server = $hostname;
$DB_site->user = $dbUser;
$DB_site->password = $dbPass;
$DB_site->database = $dbName;
$DB_site->connect();
$dbPass = '';
$DB_site->password = '';

$HTML_site = new HTML_vc();
$HTML_site->set_var('title','vCard PRO - Upgrader Script');
$HTML_site->set_var('css','./style.css');

$change_log = array();
$instructions_before = array();
$_errors = 0;
foreach($up_ids as $key=>$val)
{
	$_tmp = VCARD_ROOT_PATH .'setup/upgrade/upgrade'.$val.'.php';
	if(file_exists($_tmp))
	{
		include($_tmp);
	}else{
		echo "<hr>NOT FOUND: ". $_tmp;
		$_errors++;
	}
	$_tmp = VCARD_ROOT_PATH .'setup/schemas/mysql_upgrade'.$val.'.sql';
	if(!file_exists($_tmp))
	{
		echo "<hr>NOT FOUND: ". $_tmp;
		$_errors++;
	}
}
if ($_errors > 0 )
{
	die();
}
$js = '
<script type="text/javascript">
<!--
var abc = 0;
function go2next(theUrl)
{
	if (abc==1)
	{
		window.location.href = theUrl;
	}
	if (abc>1)
	{
		alert(\'You already clicked the link, just wait\');
	}
}
//-->
</script>
';
//<a href="javascript:go2next();" onclick="abc++">hello</a>

$HTML_site->page_header($js);
$HTML_site->table_border_header();


if (empty($step))
{
	$nextstep = $step + 1;
	$current_data = $DB_site->query_first("SELECT * FROM ". TBL_SETTING_VARS ." WHERE varname='vcardversion' ");
	$curr_ver = $current_data['value'];
	if($curr_ver < $up_cfg['last_version'] )
	{
		if(!empty($curr_ver) && $curr_ver!='2.2')
		{
			$HTML_site->table_header('Select your current version');
			$HTML_site->table_row('Your Current version is: <b style="color: Red;">' . $curr_ver .'</b>');
			$text = "<p>READ carefull the upgrade documentation before make any mistake!</p>
		<p>Upgrade Requirements: </p>
		<p>- You need have permission access to <b>ALTER</b> database structury. If you already did a vcard upgrading before then you have the permission to alter database tables. Only in few website this problem appear.</p>
		<p><i>Please be patient, some parts of this process may take quite some time.</i></p>
		<p>
		Steps to upgrade <b>pay attetion:</b>
		<ol>
			<li><b>Turn OFF your website</b></li>
			<li>Upload all files to webserver (files and directories)</li>
			<li>Now continue with upgrading.
			<li>Note: Table renaming: (you need permissions to ALTERAR/RENAME database table names before continue the upgrade process).</li>
		</ul>
		<br />
		<br />";
			$HTML_site->table_row($text);
			
			$tmp = '';
			foreach($instructions_before as $id => $text)
			{
				if($id >= $up_ids[$curr_ver])
				{
					$tmp .= $text;
				}
				$text = '';
			}
			if(!empty($tmp))
			{
				$HTML_site->table_title('Special Instructions');
				$HTML_site->table_row($tmp,2);
			}
			
			$HTML_site->table_row('<p><a href="javascript:go2next(\'upgrade.php?step='. $nextstep .'&up_id='. $up_ids[$curr_ver] .'\');" onclick="abc++"><b>Continue with the upgrade --&gt;</b></a>'. $extra .'</p>');
			$HTML_site->table_footer('');
		}
		else
		{
			$options = array(
				'10' => 'version. 2.2.x'
				);
			$HTML_site->form_header(CURR_FILE,'next',0,1);
			$HTML_site->form_hidden('step',1);
			$HTML_site->form_title('Select you vCard version');
			$HTML_site->form_select('My current vCard version is :','up_id',$options,$current_data['value']);
			$HTML_site->form_row('Note','If your vcard version is not listed here, you cant use this upgrader script. You will need download the old upgrade scripts from Member Area.');
			$HTML_site->form_footer('Go to next step');
		}
	}
	else
	{
		$HTML_site->table_header('Attention');
		$HTML_site->table_row('You cant use this upgrade script because your current vCard PRO version is up to date. You dont need use this upgrader script.  Pay attention your current version.');
		$HTML_site->table_footer('');
	}
}
if ($step == 1)
{
	$orig_ver = empty($orig_ver)? $up_id : $orig_ver;
	if ( $up_id <= $up_cfg['last_upgradeid'] )
	{
		if ( function_exists("upgrade".$up_id."_before") )
		{
			eval("upgrade". $up_id ."_before();");
			$HTML_site->table_row('<!-- upgrade before SQL queries dump -->');
		}
		$_sql_file = VCARD_ROOT_PATH.'setup/schemas/mysql_upgrade'. $up_id .'.sql';
		if ( file_exists($_sql_file) )
		{
			parse_query_from_file($_sql_file ,$table_prefix,$delimiter,$delimiter_basic);
		}
		if ( function_exists('upgrade'. $up_id . ''))
		{
			eval('upgrade' . $up_id . '();');
			$HTML_site->table_row('<!-- upgrade after SQL queries dump -->');
		}
		$_tmp_next = $up_id + 1;
		if ( $_tmp_next < $up_cfg['last_upgradeid'])
		{
			$HTML_site->table_row("<p>Upgraded from: ". $up_ids_inv[$up_id] ." to ". $up_ids_inv[$_tmp_next] . '.</p> <p><a href="javascript:go2next(\'upgrade.php?step=1&up_id='. $_tmp_next .'&amp;orig_ver='. $orig_ver .'\');" onclick="abc++"><b>Next: Continue with the upgrade --&gt;</b></a></p>');
			$HTML_site->table_row('<!-- upgrade from older versions-->');
		}
		else
		{
			$HTML_site->table_row('Database update completed. <!-- b -->');
			$HTML_site->table_row('<p><a href="javascript:go2next(\'upgrade.php?step=2&amp;orig_ver='. $orig_ver .'\');" onclick="abc++"><b>Continue with the upgrading --&gt;</b></a></p>');
		}
	}
	else
	{
		$HTML_site->table_row('Database update completed. <!-- c -->');
		$HTML_site->table_row('<p><a href="javascript:go2next(\'upgrade.php?step=2&amp;orig_ver='. $orig_ver .'\');" onclick="abc++"><b>Continue with the upgrading --&gt;</b></a></p>');
	}
}

if ($step == 2)
{
	$HTML_site->table_header('Saving Original Template');
	$DB_site->query("DELETE FROM ". TBL_TEMPLATES_ORIG ." ");
	$_style_file = VCARD_ROOT_PATH.'setup/schemas/mysql_template_o.sql';
	if (file_exists($_style_file))
	{
		parse_query_from_file($_style_file ,$table_prefix,$delimiter,$delimiter_basic);
		$HTML_site->table_row('<p>Original template Set has been upgraded.</p> <!-- d -->');
		$HTML_site->table_row('<a href="javascript:go2next(\'upgrade.php?step=3&orig_ver='. $orig_ver .'\');" onclick="abc++"><b>Continue with the upgrade --&gt;</b></a>'.  $extra . '</p>');
	}
	else
	{
		$HTML_site->table_row("<p>Please ensure that the mysql_template_o.sql file exists in the setup/schemas directory and then reload this current page</p>\n");
		$styletext='';
	}
	$HTML_site->table_footer();
}
if ($step == 3)
{
	$HTML_site->table_header('Upgrade Complete');
	if (sizeof($change_log) > 0)
	{
		$HTML_site->table_row('<b>Change Log & Notes</b>: <!-- e -->');
		foreach($change_log as $id => $text)
		{
			if($id >= $orig_ver)
			{
				$HTML_site->table_row($text);
			}
		}
	}
	$HTML_site->table_row('note: Go to control panel and use <b>Optimize database</b> tool.');
	$HTML_site->table_footer();
}

$HTML_site->table_border_footer();
$HTML_site->page_footer();

?>