UPDATE vcard_setting SET value='3.1' WHERE varname='vcardversion';

DROP TABLE IF EXISTS vcard_session;
DROP TABLE IF EXISTS vcard_address;
DROP TABLE IF EXISTS vcard_abook;


ALTER TABLE vcard_user RENAME vcard_userecard;
ALTER TABLE vcard_account RENAME vcard_cpusers;

ALTER TABLE vcard_cpusers ADD canaddsmilie TINYINT( 3 ) DEFAULT '0' NOT NULL AFTER candeleteeffect , ADD caneditsmilie TINYINT( 3 ) DEFAULT '0' NOT NULL AFTER canaddsmilie , ADD candeletesmilie TINYINT( 3 ) DEFAULT '0' NOT NULL AFTER caneditsmilie ;
ALTER TABLE vcard_cpusers CHANGE account_id cpuser_id SMALLINT( 6 ) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE vcard_category CHANGE cat_id cat_id INT( 11 ) NOT NULL AUTO_INCREMENT;
ALTER TABLE vcard_category CHANGE cat_subid cat_subid INT( 11 ) DEFAULT NULL;

ALTER TABLE vcard_cards CHANGE card_id card_id INT( 11 ) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE vcard_cards CHANGE cat_id cat_id INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE vcard_cards CHANGE card_group card_group INT( 4 ) DEFAULT '0' NOT NULL;

ALTER TABLE vcard_sound CHANGE cat_id cat_id INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE vcard_sound ADD sound_caption TEXT NOT NULL AFTER sound_genre;

ALTER TABLE vcard_search CHANGE cat_id cat_id INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL;

ALTER TABLE vcard_stats CHANGE card_id card_id INT( 11 ) DEFAULT '0' NOT NULL;

ALTER TABLE vcard_userecard CHANGE card_id card_id INT( 11 ) NOT NULL;

ALTER TABLE vcard_cardsgroup DROP cardsgroup_advancedate;
ALTER TABLE vcard_cardsgroup DROP cardsgroup_copy;
ALTER TABLE vcard_cardsgroup DROP cardsgroup_notify;
ALTER TABLE vcard_cardsgroup ADD cardsgroup_message SMALLINT( 6 ) DEFAULT '1' NOT NULL AFTER cardsgroup_heading;

DELETE FROM vcard_setting WHERE varname='user_upload_allow';
DELETE FROM vcard_setting WHERE varname='user_stamp_allow';
DELETE FROM vcard_setting WHERE varname='user_pattern_allow';
DELETE FROM vcard_setting WHERE varname='user_music_allow';
DELETE FROM vcard_setting WHERE varname='user_advance_allow';
DELETE FROM vcard_setting WHERE varname='user_poem_allow';
DELETE FROM vcard_setting WHERE varname='user_effect_allow';
DELETE FROM vcard_setting WHERE varname='user_multirecip_allow';
DELETE FROM vcard_setting WHERE varname='user_rating_allow';
DELETE FROM vcard_setting WHERE varname='user_notify_allow';
DELETE FROM vcard_setting WHERE varname='gallery_thm_width';
DELETE FROM vcard_setting WHERE varname='gallery_thm_height';
DELETE FROM vcard_setting WHERE varname='mail_abpwd_subject';
DELETE FROM vcard_setting WHERE varname='mail_abpwd_message';

DELETE FROM vcard_template WHERE title='window_addressbook';

DROP TABLE IF EXISTS vcard_sessions;
CREATE TABLE vcard_sessions (
  sid varchar(50) NOT NULL default '',
  user_id int(11) NOT NULL default '0',
  cpuser_id smallint(6) NOT NULL default '0',
  mix varchar(100) NOT NULL default '',
  opened int(14) default NULL,
  expire int(14) default NULL,
  KEY sid (sid)
) TYPE=HEAP;

DROP TABLE IF EXISTS vcard_smilies;
CREATE TABLE vcard_smilies (
  smilie_id int(11) unsigned NOT NULL auto_increment,
  code varchar(30) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  label varchar(50) NOT NULL default '',
  smilie_active tinyint(3) NOT NULL default '0',
  UNIQUE KEY smilie_id (smilie_id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS vcard_usergroup;
CREATE TABLE vcard_usergroup (
  usergroup_id int(11) unsigned NOT NULL auto_increment,
  usergroup_name varchar(100) NOT NULL default '',
  priv_canview tinyint(3) NOT NULL default '0',
  priv_cansearch tinyint(3) NOT NULL default '0',
  priv_cansend tinyint(3) NOT NULL default '0',
  priv_canvote tinyint(3) NOT NULL default '0',
  priv_canupload tinyint(3) NOT NULL default '0',
  priv_canstamp tinyint(3) NOT NULL default '0',
  priv_cansound tinyint(3) NOT NULL default '0',
  priv_canbground tinyint(3) NOT NULL default '0',
  priv_caneffect tinyint(3) NOT NULL default '0',
  priv_canpoem tinyint(3) NOT NULL default '0',
  priv_cannotify tinyint(3) NOT NULL default '0',
  priv_canadvance tinyint(3) NOT NULL default '0',
  priv_canmultirecip tinyint(3) NOT NULL default '0',
  priv_cancopy tinyint(3) NOT NULL default '0',
  UNIQUE KEY usrgroup_id (usergroup_id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS vcard_catpermission;
CREATE TABLE vcard_catpermission (
  catpermission_id int(11) unsigned NOT NULL auto_increment,
  cat_id int(11) NOT NULL default '0',
  usergroup_id int(11) NOT NULL default '0',
  UNIQUE KEY catepermission_id (catpermission_id),
  KEY usergroup_id (usergroup_id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS vcard_users;
CREATE TABLE vcard_users (
  user_id int(11) unsigned NOT NULL auto_increment,
  usergroup_id int(11) unsigned NOT NULL default '0',
  user_name varchar(100) NOT NULL default '',
  user_password varchar(50) NOT NULL default '',
  user_email varchar(50) NOT NULL default '',
  user_active tinyint(3) NOT NULL default '0',
  user_ip varchar(50) NOT NULL default '',
  user_date datetime NOT NULL default '0000-00-00 00:00:00',
  UNIQUE KEY user_id (user_id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS vcard_addrbook;
CREATE TABLE vcard_addrbook (
  addr_id int(11) unsigned NOT NULL auto_increment,
  user_id int(11) unsigned NOT NULL default '0',
  addr_name varchar(50) NOT NULL default '',
  addr_email varchar(60) NOT NULL default '',
  addr_birthday date NOT NULL default '0000-00-00',
  UNIQUE KEY addr_id (addr_id),
  KEY ab_id (user_id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS vcard_activation;
CREATE TABLE vcard_activation (
  activation_id int(11) unsigned NOT NULL auto_increment,
  user_id int(11) unsigned NOT NULL default '0',
  activation_expire int(11) NOT NULL default '0',
  activation_code varchar(30) NOT NULL default '',
  activation_todo text NOT NULL,
  PRIMARY KEY  (activation_id),
  KEY activation_code (activation_code)
) TYPE=MyISAM;

INSERT INTO vcard_settinggroup VALUES (10, 'usergroupset', 8);

INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_activation_code_subject', 'Action Required to Activate Membership', '', 11);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_activation_code_message', 'Dear {user_name},\r\n\r\nThank you for registering for the {site_name}. Before we can activate your account one last step must be taken to complete your registration!\r\n\r\nPlease note - you must complete this last step to become a registered member. You will only need to click on the link once, and your account will be updated.\r\n\r\nTo complete your registration, click on the link below: \r\n{activation_url}\r\n\r\n<a href="{activation_url}">AOL Users click Here to be Activated</a>\r\n\r\n**** Does The Above Link Not Work? ****\r\nIf the above link does not work, please use your Web browser to go to:\r\n{alt_activation_url}\r\n\r\nPlease to be sure not to add extra spaces. You will need to type in your username and activation number on the page that appears when you click on our copy the above link in your browser. \r\n\r\nYour Username is: {user_email}\r\nYour Activation ID is: {activation_code}\r\n\r\nIf you are still having problems signing up please contact us\r\n\r\nThanks very much,\r\n{site_name}\r\n{site_url}\r\n', 'textarea', 12);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_lost_password_subject', 'Lost Password', '', 13);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_lost_password_message', 'Dear Member,\r\n\r\nYou have requested to reset your password on {site_name} because you have forgotten your password. If you did not request this, please ignore it. It will expire and become useless in 24 hours time.\r\n\r\nTo reset your password, please visit the following page:\r\n{reset_url}\r\n\r\nWhen you visit that page, your password will be reset, and the new password will be emailed to you.\r\n\r\nRegards,\r\n{site_name}\r\n{site_url}', 'textarea', 14);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_reseted_password_subject', 'New Password generated', '', 15);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_reseted_password_message', 'Dear {user_name},\r\n\r\nYou have requested to reset your password on {site_name} because you have forgotten your password. \r\n\r\nThe login access info is:\r\n\r\nlogin: {user_email}\r\npassword: {user_password}\r\n\r\nRegards,\r\n{site_name}\r\n{site_url}', 'textarea', 16);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_emailchange_subject', 'Confirm e-mail address change', '', 17);
INSERT INTO vcard_setting VALUES (NULL, 4, 'mail_emailchange_message', 'Dear {user_name},\r\n\r\nYou have requested the e-mail alteration of you account into {site_name}. To complete the request please use the link below\r\n\r\n{activation_url}\r\n\r\nRegards,\r\n{site_name}\r\n{site_url}', 'textarea', 18);
INSERT INTO vcard_setting VALUES (NULL, 10, 'user_usergroup_guest', '1', 'set_usergroup', 2);
INSERT INTO vcard_setting VALUES (NULL, 10, 'user_usergroup_registered', '2', 'set_usergroup', 1);
INSERT INTO vcard_setting VALUES (NULL, 8, 'thumb_max_width_heigth', '75', '', 8);
INSERT INTO vcard_setting VALUES (NULL, 8, 'thumb_image_quality', '60', '', 9);

INSERT INTO vcard_smilies VALUES (1, ':-)', 'smilies/smiley.gif', 'Smile', 1);
INSERT INTO vcard_smilies VALUES (2, ':-(', 'smilies/sad.gif', 'Sad', 1);
INSERT INTO vcard_smilies VALUES (3, ':-P', 'smilies/tong.gif', 'tong', 1);
INSERT INTO vcard_smilies VALUES (4, '8-)', 'smilies/cool.gif', 'cool', 1);
INSERT INTO vcard_smilies VALUES (5, '8-P', 'smilies/cooltong.gif', 'cooltong', 1);
INSERT INTO vcard_smilies VALUES (6, '8-O', 'smilies/coolmouth.gif', 'coolmouth', 1);
INSERT INTO vcard_smilies VALUES (7, '8-(', 'smilies/coolsad.gif', 'coolsad', 1);
INSERT INTO vcard_smilies VALUES (8, '%-)', 'smilies/dazed.gif', 'dazed', 1);
INSERT INTO vcard_smilies VALUES (9, '%-O', 'smilies/dazedmouth.gif', 'dazedmouth', 1);
INSERT INTO vcard_smilies VALUES (10, '%-(', 'smilies/dazedsad.gif', 'dazedsad', 1);
INSERT INTO vcard_smilies VALUES (11, '%-P', 'smilies/dazedtong.gif', 'dazedtong', 1);
INSERT INTO vcard_smilies VALUES (12, ':-O', 'smilies/mouth.gif', 'mouth', 1);
INSERT INTO vcard_smilies VALUES (13, ';-)', 'smilies/wink.gif', 'wink', 1);
INSERT INTO vcard_smilies VALUES (14, ';-O', 'smilies/winkmouth.gif', 'winkmouth', 1);
INSERT INTO vcard_smilies VALUES (15, ';-(', 'smilies/winksad.gif', 'winksad', 1);
INSERT INTO vcard_smilies VALUES (16, ';-P', 'smilies/winktong.gif', 'wink tong', 1);

INSERT INTO vcard_usergroup VALUES (1, 'Guest / Not Registered', 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
INSERT INTO vcard_usergroup VALUES (2, 'Registered', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO vcard_userecard VALUES ('2004-07-11 10:07:52', 'qwert', 'qwert@mail.com', '127.0.0.1', 'qwert', 'qwert@mail.com', 'pic001.jpg', 'defaultstamp.gif', '', 0, 0, 'test', '1', 'teste', '', '', 'white', 'template01', '', 'black', '+1', '040711100751TcOV5taBabuD', 0, '0', '2004-07-11', '0');

INSERT INTO vcard_template VALUES ('box_online_users', 'boxes', '<table width="100%" border="0" cellpadding="4" cellspacing="0" class="tableborder">\r\n  <tr>\r\n    <td valign="top" width="100%" class="maintitle">Current online users</td>\r\n  </tr>\r\n  <tr>\r\n    <td class="row3">${online_users}</td>\r\n  </tr>\r\n</table>\r\n<br>');
INSERT INTO vcard_template VALUES ('form_compose_card_emoticonbox', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" class="tableborder">\r\n  <tr>\r\n    <td colspan="5" align="center"><b>Clickable Smilies</b><br><br></td>\r\n  </tr>\r\n  $emoticonbox_rows\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_message', 'form_compose_card', '<textarea class="forminput" name="card_message" cols="60" rows="15" wrap="virtual" onselect="storeCaret(this);" onclick="storeCaret(this);"  onkeyup="storeCaret(this);">$value_card_message</textarea>\r\n<a href="javascript:winhelp(\'vcode\',430,370)"><img src="img/icon_help.gif" alt="${msg[\'icon_help\']}" /></a>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardfontcolor', 'form_compose_card', '<input class="forminput" type="text" name="card_fontcolor" value="$value_card_fontcolor" readonly="readonly" /> <a href="JavaScript:popup(\'./select_color.php?action=card_fontcolor\',238,178,\'color\')"><img src="img/icon_colorpicker.gif" alt="${msg[\'icon_colorpicker\']}" /></a>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardfontface', 'form_compose_card', '<select class="forminput" name="card_fontface">\r\n<option value="">${msg[\'font_nonefont\']}</option>\r\n<option value=""></option>\r\n$cardfontface_options\r\n</select>\r\n <a href="javascript:winhelp(\'fonts\',550,270)"><img src="img/icon_help.gif" alt="${msg[\'icon_help\']}" /></a>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardfontsize', 'form_compose_card', '<select class="forminput" name="card_fontsize">\r\n$cardfontsize_options\r\n</select>');
INSERT INTO vcard_template VALUES ('form_compose_card_signature', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'signature\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td width="100%" class="tdrow1" align="left"><input type="text" name="card_sig" value="$value_card_sig" maxlength="50" class="forminput" size="40" />\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_poem', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'choose_poem\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td width="100%" class="tdrow1" align="left">\r\n      <select name="card_poem" size="1" class="forminput">\r\n      <option value=""> ${msg[\'none\']} </option>\r\n      <option value=""> </option>\r\n      $poem_options\r\n      </select> \r\n      <input type="button" value="${msg[\'view\']}" width="100" onClick="viewpoem(this.form)" class="button" />\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_effect', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'choose_effect\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td width="100%" class="tdrow1" align="left">\r\n      <select name="card_effect" size="1" class="forminput">\r\n      <option value="">${msg[\'none\']}</option>\r\n      <option value=""></option>\r\n      $effect_options\r\n      </select> \r\n      <input type="button" class="button" value="${msg[\'view\']}" width="100" onClick="vieweffect(this.form)" />\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_advancedate', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'date_to_send\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <select class="forminput" name="card_tosend">\r\n       $card_tosend_options\r\n      </select>\r\n      <br />\r\n      ${msg[\'date_to_send_note\']}\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardlayout', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'choose_card_layout\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <table cellpadding="4">\r\n        <tr>\r\n          <td align="center"><input type="radio" name="card_template" value="template01" $value_card_template01 /></td>\r\n          <td align="center"><input type="radio" name="card_template" value="template02" $value_card_template02 /></td>\r\n          <td align="center"><input type="radio" name="card_template" value="template03" $value_card_template03 /></td>\r\n        </tr>\r\n        <tr>\r\n          <td align="center"><img src="img/style_01.gif" alt="" /></td>\r\n          <td align="center"><img src="img/style_02.gif" alt="" /></td>\r\n          <td align="center"><img src="img/style_03.gif" alt="" /></td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardcolor', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'card_background\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <input type="text" class="forminput" name="card_color" value="$value_card_color" readonly="readonly" /> \r\n      <a href="JavaScript:popup(\'./select_color.php?action=card_color\',238,178,\'color\')"><img src="img/icon_colorpicker.gif" alt="${msg[\'icon_colorpicker\']}" /></a>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_stamp', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'choose_stamp\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <select name="card_stamp" size="1" onChange="changestamp(this.form);" class="forminput">\r\n      <option value="null.gif">${msg[\'none\']}</option>\r\n      <option value="null.gif"></option>\r\n      $stamp_options\r\n      </select> <a href="javascript:winhelp(\'stamp\',300,290)"><img src="img/icon_help.gif" alt="${msg[\'icon_help\']}" /></a>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_pattern', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'page_background\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <select class="forminput" name="card_background" size="1" onChange="changebg(this.form);">\r\n      <option value="null.gif">${msg[\'none\']}</option>\r\n      <option value="null.gif"> </option>\r\n      $pattern_options\r\n      </select> \r\n      <a href="javascript:winhelp(\'background\',250,290)"><img src="img/icon_help.gif" alt="${msg[\'icon_help\']}" /></a>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_imagepreviewbox', 'form_compose_card', '<img src="img/null.gif" alt="" name="sample" id="sample" width="80" height="80" border="0" />');
INSERT INTO vcard_template VALUES ('form_compose_card_music', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'music\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <select name="card_sound" class="forminput">\r\n      <option value="">${msg[\'none\']}</option>\r\n      <option value=""></option>\r\n      $music_options\r\n      </select> \r\n      <input type="button" class="button" value="${msg[\'play\']}" width="100" onClick="playmusic(this.form)" />\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardnotify', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'notification\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">${msg[\'notify_me\']}: <br />\r\n      <input type="radio" name="card_notify" value="1" $value_card_notify_yes /> ${msg[\'yes\']}\r\n      <input type="radio" name="card_notify" value="0" $value_card_notify_no /> ${msg[\'no\']}\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_cardcopy', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'card_copy\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">${msg[\'ecard_copy_do_you_want\']}<br />\r\n      <input type="radio" name="card_copy" value="1" $value_card_copy_yes /> ${msg[\'yes\']}\r\n      <input type="radio" name="card_copy" value="0" $value_card_copy_no /> ${msg[\'no\']}\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_newsletter', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" width="100%">\r\n  <tr>\r\n    <td align="left" width="100%" class="pformstrip">${msg[\'mailing_list\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="left" width="100%" class="tdrow1">\r\n      <input type="checkbox" name="receive_newsletter" value="1" $value_receive_newsletter /> ${msg[\'join_mailing_list\']}\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('form_compose_card_title', 'form_compose_card', '<table border="0" cellspacing="0" cellpadding="4" algin="left" width="100%">\r\n  <tr>\r\n    <td width="50%" class="pformstrip">${msg[\'title\']}:</td>\r\n  </tr>\r\n  <tr>\r\n    <td width="50%" class="tdrow1"><input class="forminput" type="text" name="card_heading" value="$value_card_heading" maxlength="100" size="40" /></td>\r\n  </tr>\r\n</table>');
INSERT INTO vcard_template VALUES ('page_browse_cat_subcats_textlist', 'page_browse_cat', ' <table width="100%" border="0" cellpadding="0" cellspacing="0" class="tableborder">\r\n <tr>\r\n <td valign="top" width="100%" class="titlemedium">Sub-Categorias</td>\r\n </tr>\r\n <tr>\r\n <td class="row1" align="left" valign="top" width="100%">\r\n <br /><blockquote>${text_links_available_subcats}</blockquote>\r\n </td>\r\n <tr>\r\n </table>\r\n<br />');
INSERT INTO vcard_template VALUES ('page_complete_catlist', 'pages', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br>\r\n      ${list_calendar}<br>\r\n      ${list_top_total_cards}</td>\r\n    <td valign="top" width="66%">\r\n      <table width="100%" border="0" cellpadding="5" cellspacing="0" class="tableborder">\r\n        <tr>\r\n          <td valign="top" width="100%" class="maintitle">Complete Categories List</td>\r\n        </tr>\r\n        <tr>\r\n          <td class="row2" align="left" valign="top" width="100%">\r\n          <br />\r\n          ${list_text_all_cats}\r\n         </td>\r\n       </tr>\r\n     </table>\r\n    </td>\r\n   <td valign="top" width="17%">\r\n      banner\r\n      <br />\r\n      banner\r\n    </td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_index_antispam', 'page_index', '          <table width="100%" border="0" cellpadding="10" cellspacing="0" class="tableborder"> \r\n            <tr> \r\n              <td valign="top" width="100%" class="maintitle">Anti-Spam Policy</td> \r\n            </tr> \r\n            <tr> \r\n              <td class="row2" align="left"> \r\n                The ecard senting has been limited to ${cfg[\'antispam_allow_entries\']}  ecards per hour to prevent abuse of this service. Questions please email <a href="mailto:${admin_email}">${admin_email}</a> \r\n              </td> \r\n            </tr> \r\n          </table> \r\n          <br /><br />');
INSERT INTO vcard_template VALUES ('page_top_card_day', 'page_top_card', '        <table border="0" cellpadding="3" cellspacing="0" width="100%" class="tableborder">\r\n          <tr>\r\n            <td class="maintitle" align="center" valign="top" width="100%">\r\n              ${msg[\'top_day_cards\']}\r\n            </td>\r\n          </tr>\r\n          <tr>\r\n            <td class="row2" align="center" valign="top" width="100%">\r\n              ${content_top_day}\r\n            </td>\r\n          </tr>\r\n        </table>\r\n<br />');
INSERT INTO vcard_template VALUES ('page_top_card_week', 'page_top_card', '        <table border="0" cellpadding="3" cellspacing="0" width="100%" class="tableborder">\r\n          <tr>\r\n            <td class="maintitle" align="center" valign="top" width="100%">\r\n              ${msg[\'top_week_cards\']}\r\n            </td>\r\n          </tr>\r\n          <tr>\r\n            <td class="row2" align="center" valign="top" width="100%">\r\n              ${content_top_week}\r\n            </td>\r\n          </tr>\r\n        </table>\r\n<br />');
INSERT INTO vcard_template VALUES ('page_top_card_all', 'page_top_card', '        <table border="0" cellpadding="3" cellspacing="0" width="100%" class="tableborder">\r\n          <tr>\r\n            <td class="maintitle" align="center" valign="top" width="100%">\r\n              ${msg[\'alltime_topcards\']}\r\n            </td>\r\n          </tr>\r\n          <tr>\r\n            <td class="row2" align="center" valign="top" width="100%">\r\n              ${content_top_total}\r\n            </td>\r\n          </tr>\r\n        </table>\r\n<br />');
INSERT INTO vcard_template VALUES ('page_user', 'pages', '');
INSERT INTO vcard_template VALUES ('page_user_login', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <form action="login.php" method="post">\r\n      <table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'login\']}</td>\r\n        </tr>\r\n        <tr>\r\n        <tr>\r\n          <td class="tdrow1" width="40%" align="right"><b>${msg[\'mem_email\']}:</b></td>\r\n          <td class="tdrow1" width="60%" align="left"><input type="text" name="user_email" value="" class="forminput" size="40" /></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" align="right"><b>${msg[\'mem_password\']}:</b></td>\r\n          <td class="tdrow2" align="left"><input type="password" name="user_password" value="" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" align="center" class="tdrow1" width="50%">\r\n            <input type="submit" class="button" value="${msg[\'login\']}" />\r\n            <br /><br />\r\n             <a href="register.php">${msg[\'mem_want_register\']}</a>&nbsp;&nbsp;&nbsp;<a href="member.php?action=lostpassword">${msg[\'mem_forgot_password\']}</a>\r\n          </td>\r\n        </tr>\r\n      </table>\r\n      <input type="hidden" name="action" value="login" />\r\n      <input type="hidden" name="ref" value="${url_ref}" />\r\n      </form>\r\n    </td>\r\n    <td valign="top" width="17%">Banner</td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_profile', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <form action="profile.php" method="post">\r\n      <table cellSpacing="0" cellPadding="2" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'mem_pro_frm_form_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left" width="40%">${msg[\'mem_pro_frm_name\']}</td>\r\n          <td class="tdrow1" align="left" width="60%"><input type="text" name="user_name" value="${user[\'user_name\']}" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" align="left">${msg[\'mem_pro_frm_password\']}:</td>\r\n          <td class="tdrow2" align="left"><input type="password" name="user_password" value="" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left">${msg[\'mem_pro_frm_password_confirm\']}</td>\r\n          <td class="tdrow1" align="left"><input type="password" name="user_password_confirm" value="" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" align="left">${msg[\'mem_pro_frm_email\']}</td>\r\n          <td class="tdrow2" align="left"><input type="text" name="user_email" value="${user[\'user_email\']}" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left">${msg[\'mem_pro_frm_email_confirm\']}</td>\r\n          <td class="tdrow1" align="left"><input type="text" name="user_email_confirm" value="${user[\'user_email\']}" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" align="center" class="tdrow2">\r\n            <input type="submit" value="Submit" class="button" /> &nbsp; &nbsp; <input type="reset" value="Reset" class="button" />\r\n          </td>\r\n        </tr>\r\n      </table>\r\n      <input type="hidden" name="action" value="update">\r\n      </form>\r\n    </td>\r\n    <td valign="top" width="17%"> banner</td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_addressbook', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <table width="100%" border="0" cellpadding="10" cellspacing="0" class="tableborder">\r\n        <tr>\r\n          <td valign="top" width="100%" class="maintitle">${msg[\'mem_ab_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" align="left" width="100%">\r\n            <a href="addrbook.php">${msg[\'mem_ab_title\']}</a>\r\n          </td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" align="left">\r\n            <a href="addrbook.php?action=add">${msg[\'mem_ab_add_person\']}</a>\r\n          </td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2">${html_form_content}</td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n    <td valign="top" width="17%">Banner</td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_need_register', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br>\r\n      ${list_calendar}<br>\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <form action="login.php" method="post">\r\n        <table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n          <tr>\r\n            <td class="maintitle" colspan="2">${msg[\'login\']}</td>\r\n          </tr>\r\n          <tr>\r\n          <tr>\r\n            <td class="tdrow2" align="right"><b>${msg[\'mem_email\']}:</b></td>\r\n            <td class="tdrow2" align="left"><input type="text" name="user_email" value="" size="30" class="forminput" /> <br/ ><a href="register.php">${msg[\'mem_want_register\']}</a></td>\r\n          </tr>\r\n          <tr>\r\n            <td class="tdrow2" align="right"><b>${msg[\'mem_password\']}:</b></td>\r\n            <td class="tdrow2" align="left"><input type="password" name="user_password" value="" size="30" class="forminput" /> <br/ ><a href="member.php?action=lostpassword">${msg[\'mem_forgot_password\']}</a></td>\r\n          </tr>\r\n          <tr>\r\n            <td colspan="2" class="tdrow1" align="center"><input type="submit" value="${msg[\'login\']}" class="button" /></td>\r\n          </tr>\r\n        </table>\r\n        <input type="hidden" name="ref" value="${url_ref}" />\r\n        <input type="hidden" name="action" value="login" />\r\n      </form>\r\n      <br />\r\n      <table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'error_mem_you_arent_logged\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="tdrow1" align="left">\r\n            You are not logged in or you do not have permission to access this page. This could be due to one of several reasons:\r\n            <br /><br />\r\n                <li>You are not logged in. Fill in the form  of this page and try again. </li>\r\n                <li>You do not have permission to access the page that you were trying to.</li>\r\n                <li>If you are trying to send an ecard, the administrator may have disabled your account, or it may be awaiting activation. </li>\r\n            <strong>$txt_reason</strong>\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n   <td valign="top" width="17%">\r\n      banner\r\n      <br />\r\n      banner\r\n    </td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_member', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <form action="member.php" method="post">\r\n      <table cellSpacing="0" cellPadding="10" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'mem_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="pformstrip">${msg[\'mem_pro_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="tdrow1" align="left"><a href="profile.php?action=edit">${msg[\'mem_pro_edit_profile\']}</a></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="tdrow1" align="left"><a href="addrbook.php">${msg[\'mem_ab_title\']}</a></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="tdrow1" align="left"><a href="addrbook.php?action=add">${msg[\'mem_ab_add_person\']}</a></td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n    <td valign="top" width="17%">Banner</td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_register', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="83%">\r\n      <form action="register.php" method="post">\r\n      <table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'reg_form_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" width="40%" align="left">${msg[\'reg_user_name\']}</td>\r\n          <td class="tdrow1" width="60%" align="left"><input type="text" name="user_name" value="" size="50" class="forminput" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left">${msg[\'reg_user_email\']}</td>\r\n          <td class="tdrow1" align="left"><input type="text" name="user_email" value="" size="50" class="forminput" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left">${msg[\'reg_user_email_confirm\']}</td>\r\n          <td class="tdrow1" align="left"><input type="text" name="user_email_confirm" value="" size="50" class="forminput" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left">${msg[\'reg_user_password\']}</td>\r\n          <td class="tdrow1" align="left"><input type="password" name="user_password" value="" size="50" class="forminput" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow1" align="left">${msg[\'reg_user_password_confirm\']}</td>\r\n          <td class="tdrow1" align="left"><input type="password" name="user_password_confirm" value="" size="50" class="forminput" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="pformstrip" align="center" valign="top" width="100%">${msg[\'term_of_service\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" class="tdrow1">\r\n            <input type="radio" name="tos_agreement" value="1" /> ${msg[\'reg_user_agree_yes\']} <a href="tos.php">${msg[\'term_of_service\']}</a><br />\r\n            <input type="radio" name="tos_agreement" value="" checked="checked" /> ${msg[\'reg_user_agree_no\']}<br />\r\n          </td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" align="center" class="pformstrip">\r\n            <input type="submit" value="Submit" class="button" />\r\n            &nbsp; &nbsp;<input type="reset" value="Reset" class="button" />\r\n          </td>\r\n        </tr>\r\n      </table>\r\n      <input type="hidden" name="action" value="addmember">\r\n      </form>\r\n    </td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_lost_password', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <form action="member.php" method="post">\r\n      <table cellSpacing="0" cellPadding="2" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'mem_lp_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" width="40%" align="right"><b>${msg[\'mem_lp_your_email\']}:</b></td>\r\n          <td class="tdrow2" width="60%" align="left"><input type="text" name="user_email" value="" class="forminput" size="30" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" align="center" class="tdrow1">\r\n            <input type="submit" value=" Submit" class="button"/> &nbsp; &nbsp; \r\n            <input type="reset" value="Reset" class="button" />\r\n          </td>\r\n        </tr>\r\n      </table>\r\n      <input type="hidden" name="action" value="emailpassword">\r\n      </form>\r\n    </td>\r\n    <td valign="top" width="17%">Banner</td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_addressbook_add', 'page_user_addressbook', '<form action="addrbook.php" method="post">\r\n<table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n  <tr>\r\n    <td class="pformstrip" colspan="2">${msg[\'mem_ab_add_entry\']}</td>\r\n  </tr>\r\n  <tr>\r\n  <tr>\r\n    <td class="tdrow2" align="right"><b>${msg[\'mem_ab_name\']}:</b></td>\r\n    <td class="tdrow2"align="left"><input type="text" name="addr_name" value="${addr_name}" size="30" class="forminput" /></td>\r\n  </tr>\r\n  <tr class="row2">\r\n    <td class="tdrow1" align="right"><b>${msg[\'mem_ab_email\']}:</b></td>\r\n    <td class="tdrow1" align="left"><input type="text" name="addr_email" value="${addr_email}" size="30" class="forminput" /></td>\r\n  </tr>\r\n  <tr>\r\n    <td class="tdrow2" align="right"><b>${msg[\'mem_ab_birth_title\']}:</b></td>\r\n    <td class="tdrow2" align="left">${html_form_select_birthday}</td>\r\n  </tr>\r\n  <tr>\r\n    <td colspan="2" height="20" align="center" class="row3">\r\n      <input type="submit" class="button" value="${msg[\'mem_ab_button_add\']}" />\r\n      <input type="reset" class="button" value="${msg[\'mem_ab_button_cancel\']}" onClick="javascript:history.go(-1);" />\r\n    </td>\r\n  </tr>\r\n</table>\r\n<input type="hidden" name="action" value="insert" />\r\n<input type="hidden" name="scr" value="${scr}" />\r\n</form>');
INSERT INTO vcard_template VALUES ('page_user_activate_account', 'page_user', '${page_header}\r\n<table width="100%" border="0" cellpadding="0" cellspacing="6">\r\n  <tr>\r\n    <td valign="top" width="17%">\r\n      ${box_search}<br />\r\n      ${list_calendar}<br />\r\n      ${list_top_total_cards}\r\n    </td>\r\n    <td valign="top" width="66%">\r\n      <form action="member.php" method="post">\r\n      <table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n        <tr>\r\n          <td class="maintitle" colspan="2">${msg[\'reg_act_title\']}</td>\r\n        </tr>\r\n        <tr>\r\n          <td widht="35%" class="tdrow1" align="right"><b>${msg[\'reg_act_user_email\']}:</b></td>\r\n          <td width="65%" class="tdrow1" align="left"><input type="text" name="user_email" value="" class="forminput" size="40"/></td>\r\n        </tr>\r\n        <tr>\r\n          <td class="tdrow2" align="right"><b>${msg[\'reg_act_activation_code\']}:</b></td>\r\n          <td class="tdrow2" align="left"><input type="text" name="activation_code" value="" class="forminput" size="40" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan="2" aling="center" class="tdrow1">\r\n            <input type="submit" value="Submit" class="button" /> &nbsp; &nbsp; <input type="reset" value="Reset" class="button" />\r\n          </td>\r\n        </tr>\r\n      </table>\r\n      <input type="hidden" name="action" value="activate">\r\n      </form>\r\n    </td>\r\n    <td valign="top" width="17%">\r\n      Banner\r\n    </td>\r\n  </tr>\r\n</table>\r\n${page_footer}');
INSERT INTO vcard_template VALUES ('page_user_addressbook_edit', 'page_user_addressbook', '<form action="addrbook.php" method="post">\r\n<table cellSpacing="0" cellPadding="5" width="100%" border="0" class="tableborder" align="center">\r\n  <tr>\r\n    <td class="pformstrip" colspan="2">${msg[\'mem_ab_edit_entry\']}</td>\r\n  </tr>\r\n  <tr>\r\n    <td colspan="2" align="right" class="tdrow2">\r\n      <a href="addrbook.php?action=delete&addr_id=${row[\'addr_id\']}">${msg[\'mem_ab_delete_entry\']}</a>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class="tdrow1" align="right"><b>${msg[\'mem_ab_name\']}</b></td>\r\n    <td class="tdrow1" align="left"><input type="text" name="addr_name" value="${row[\'addr_name\']}" class="forminput" size="40" /></td>\r\n  </tr>\r\n  <tr>\r\n    <td class="tdrow2" align="right"><b>${msg[\'mem_ab_email\']}</b></td>\r\n    <td class="tdrow2" align="left"><input type="text" name="addr_email" value="${row[\'addr_email\']}" class="forminput" size="40" /></td>\r\n  </tr>\r\n  <tr>\r\n    <td class="tdrow1" align="right"><b>${msg[\'mem_ab_birth_title\']}</b></td>\r\n    <td class="tdrow1" align="left">${html_form_select_birthday}</td>\r\n  </tr>\r\n  <tr>\r\n    <td colspan="2" class="tdrow2" align="center">\r\n      <table>\r\n        <tr>\r\n          <td align="center">\r\n            <input type="submit" value="${msg[\'mem_ab_button_edit\']}" class="button" />\r\n            <input type="hidden" name="addr_id" value="${row[\'addr_id\']}" />\r\n            <input type="hidden" name="scr" value="${scr}" />\r\n            <input type="hidden" name="action" value="update" />\r\n</form>\r\n          </td>\r\n          <td align="center">\r\n            <form action="addrbook.php" method="post">\r\n            <input type="reset" value="${msg[\'mem_ab_button_cancel\']}" onClick="javascript:history.go(-1)" class="button" />\r\n            <input type="hidden" name="scr" value="${scr}" />\r\n            </form>\r\n          </td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n');
INSERT INTO vcard_template VALUES ('popup_user_addressbook', 'page_user_addressbook', '<!DOCTYPE html\r\n     PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\r\n     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\r\n<html dir="${msg[\'htmldir\']}">\r\n<head>\r\n<title>${site_name} : ${msg[\'mem_ab_title\']}</title>\r\n${page_header_include}\r\n<script type="text/javascript">\r\nfunction HL(el)\r\n{\r\n	if (el.checked){\r\n		do_highlight(el);\r\n	}else{\r\n	    undo_highlight(el);\r\n	}\r\n}\r\nfunction do_highlight(el)\r\n{\r\n	var ref = null;\r\n	if (el.parentNode && el.parentNode.parentNode)\r\n	{\r\n	    ref = el.parentNode.parentNode;\r\n	}\r\n	else if (el.parentElement && el.parentElement.parentElement)\r\n	{\r\n	    ref = el.parentElement.parentElement;\r\n	}\r\n	if (ref)\r\n	{\r\n	    if (ref.className == \'row\')\r\n		{\r\n			ref.className = \'rowhighlight\';\r\n	    }\r\n	    else if (ref.className == \'row1\')\r\n		{\r\n			ref.className = \'row1highlight\';\r\n	    }\r\n	}\r\n}\r\nfunction undo_highlight(el)\r\n{\r\n	var ref = null;\r\n	if (el.parentNode && el.parentNode.parentNode)\r\n	{\r\n	    ref = el.parentNode.parentNode;\r\n	}\r\n	else if (el.parentElement && el.parentElement.parentElement)\r\n	{\r\n	    ref = el.parentElement.parentElement;\r\n	}\r\n	if (ref)\r\n	{\r\n	    if (ref.className == \'rowhighlight\')\r\n		{\r\n			ref.className = \'row\';\r\n	    }\r\n	    else if (ref.className == \'row1highlight\')\r\n		{\r\n			ref.className = \'row1\';\r\n	    }\r\n	}\r\n}\r\n</script>\r\n</head>\r\n<body>\r\n<br>\r\n${html_form_content}\r\n</body>\r\n</html>\r\n');



