<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
// ##############################  DATE FUNC  ############################## //
function get_day_after($date)
{
	list ($year, $month, $day) = split ('[/.-]', $date);
	$sec_pass = mktime() - mktime(0,0,0, $month, $day, $year);
	$day_pass = floor( $sec_pass / 86400); // % div modulo
	return $day_pass;
}
function make_date_form2db($date, $limit = '-')
{
	if (ereg("([0-9]{2,4})$limit([0-9]{1,2})$limit([0-9]{1,2})", $date, $regs))
	{
		$regs['1'] = (strlen($regs['1']) < 4) ? '20' . $regs['1'] : $regs['1'];
		$regs['2'] = (strlen($regs['2']) < 2) ? '0' . $regs['2'] : $regs['2'];
		$regs['3'] = (strlen($regs['3']) < 2) ? '0' . $regs['3'] : $regs['3'];
		$value = $regs['1'].'-'.$regs['2'].'-'.$regs['3'];
		return $value;
	}
	else
	{
		return false;
	}
}
function make_date_db2form($date, $delimiter = '-')
{
	$d = array();
	$d['day'] = substr($date, 6, 2);
	$d['month'] = substr($date, 4, 2);
	$d['year'] = substr($date, 0, 4);
	return $d['day'] . $delimiter . $d['month'] . $delimiter . $d['year'];
}
function get_date_readable($date)
{
	global $cfg;
	
	if (eregi("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $date, $regs))
	{
		$regs['1'] = (strlen($regs['1']) >= 4) ? $regs['1'] : '20'.$regs['1'];
		$regs['2'] = (strlen($regs['2']) >= 2) ? $regs['2'] : '0'.$regs['2'];
		$regs['3'] = (strlen($regs['3']) >= 2) ? $regs['3'] : '0'.$regs['3'];
		$m = get_monthname($regs['2'], 1);
		$d = $regs['3'];
		$y = $regs['1'];
		if ($cfg['site_dateformat'] == 1)
		{
			$date = $d . '-' . $m . '-' . $y;
		}
		else
		{
			$date = $m . '-' . $d . '-' . $y;
		}
	}
	if ($y != '0000')
	{
		return $date;
	}
}
function get_monthname($month, $section = '')
{
	global $msg;
	
	$month = $month + 1;
	$month = $month - 1;
	return ($section == 1) ? $msg['month_names'][$month] : $msg['a_month_names'][$month];
}

// ##############################  FILE & DIR FUNC  ############################## //
function get_file_extension($file)
{
	$file = strtolower($file);
	$extension = split("[/\\.]", $file);
	$n = sizeof($extension) - 1;
	return $extension[$n];
}
function is_invalid_file_extension($file, $types = array())
{
	$ext = get_file_extension($file);
	return in_array($ext, $types) ? false : true;
}
function get_video_url($file, $base_url = '')
{
	global $cfg;
	
	$base_url = !empty($base_url)? $base_url : $cfg['site_image_url'];
	return !is_int(strpos($file,'http://'))? $base_url . $file : $file;
}
function get_audio_url($file, $base_url = '')
{
	global $cfg;
	
	$base_url = !empty($base_url)? $base_url : $cfg['site_music_url'];
	return !is_int(strpos($file,'http://'))? $cfg['site_music_url'] . $file : $file;
}
function get_video_dir($file)
{
	global $cfg;
	
	return $cfg['site_image_path'] . $file;
}
function get_audio_dir($file)
{
	global $cfg;
	
	return $cfg['site_music_path'] . $file;
}

// ##############################  STRING FUNC  ############################## //
function my_htmlspecialchars($str)
{
	$str = stripslashes($str);
	$str = str_replace('"', '&quot;', $str);
	$str = str_replace("'", '&#039;', $str);
	$str = str_replace('<', '&lt;', $str);
	$str = str_replace('>', '&gt;', $str);
	$str = str_replace('&nbsp;', '&amp;nbsp;', $str);
	return $str;
}
function get_widthpercent($column)
{
	$width = (100/$column);
	list($first, $second) = split ('[/.-]', $width);
	$valor = $first . '%';
	return $valor;
}
function make_message_id()
{
	$pool = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	mt_srand ((double)microtime() * 1000000);
	$unique_id = '';
	for ($i = 0; $i < 12; $i++)
	{
		$unique_id .= substr($pool, (mt_rand()%(strlen($pool))), 1);
	}
	return date('ymdHis') . $unique_id;
}
function get_readable_password()
{
	$word_arr_one = array(
						'mirc','old','rose','pink','blue','cyan','gold', 'lime','silk','slim','sant','lock',
						'walk','warm','zoom','high','jack','posh','face','hand','next','site','they','tune',
						'dose','cool','club','club','cube','baby','body','auto','acid','home');
	$word_arr_two = array(
						'aunt','gold','love','girl','time','door','disc','book','news','star','wica','morp',
						'ball','bond','trek','joke','tall','tank','drum','hill','duck','rock','blur','luar',
						'hand','cook','black','look','mate','main','pack','page','palm','talk');
	$arr_one_len = sizeof($word_arr_one);
	$arr_two_len = sizeof($word_arr_two);
	mt_srand ((double)microtime()*1000000);
	for ($i = 0; $i < 5; $i++)
	{
		$pos_one = mt_rand(0,($arr_one_len-1));
		if ($pos_one%2 == 0 )
		{
			$pwd_one = $word_arr_one[$pos_one] . $pwd_one;
		}
		else
		{
			$pwd_one .= $word_arr_one[$pos_one];
		}
	}
	for ($i = 0; $i < 5; $i++)
	{
		$pos_two = mt_rand(0,($arr_two_len-1));
		if($pos_two%2 == 0 )
		{
			$pwd_two .= $word_arr_two[$pos_two];
		}
		else
		{
			$pwd_two = $word_arr_two[$pos_two] . $pwd_two;
		}
	}
	$str = substr($pwd_one, 0, 4) . mt_rand(10, 99) . substr($pwd_two, 0, 4); 
	return $str; 
}

// ##############################  ARRAYS  ############################## //
function view_array($array)
{
	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($array as $key => $val)
	{
		echo '<tr>';
		echo '<td>' . $key . '&nbsp;</td>';
		if (is_array($val))
		{
			ext_array($val);
		}
		else
		{
			echo '<td>' . htmlspecialchars($val) . '&nbsp;</td>';
		}
		echo '</tr>';
	}
	echo '</table>';
}
function ext_array($array)
{
	echo '<td>';
	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($array as $key => $val)
	{
		echo '<tr>';
		echo '<td>' . $key . '&nbsp;</td>';
		if (is_array($val))
		{
			ext_array($val);
		}
		else
		{
			echo '<td>' . htmlspecialchars($val) . '&nbsp;</td>';
		}
		echo '</tr>';
	}
	echo '</table>';
	echo '</td>';
}
function my_array_sort($array, $key)
{
	$k = sizeof($array);
	for ($i = 0; $i < $k; $i++)
	{
		$sort_values[$i] = $array[$i][$key];
	}
	if (is_array($sort_values))
	{
		asort($sort_values);
		reset($sort_values);
		foreach($sort_values as $arr_key=>$arr_val)
		{
			$sorted_arr[] = $array[$arr_key];
		}
	}
	return $sorted_arr;
}
// ##############################  URL VARS  ############################## //
function grab_friendly_url_vars()
{
	$var_array = explode('/', getenv('PATH_INFO'));
	for($i=0; $i<sizeof($var_array); $i++)
	{
		if (in_array($var_array[$i], array('a','id','u','c')))
		{
			global $$var_array[$i];
			$$var_array[$i] = $var_array[$i + 1];
		}
	}
}

// ##############################  HTTP HEADER  ############################## //
function my_setcookie($name, $value = '', $permanent = 1)
{
	$cookiepath = '/';
	$cookiedomain = '';
	$SERVER_PORT = '';
	$expire = ($permanent) ? (time() + 60 * 60 * 24 * 365) : 0;
	$secure = ($SERVER_PORT == '443') ? 1 : 0;
	return @setcookie($name, addslashes($value), $expire, $cookiepath, $cookiedomain, $secure);
}
function generate_url()
{
	global $cfg;
	
	$path = preg_replace('#^/?(.*?)/?$#', '\1', trim($cfg['site_prog_url']));
	return 'http://' . preg_replace('#^/?(.*?)/?$#', '\1', trim($cfg['server_name'])) . (($cfg['server_port'] <> 80) ? ':' . trim($cfg['server_port']) : '') . (($path) ? '/' . $path : '');
}
function my_redirect_die($url)
{
	global $msg, $DB_site;
	
	if (isset($DB_site))
	{
		$DB_site->close();
	}
	if (defined('HEADER_INC'))
	{
		echo '<script type="text/javascript">window.location="' . $url . '";</script>';
		echo '<p><a href="' . $url . '">' . $msg['a_continue'] . '</a></p>';
	}
	else
	{
		if (@preg_match('#Microsoft|WebSTAR|Xitami#', getenv('SERVER_SOFTWARE')))
		{
			header('Refresh: 0; URL=' . $url);
			echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head>';
			echo '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">';
			echo '<meta http-equiv="refresh" content="0; url=' . $url . '">';
			echo '<title>Redirect</title></head><body>';
			echo '<center>' . sprintf($msg['url_redirect'], '<a href="' . $url . '">', '</a>') . '</center></body></html>';
			exit;
		}
		@header("Location: ". $url);
	}
	exit;
}

// ##############################  HTML CODES  ############################## //
function html_body($file_url = '')
{
	global $cfg;
	
	$url = !is_int(strpos($file_url, 'http://')) ? $cfg['site_image_url'] . $file_url : $file_url;
	$show = '<body ' . (!empty($file_url) ? 'background="' . $url . '"' : '') .'>';
	return $show;
}

// ##############################  ERROR HANDLING ############################## /
function usr_deniedpage_die()
{
	global $page_header, $page_footer, $page_header_include, $page_phpinclude, $htmlbody, $cfg, $msg, $sys_tmp_vars;
	global $drop_down_list, $list_cat_text, $list_calendar, $list_topcards_in_site, $msg_top_cards;
	global $list_text_all_cats, $box_pickup, $box_search;
	global $DB_site,$user;
	
	if (!defined('HEADER_INC'))
	{
		include(VCARD_ROOT_PATH.'include/user_header.inc.php');
	}
	eval("make_output(\"" . get_template('page_user_need_register') . "\");");
	if (!defined('FOOTER_INC'))
	{
		include(VCARD_ROOT_PATH.'include/user_footer.inc.php');
	}
	exit;
}
function usr_message_die($msg_case, $msg_text, $case = '')
{
	global $page_header, $page_footer, $page_header_include, $page_phpinclude, $htmlbody, $cfg, $msg, $sys_tmp_vars;
	global $drop_down_list, $list_cat_text, $list_calendar, $list_topcards_in_site, $msg_top_cards;
	global $list_text_all_cats, $box_pickup, $box_search;
	global $HTTP_POST_VARS, $DB_site, $user, $html_link_member, $html_link_loginout;
	
	if (!defined('HEADER_INC'))
	{
		include(VCARD_ROOT_PATH.'include/user_header.inc.php');
	}
	if (is_array($HTTP_POST_VARS))
	{
		foreach ($HTTP_POST_VARS as $name => $value) 
		{
			if (($varname != 'action') && ($varname != 'preview') && ($varname != 'sendnow'))
			{
				$hidden_fields .= '<input name="' . $name . '" type="hidden" value="' . $value . '" />';
			}
		}
	}
	if (!empty($action))
	{
		$hidden_fields .= '<input name="action" type="hidden" value="' . $action . '" />';
	}
	switch($msg_case)
	{
		case GENERAL_MESSAGE:
			$error_title = $msg['mdie_information'];
			$error_text = $msg_text;
			break;
		case CRITICAL_MESSAGE:
			$error_title = $msg['mdie_critical_information'];
			$error_text = $msg_text;
			break;
		case GENERAL_ERROR:
			$error_title = $msg['mdie_general_error'];
			$error_text = empty($msg_text)? $msg['mdie_an_error_occured'] : $msg_text;
			break;
		case CRITICAL_ERROR:
			$error_title = $msg['mdie_critical_error'];
			$error_text = empty($msg_text)? $msg['mdie_critical_error'] : $msg_text;
			break;
	}
	switch($case)
	{
		case 'edit':
			$form_button = '<form action="' . CREATE_PAGE . '" method="post">' . $hidden_fields . '<input type="hidden" name="action" value="edit"><input type="submit" value=" ' . $msg['back'] . ' " width="200" /></form>';
			break;
		case 'back':
			$form_button = '<form><input type="button" class="button" value=" ' . $msg['back'] . ' " width="200" onClick="javascript:history.go(-1)" /></form>';
			break;
		default:
			$form_button = '<p align="center"><a href="' . INDEX_PAGE . '"><b>' . $msg['home']  . '</b></a></p>';
	}
	$page_header_include .= '<script src="./script.js" type="text/javascript"></script>';
	$htmlbody = html_body($cfg['site_body_bgimage']);
	eval("make_output(\"" . get_template('page_error') . "\");");
	if (!defined('FOOTER_INC'))
	{
		include(VCARD_ROOT_PATH.'include/user_footer.inc.php');
	}
	exit;
}

// ##############################  CATS ARRAYS  ############################## //
function make_full_cat_tree()
{
	global $DB_site, $totalcards_in_site, $sys_tmp_vars, $cat_tree_arr;
	
	$cat_tree_arr = array();
	$totalcards_in_site = 0;
	$sql = "SELECT * FROM ". TBL_CARDS_CAT ." ORDER BY cat_order";
	$data_arr = $DB_site->query($sql);
	$i = 0;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$cat_tree_arr[] = array(
				'cat_id' => $row['cat_id'],
				'cat_subid' => $row['cat_subid'],
				'cat_order' => $row['cat_order'],
				'cat_name' => stripslashes($row['cat_name']),
				'cat_img' => $row['cat_img'],
				'cat_link' => $row['cat_link'],
				'cat_header' => stripslashes($row['cat_header']),
				'cat_footer' => stripslashes($row['cat_footer']),
				'cat_sort' => $row['cat_sort'],
				'cat_ncards' => $row['cat_ncards'],
				'cat_active' => $row['cat_active']
		);
		$totalcards_in_site += $row['cat_active']==1 ? $row['cat_ncards'] : 0;
		$i++;
	}
	$sys_tmp_vars['k'] = $i;
	unset($row);
	$DB_site->free_result($data_arr);
}
function get_catinfo($cid)
{
	global $cat_tree_arr, $sys_tmp_vars;
	
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id'] == $cid)
		{
			return array(
				'cat_id' => $cat_tree_arr[$i]['cat_id'],
				'cat_subid'=> $cat_tree_arr[$i]['cat_subid'],
				'cat_order'=> $cat_tree_arr[$i]['cat_order'],
				'cat_name'=> $cat_tree_arr[$i]['cat_name'],
				'cat_img'=> $cat_tree_arr[$i]['cat_img'],
				'cat_link'=> $cat_tree_arr[$i]['cat_link'],
				'cat_header' => $cat_tree_arr[$i]['cat_header'],
				'cat_footer' => $cat_tree_arr[$i]['cat_footer'],
				'cat_sort'=> $cat_tree_arr[$i]['cat_sort'],
				'cat_ncards'=> $cat_tree_arr[$i]['cat_ncards'],
				'cat_active'=> $cat_tree_arr[$i]['cat_active']);
		}
	}
}
function get_total_ncards($cid = 0)
{
	global $cat_tree_arr, $sys_tmp_vars;
	
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id'] == $cid)
		{
			return $cat_tree_arr[$i]['cat_ncards'];
		}
	}
}
function get_total_ncards_catandsubcat($cid=0)
{
	global $cat_tree_arr, $sys_tmp_vars;
	
	$total = get_total_ncards($cid);
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if (($cat_tree_arr[$i]['cat_subid'] == $cid) && ($cat_tree_arr[$i]['cat_active'] == 1))
		{
			$total += get_total_ncards_catandsubcat($cat_tree_arr[$i]['cat_id']);
		}
	}
	return $total;
}
function get_html_dropdown_cat()
{
	global $DB_site, $msg, $cfg, $sys_tmp_vars;
	
	$drop_down_list = '<form action=""><select OnChange="if (options[selectedIndex].value) location.href=(options[selectedIndex].value)" class="forminput"><option value="">' . $msg['go_to'] . '</option><option value="'. INDEX_PAGE . '">' . $msg['home'] . '</option>';
	$drop_down_list .= get_html_dropdown_opt_cat();
	$drop_down_list .= '</select></form>';
	return $drop_down_list;
}
function get_html_dropdown_opt_cat($cat_parent = 0, $selected = 0, $_menu_level = 0){
	global $cat_tree_arr, $sys_tmp_vars;
	
	$space = str_repeat('&nbsp;&nbsp;',$_menu_level*3);
	$_menu_level++;
	$_html = '';
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if (($cat_tree_arr[$i]['cat_subid']==$cat_parent) && ($cat_tree_arr[$i]['cat_active']==1))
		{
			$_html .= '<option value="' . GBROWSE_PAGE . '?cat_id=' . $cat_tree_arr[$i]['cat_id'] . '">' . $space . $cat_tree_arr[$i]['cat_name'] . '</option>';
			$_html .= get_html_dropdown_opt_cat($cat_tree_arr[$i]['cat_id'], $selected, $_menu_level);
		}
	}
	$_menu_level--;
	return $_html;
}

// ##############################  CATS  ############################## //
function get_parents_cat_ids($cat_id=0)
{
	global $cat_tree_arr, $sys_tmp_vars;
	static $_arr = '';
	if ($cat_id == 0)
	{
		return $_arr;
	}
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id'] == $cat_id)
		{
			$_arr[] = $cat_tree_arr[$i]['cat_id'];
			get_parents_cat_ids($cat_tree_arr[$i]['cat_subid']);
			break;
		}
	}
	return $_arr;
}
function get_categories_table()
{
	global $DB_site, $totalcards_in_site, $cat_tree_arr, $cfg, $sys_tmp_vars, $msg, $list_table_cats, $list_table_main_cats, $sys_tmp_vars;
	
	$number = $totalcards_in_site;
	$tbl_cat ='<table cellspacing="0" cellpadding="0" width="100%" border="0"><tr>';
	$tbl_upcat = '<table cellspacing="0" cellpadding="3" width="100%" border="0"><tr>';
	$total_cards_incatsubcat = 0;
	$td = 0;
	$tdd = 0;
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		$catinfo['cat_id'] = $cat_tree_arr[$i]['cat_id'];
		$catinfo['cat_img'] = $cat_tree_arr[$i]['cat_img'];
		$catinfo['cat_name'] = my_htmlspecialchars(stripslashes($cat_tree_arr[$i]['cat_name']));
		$catinfo['totalcards'] = get_total_ncards_catandsubcat($cat_tree_arr[$i]['cat_id']);
		$cat_name = $catinfo['cat_name'];
		$cat_img_url = get_video_url($cat_tree_arr[$i]['cat_img']);
		// $cat_html_image = get_html_image($cat_img_url, $cfg['thumb_max_width_heigth'], $cfg['thumb_max_width_heigth']);
		// main cats
		if ((empty($cat_tree_arr[$i]['cat_subid']) || ($cat_tree_arr[$i]['cat_subid'] == 0)) && ($cat_tree_arr[$i]['cat_active'] == 1))
		{
			$tbl_upcat .= '<td align="center" valign="top" width="' . get_widthpercent($cfg['gallery_table_cols']) . '">';
			if ($cat_tree_arr[$i]['cat_link'] == 1)
			{
				eval("\$tbl_upcat .= \"" . get_template('link_cat_text') . "\";");
			}
			else
			{
				eval("\$tbl_upcat .= \"" . get_template('link_cat_image') . "\";");
			}
			$tbl_upcat .= '</td>';
			$td++;
			if ($td == $cfg['gallery_table_cols'])
			{
				$tbl_upcat.='</tr><tr>';
				$td = 0;
			}
		}
		if ($cat_tree_arr[$i]['cat_active'] == 1)
		{
			$tbl_cat .= '<td align="center" valign="top" width="' . get_widthpercent($cfg['gallery_table_cols']) .'">';
			// all cats
			if ($cat_tree_arr[$i]['cat_link'] == 1)
			{
				eval("\$tbl_cat .= \"" . get_template('link_cat_text') . "\";");
			}
			else
			{
				eval("\$tbl_cat .= \"" . get_template('link_cat_image') . "\";");
			}
			$tbl_cat .= '</td>';
			$tdd++;
			if ($tdd == $cfg['gallery_table_cols'])
			{
				$tbl_cat .= '</tr><tr>';
				$tdd = 0;
			}
		}
	}
	$tbl_upcat .= '</tr></table>';
	$tbl_cat .= '</tr></table>';
	$list_table_main_cats = $tbl_upcat;
	$list_table_cats = $tbl_cat;
	return true;
}
function make_html_cat_nav_links($cid)
{
	global $cat_tree_arr, $sys_tmp_vars, $sortby;
	
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id'] == $cid)
		{
			$_html = ' &raquo; <a href="' . GBROWSE_PAGE . '?cat_id=' . $cat_tree_arr[$i]['cat_id'] . '&amp;sortby='. addslashes($sortby) .'">' . $cat_tree_arr[$i]['cat_name'] . '</a>' . $_html;
			if ($cat_tree_arr[$i]['cat_subid'] != '0')
			{
				$_html = make_html_cat_nav_links($cat_tree_arr[$i]['cat_subid']) . $_html;
			}
			break;
		}
	}
	return $_html;
}
function get_text_link_to_cat($cid = 0, $_menu_level = 0)
{
	global $cfg, $cat_tree_arr, $sys_tmp_vars;
	
	$_html = '';
	$space = str_repeat('&nbsp;-', $_menu_level*3);
	if($_menu_level > 3)
	{
		return $_html;
	}
	$_menu_level++;
	reset($cat_tree_arr);
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if (($cat_tree_arr[$i]['cat_subid'] == $cid) && ($cat_tree_arr[$i]['cat_active'] == 1))
		{
			$cat_name = stripslashes($cat_tree_arr[$i]['cat_name']);
			$cat_id = $cat_tree_arr[$i]['cat_id'];
			
			if(get_has_sub_cat($cat_tree_arr[$i]['cat_id'])) // with subcats
			{
				$list_cat_text_subs = get_text_link_to_cat($cat_tree_arr[$i]['cat_id'], $_menu_level);
				eval("\$_html .= \"" . get_template('list_cats_text_with_sub') . "\";");
				unset($list_cat_text_subs);
			}
			else
			{
				eval("\$_html .= \"" . get_template('list_cats_text_without_sub') . "\";");
			}
		}
	}
	$_menu_level--;
	
	if($_menu_level == 0) // final output
	{
		$list_cat_text_rows = $_html;
		eval("\$html = \"" . get_template('list_cats_text') . "\";");
		return $html;
	}
	return $_html;
}
function get_has_sub_cat($cid = 0)
{
	global $cfg, $cat_tree_arr, $sys_tmp_vars;
	
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if (($cat_tree_arr[$i]['cat_subid'] == $cid) && ($cat_tree_arr[$i]['cat_active'] == 1))
		{
			return true;
		}
	}
	return false;
}

// ##############################  CARDS  ############################## //
function get_html_day_topcard()
{
	global $DB_site, $cfg, $sys_tmp_vars, $msg;
	
	$sql = "SELECT COUNT(s.card_id) AS score, cd.card_id, cd.card_thmfile, cd.card_caption,cd.card_date, cd.card_rating
				FROM " . TBL_STATS_ECARD . " AS s
					LEFT JOIN ". TBL_CARDS_DATA ." AS cd ON (cd.card_id=s.card_id)
					LEFT JOIN ". TBL_CARDS_CAT ." AS ct ON (cd.cat_id = ct.cat_id)
					WHERE s.date>='". $sys_tmp_vars['Y-m-d'] ." 00:00:00' AND ct.cat_active='1' AND cd.card_active='1'
						GROUP BY s.card_id
						ORDER BY score DESC
					LIMIT " . $cfg['gallery_toplist_value'];
	$data_arr = $DB_site->query($sql);
	$list_top_card_itens = '';
	$i = 0;
	$c = 0;
	$columns = 1;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_id = $row['card_id'];
		$card_imgthm = $row['card_thmfile'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = get_icon_star($row['card_rating']);
		$card_new = get_icon_new($row['card_date']);
		if (!empty($card_imgthm))
		{
			$card_caption = stripslashes($row['card_caption']);
			$card_img_url = get_video_url($row['card_thmfile']);
			$card_thm_image = '<img src="'. $card_img_url .'" hspace="2" vspace="2" alt="" />';
			eval("\$list_top_card_itens .= \"" . get_template('list_top_card_item') . "\";");
			$i++;
			$c++;
			if ($c == $columns)
			{
				$list_top_card_itens .= '';
				$c = 0;
			}
		}
		if ($i == $cfg['gallery_toplist_value'])
		{
			break;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$output = \"" . get_template('list_top_card') . "\";");
	return $output;
}
function get_html_week_topcard()
{
	global $DB_site, $cfg, $sys_tmp_vars, $msg;
	
	$begin = date("Y-m-d H:i:s", mktime(0, 0, 0, $sys_tmp_vars['m'], $sys_tmp_vars['d'] - date("w", mktime(0, 0, 0, $sys_tmp_vars['m'], $sys_tmp_vars['d'], $sys_tmp_vars['Y'])), $sys_tmp_vars['Y']));
	$end = date("Y-m-d H:i:s", mktime(0, 0, 0, $sys_tmp_vars['m'], $sys_tmp_vars['d'] + 6 - date("w", mktime(0, 0, 0, $sys_tmp_vars['m'], $sys_tmp_vars['d'], $sys_tmp_vars['Y'])), $sys_tmp_vars['Y']));
	$list_top_card_itens = '';
	$i = 0;
	$c = 0;
	$columns = 1;
	$sql = "SELECT COUNT(cd.card_id) AS score, cd.card_id, cd.card_thmfile, cd.card_caption, cd.card_date, cd.card_rating 
				FROM " . TBL_STATS_ECARD . " AS s
					LEFT JOIN " . TBL_CARDS_DATA . " AS cd ON s.card_id=cd.card_id
					LEFT JOIN " . TBL_CARDS_CAT . " AS ct ON ct.cat_id=cd.cat_id
				WHERE s.date>='". $begin ."' 
					AND s.date<='". $end ."' 
					AND ct.cat_active='1' 
					AND cd.card_active='1'
				GROUP BY s.card_id
				ORDER BY score DESC";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_id = $row['card_id'];
		$card_imgthm = $row['card_thmfile'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = get_icon_star($row['card_rating']);
		$card_new = get_icon_new($row['card_date']);
		if (!empty($card_imgthm))
		{
			$card_caption = stripslashes($row['card_caption']);
			$card_img_url = get_video_url($row['card_thmfile']);
			$card_thm_image = '<img src="'. $card_img_url .'" hspace="2" vspace="2" alt="" />';
			eval("\$list_top_card_itens .= \"" . get_template('list_top_card_item') . "\";");
			$i++;
			$c++;
			if ($c == $columns)
			{
				$list_top_card_itens .= '';
				$c = 0;
			}
		}
		if ($i == $cfg['gallery_toplist_value'])
		{
			break;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$output = \"" . get_template('list_top_card') . "\";");
	return $output;;
}
function get_html_toplist($cid = 0)
{
	global $DB_site, $cfg, $sys_tmp_vars, $msg;
	
	$i = 0;
	$columns = 0;
	$list_top_card_itens = '';
	$sql_where = ($cid == 0) ? '' : " AND cd.cat_id='$cid' ";
	$sql = "SELECT cd.card_id,cd.card_thmfile,cd.card_date,cd.card_caption,cd.hits,cd.card_rating
				FROM ". TBL_CARDS_DATA ." AS cd, ". TBL_CARDS_CAT ." AS ct
				WHERE cd.card_active='1' 
					AND cd.cat_id=ct.cat_id 
					AND ct.cat_active='1' 
					AND cd.hits!='0' 
					$sql_where
				ORDER BY cd.hits DESC
				LIMIT ". $cfg['gallery_toplist_value'];
	$data_arr = $DB_site->query($sql);
	$num_rows = $DB_site->num_rows($data_arr);
	if ($num_rows > 0)
	{
		while ($row = $DB_site->fetch_array($data_arr))
		{
			$card_id = $row['card_id'];
			$card_imgthm = $row['card_thmfile'];
			$card_date = get_date_readable($row['card_date']);
			$card_caption = stripslashes($row['card_caption']);
			$card_img_url = get_video_url($row['card_thmfile']);
			$card_thm_image = '<img src="'. $card_img_url .'" hspace="2" vspace="2" alt="" />';
			$card_rating = get_icon_star($row['card_rating']);
			$card_new = get_icon_new($row['card_date']);
			eval("\$list_top_card_itens .= \"" . get_template('list_top_card_item') . "\";");
			if ($i == $columns)
			{
				$list_top_card_itens .= '';
				$i = 0;
			}
		}
		eval("\$output = \"" . get_template('list_top_card') . "\";");
	}
	else
	{
		$output = '';
	}
	$DB_site->free_result($data_arr);
	return $output;
}
// ##############################  NEW CARDS  ############################## //
function get_html_newcard()
{
	global $DB_site, $cfg, $sys_tmp_vars, $msg;
	
	$i = 0;
	$columns = 1;
	$list_new_card_itens = '';
	$sql = "SELECT * 
				FROM ". TBL_CARDS_DATA ." c LEFT JOIN ". TBL_CARDS_CAT ." cat ON c.cat_id=cat.cat_id 
				WHERE cat.cat_active='1' 
					AND c.card_active='1' 
				ORDER BY c.card_id DESC 
				LIMIT ". $cfg['gallery_newlist_value'];
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_thmfile = $row['card_thmfile'];
		$card_caption = stripslashes($row['card_caption']);
		$card_id = $row['card_id'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = get_icon_star($row['card_rating']);
		$card_new = get_icon_new($row['card_date']);
		$card_thmfile = get_video_url($row['card_thmfile']);
		$card_thm_image = '<img src="'. $card_thmfile .'" hspace="2" vspace="2" />';
		eval("\$list_new_card_itens .= \"".get_template('list_new_card_item')."\";");
		$i++;
		if ($i == $columns)
		{
			$list_new_card_itens .= '';
			$i = 0;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$card_list = \"" . get_template('list_new_card') . "\";");
	return $card_list;
}
// ##############################  EVENTS  ############################## //
function get_html_event()
{
	global $DB_site, $cfg, $sys_tmp_vars, $msg;
	
	$range_days = 60;
	$max_num_events = 100;
	
	$now_month = $sys_tmp_vars['m'];
	$now_day = $sys_tmp_vars['d'];
	$now_year = $sys_tmp_vars['Y'];
	$stopdate = date('Y-m-d', $sys_tmp_vars['timestamp'] + ($range_days*24*60*60));
	$now_x = date('md', $sys_tmp_vars['timestamp']);
	
	$list_calendar	= '';
	$list_calendar_rows = '';
	$cfg['gallery_event_allow'] = 1;
	$event_array = array();
	if ($cfg['gallery_event_allow'] == 1)
	{
		$sql = "SELECT * 
				FROM ". TBL_EVENTS ." 
				WHERE event_active='1' 
				ORDER BY event_month,event_day ASC ";
		$data_arr = $DB_site->query($sql);
		while ($row = $DB_site->fetch_array($data_arr))
		{
			$x = $row['event_month'] . $row['event_dayend'];
			$temp_year = (($x <= 3112) && ($x >= $now_x)) ? $now_year : $now_year + 1;
			$event_array[] = array(
				'event_id' => $row['event_id'],
				'event_day' => $row['event_day'],
				'event_dayend' => $row['event_dayend'],
				'event_month' => $row['event_month'],
				'event_name' => stripslashes($row['event_name']),
				'event_active' => $row['event_active'],
				'stop_date' => $temp_year . '-' . $row['event_month'] . '-' . $row['event_dayend']
			);
		}
		unset($row);
		$DB_site->free_result($data_arr);
		$event_array = my_array_sort($event_array, 'stop_date');
		
		$lm ='';
		$displayed = 0;
		$k = sizeof($event_array);
		$j = 0;
		for ($i = 0; $i < $k; $i++)
		{
			if ($j >= $max_num_events)
			{
				break;
			}
			if ($event_array[$i]['stop_date'] >= $stopdate)
			{
				break;
			}
			if (!empty($event_array[$i]))
			{
				extract($event_array[$i]);
			}
			if (($event_array[$i]['event_month'] != $lm) && ($displayed == 1))
			{
				$displayed = 0;
			}
			if (($event_array[$i]['event_month'] != $lm) && ($displayed == 0))
			{
				$event_month = get_monthname($event_month,1);
				eval("\$list_calendar_rows .= \"" . get_template('list_calendar_month') . "\";");
				$displayed = 1;
				$lm = $event_array[$i]['event_month'];
			}
			$event_date = $event_day . (($event_dayend != $event_day) ? "-$event_dayend" : '');
			eval("\$list_calendar_rows .= \"" . get_template('list_calendar_day') . "\";");
			$j++;
		}
		eval("\$_html = \"" . get_template('list_calendar') . "\";");
	}
	return $_html;
}

// ##############################  CARDS COMPONENTES  ############################## //
function get_html_card_link($row = array())
{
	$card_thmfile = $row['card_thmfile'];
	$card_caption = stripslashes($row['card_caption']);
	$card_id = $row['card_id'];
	$card_date = get_date_readable($row['card_date']);
	$card_rating = get_icon_star($row['card_rating']);
	$icon_new = get_icon_new($row['card_date']);
	$url_thumb_image = get_video_url($row['card_thmfile']);
	// $html_thumb_image = get_html_image($url_thumb_image, $cfg['thumb_max_width_heigth'], $cfg['thumb_max_width_heigth']);
	eval("\$_html = \"" . get_template('link_card') . "\";");
	return $_html;
}
function get_icon_new($date)
{
	global $cfg;
	
	$days = get_day_after($date);
	if ($cfg['site_new_days'] > $days)
	{
		return '<img src="img/icon_new.gif" alt="New" />';
	}
}
function get_icon_star($value = 0)
{
	global $msg;
	$stars = split("[/\\.]", $value);
	switch($stars[0])
	{
		case '0':
			return '<img src="img/rate0.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
		case '1':
			return '<img src="img/rate1.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
			break;
		case '2':
			return '<img src="img/rate2.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
			break;
		case '3':
			return '<img src="img/rate3.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
			break;
		case '4':
			return '<img src="img/rate4.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
			break;
		case '5':
			return '<img src="img/rate5.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
			break;
		default:
			return '<img src="img/rate0.gif" alt="'. $msg['see_rated_ecards'] .'" vspace="2" />';
	}
}
// ##############################  STATS ############################## //
function save_data_stats($card_id, $card_template)
{
	global $DB_site, $sys_tmp_vars;
	
	$sql = "INSERT INTO " . TBL_STATS_ECARD . " ( date, card_id,card_template) VALUES ('" . date('Y-m-d H:i:s', $sys_tmp_vars['timestamp']) . "','" . addslashes($card_id) . "','" . addslashes($card_template) . "') ";
	$DB_site->query($sql);
}

// ##############################  CACHE & TEMPLATES  ############################## //
function get_replaced_vars($text)
{
	global $DB_site;
	static $_vars, $_k;
	
	if (!isset($_vars) && (!isset($_k)))
	{
		$sql = "SELECT findword, replaceword FROM " . TBL_REPLACE . " ";
		$data_arr = $DB_site->query($sql);
		while ($row = $DB_site->fetch_array($data_arr))
		{
			if (!empty($row['findword']))
			{
				$_vars[] = array(
					'findword' => stripslashes($row['findword']),
					'replaceword' => stripslashes($row['replaceword'])
				);
			}
		}
		$DB_site->free_result($data_arr);
		$_k = sizeof($_vars);
	}
	for ($i = 0; $i < $_k; $i++)
	{
		$text = str_replace($_vars[$i]['findword'], $_vars[$i]['replaceword'], $text);	
	}
	return $text;
}
function make_output($str)
{
	echo get_replaced_vars($str);
	flush();
}
function get_template($templatename, $escape = 1, $comment = 0)
{
	global $templatecache, $DB_site;
	
	$template = $templatecache[$templatename];
	if ($escape == 1)
	{
		$template = addslashes($template);
		$template = str_replace("\\'","'",$template);
	}
	if (($comment == 1) && ($templatename != 'page_phpinclude'))
	{
		return "<!-- TEMPLATE: $templatename -->\n$template\n<!-- /TEMPLATE: $templatename -->\n";
	}
	return $template;
}
function make_cachereflash()
{
	global $DB_site;
	
	$sql = "DELETE FROM ". TBL_CACHE ." ";
	$DB_site->query($sql);
}

function get_vc_cached_item($item)
{
	global $DB_site, $cfg, $cache_tree_arr, $cat_tree_arr, $list_table_cats, $list_table_main_cats;
	
	if (empty($cat_tree_arr))
	{
		make_full_cat_tree();
	}
	$str = $cache_tree_arr[$item];
	if (!empty($str))
	{
		return $str;
	}
	else
	{
		$item = addslashes($item);
		$next = time() + (60 * $cfg['vcachereflesh']);
		switch ($item)
		{
			case 'cache_date':
				$str = $next;
				break;
			case 'cache_dropdown':
				$str = get_html_dropdown_cat();
				break;
			case 'cache_newcard':
				$str = get_html_newcard();
				break;
			case 'cache_today_topcard' :
				$str = get_html_day_topcard();
				break;
			case 'cache_week_topcard' :
				$str = get_html_week_topcard();
				break;
			case 'cache_calendar':
				$str = get_html_event();
				break;
			case 'cache_categories_text':
				$str = get_html_table_cattex();
				break;
			case 'cache_categories_table_upcat':
				$list_table_main_cats = '';
				$list_table_cats = '';
				get_categories_table();
				$str = $list_table_main_cats;
				break;
			case 'cache_categories_table_cat':
				$list_table_main_cats = '';
				$list_table_cats = '';
				get_categories_table();
				$str = $list_table_cats;
				break;
			case 'cache_list_text_all_cats':
				$str = get_text_link_to_cat();
				break;
		}
		$sql = "REPLACE INTO ". TBL_CACHE ." (title,content,date) VALUES ('$item', '".addslashes($str)."', '". $next ."')";
		$DB_site->query($sql);
		return $str;
	}
}
function get_vc_cached_cattoplist($cid = '')
{
	global $DB_site, $cfg, $cache_tree_arr;
	
	$cid = addslashes($cid);
	$title = 'topcat_id_' . $cid;
	if (!empty($cache_tree_arr[$title]))
	{
		return $cache_tree_arr[$title];
	}
	else
	{
		$now = time();
		$next = (60 * $cfg['vcachereflesh']) + $now;
		$sql = "SELECT * FROM " . TBL_CACHE . " WHERE title='" . $title . "' ";
		$row = $DB_site->query_first($sql);
		if ($row)
		{
			if ($now <= $row['date'])
			{
				$content = stripslashes($row['content']);
			}
			else
			{
					$content = get_html_toplist($cid);
					$sql = "REPLACE INTO " . TBL_CACHE . " (title,content,date) VALUES ('" . $title . "','" . addslashes($content) . "','" . $next . "') ";
					if (!empty($content))
					{
						$DB_site->query($sql);
					}
					else
					{
						$content = get_html_toplist($cid);
						$DB_site->query($sql);
					}
			}
		}
		else
		{
			$content = get_html_toplist($cid);
			$sql = "REPLACE INTO " . TBL_CACHE . " (title,content,date) VALUES ('" . $title . "','" . addslashes($content) . "','" . $next . "') ";
			if (!empty($content))
			{
				$DB_site->query($sql);
			}
			else
			{
				$content = get_html_toplist($cid);
				$DB_site->query($sql);
			}
		}
		return $content;
	}
}

function simple_table_builder($arr = array(), $max_cols = 1, $param = '')
{
	if (is_array($arr))
	{
		$k = sizeof($arr);
		if ($k < 1)
		{
			return false;
		}
		$_html = '<table '. $param .'>';
		$cols = 0;
		$tr_closed = true;
		for($i=0; $i<$k; $i++)
		{
			if ($cols == 0)
			{
				$tr_closed = false;
				$_html .= '<tr>';
			}
			$_html .= '<td>' . $arr[$i] . '</td>';
			$cols++;
			if ($cols == $max_cols)
			{
				$_html .= '</tr>';
				$cols = 0;
				$tr_closed = true;
			}
		}
		while ($cols > 0 && $cols != $max_cols)
		{
			$_html .= '<td>&nbsp;</td>'; 
			$cols++;
		}
		$_html .= ($tr_closed) ? '' : '</tr>';
		$_html .= '</table>';
		return $_html;
	}
	else
	{
		return false;
	}
}
?>