<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
if (defined('USE_EMAILER'))
{
	if ($cfg['smtp_use'] == 1)
	{
		$charset = $msg['charset'];
		$content_type = ($cfg['mail_format'] == 1) ? 'text/html' : 'text/plain';
		$SMTP_site = new SMTP_Class($charset, $content_type);
		$SMTP_site->smtp_host = $cfg['smtp_host'];
		//$SMTP_site->smtp_port = $cfg['smtp_port'];
		$SMTP_site->smtp_username = $cfg['smtp_username'];
		$SMTP_site->smtp_password = $cfg['smtp_password'];
		$SMTP_site->init();
		$SMTP_site->sender_ip = $sys_user_session['ip'];
		$SMTP_site->smtp_password = '';
		define('SMTP_IS_ON', true);
	}
	$smtp_password = '';
}
function email_tags($arr, $text)
{
	foreach ($arr as $key => $val)
	{
		$text = str_replace('{'.$key.'}', $val, $text);
	}
	return $text;
}
function server_hostname()
{
    if (getenv('SERVER_NAME') != '')
	{
		return getenv('SERVER_NAME');
	}
	else
    {
		return 'localhost.localdomain';
	}
}
function vl_preg_quote($str, $delimiter='')
{
	$text = preg_quote($str);
	$text = str_replace($delimiter, '\\' . $delimiter, $text);
	
	return $text;
}
function encode_txt_mail_header($str='')
{
	global $cfg, $msg;
	if ($msg['charset'] == '')
	{
		return $str;
	}
	$end = '?=';
	$start = '=?'. $msg['charset'] .'?B?';  // B => base64 / Q -> quoted-printable
	$spacer = "$end\r\n $start";
	$length = 75 - strlen($start) - strlen($end);
	$length = floor($length / 2) * 2;
	$str = chunk_split(base64_encode($str), $length, $spacer);
	$str = preg_replace('#' . vl_preg_quote($spacer) . '$#', '', $str);
	return $start . $str . $end;
}
function friendly_url($url = '')
{
	global $use_friendly_url;
	
	$is_Apache = strstr(getenv('SERVER_SOFTWARE'), 'Apache') ? true : false;
	$is_IIS = strstr(getenv('SERVER_SOFTWARE'), 'Microsoft-IIS') ? true : false;
	if ($use_friendly_url && $is_Apache)
	{
		$arrs = explode('?', $url);
		$paras = explode('&', $arrs[1]);
		foreach($paras as $k=>$v)
		{
			$ar = explode('=', $v);
			if ($ar[1]=='')
			{
				$ar[1] = 0;
			}
			$friendly .= '/'.$ar[0] .'/'. $ar[1];
		}
		return $arrs[0] . $friendly;
	}
	else
	{
		return $url;
	}
}
function build_mail_header($charset, $format, $to_email, $from_email)
{
	global $cfg, $sys_user_session;
	$CRLF = "\n";
	
	$uniq_id = md5(uniqid(time()));
	$headers = '';
	if (!empty($cfg['mail_default_sender_address']))
	{
		$headers .= 'From: <'. $cfg['mail_default_sender_address'] .'>'. $CRLF;
	}
	else
	{
		//$headers .= 'From: "'. encode_txt_mail_header($from_email) .'" <'. $from_email .'>'. $CRLF;
		$headers .= 'From: <'. $from_email .'>'. $CRLF;
	}
	//$headers .= 'To: "'. encode_txt_mail_header($to_name) .'" <'. $to_email .'>'. $CRLF;
	$headers .= 'Date: ' . gmdate('D, d M Y H:i:s Z', time()) . $CRLF;
	$headers .= sprintf("Message-ID: <%s@%s>%s", $uniq_id, server_hostname(), $CRLF);
	$headers .= 'X-Priority: 3'. $CRLF; // 1-Urgent message! 2-very 3-normal
	$headers .= 'X-Mailer: PHP/vCard Pro '. VCARD_PRO_SOFTWARE_VERSION . $CRLF;
	$headers .= 'X-Sender: <'. $from_email .'>'. $CRLF; 
	$headers .= 'X-SenderIP: '. $sys_user_session['ip'] . $CRLF;
	$headers .= 'MIME-Version: 1.0'. $CRLF;
	$headers .= 'Content-Type: '. (($format == 1) ? 'text/html' : 'text/plain') .'; charset='. $charset . $CRLF;
	$headers .= 'Content-Transfer-Encoding: 8bit';
	return $headers;
}
function sendmail_pickup($recip_email, $recip_name, $sender_email, $sender_name, $message_id, $sender_ip)
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$subject = $cfg['mail_recip_subject'];
	$message = $cfg['mail_recip_message'];
	$subject = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
	), $subject);
	$message = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
		'pickup_url' => $cfg['site_prog_url'] . PICKUP_PAGE ."?id=$message_id",
		'pickup_link' => $cfg['site_prog_url'] . PICKUP_PAGE ."?id=$message_id",
		'id_code' => $message_id,
		'today_date' => $sys_tmp_vars['timenow'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'user_ip' => $sys_user_session['ip']
	), $message);
	$to_email = $recip_email; 
	$from_email = $sender_email;
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email, $from_email, $subject, $message, $headers);
}
/********************************************************************
Function to card copy mail
********************************************************************/
function sendmail_copy($recip_arr, $sender_email, $sender_name, $data, $message_id)
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$card_tosend = make_date_form2db($data['card_tosend']);
	$subject = $cfg['mail_copy_subject'];
	$message = $cfg['mail_copy_message'];
	$z = sizeof($recip_arr);
	for ($i=0; $i<$z; $i++)
	{
		$recipients_names .= $recip_arr[$i]['name'].', ';
		$recipients_mails .= $recip_arr[$i]['email'].', ';
		
		$recipients_list .= $recip_arr[$i]['name'] .' '. $recip_arr[$i]['email']. "\n";
		if ($data['card_tosend'] >$sys_tmp_vars['Y-m-d'])
		{
			if ($cfg['mail_format'] == 1)
			{
				$recipients_list .= $msg['cancel_this_ecard_delivery']." : <a href='". $cfg['site_prog_url'] . CANCEL_PAGE ."?id=". $recip_arr[$i]['id'] ."'>". $msg['cancel_ecard_title'] ."</a><br /><br />";
			}
			else
			{
				$recipients_list .= $msg['cancel_this_ecard_delivery'].' : '. $cfg['site_prog_url'] . CANCEL_PAGE ."?id=". $recip_arr[$i]['id'] ."\n\n";
			}
		}
	}
	$subject = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
	), $subject);
	$message = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'recipients_names' => $recipients_names,
		'recipients_mails' => $recipients_mails,
		'recipients_list' => $recipients_list,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
		'delivery_date' => get_date_readable($data['card_tosend']),
		'pickup_url' => $cfg['site_prog_url'] . PICKUP_PAGE ."?id=$message_id",
		'pickup_link' => $cfg['site_prog_url'] . PICKUP_PAGE ."?id=$message_id",
		'id_code' => $message_id,
		'today_date' => $sys_tmp_vars['timenow'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'user_ip' => $sys_user_session['ip']
	), $message);
	$to_email = $sender_email; 
	$from_email = $sender_email;
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email,$from_email,$subject,$message,$headers);
}
/********************************************************************
Function to mail sender about notification
********************************************************************/
function sendmail_notify($sender_email, $sender_name, $recip_name, $recip_email)
{
	global $cfg, $msg, $sys_user_session, $message_id, $sys_tmp_vars;
	
	$subject = $cfg['mail_sender_subject'];
	$message = $cfg['mail_sender_message'];
	$subject = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
	), $subject);
	$message = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
		'pickup_url' => $cfg['site_prog_url'] . PICKUP_PAGE ."?id=$message_id",
		'pickup_link' => $cfg['site_prog_url'] . PICKUP_PAGE ."?id=$message_id",
		'id_code' => $message_id,
		'today_date' => $sys_tmp_vars['timenow'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'user_ip' => $sys_user_session['ip']
	), $message);
	$to_email = $sender_email; 
	$from_email = $recip_email;
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email,$from_email,$subject,$message,$headers);
}
/********************************************************************
Function to mail a friend
********************************************************************/
function send_emailfriend($sender_email, $sender_name, $recip_name, $recip_email, $user_message='')
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$subject = $cfg['mail_emailfriend_subject'];
	$message = $cfg['mail_emailfriend_message'];
	$subject = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
	), $subject);
	$message = email_tags(array(
		'recipient_name' => $recip_name,
		'recipient_email' => $recip_email,
		'sender_name' => $sender_name,
		'sender_email' => $sender_email,
		'user_message' => $user_message,
		'today_date' => $sys_tmp_vars['timenow'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'user_ip' => $sys_user_session['ip']
	), $message);
	$to_email = $recip_email; 
	$from_email = $sender_email;
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email,$from_email,$subject,$message,$headers);
}
/********************************************************************
Function to mail activation code
********************************************************************/
function mail_activation_code($data = array())
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$subject = $cfg['mail_activation_code_subject'];
	$message = $cfg['mail_activation_code_message'];
	// message subject
	$subject = email_tags(array('user_name' => $data['user_name']
	), $subject);
	// message body
	$message = email_tags(array(
		'alt_activation_url' => $cfg['site_prog_url'] . USR_MEMBER_PAGE ."?a=ver",
		'activation_url' => $cfg['site_prog_url'] . USR_MEMBER_PAGE ."?a=act&u=". $data['user_id'] ."&c=". $data['activation_code'],
		'activation_code' => $data['activation_code'],
		'user_name' => $data['user_name'],
		'user_email' => $data['user_email'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'site_name' => $cfg['site_name'],
		'user_ip' => $data['user_ip']
	), $message);
	$to_email = $data['user_email']; 
	$from_email = $cfg['admin_email'];
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email, $from_email, $subject, $message, $headers);
}
function mail_lost_password($data = array())
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$subject = $cfg['mail_lost_password_subject'];
	$message = $cfg['mail_lost_password_message'];
	// message subject
	$subject = email_tags(array(
		'user_name' => $data['user_name']
	), $subject);
	// message body
	$message = email_tags(array(
		'activation_code' => $data['activation_code'],
		'reset_url' => $cfg['site_prog_url'] . USR_MEMBER_PAGE ."?a=pwd&u=". $data['user_id'] ."&c=". $data['activation_code'],
		'user_name' => $data['user_name'],
		'user_email' => $data['user_email'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'site_name' => $cfg['site_name'],
		'ip' => $data['ip']
	), $message);
	$to_email = $data['user_email']; 
	$from_email = $cfg['admin_email'];
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email, $from_email, $subject, $message, $headers);
}
function mail_new_password($data = array())
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$subject = $cfg['mail_reseted_password_subject'];
	$message = $cfg['mail_reseted_password_message'];
	// message subject
	$subject = email_tags(array(
		'user_name' => $data['user_name']
	), $subject);
	// message body
	$message = email_tags(array(
		'activation_code' => $data['activation_code'],
		'reset_url' => $cfg['site_prog_url'] . USR_MEMBER_PAGE ."?a=pwd&u=". $data['user_id'] ."&c=". $data['activation_code'],
		'user_name' => $data['user_name'],
		'user_password' => $data['user_password'],
		'user_email' => $data['user_email'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'site_name' => $cfg['site_name'],
		'ip' => $data['ip']
	), $message);
	$to_email = $data['user_email']; 
	$from_email = $cfg['admin_email'];
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email, $from_email, $subject, $message, $headers);
}
function mail_new_email_activation($data = array())
{
	global $cfg, $msg, $sys_tmp_vars, $sys_user_session;
	
	$subject = $cfg['mail_emailchange_subject'];
	$message = $cfg['mail_emailchange_message'];
	// message subject
	$subject = email_tags(array(
		'user_name' => $data['user_name']
	), $subject);
	// message body
	$message = email_tags(array(
		'activation_code' => $data['activation_code'],
		'activation_url' => $cfg['site_prog_url'] . USR_MEMBER_PAGE ."?a=email&u=". $data['user_id'] ."&c=". $data['activation_code'],
		'user_name' => $data['user_name'],
		'user_email' => $data['user_email'],
		'timenow' => $sys_tmp_vars['timenow'],
		'site_url' => $cfg['site_url'],
		'site_name' => $cfg['site_name'],
		'ip' => $data['ip']
	), $message);
	$to_email = $data['user_email']; 
	$from_email = $cfg['admin_email'];
	$headers = build_mail_header($msg['charset'], $cfg['mail_format'], $to_email, $from_email);
	return my_sendmail($to_email, $from_email, $subject, $message, $headers);
}
function my_sendmail($to_email, $from_email, $subject, $message, $headers)
{
	global $SMTP_site, $msg, $cfg, $sys_user_session;

	if ($cfg['smtp_use'] == 1)
	{
		if (!defined('SMTP_IS_ON'))
		{
			$charset = $msg['charset'];
			$content_type = ($cfg['mail_format'] == 1) ? 'text/html' : 'text/plain';
			$SMTP_site = new SMTP_Class($charset, $content_type);
			$SMTP_site->smtp_host = $cfg['smtp_host'];
			//$SMTP_site->smtp_port = $cfg['smtp_port'];
			$SMTP_site->smtp_username = $cfg['smtp_username'];
			$SMTP_site->smtp_password = $cfg['smtp_password'];
			$SMTP_site->init();
			$SMTP_site->sender_ip = $sys_user_session['ip'];
			$SMTP_site->smtp_password = '';
		}
		return $SMTP_site->smtpmail($to_email, $from_email, $subject, $message);
	}
	else
	{
		//$subject = encode_txt_mail_header($subject);
		if (@mail($to_email,$subject,$message,$headers))
		{
			//echo "@mail($to_email,$subject,$message,$headers)";
			return true;
		}
		else
		{
			return false;
		}
	}
}
?>