<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('SMTP_INCLUDED', 1);
define('SMTP_STATUS_NOT_CONNECTED', 1, true);
define('SMTP_STATUS_CONNECTED', 2, true);
define('SMTP_CRLF',"\r\n");
class SMTP_Class
{
	var $debug = false;
	var $line_wrap = 75;
	var $authenticated	= false;
	var $timeout = 20;
	var $smtp_host = 'localhost';
	var $smtp_username = '';
	var $smtp_password = '';
	var $smtp_port = 25;
	var $status = '';
	var $auth = false;
	var $reporterror = false;
	var $errors = '';
	var $parts = array();
	var $attach = array();
	var $sender_ip = '';
	
	function SMTP_Class($charset = 'iso-8859-1', $ctype = 'text/plain')
	{
		$this->set_var('charset', $charset);
		$this->set_var('ctype', $ctype);
	}
	
	function init()
	{
		$this->connect();
		$this->auth();
	}
	function set_var($name, $value = '')
	{
		$this->$name = $value;
	}
	
	function &connect()
	{
		if (!isset($this->status))
		{
			$this->debuger("Connecting to SMTP server ' $this->smtp_host : $this->smtp_port '. ");
			$obj = new SMTP_Class($params);
			if ($obj->connect())
			{
				$this->debuger("Connected to SMTP server ");
				$obj->status = SMTP_STATUS_CONNECTED;
			}
			return $obj;
		}
		else
		{
			$this->debuger("Connecting to SMTP server ' $this->smtp_host : $this->smtp_port '. ");
			if ($this->socketconnection = @fsockopen($this->smtp_host, $this->smtp_port, $errno, $errstr, $this->timeout))
			{
				if (function_exists('socket_set_timeout'))
				{
					@socket_set_timeout($this->socketconnection, 5, 0);
				}
			}
			else
			{
				$this->errors .= "couldn't connect to SMTP mail server $this->smtp_host : $this->smtp_port \n";
				$this->stop("Couldn't Connect", __LINE__, __FILE__);
			}
    	}
		$this->server_result($this->socketconnection, '220');
	}
	
	function auth()
	{
		$this->debuger("Authenticating to SMTP server.");
		if (!empty($this->smtp_username) && !empty($this->smtp_password))
		{
			$this->send_data("EHLO " . $this->smtp_host,'250');
			$this->send_data("AUTH LOGIN",'334');
			$this->send_data(base64_encode($this->smtp_username),'334');
			$this->send_data(base64_encode($this->smtp_password),'235');
			$this->authenticated = true;
			$this->debuger("Authenticated!");
		}
		else
		{
			$this->debuger("Sending HELO.");
			$this->send_data("HELO " . $this->smtp_host,'250');// Send the RFC821 specified HELO.
		}
	}
	
	function close()
	{
		$this->debuger("Closing the connection to SMTP server: ' $this->smtp_host '. ");
		if ($this->socketconnection)
		{
			fputs($this->socketconnection, "QUIT". SMTP_CRLF);
			fclose($this->socketconnection);
			$this->status = SMTP_STATUS_NOT_CONNECTED;
			$this->socketconnection=0;
		}
	}
	
	function smtpmail($to_email, $from_email, $subject, $message)
	{
		if ($this->is_connected())
		{
			if ($this->auth && !$this->authenticated)
			{
				if (!$this->auth())
				{
					return false;
				}
			}
		}
		if (is_array($message))
		{
			$this->parts[] = array(
				'ctype'=> $message['ctype'],
                'message'=> $message['message'],
				'name'=> $message['name']
			);
			$this->debuger("Creating parts[] array ") ;
			$formatted_body = $this->build_multipart();
		}
		else
		{
			$parts =  array(
				'ctype'=> $this->ctype,
				'message'=> $message,
				'name'=> ''
			);
			$this->debuger("Creating formatted_body ");
			$formatted_body = $this->build_message($parts);
			$this->debuger("formatted_body = $formatted_body");
		}
		$this->debuger("Sending e-mail.");
		$headers = $this->build_headers($to_email, $from_email, $subject);
		$this->send_data('MAIL FROM: <' . $from_email . '>', 250);
		$this->send_data('RCPT TO: <'. $to_email .'>', 250);
		$this->send_data('DATA', 354);
		$this->send_data($headers);
		$this->send_data($formatted_body);
		$this->send_data('.', 250);
		$this->clear_rcpt();
		return true;
	}
	
	function build_headers($to_email, $from_email, $subject)
	{
		$headers  = 'From: <'. $from_email .'>'. SMTP_CRLF;
		$headers .= 'To: <'. $to_email .'>'. SMTP_CRLF;
	//	$headers .= 'To: "'. $this->encode_txt_mail_header($to_name) .'" <'. $to_email .'>'. SMTP_CRLF;
	//	$headers .= 'From: "'. $this->encode_txt_mail_header($from_email) .'" <'. $from_email .'>'. SMTP_CRLF;
		$headers .= 'Reply-To: <'. $from_email .'>'. SMTP_CRLF;
	//	$headers .= 'Reply-To: "'. $this->encode_txt_mail_header($to_name) .'" <'. $from_email .'>'. SMTP_CRLF;
		$headers .= 'Return-Path: <'. $from_email .'>'. SMTP_CRLF; // Return path for errors
	//	$headers .= 'Return-Receipt-To: <'. $from_email .'>'. SMTP_CRLF; // Notify when recipients read the email
		$headers .= 'Subject: ' . $subject . SMTP_CRLF;
	//	$headers .= 'Subject: ' . $this->encode_txt_mail_header($subject) . SMTP_CRLF;
		$headers .= 'MIME-Version: 1.0'. SMTP_CRLF;
//		$headers .= 'Date: ' . gmdate('D, d M Y H:i:s Z', time()) . SMTP_CRLF;
		$headers .= sprintf("Message-ID: <%s@%s>%s", md5(uniqid(time())), $this->server_hostname(), SMTP_CRLF);
//		$headers .= 'X-Sender: <'. $from_email .'>'. SMTP_CRLF; 
		$headers .= 'X-Priority: 3'. SMTP_CRLF; // 1-Urgent message! 2-very 3-normal
		$headers .= 'X-MSMail-Priority: Normal'. SMTP_CRLF;
		$headers .= 'X-MimeOLE: Produced By vCard Pro'. SMTP_CRLF;
		$headers .= 'X-Mailer: PHP/ '. phpversion() . SMTP_CRLF; // mailer
		$headers .= 'X-SenderIP: '. $this->sender_ip;
		return $headers;
	}
	
	function send_data($command, $expect = '')
	{
		$this->debuger("sending: $command \n exp: [$expect] ");
		fputs($this->socketconnection, $command .  SMTP_CRLF);
		if (!empty($expect))
		{
			$this->server_result($this->socketconnection, $expect);
		}
	}
	
	function attach_file($source, $c_type, $f_name)
	{
		$this->parts[] = array(
			'ctype'    => $c_type,
			'message'  => $source,
			'name'     => $f_name
		);
	}
	
	function build_multipart()
	{
		$boundary = 'next' . md5(time());
		$multipart = 'Content-Type: multipart/mixed; boundary="'. $boundary .'"'.  SMTP_CRLF .  SMTP_CRLF . "This is a MIME encoded message." .  SMTP_CRLF .  SMTP_CRLF . '--' . $boundary;
		for ($i = sizeof($this->parts)-1; $i >= 0; $i--)
		{
        	$multipart .=  SMTP_CRLF . $this->build_message($this->parts[$i]) . '--' . $boundary;
		}
		return $multipart .= '--' . SMTP_CRLF;
	}
	
	function build_message($part)
	{
		$this->debuger("building message:");
		if (($part['ctype'] == 'text/plain') || ($part['ctype'] == 'text/html'))
		{
	        $msg = $this->wrap_text($part['message']);
			$str = 'Content-Type: ' . $part['ctype']. (($this->charset != '') ? '; charset="'. $this->charset.'"' : '') . SMTP_CRLF . SMTP_CRLF . $msg . SMTP_CRLF;
	        return $str;
		}
		else
		{
			$msg = empty($this->attach[$part['message']])? $this->encode_file($part['message']) : $this->attach[$part['message']]['encoded'];
			$encoding = 'base64';
			$charset = '';
			$part['ctype'] = empty($part['ctype'])? $this->get_type($part['message']) : $part['ctype'];
			$str = 'Content-Type: '. $part['ctype'] .( !empty($part['name'])? '; name="'. $part['name'] .'"' .SMTP_CRLF : SMTP_CRLF) . ( !empty($encoding)? 'Content-Transfer-Encoding: '. $encoding . SMTP_CRLF : '' ) . $msg . SMTP_CRLF;
			return $str;
		}
    	unset($msg);
		unset($encoding);
		unset($charset);
	}
	
	function message_type($type)
	{
		$type = strtolower($type);
		switch ($type)
		{
			case 'html':
				$this->ctype = 'text/html';
				break;
			default:
				$this->ctype = 'text/plain';
		}
	}
	
	function get_type($file_type)
	{
		$type = strtolower($file_type);
		switch (strrchr($file_type, '.'))
		{
			case '.gif':
				return 'image/gif';
				break;
			case '.jpg':
				return "image/jpeg";
				break;
			case '.jpeg':
				return "image/jpeg";
				break;
			case '.png':
				return "image/png";
				break;
			case '.gz':
				return 'application/x-gzip';
				break;
			case '.htm':
				return 'text/html';
				break;
			case '.html':
				return 'text/html';
				break;
			case '.tar':
				return 'application/x-tar';
				break;
			case '.txt':
				return 'text/plain';
				break;
			case '.doc':
				return 'application/msword';
				break;
			case '.zip':
				return "application/zip";
				break;
			default:
				return "application/octet-stream";
		}
    }
	
	function wrap_text($msg)
	{
		return wordwrap($msg, $this->line_wrap, SMTP_CRLF);
	}
	
	function prepare_data(&$data, &$output)
	{
		if(function_exists('preg_replace'))
		{
			$output = preg_replace( array("/(^|[^\r])\n/", "/\r([^\n])/", "/(^|\n)\\./"), array("\\1\r\n", "\r\n\\1", "\\1.."), $data);
		}
		else
		{
			$output = ereg_replace("(^|\n)\\.", "\\1..", ereg_replace("\r([^\n])", "\r\n\\1", ereg_replace("(^|[^\r])\n", "\\1\r\n", $data)));
		}
	}
	
	function encode_file($file)
	{
		if (is_readable($file))
		{
			$fd = fopen($file,'rb');
			$content = fread($fd,filesize($file));
			$encoded = chunk_split(base64_encode($content)); // format $data using RFC 2045 semantics
			fclose($fd);
			$this->attach[$file] = array(
				'ctype' => $this->get_type($file),
				'encoded' => $encoded,
				'name' => $file
			);
		}
		else
		{
			$this->errors .= 'Unreadable file: ' . $file . ', check if file is available and/or permissions.';
			$this->stop('Couldnt load file', __LINE__, __FILE__);
		}
		return $encoded;
	}
	
	function server_result($socket, $response)
	{
		while (substr($server_response,3,1) != ' ')
		{
			if (!($server_response = fgets($socket, 256)))
			{
				$this->stop("Couldn't receive smtp server response codes", __LINE__, __FILE__);
			}
		}
		if (!(substr($server_response, 0, 3) == $response))
		{
			$this->stop("Problems sending Mail.\n Response: $server_response", __LINE__, __FILE__); 
		}
	}
	
	function is_connected()
	{
		return (is_resource($this->socketconnection) && ($this->status === SMTP_STATUS_CONNECTED));
	}
	
	function stop($msg, $line, $file)
	{
		if ($this->reporterror)
		{
			$message  = "SMTP Class Error:\n$msg\n";
			$message .= "Error(s): <strong> ". $this->errors ." </strong>\n";
			$message .= !empty($errstr)? "$errstr ($errno)\n" : '';
			$message .= "Date: " . date('Y/m/d - h:i:s A') . "\n";
			$message .= "Script: " . getenv('SCRIPT_NAME') . "\n";
			$message .= "Referer: " . getenv('HTTP_REFERER') . "\n";
			$message .= "File: " . $file . "\n";
			$message .= "Line: " . $line . "\n";
			echo "</td></tr></table><p><pre>\n $message \n";
			//      echo "\n<!-- $message -->\n";
			die();
		}
		return false;
	}
	function server_hostname()
	{
	    if (getenv('SERVER_NAME') != '')
		{
			return getenv('SERVER_NAME');
		}
		else
	    {
			return 'localhost.localdomain';
		}
	}
	function vl_preg_quote($str, $delimiter='')
	{
		$text = preg_quote($str);
		$text = str_replace($delimiter, '\\' . $delimiter, $text);
		
		return $text;
	}
	function encode_txt_mail_header($str='')
	{
		if ($this->charset == '')
		{
			return $str;
		}
		$end = '?=';
		$start = '=?'. $this->charset .'?B?';
		$spacer = "$end\r\n $start";
		$length = 75 - strlen($start) - strlen($end);
		$length = floor($length / 2) * 2;
		$str = chunk_split(base64_encode($str), $length, $spacer);
		$str = preg_replace('#' . $this->vl_preg_quote($spacer) . '$#', '', $str);
		return $start . $str . $end;
	}
	function clear_all()
	{
		$this->parts = array();
		$this->attach = array();
	}
	
	function clear_rcpt()
	{
		$this->parts = array();
	}
	
	function debuger($msg)
	{
		if ($this->debug)
		{
			print "<hr><pre style='text-align: left;'>\n". htmlspecialchars($msg) ."\n</pre>";
		}
	}
}
?>