<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('SESSION_INC', true);
/* class Session_site
 * require: PHP > 4.0.4
 * version: 0.2.6 - RC 1
 * use : db class $DB_site
 * author : Belchior Foundry
 * date   : start: 2003-12-14
 */
class Session_site
{
	var $sid_length = 15; // sid length
	var $sid_timeout = 60; // session time out (min)
	
	// error handler
	var $error_timeout_act = 'silence_red'; 
										// action options:
										// silence_red = redirect without message.
										// redirect = redirect with error message.
										// none = skip
	var $error_timeout_url = 'index.php';
	var $tbl_name = 'sessions';			// database table name
	// dont change if you dont know what you are doing.
	var $sid = '';
	var $data = array(); // multidimension
	var $logged_in = false;
	var $use_addr = 'sec';
	var $sql_basket = 'NONE';
	var $debug = 0;
	var $ip = '';
	var $browser = '';
	var $cookie_name = 's';
	
	// ############################## PUBLIC ################################## //
	// ############################## PUBLIC ################################## //
	// ############################## PUBLIC ################################## //
	function Session_site($sql = '', $cookie_name='s')
	{
		define('SESSION_STARTED', true);
		$this->cookie_name = $cookie_name;
		$this->_debuger("Session_site() starting class construct");
		$this->tbl_name = (defined('TBL_SESSIONS')) ? TBL_SESSIONS : 'sessions';
		$this->user_tbl_name = (defined('TBL_USR_PROFILE')) ? TBL_USR_PROFILE : 'vcard_users';
		$this->cpuser_tbl_name = (defined('TBL_CPUSR_PROFILE')) ? TBL_CPUSR_PROFILE : 'vcard_cpusers';
		
		$this->browser = (!empty($_SERVER['HTTP_USER_AGENT'])) ? $_SERVER['HTTP_USER_AGENT'] : $_ENV['HTTP_USER_AGENT'];
		$this->ip = (!empty($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : getenv('REMOTE_ADDR');
		if (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
		{
			$private_ip = array('#^0\.#', '#^127\.0\.0\.1#', '#^192\.168\.#', '#^172\.16\.#', '#^10\.#', '#^224\.#', '#^240\.#');
			foreach (explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']) as $x_ip)
			{
				if (preg_match('#([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)#', $x_ip, $ip_list))
				{
					if (($this->ip = trim(preg_replace($private_ip, $this->ip, $ip_list[1]))) == trim($ip_list[1]))
					{
						break;
					}
				}
			}
		}
		$this->_clean_expired_data();
		$this->sid = $this->_grap_sid();
		$this->_debuger("\$this->sid = $this->sid ");
		$this->sql = $sql;
		if (strlen($this->sid) == $this->sid_length)
		{
			$this->_resume_session();
		}
		else if (!empty($sql))
		{
			$this->_create_sid($sql);
		}
		else
		{
			//$this->_print_timeout();
			$this->_clean_user_sid_info();
		}
		if ($sql == $this->sql_basket)
		{
			$this->is_logged();
		}
	}
	// ################ SID
	function get_sid()
	{
		$this->_debuger("get_sid() retriving sid.");
		return $this->sid;
	}
	// ################ Session data handler
	function is_logged()
	{
		global $DB_site;
		
		$this->_debuger("is_logged() check if user is already logged.");
		$make_sess = false;
		if ($this->logged_in == false)
		{
       		$this->data = array();
			if($this->sql != $this->sql_basket)
			{
				if (strtoupper(substr($this->sql,0,6)) != 'SELECT')
				{
					$this->_print_error("Invalid call to is_logged(). Pass SELECT statements only.");
				}
				if (!empty($this->sql))
				{
					$data_arr = $DB_site->query_first($this->sql);
					if (is_array($data_arr) && !empty($data_arr))
					{
						$this->assign_sql_row_data($data_arr);
						$make_sess = true;
					}
					else
					{
						$make_sess = false;
					}
				}
				else
				{
					$make_sess = false;
				}
			}
			else
			{
				$make_sess = true;
			}
			if ($make_sess)
			{
				if ($this->_start_db_data())
				{
					$this->logged_in = true;
					$this->_update_db_data();
					return true;
				}
				else
				{
					return false;
				}
			}
			else
			{
				$this->_setcookie($this->cookie_name,'');
				unset($_COOKIE[$this->cookie_name]);
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	function get_data($handler)
	{
		$this->_debuger("get_data() retriving var data.");
		if ($this->_is_logged_in())
		{
			if ($this->_is_query_handler($handler))
			{
				return $this->data[$handler][$this->data['SESSION_QUERIES'][$handler]];
			}
			else
			{
				if (!empty($this->data[$handler]))
				{
					 return $this->data[$handler];
				}
				else
				{
					return false;
				}
			}
		}
		return false;
	}
	
	function get_var($handler)
	{
		return $this->get_data($handler);
	}
	
	function set_var($handler, $value = '',$updatenow = true)
	{
		$this->_debuger("set_var() assign var data.");
		if ($this->_is_logged_in())
		{
			$this->data[$handler] = $value;
			if($updatenow)
			{
				return $this->_update_db_data();
			}
		}
		return false;
	}
	
	function unset_var($handler)
	{
		$this->_debuger("unset_var() unset var.");
		if ($this->_is_logged_in())
		{
			if (isset($this->data[$handler]))
			{
				unset($this->data[$handler]);
			}
			return true;
		}
		return false;
	}
	
	function set_query_var($sql_handler, $val = '', $updatenow = true)
	{
		if ($this->_is_logged_in())
		{
			$this->_debuger("set_query_var() setting sql data.");
			$this->data['SESSION_QUERIES'][$sql_handler] = $val;
			if ($updatenow)
			{
				return $this->_update_db_data();
			}
			return true;
		}
		return false;
	}
	
	function unset_query_var($sql_handler)
	{
		$this->_debuger("unset_query_var() unset query var.");
		if ($this->_is_logged_in())
		{
			if (isset($this->data['SESSION_QUERIES'][$sql_handler]))
			{
				unset($this->data['SESSION_QUERIES'][$sql_handler]);
			}
			return true;
		}
		return false;
	}
	
	function update()
	{
		$this->_debuger("update() updating session stored into db.");
		if ($this->_is_logged_in())
		{
			return $this->_update_db_data();
		}
		return false;
	}
	
	function sql2session($sql_handler, $sql)
	{
		global $DB_site;
		
		$this->_debuger("sql2session() save query result to session data.");
		if (empty($sql))
		{
			return false;
		}
		$data_arr = $DB_site->query($sql);
		if ($DB_site->num_rows() != 0)
		{
			while ($row = $DB_site->fetch_array($data_arr) )
			{
				$data[] = $row;
			}
		}
		else
		{
			return false;
		}
		$this->set_query_var($sql_handler, '', false);
		$this->set_var($sql_handler, $data);
		$data_arr = null;
		return true;
	}
	
	function assign_sql_row_data($data)
	{
		$this->_debuger("assign_sql_row_data() assign sql data to data array.");
		foreach ($data as $k => $v)
		{
			if (!is_integer($k))
			{
				$this->data[$k] = $v;
			}
		}
	}
	
	function logout()
	{
		global $DB_site;
		
		$this->_debuger("_clean_expired_data() clean expired session data.");
		$sql = "DELETE FROM ". $this->tbl_name ." WHERE sid='". $this->sid ."'";
		$DB_site->query($sql);
		unset($this->sid);
		unset($this->sql);
		return true;
	}
	// ############################## helper ################################## //
	function set_config($name, $value='')
	{
		$this->_debuger("set_config() config internal variables.");
		$this->$name = $value;
	}
	function set_table($value)
	{
		$this->_debuger("set_table() config db table name.");
		$this->_debuger("seting table name.");
		$this->set_var('tbl_name',$value);
	}
	
	// ############################## PRIVATE ################################## //
	// ############################## PRIVATE ################################## //
	// ############################## PRIVATE ################################## //
	function _update_db_data()
	{
		$this->_debuger("_update_db_data() updating var data.");
		$sql = "UPDATE ". $this->tbl_name ." SET user_id='". addslashes($this->data['user_id'])."', cpuser_id='". addslashes($this->data['cpuser_id'])."' WHERE sid='". $this->sid ."'";
		$sql = $this->_append_sql($sql);
		return $this->_return_affected($sql);
	}
	
	function _start_db_data()
	{
		$this->_debuger("_start_db_data() creating default session data.");
		$this->_assign_data_var(array(
			'SESSION_START' =>  time(),
			'SESSION_EXPIRE' => (time()+(60*$this->sid_timeout)),
			'SESSION_STRID' =>  $this->_get_sec_hash_info(),
			'SESSION_QUERIES' => array(),
			'SESSION_USER' => $this->data['user_id'],
			'SESSION_CPUSER' => $this->data['cpuser_id'],
			'SID' => $this->sid
		));
		$sql = "INSERT INTO ". $this->tbl_name ." (sid,opened,expire,mix) VALUES ('". $this->sid ."', '". $this->data['SESSION_START'] ."', '". $this->data['SESSION_EXPIRE'] ."', '". $this->data['SESSION_STRID'] ."') ";
		return $this->_return_affected($sql);
	}
	
	function _assign_data_var($name, $val = '')
	{
		$this->_debuger("_assign_data_var() assign data var.");
		if (is_array($name))
		{
			foreach ($name as $key => $rval)
			{
				$this->data[$key] = $rval;
			}
		}
		else
		{
			$this->data[$name] = $val;
		}
	}
	// user info SID
	function _gen_sid_hashy()
	{
		srand((float)microtime()*10000000);
		$sid = substr(md5(rand(0,9999999)), 0, $this->sid_length);
		$this->_debuger("_gen_sid_hashy() generating sid code ($sid).");
		return $sid;
	}
	
	function _get_sec_hash_info()
	{
		//$this->_debuger("_get_sec_hash_info() generating security str code from ip,browser,md5.");
		switch ($this->use_addr)
		{
			case 'sec':
				$str = $this->ip . $this->browser;
				return md5($str);
				break;
			case 'old':
				return $this->ip;
				break;
			default:
				return '';
		}
	}
	
	function _grap_sid()
	{
		$this->_debuger("_grap_sid() grapping sid from _GET or _POST. ($this->cookie_name) ");
		if (isset($_GET[$this->cookie_name]))
		{
			return (strlen($_GET[$this->cookie_name]) == $this->sid_length) ? $_GET[$this->cookie_name] : '';
			//return ( strlen($_GET[$this->cookie_name])==$this->sid_length )? $_GET[$this->cookie_name] : (strlen($_POST[$this->cookie_name])==$this->sid_length)? $_POST[$this->cookie_name] : '';
		}
		else if(isset($_POST[$this->cookie_name]))
		{
			return (strlen($_POST[$this->cookie_name]) == $this->sid_length) ? $_POST[$this->cookie_name] : '';
		}
		elseif (isset($_COOKIE[$this->cookie_name]))
		{
			return (strlen($_COOKIE[$this->cookie_name]) == $this->sid_length) ? $_COOKIE[$this->cookie_name] : '';
		}
		else
		{
			return '';
		}
	}
	
	function _create_sid($sql = '')
	{
		$this->_debuger("_create_sid() creating sid $sql.");
		$this->sql = $sql;
		$this->sid = $this->_gen_sid_hashy();
		unset($_COOKIE[$this->cookie_name]);
		$this->_setcookie($this->cookie_name,$this->sid);
		return true;
	}
	
	function _is_logged_in()
	{
		$this->_debuger("_is_logged_in() bolean.");
		if (($this->sql != $this->sql_basket) && ($this->logged_in == false))
		{
			$this->_print_error("Session is not created. Call is_logged() before trying to execute other session functions.");
			return false;
		}
		else
		{
			return true;
		}
	}
	
	function _is_query_handler($name)
	{
		$this->_debuger("_is_query_handler() check if current handle is a query handler.");
		return (array_key_exists($name, $this->data['SESSION_QUERIES'])) ? true : false;
	}
	
	// db manipulation
	function _append_sql($sql = '')
	{
		$sql_and = " AND mix='".($this->_get_sec_hash_info())."'";
		$sql = (strtoupper(substr($sql,0,6))=='UPDATE')? $sql.$sql_and : $sql.' LIMIT 0,1';
		//$this->_debuger("_append_sql() $sql");
		return $sql;
	}
	
	function _clean_user_sid_info()
	{
		$this->sql = '';
		unset($_COOKIE[$this->cookie_name]);
		$this->_setcookie($this->cookie_name,'');
		return true;
	}
	
	function _clean_expired_data()
	{
		global $DB_site;
		
		$sql = "DELETE FROM ". $this->tbl_name ." WHERE expire<'". time() ."' ";
		$this->_debuger("_clean_expired_data() clean expired session data. $sql");
		$DB_site->query($sql);
		return true;
	}
	
	function _resume_session()
	{
		global $DB_site;
		
		//$sql = "SELECT sid FROM ". $this->tbl_name ." WHERE sid='". $this->sid ."'";
		if (!defined('IN_ADMIN'))
		{
			$sql = "SELECT * FROM ". $this->tbl_name ." AS s LEFT JOIN ". $this->user_tbl_name  ." AS u ON (u.user_id=s.user_id) LEFT JOIN ". TBL_USR_GROUP ." AS g ON (u.usergroup_id=g.usergroup_id) WHERE s.sid='". $this->sid ."'";
			//$sql = "SELECT u.id as user_id, u.name as user_name, u.email as user_email, u.ip_address as user_ip, g.*, s.* FROM vcard_sessions AS s LEFT JOIN forum_members AS u ON (u.id=s.user_id) LEFT JOIN vcard_usergroup AS g ON (g.usergroup_id='2') WHERE s.sid='". $this->sid ."'";
		}
		else
		{
			$sql = "SELECT * FROM ". $this->tbl_name ." AS s LEFT JOIN ". $this->cpuser_tbl_name  ." AS u ON (s.cpuser_id=u.cpuser_id) WHERE s.sid='". $this->sid ."'";
		}
		$this->_debuger("_resume_session() $sql");
		$sql = $this->_append_sql($sql);
		$user = $DB_site->query_first($sql);
		if (!empty($user['sid']))
		{
			if (!defined('IN_ADMIN'))
			{
				$sql = "SELECT * FROM ". TBL_CARDS_CAT_PERMISSION ." WHERE usergroup_id='". $user['usergroup_id'] ."' ";
				$data_arr = $DB_site->query($sql);
				while ($row = $DB_site->fetch_array($data_arr))
				{
					$cat_access[$row['cat_id']] = $row['cat_id'];
				}
				$DB_site->free_result($data_arr);
				$user['cat_access'] = $cat_access;
			}
			$this->logged_in = true;
			$this->_update_db_lifetime();
			$this->data = $user;
			return true;
		}
		else
		{
			$this->logged_in = false;
			$this->_clean_user_sid_info();
			$this->_setcookie($this->cookie_name,'');
			unset($_COOKIE[$this->cookie_name]);
			$this->_print_timeout();
		}
	}
	
	function _get_data_from_db()
	{
		global $DB_site;
		
		
		if (!defined('IN_ADMIN'))
		{
			$sql = "SELECT * FROM ". $this->tbl_name ." AS s LEFT JOIN ". $this->user_tbl_name  ." AS u ON (u.user_id=s.user_id) WHERE s.sid='". $this->sid ."'";
			//$sql = "SELECT u.id as user_id, u.name as user_name, u.email as user_email, u.ip_address as user_ip, g.*, s.* FROM vcard_sessions AS s LEFT JOIN forum_members AS u ON (u.id=s.user_id) LEFT JOIN vcard_usergroup AS g ON (g.usergroup_id='2') WHERE s.sid='". $this->sid ."'";
		}
		else
		{
			$sql = "SELECT * FROM ". $this->tbl_name ." AS s LEFT JOIN ". $this->cpuser_tbl_name  ." AS u ON (s.cpuser_id=u.cpuser_id) WHERE s.sid='". $this->sid ."'";
		}
		$this->_debuger("_get_data_from_db() $sql");
		$sql = $this->_append_sql($sql);
		$this->data = $DB_site->query_first($sql);
		return (!empty($row['sid'])) ? true : false;
	}
	
	function _update_db_lifetime()
	{
		global $DB_site;
		
		$this->data['SESSION_EXPIRE'] = time() + (60*$this->sid_timeout);
		$sql = "UPDATE ". $this->tbl_name ." SET expire='". $this->data['SESSION_EXPIRE']."' WHERE sid='". $this->sid ."'";
		$this->_debuger("_update_db_lifetime() $sql ");
		$DB_site->query($sql);
		return true;
	}
	
	function _return_affected($sql)
	{
		global $DB_site;
		
		$this->_debuger("_return_affected() $sql");
		$DB_site->query($sql);
		return ($DB_site->affected_rows() == 0) ? false : true;
	}
	
	function _setcookie($name,$value = '',$permanent = 0)
	{
		$this->_debuger("_setcookie() $name,$value,$permanent");
		$cookiepath = '/';
		$cookiedomain = '';
		$SERVER_PORT = '';
		$expire = ($permanent) ? time() + 60*60*24*365 : 0;
		if ($SERVER_PORT == '443')
		{
			$secure = 1; // we're using SSL
		}
		else
		{
			$secure = 0;
		}
		if ($cookiedomain)
		{
			@setcookie($name,addslashes($value), $expire, $cookiepath, $cookiedomain, $secure);
		}
		else
		{
			@setcookie($name,addslashes($value), $expire, $cookiepath, '', $secure);
		}
	}
	// ############################## OUTPUT ############################//
	function _debuger($msg)
	{
		if ($this->debug)
		{
			print "<hr><pre>\n".$msg."\n</pre>";
		}
	}
	
	function _print_timeout()
	{
		switch ($this->error_timeout_act)
		{
			case 'redirect':
				$time = 10; // seconds
				echo '<html><head><title> Error </title></head><body>
				<script type="text/javascript">
				window.setTimeout("redirect2page()",'. ($time*1000) .');
				function redirect2page(){ parent.window.location="'. $this->error_timeout_url .'"}
				</script>
				Error:&nbsp; <blockquote><strong>Session could not be established. Session time out!</strong></blockquote>
				<center><p><a href="'. $this->error_timeout_url .'" target="_top">continue</a></p></center>
				</body>
				</html>';
				exit;
				break;
			case 'silence_red':
				echo '<html><head><title> Error </title></head><body>
				<script type="text/javascript">
				window.setTimeout("redirect2page()",'. ($time*100) .');
				function redirect2page(){ parent.window.location="'. $this->error_timeout_url .'"}
				</script>
				</body>
				</html>';
				exit;
				break;
			case 'none':
				return true;
				break;
			case 'print':
			default:
				$this->_print_error('Session could not be established. Session time out!');
		}
	}
	
	function _print_error($msg = '')
	{
		echo 'Error:&nbsp; <blockquote><strong>'. $msg . '</strong></blockquote>';
		exit;
	}
}

?>