<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('HTML_INC',true);
class HTML_vc
{
	var $html;
	var $bgcounter;
	var $target;
	var $need_access;
	var $htmldir;
	var $lang;
	var $charset;
	var $source = false;
	var $doctype = 'transitional';
	var $title = 'vCard PRO';
	var $css = '';
	var $jscript = '';
	
	var $nl = "\n";
	function HTML_vc($s = '')
	{
		$this->set_var('s', $s);
		$this->set_var('html', '');
		$this->set_var('bgcounter', '');
		$this->set_var('show', true);
		$this->set_var('target', '');
		$this->set_var('need_access', false);
		$this->set_var('charset', 'iso-8859-1');
		$this->set_var('htmldir', 'ltr');
		$this->set_var('lang', 'en');
		$this->set_var('source', false);
		$this->set_var('doctype', 'transitional');
		$this->set_var('title', 'vCard PRO');
	}
	
	/* ################################ CONTROL ################################ */
	function clean($name = '')
	{
		if (empty($name))
		{
			$this->set_var('html', '');
			$this->set_var('bgcounter', '');
			$this->set_var('target', '');
			$this->set_var('need_access', '');
			$this->set_var('charset', '');
			$this->set_var('htmldir', '');
			$this->set_var('lang', '');
		}
		else
		{
			$this->set_var($name);
		}
	}
	
	function set_var($varname, $value = '')
	{
		$this->$varname = $value;
	}
	
	/* ################################ COSMETIC ################################ */
	function get_row_bg()
	{
		if ($this->bgcounter++%2 == 0)
		{
			return 'firstalt';
		}
		else
		{
			return 'secondalt';
		}
	}
	
	/* ################################ TEXT ################################ */
	function html_ahref($url, $text, $title = '')
	{
		$target = !empty($this->target)? ' target="'. $this->target .'"' : '';
		$_html = '<a href="'. $this->append_sid($url) .'" title="'. $title .'"'. $target .'>'. $text .'</a>';
		return $_html;
	}
	
	function append_sid($url, $non_html_amp = false)
	{
		if (!empty($this->s) && !eregi('sid=', $url))
		{
			$url .= ((strpos($url,'?') != false) ? (($non_html_amp) ? '&' : '&amp;') : '?') . 's=' . $this->s;
		}
		return($url);
	}
	
	/* ################################ FORM ################################ */
	function form_input($title, $name, $value = '', $htmlise = true, $size = 45)
	{
		if ($htmlise)
		{
			$value = $this->my_htmlspecialchars(stripslashes($value));
		}
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><input type="text" size="' . $size . '" name="' . $name . '" value="' . $value . '" /></td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_input_opthumb($title, $name, $value = '', $htmlise = true, $size = 45, $op_thumb = true)
	{
		global $msg;
		
		if ($htmlise)
		{
			$value = $this->my_htmlspecialchars(stripslashes($value));
		}
		$_thumb = (function_exists('imagejpeg') && $op_thumb) ? " (<input type='checkbox' name='make_thumb' value='1' /> ". $msg['a_makethumb'] ."*)" : '';
		$_html = "<tr class='" . $this->get_row_bg() . "' valign='top'>
			<td><b>" . $title . "</b></td>
			<td><input type='text' size='" . $size . "' name='" . $name . "' value='" . $value . "' /> $_thumb </td>
		</tr>";
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_file($title, $name, $op_thumb = false)
	{
		global $msg;
		
		$_thumb = (function_exists('imagejpeg') && $op_thumb) ? " (<input type='checkbox' name='make_thumb' value='1' /> " . $msg['a_makethumb'] . "*)" : '';
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><input type="file" name="' . $name . '" value="" />' . $_thumb . '</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_hidden($name, $value = '', $htmlise = true)
	{
		if (is_array($name))
		{
			foreach ($name as $key => $value)
			{
				if ($htmlise)
				{
					$value = $this->my_htmlspecialchars(stripslashes($value));
				}
				$_html .= '<input type="hidden" name="' . $key . '" value="' . $value . '" />';
			}
		}
		else
		{
			if ($htmlise)
			{
				$value = $this->my_htmlspecialchars(stripslashes($value));
			}
			$_html .= '<input type="hidden" name="' . $name . '" value="' . $value . '" />';
		}
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_password($title, $name, $value = '', $htmlise = true, $size = 45)
	{
		if ($htmlise)
		{
			$value = $this->my_htmlspecialchars(stripslashes($value));
		}
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><input type="password" size="' . $size . '" name="' . $name . '" value="' . $value . '" /></td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_textarea($title, $name, $value = '', $rows = 15, $cols = 45, $htmlise = 1)
	{
		if ($htmlise)
		{
			$value = $this->my_htmlspecialchars(stripslashes($value));
		}
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><textarea name="' . $name . '" rows="' . $rows . '" cols="' . $cols . '">' . $value . '</textarea></td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_yesno($title, $name, $value = 1)
	{
		global $msg;
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
		<td><b>' . $title . '</b></td>
			<td>
				' . $msg['a_yes'] . '<input type="radio" name="' . $name . '" value="1" ' . (($value == 1) ? 'checked="checked"' : '') . ' />
				' . $msg['a_no'] . '<input type="radio" name="' . $name . '" value="0" ' . (($value == 0 || empty($value)) ? 'checked="checked"' : '') . ' />
			</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_select($title, $name, $value = '', $select = '', $extra = '')
	{
		$output = $extra;
		if (is_array($value))
		{
			foreach ($value as $key => $val)
			{
				$selected = ($select == $key) ? 'selected="selected"' : '';
				$output .= '<option value="' . $key . '" '. $selected . '>' . $this->my_htmlspecialchars(stripslashes($val)) . '</option>';
			}
		}
		else
		{
			$output = $value;
		}
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><select name="' . $name . '">' . $output . '</select></td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_date_select($title, $name, $value = '')
	{
		$day = strval(substr($value, 8, 2));
		$month = strval(substr($value, 5, 2));
		$year = strval(substr($value, 0, 4));
		$o = '<select name="'. $name.'[year]">';
		$start_y = 1900;
		$end_y = date('Y',time()) +6; 
		$selected = !empty($year) ? $year : date('Y',time());
		for ($i = $start_y; $i <= $end_y; $i++)
		{
			$o .= ($i == $selected) ? '<option value="' . $i . '" selected="selected">' . $i : '<option value="' . $i . '">' . $i;
		}
		$o .= '</select>';
		//create month choice
		$monthsArray = array(1 => 'Jan',2 => 'Feb',3 => 'Mar',4 => 'Apr',5 => 'May',6 => 'Jun',7 => 'Jul',8 => 'Aug',9 => 'Sept',10 => 'Oct',11 => 'Nov',12 => 'Dec');
		$o .= '<select name="' . $name . '[month]">';
		$selected = !empty($month) ? $month : date('m', time());
		for ($i = 1; $i <= 12; $i++)
		{
			$o .= ($i == $selected)? '<option value="' . $i . '" selected="selected">' . $monthsArray[$i] : '<option value="'.$i.'">' . $monthsArray[$i]; 
		}
		$o .= '</select>';
		
		//create day choice
		$o .= '<select name="' . $name . '[day]">';
		$selected = !empty($day) ? $day : date('d', time());
		for ($i  = 1; $i <= 31; $i++)
		{
			$o .= ($i == $selected)? '<option value="' . $i . '" selected="selected">' . $i : '<option value="' . $i . '">' . $i;
		}
		$o .= '</select>';
		
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td>' . $o . '</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_multiple_select($title, $name, $value = '', $select = '', $extra = '', $size = 15)
	{
		$output = $extra;
		if (is_array($value))
		{
			foreach ($value as $v_key => $v_val)
			{
				if (is_array($select))
				{
					foreach ($select as $s_val)
					{
						if ($v_key == $s_val)
						{
							$selected = 'selected="selected"';
							break;
						}
						else
						{
							$selected = '';
						}
					}
				}
				else
				{
					$selected = '';
				}
				$output .= '<option value="' . $v_key . '" '. $selected .'>' . $this->my_htmlspecialchars(stripslashes($v_val)) . '</option>';
			}
		}
		else
		{
			$output .= $value;
		}
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><select name="' . $name . '" size="' . $size . '" multiple="multiple" />' . $output . '</select></td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_option($value = '', $select = '', $extra = '')
	{
		$_html = $extra;
		if (is_array($value))
		{
			foreach ($value as $key => $val)
			{
				$selected = ($select == $key) ? 'selected="selected"' : '';
				$_html .= '<option value="' . $key . '" '. $selected .'>' . $this->my_htmlspecialchars(stripslashes($val)) . '</option>';
			}
		}
		else
		{
			$_html = $value;
		}
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_radio($title, $name, $value = '', $select = '')
	{
		if (is_array($value))
		{
			foreach ($value as $key => $val)
			{
				$selected = ($select == $key) ? 'checked="checked"' : '';
				$options .= '<input type="radio" name="' . $name . '" value="' . $val . '" '. $selected .' />' . $val . '<br />';
			}
		}
		else
		{
			$options = $value;
		}
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td>' . $options . '</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_checkbox($title, $name, $value = '', $select = false)
	{
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td><b>' . $title . '</b></td>
			<td><input type="checkbox" name="' . $name . '" value="' . $value . '" ' . (($select) ? 'checked="checked"' : '') . ' /></td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	/* ################################ OUTPUT ################################ */
	function parse()
	{
		echo $this->html;
	}
	
	function get()
	{
		return $this->html;
	}
	
	function form_header($script, $action, $uploadform = 0, $addtable = false, $name = 'formname')
	{
		// class='formline'
		$_html = $this->nl . '<form action="' . $script . '" ' . (($uploadform) ? 'enctype="multipart/form-data"' : '') . ' name="' . $name . '" method="post"><input type="hidden" name="s" value="' . $this->s . '" /><input type="hidden" name="action" value="' . $action . '" />';
		if ($addtable)
		{
			$_html .= '<table width="100%" cellpadding="4" cellspacing="1" border="0" align="center" class="tableline">';
		}
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_footer($submit = 'Submit', $on_reset = '')
	{
		$_html = '</table>';
		//$on_click_submit = !empty($on_submit) ? "onClick='$on_submit' " :'';
		$on_click_reset = !empty($on_reset) ? "onClick='$on_reset' " :'';
		$_html .= '<table width="100%" cellpadding="4" cellspacing="1" border="0" align="center" class="tableline">
		<tr>
			<td align="center"><input type="submit" name="submit" value=" ' . $submit . ' " class="mainoption" /></td>
			<td align="center"><input type="reset" value="" name="reset" class="liteoption" ' . $on_click_reset . ' /></td>
		</tr>
		</table></form>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_note($note)
	{
		global $msg;
		
		$i = 1;
		if (is_array($note))
		{
			foreach ($note as $val)
			{
				$output .= '<p>' . str_repeat('*', $i++) . ' ' . $val . '</p>';
			}
		}
		else
		{
			$output = $note;
		}
		$_html .= '<tr>
			<td><b>' . $msg['a_t_note'] . '</b></td>
			<td>' . $output . '</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_help($note)
	{
		global $msg;
		
		$_html .= '<tr>
			<td><b>' . $msg['a_t_help'] . '</b></td>
			<td class="help">' . $note . '</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_title($title)
	{
		global $msg;
		
		$_html .= '<tr>
			<th colspan="2">' . $title . '</th>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function form_row($title, $html, $desc = '', $extra = '')
	{
		$_html = '<tr class="' . $this->get_row_bg() . '" valign="top">
			<td ' . $extra . '><b>' . $title . '</b><br />' . $desc . '</td>
			<td>' . $html . '</td>
		</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	/* ################################ PAGE ################################ */
	function page_header($extra = '')
	{
	
		$_html = '<?xml version="1.0"?>' . $this->nl;
		$this->doctype = strtolower($this->doctype);
		switch ($this->doctype)
		{
			case 'transitional':
				$_html .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' . $this->nl;
				break;
			case 'frameset':
				$_html .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">' . $this->nl;
				break;
			case 'strict':
				$_html .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' . $this->nl;
			break;
		}
		//$_html .= '<html dir="'. $this->htmldir .'" xml:lang="'. $this->lang .'" lang="'. $this->lang .'">'. $this->nl;
		$_html .= '<html>'. $this->nl .'<head>' . $extra . $this->nl . '<title>' . $this->title . '</title>'. $this->nl .'<meta http-equiv="Content-Type" content="text/html; charset='. $this->charset .'" />' . $this->nl;
		$_html .= !empty($this->css) ? '<link rel="stylesheet" href="' . $this->css . '" type="text/css" />' . $this->nl : '';
		$_html .= !empty($this->jscript) ? '<script src="' . $this->jscript .'" type="text/javascript"></script>' . $this->nl: '';
		$_html .= '</head><body>' . $this->nl;
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function page_footer($extra = '')
	{
		$_html = $extra;
		$_html .= '<br /><br />' . $this->nl . '</body>' . $this->nl . '</html>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	/* ################################ TABLES ################################ */
	function table_border_header($extra = '')
	{
		$_html = '<table width="100%" cellpadding="4" cellspacing="1" border="0" align="center">
		<tr><td>'. $extra;
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function table_border_footer()
	{
		$_html = '</td></tr></table>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function table_header($title, $colspan = 2)
	{
		$_html = '<table width="100%" cellpadding="4" cellspacing="1" border="0" class="tableline">
		<tr><th colspan="' . $colspan . '">' . $title . '</th></tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function table_title($title, $colspan = 2)
	{
		$_html = '<tr><th colspan="' . $colspan . '">' . $title . '</th></tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function table_footer()
	{
		$_html = '</table>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function table_row($value, $colspan = 2)
	{
		$_html .= '<tr>';
		if (is_array($value))
		{
			foreach ($value as $val)
			{
				$_html .= '<td>' . $val . '</td>';
			}
		}
		else
		{
			$colspan = !empty($colspan) ? ' colspan="' . $colspan . '"' : '';
			$_html .= '<td '. $colspan .'>' . $value . '</td>';
		}
		$_html .= '</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	
	function table_td($value)
	{
		$_html .= '<td>' . $value . '</tr>';
		if ($this->source)
		{
			return $_html;
		}
		echo ($this->show) ? $_html : '';
	}
	/* ################################ HELPER funct ################################ */
	function my_htmlspecialchars($str)
	{
		$str = str_replace('"', '&quot;', $str);
		$str = str_replace("'", '&#039;', $str);
		$str = str_replace('<', '&lt;', $str);
		$str = str_replace('>', '&gt;', $str);
		$str = str_replace('&nbsp;', '&amp;nbsp;', $str);
		return $str;
	}
	
	/* ################################ MENU ################################ */
	function menu_title($title, $can_access = 0)
	{
		if (($this->superuser == 1) || ($can_access != ''))
		{
			$_html = '<tr><th class="thHead">' . $title . '</th></tr>';
			if ($this->source)
			{
				return $_html;
			}
			echo ($this->show) ? $_html : '';
		}
	}
	
	function menu_row($url, $title, $can_access = 0)
	{
		if (($this->superuser == 1) || ($can_access == 1))
		{
			$_html = '<tr><td>' . $this->html_ahref($url, $title) . '</td></tr>';
			if ($this->source)
			{
				return $_html;
			}
			echo ($this->show) ? $_html : '';
		}
	}
}
?>