<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('FILEHANDLER_INC',true);
class File_Handler
{
	var $prefix = 'thm_';
	var $width = 90;
	var $height = 90;
	var $resize_type = 1;    /* $resize case :  0 = discart aspect
							 *					1 = aspect ratio
							 *					2 = smart cut (like crop)
							 */
	var $base_dir = './';
	var $is_gd_unchecked = true;
	var $base_format = 'jpeg';
	var $jpeg_image_quality = 60; /* range 0-100% */
	var $safeupload = true;
	var $gd_installed = false;
	
	function File_Handler($base_dir = './', $base_format = 'jpeg', $prefix = 'thm_',$width = 90, $height = 90)
	{
		$this->set_base_dir($base_dir);
		$this->set_var('prefix',$prefix);
		$this->set_var('width',$width);
		$this->set_var('height',$height);
		$this->set_var('base_format',$base_format);
	}
	
	function set_base_dir($value='./')
	{
		if (substr($value, -1)!='/')
		{
			$this->set_var('base_dir', $value . '/');
		}
		else
		{
			$this->set_var('base_dir', $value);
		}
	}
	
	function set_var($varname, $value = '')
	{
		$this->$varname = $value;
	}
	
	/* helper funcstions */
	function get_curr_dir($file)
	{
		$arr = split("[/\\]",$file);
		$n = count($arr)-1;
		$final = str_replace($arr[$n],'',$file);
		return $final;
	}
	
	function get_file_name($file, $only = false)
	{
		$arr = split("[/\\]",$file);
		$n = count($arr)-1;
		$file_name = $arr[$n];
		if ($only)
		{
			$arra = explode('.',$file_name);
			$n = count($arra)-1;
			return str_replace('.'.$arra[$n],'',$file_name);
		}
		else
		{
			return $file_name;
		}
	}
	
	function get_file_extension($file)
	{
		$file = strtolower($file);
		$arr = split('[/\\.]', $file);
		$n = sizeof($arr)-1;
		return $arr[$n];
	}
	
	function get_file_content($source)
	{
		if (file_exists($source) == 0)
		{
			return false;
		}
		else
		{
			$stuff = @fread(@fopen($source, 'rb'), @filesize($source));
			return $stuff;
		}
	}
	
	function check_gd_version()
	{
		ob_start();
		phpinfo(8);
		$phpinfo = ob_get_contents();
		ob_end_clean();
		$phpinfo = strip_tags($phpinfo);
		$phpinfo = stristr($phpinfo,'gd version');
		$phpinfo = stristr($phpinfo,'version');
		$end = strpos($phpinfo,'.');
		$phpinfo = substr($phpinfo,0,$end);
		$length = strlen($phpinfo)-1;
		$phpinfo = substr($phpinfo,$length);
		$this->gd_version = $phpinfo;
		$this->is_gd_unchecked = false;
		$this->gd_installed = !empty($this->gd_version) ? true : false;
	}
	/*
	* Create Thumbnails files: default only can be is JPEG / PNG
	* 'cause COMPUSERVE probelm.... shit
	*/
	function make_thumb($source_file, $dest_subdir = '')
	{
		if ($this->is_gd_unchecked)
		{
			$this->check_gd_version();
		}
		if (!$this->gd_installed)
		{
			$this->stop('The GD Lib unavailble into your server php installation. GD Lib is required to run this action.');
		}
		switch ($this->base_format)
		{
			case 'jpeg':
				$_new_ext = '.jpg';
				break;
			case 'png':
				$_new_ext = '.png';
				break;
			default:
				$_new_ext = '.jpg';
		}
		$_thm_file_name = $this->prefix . $this->get_file_name($source_file,1) . $_new_ext;
		$new_w = ($this->width==0 || empty($this->width))? 90 : $this->width;
		$new_h = ($this->height==0 || empty($this->height))? 90 : $this->height;
		
		$new_dir = $this->base_dir . $this->get_curr_dir($source_file) . $dest_subdir;
		if (!empty($dest_subdir) && !is_dir($new_dir))
		{
			mkdir($new_dir);
			chmod($new_dir,octdec(666));
		}
		$dest = $this->base_dir . $this->get_curr_dir($source_file) . $dest_subdir . $_thm_file_name;
		$source_path = $this->base_dir . $source_file;
		$ext = $this->get_file_extension($source_file);
		switch ($ext)
		{
			case 'jpg':
			case 'jpeg':
				$im = imagecreatefromjpeg($source_path);
				break;
			case 'png':
				$im = imagecreatefrompng($source_path);
				break;
			case 'gif':
				$im = imagecreatefromgif($source_path);
				return false;
		}
		if (!$im) /* See if it failed */
		{
			$this->stop("Unable create thumbnail image from :". $source_path ."\n Possible reasons: Unsupported image formate. Wrong directory path to source image.\n");
			$im  = imagecreate(150, 30); /* Create a blank image */
			$bgc = imagecolorallocate($im, 255, 255, 255);
			$tc  = imagecolorallocate($im, 0, 0, 0);
			imagefilledrectangle($im, 0, 0, 150, 30, $bgc);
			/* Output an errmsg */
			imagestring ($im, 1, 5, 5, "Error loading $source_path", $tc);
	    }
		$cur_w = imagesx($im);
		$cur_h = imagesy($im);
		
		switch ($this->resize_type)
		{
			case 0: // discart aspect ratio
				$source_s_w = 0;
				$source_s_h = 0;
				$source_e_w = $cur_w;
				$source_e_h = $cur_h;
				if ($this->gd_version >=2)
				{
					$ni = @imageCreateTrueColor($new_w,$new_h);
					imagecopyresampled($ni,$im,0,0,$source_s_w,$source_s_h,$new_w,$new_h,$source_e_w,$source_e_h);
				}
				else
				{
					$ni	= imagecreate($new_w,$new_h);
					imagecopyresized($ni,$im,0,0,$source_s_w,$source_s_h,$new_w,$new_h,$source_e_w,$source_e_h);
				}
				break;
			case 1: // aspect ratio
				if ($cur_w > $cur_h)
				{
					$new_w = $new_w;
					$new_h = ($cur_h * $new_w)/$cur_w;
				}
				else
				{
					$new_h = $new_h;
					$new_w = ($cur_w * $new_w)/$cur_h;
				}
				$source_s_w = 0;
				$source_s_h = 0;
				$source_e_w = $cur_w;
				$source_e_h = $cur_h;
				if ($this->gd_version >=2) // function_exists('imagecopyresampled')
				{
					$ni = imageCreateTrueColor($new_w,$new_h); // GD 1.6 ????1
					imagecopyresampled($ni,$im,0,0,$source_s_w,$source_s_h,$new_w,$new_h,$source_e_w,$source_e_h);
				}
				else
				{
					$ni	= imagecreate($new_w,$new_h);
					imagecopyresized($ni,$im,0,0,$source_s_w,$source_s_h,$new_w,$new_h,$source_e_w,$source_e_h);
				}
				break;
			case 2:  // smart cut
				if ($new_w < $new_h)
				{
					$temp_w = ($cur_w * $new_h)/$cur_h;
					$temp_h = $new_h;
				}
				else if ($new_w > $new_h)
				{
					$temp_w = $new_w;
					$temp_h = ($cur_h * $new_w)/$cur_w;
				}
				else
				{
					$temp_w = ($cur_w > $cur_h)? ($cur_h * $new_w)/$new_h : $new_w;
					$temp_h = ($cur_w > $cur_h)? $new_h : ($cur_h * $new_w)/$cur_w;
				}
				$temp_w = round($temp_w);
				$temp_h = round($temp_h);
				//echo "cur_w=$cur_w/cur_h=$cur_h<br>new_w=$new_w/new_h$new_h<br>temp_w=$temp_w/temp_h=$temp_h<hr>";
				if ($this->gd_version >= 2)
				{
					$temp_img = imageCreateTrueColor($temp_w,$temp_h);
					imagecopyresampled($temp_img,$im,0,0,0,0,$temp_w,$temp_h,$cur_w,$cur_h);
				}
				else
				{
					$temp_img = imagecreate($new_w,$new_h);
					imagecopyresized($temp_img,$im,0,0,0,0,$temp_w,$temp_h,$cur_w,$cur_h);
				}
				if ($temp_w > $new_w ) // thumb port
				{
					$hrest = round( ($temp_w - $new_w)/2 );
					$source_s_w = $hrest;
					$source_s_h = 0;
					$source_e_w = $new_w + $hrest;
					$source_e_h = $new_h;
				}
				else
				{
					// land
					$hrest = round( ($temp_h - $new_h)/2 );
					$source_s_w = 0;
					$source_s_h = $hrest;
					$source_e_w = $new_w;
					$source_e_h = $new_h + $hrest;
				}
				if ($this->gd_version >= 2)
				{
					$ni = imageCreateTrueColor($new_w,$new_h);
				}
				else
				{
					$ni	= imagecreate($new_w,$new_h);
				}
				imagecopy($ni, $temp_img, 0, 0, $source_s_w, $source_s_h, $source_e_w, $source_e_h);
				imagedestroy($temp_img);
				break;
		}
		switch($this->base_format)
		{
			case 'jpg':
			case 'jpeg':
				imagejpeg($ni,$dest,$this->jpeg_image_quality);
				break;
			case 'png':
				imagepng($ni,$dest);
				break;
			case 'gif': // only GD < ver. 1.6
				imagegif($ni,$dest);
				break;
			case 'bmp': // only GD ver 1.8 or greater
				imagewbmp($ni,$dest);
				break;
			default:
				imagejpeg($ni, $dest, $this->jpeg_image_quality);
		}
		imagedestroy($ni);
		imagedestroy($im);
		return $this->get_curr_dir($source_file) . $dest_subdir . $_thm_file_name;
	}
	function make_resize_upload($obj, $n_width_height = '')
	{
		if ($this->is_gd_unchecked)
		{
			$this->check_gd_version();
		}
		if (!$this->gd_installed)
		{
			$this->stop('The GD Lib unavailble into your server php installation. GD Lib is required to run this action.');
		}
		$new_w = ($n_width_height==0 || empty($n_width_height)) ? 300 : $n_width_height;
		$new_h = ($n_width_height==0 || empty($n_width_height)) ? 300 : $n_width_height;
		
		$ext = $this->get_file_extension($obj['name']);
		$source = $obj['name'];
		switch ($ext)
		{
			case 'jpg':
			case 'jpeg':
				$im = imagecreatefromjpeg($obj['tmp_name']);
				break;
			case 'png':
				$im = imagecreatefrompng($obj['tmp_name']);
				break;
			case 'gif':
				$im = imagecreatefromgif($obj['tmp_name']);
				return false;
		}
		if (!$im) /* See if it failed */
		{
			$this->stop("Unable create thumbnail image from :". $source ."\n Possible reasons: Unsupported image formate. Wrong directory path to source image.\n");
			$im  = imagecreate(150, 30); /* Create a blank image */
			$bgc = imagecolorallocate($im, 255, 255, 255);
			$tc  = imagecolorallocate($im, 0, 0, 0);
			imagefilledrectangle($im, 0, 0, 150, 30, $bgc);
			/* Output an errmsg */
			imagestring ($im, 1, 5, 5, "Error loading $source", $tc);
	    }
		$cur_w = imagesx($im);
		$cur_h = imagesy($im);
		
		if ($cur_w > $cur_h)
		{
			$new_w = $new_w;
			$new_h = ($cur_h * $new_w)/$cur_w;
		}
		else
		{
			$new_h = $new_h;
			$new_w = ($cur_w * $new_w)/$cur_h;
		}
		$source_s_w = 0;
		$source_s_h = 0;
		$source_e_w = $cur_w;
		$source_e_h = $cur_h;
		if ($this->gd_version >= 2) // function_exists('imagecopyresampled')
		{
			$ni = imageCreateTrueColor($new_w,$new_h); // GD 1.6 ????1
			imagecopyresampled($ni,$im,0,0,$source_s_w,$source_s_h,$new_w,$new_h,$source_e_w,$source_e_h);
		}
		else
		{
			$ni	= imagecreate($new_w,$new_h);
			imagecopyresized($ni,$im,0,0,$source_s_w,$source_s_h,$new_w,$new_h,$source_e_w,$source_e_h);
		}
		imagedestroy($im);
		switch ($this->base_format)
		{
			case 'jpg':
			case 'jpeg':
				imagejpeg($ni, $obj['tmp_name'], $this->jpeg_image_quality);
				break;
			case 'png':
				imagepng($ni, $obj['tmp_name']);
				break;
			case 'gif': // only GD < ver. 1.6
				imagegif($ni, $obj['tmp_name']);
				break;
			case 'bmp': // only GD ver 1.8 or greater
				imagewbmp($ni, $obj['tmp_name']);
				break;
			default:
				imagejpeg($ni, $obj['tmp_name'], $this->jpeg_image_quality);
		}
		$obj['size'] = filesize($obj['tmp_name']);
		imagedestroy($ni);
		return $obj;
	}
	
	function make_upload($source, $dest_name)
	{
		if (file_exists($source))
		{
			if (strstr($source, '..') != '')
			{
				return true;
			}
			$dest = $this->base_dir . $dest_name;
			if ($this->safeupload)
			{
				if (function_exists('is_uploaded_file'))
				{
					if (is_uploaded_file($source))
					{
						if (move_uploaded_file($source, $dest))
						{
							/* exec("chmod 666 $path"); 666 work Win. 644 not */
							chmod($dest, octdec(666));
							return false;
						}
						else
						{
							return true;
						}
					}
					else
					{
						return true;
					}
				}
			}
			else
			{
				if (!copy($source, $dest))
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}
		else
		{
			return true;
		}
	}
	
	function validate_extension($file, $types = array())
	{
		$ext = $this->get_file_extension($file);
		return (in_array($ext, $types)) ? true : false;
	}
	
	function is_invalid_extension($file, $types = array())
	{
		$ext = $this->get_file_extension($file);
		return (in_array($ext, $types)) ? false : true;
	}
	
	function rename_files($path, $old_ext = 'html', $new_ext = 'php')
	{
		$path_array = $this->_get_dir_content($path);
		for ($i=0; $i < count($path_array); $i++)
		{
			$p = ($path > '')? '/' : '';
			$file_path = $path . $p . $path_array[$i];
			if (@is_dir($file_path))
			{
				$this->rename_files($file_path);
			}
			else if (preg_match('/\.'. $old_ext .'$/i', $file_path))
			{
				$fd_new = substr($file_path, 0, strlen($file_path)-strlen($old_ext)) . $new_ext;
			}
			rename($file_path, $fd_new); 
			//echo $file_path .'-> '. $fd_new .'<br />';
		}
	}
	/* private functions */
	function _get_dir_content($url)
	{
		$surl = $url;
		$i = 0;
		if (substr($url,0,1) == '/')
		{
			$surl = substr($url,1);
		}
		$dirhandle = @opendir($surl);
		while ($file = @readdir($dirhandle))
		{
			if ($file != '.' && $file != '..')
			{
				$out[$i] = $file;
				++$i;
			}
		}
		@closedir($dirhandle);
		return $out;
	}
	
	function stop($text)
	{
		echo "</td></tr></table>\n<p>\n<pre>\n". $text ." \n";
		exit;
	}
}

?>