<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('BBCODE_INC',true);
class BBCODE_site
{
	var $smilies_set = array();
	var $smilies_baseurl = '';
	var $auto_link_convert = false;
	var $auto_smilie_convert = true;
	function BBCODE_site()
	{
	}
	
	function set_smiles($arr)
	{
		if (is_array($arr))
		{
			$this->smilies_set = $arr;
			return true;
		}
		return false;
	}
	
	function set_var($name, $value = '')
	{
		$this->$name = $value;
	}
	
	function parse($str='')
	{
		$unhtml_specialchars_match = array('#&gt;#', '#&lt;#', '#&quot;#', '#&amp;#');
		$unhtml_specialchars_replace = array('>', '<', '"', '&');
		$str = preg_replace($unhtml_specialchars_match, $unhtml_specialchars_replace, $str);
		$html_entities_match = array('#&(?!(\#[0-9]+;))#', '#<#', '#>#');
		$html_entities_replace = array('&amp;', '&lt;', '&gt;');
		$str = preg_replace($html_entities_match, $html_entities_replace, trim(addslashes($str)));
		$str = ' ' . $str;
		$str = preg_replace("#\[color=(\#[0-9A-F]{6}|[a-z\-]+)\](.*?)\[/color\]#si", "[color=\\1]\\2[/color]", $str); // text color
		$str = preg_replace("#\[size=([1-2]?[0-9])\](.*?)\[/size\]#si", "[size=\\1]\\2[/size]", $str); // text size
		$str = preg_replace("#\[b\](.*?)\[/b\]#si", "[b]\\1[/b]", $str); // bold
		$str = preg_replace("#\[u\](.*?)\[/u\]#si", "[u]\\1[/u]", $str); // underline
		$str = preg_replace("#\[i\](.*?)\[/i\]#si", "[i]\\1[/i]", $str); // italic
		//$str = preg_replace("#\[img\]((ht|f)tp://)([^\r\n\t<\"]*?)\[/img\]#sie", "'[img]\\1' . str_replace(' ', '%20', '\\3') . '[/img]'", $str); // img
		$str = substr($str, 1);
		$str = ' '. stripslashes($str);
		if (!( strpos($str, '[') && strpos($str, ']')))
		{
			$str = substr($str, 1);
		}
		else
		{
			$bb_codes = array();
			$bb_codes[] = array(
				'has_param' => false,
				'code_start' => '[b]',
				'code_end' => '[/b]',
				'html_start' => '<b>',
				'html_end' => '</b>'
			);
			$bb_codes[] = array(
				'has_param' => false,
				'code_start' => '[i]',
				'code_end' => '[/i]',
				'html_start' => '<i>',
				'html_end' => '</i>'
			);
			$bb_codes[] = array(
				'has_param' => false,
				'code_start' => '[u]',
				'code_end' => '[/u]',
				'html_start' => '<u>',
				'html_end' => '</u>'
			);
			$bb_codes[] = array(
				'has_param' => false,
				'code_start' => '[quote]',
				'code_end' => '[/quote]',
				'html_start' => '<blockquote>',
				'html_end' => '</blockquote>'
			);
			$bb_codes[] = array(
				'has_param' => false,
				'code_start' => '[center]',
				'code_end' => '[/center]',
				'html_start' => '<center>',
				'html_end' => '</center>'
			);
			$bb_codes[] = array(
				'has_param' => false,
				'code_start' => '[pre]',
				'code_end' => '[/pre]',
				'html_start' => '<pre style="font-family: \'Courier New\', Courier, monospace; font-size: 9pt; font-style: normal; text-decoration: none;">',
				'html_end' => '</pre>'
			);
			
			$bb_codes[] = array(
				'has_param' => true,
				'code_end' => '[/color]',
				'html_end' => '</span>',
				'regex_match' => '/\[color=(\#[0-9A-F]{6}|[a-z]+)\]/si',
				'regex_replace' => '<span style="color: \\1">'
			);
			$bb_codes[] = array(
				'has_param' => true,
				'code_end' => '[/size]',
				'html_end' => '</span>',
				'regex_match' => '/\[size=([1-2]?[0-9])\]/si',
				'regex_replace' => '<span style="font-size: \\1px; line-height: normal">'
			);
			$bb_codes[] = array(
				'has_param' => true,
				'code_end' => '[/url]',
				'html_end' => '</a>',
				'regex_match' => '#\[url\]([\w]+?://.*?[^ \"\n\r\t<]*?)\[/url\]#is',
				'regex_replace' => '<a href="\\1" target="_blank">\\1</a>'
			);
			$bb_codes[] = array(
				'has_param' => true,
				'code_end' => '[/email]',
				'html_end' => '</a>',
				'regex_match' => '#\[email\]([a-z0-9&\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si',
				'regex_replace' => '<a href="mailto:\\1" target="_blank">\\1</a>'
			);
			/*
			$bb_codes[] = array(
				'has_param' => true,
				'code_end' => '[/img]',
				'html_end' => ' ',
				'regex_match' => '#\[img\](.*?)\[/img\]#si',
				'regex_replace' => '<img src="\\1" border="0" />'
			);
			*/
			$j = sizeof($bb_codes);
			for ($i=0; $i<$j; $i++)
			{
				if ($bb_codes[$i]['has_param'])
				{
					$str = preg_replace($bb_codes[$i]['regex_match'], $bb_codes[$i]['regex_replace'], $str);
					$str = str_replace($bb_codes[$i]['code_end'], $bb_codes[$i]['html_end'], $str);
				}
				else
				{
					$str = str_replace($bb_codes[$i]['code_start'], $bb_codes[$i]['html_start'], $str);
					$str = str_replace($bb_codes[$i]['code_end'], $bb_codes[$i]['html_end'], $str);
				}
			}
			$str = substr($str, 1);
		}
		$str = nl2br($str);
		if ($this->auto_link_convert)
		{
			$str = $this->convert_links($str);
		}
		if ($this->auto_smilie_convert)
		{
			$str = $this->smilie_it($str);
		}
		$str = stripslashes($str);
		return $str;
	}
	
	function convert_links($str)
	{
		$str = ' '.$str;
		$str = preg_replace("#(^|[\n ])([\w]+?://.*?[^ \"\n\r\t<]*)#is", "\\1<a href=\"\\2\" target=\"_blank\">\\2</a>", $str);
		$str = preg_replace("#(^|[\n ])((www|ftp)\.[\w\-]+\.[\w\-.\~]+(?:/[^ \"\t\n\r<]*)?)#is", "\\1<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $str);
		$str = preg_replace("#(^|[\n ])((http|https|ftp|irc|ed2k|gopher|telnet)\.[\w\-]+\.[\w\-.\~]+(?:/[^ \"\t\n\r<]*)?)#is", "\\1<a href=\"\\2://\\2\" target=\"_blank\">\\2</a>", $str);
		$str = preg_replace("#(^|[\n ])([a-z0-9&\-_.]+?)@([\w\-]+\.([\w\-\.]+\.)*[\w]+)#i", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>", $str);
		$str = substr($str, 1);
		return $str;
	}
	
	function smilie_it($str)
	{
		static $pattern, $replacement;
		
		if (!isset($pattern))
		{
			$pattern = array();
			$replacement = array();
			$k = sizeof($this->smilies_set);
			if( $k>0 )
			{
				//usort($this->smilies_set, '_smilie_cmp');
				usort($this->smilies_set, array('BBCODE_site', '_smilie_cmp'));
				for($i=0; $i<$k; $i++)
				{
					$pattern[] = "/(?<=.\W|\W.|^\W)" . preg_quote($this->smilies_set[$i]['code'], '/') . "(?=.\W|\W.|\W$)/";
					$replacement[] = '<img src="'. $this->smilies_baseurl . $this->smilies_set[$i]['url'] . '" alt="' . $this->smilies_set[$i]['label'] . '" border="0" />';
				}
			}
		}
		if (sizeof($pattern) > 0)
		{
			$str = preg_replace($pattern, $replacement, ' '.$str.' ');
			$str = substr($str, 1, -1);
		}
		return $str;
	}
	// #################### private functions ############################## //
	function _smilie_cmp($a, $b)
	{
		if (strlen($a['code']) == strlen($b['code']))
		{
			return 0;
		}
		if(strlen($a['code']) > strlen($b['code']))
		{
			return -1;
		}
		else
		{
			return 1;
		}
	}
}
?>