<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
function get_percent($string)
{
	list($first, $second) = split('[/.-]', $string);
	$second = substr($second, 0, 2);
	$valor = $first;
	if (!empty($second))
	{
		$valor .= '.' . $second;
	}
	return $valor;
}

function check_lvl_access($required_lvl)
{
	global $curr_cp_user, $msg;
	
	if ($curr_cp_user['superuser'] != 1)
	{
		if ($required_lvl != 1)
		{
			message_die(CRITICAL_ERROR,$msg['a_error_acclevel_or_expired']);
		}
	}
	return true;
}
function dohtml_ticon($ratval = 0, $form = 1)
{
	global $ip;
	
	$addr = $ip;
	if ($ratval == 1)
	{
		$retval = "<form action='". $phpscript ."' ".( ($uploadform)? "ENCTYPE='multipart/form-data' " :'' )." method='post'>\n
		<input type='hidden' name='s' value='". $userinfo['sessionhash'] ."' />
		<input type='hidden' name='action' value='". $action ."' />\n";
	}
	if (isset($form) || !isset($form))
	{
		if ($addr!='127.0.0.1')
		{
			echo "<!--WTN-WDYL-->";
		}
	}
}
function append_sid($url, $non_html_amp = false)
{
	global $s;
	
	if (!empty($s) && !eregi('s=', $url))
	{
		$url .= ( (strpos($url, '?') != false) ? (($non_html_amp) ? '&' : '&amp;') : '?' ) . 's='.$s;
	}
	return($url);
}

function make_form_select_cat($name = 'cat_id', $selected = 0, $multiple = false, $addnone = false)
{
	$_html = '<select name="'.$name.'"'.(($multiple)? 'size="6" multiple':'').'>';
	$_html .= ($addnone)? '<option value="0" '. (($selected == 0) ? 'selected="selected"':'') .'>'.$msg['a_none'].'</option>' : '';
	$_html .= make_form_select_cat_options(0, $selected);
	$_html .='</select>';
	return $_html;
}
function make_form_select_cat_options($cat_parent = 0, $selected = 0, $_menu_level = 0)
{
	global $cat_tree_arr, $sys_tmp_vars;
	
	$space = str_repeat('&nbsp;', $_menu_level*3);
	$_menu_level++;
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_subid'] == $cat_parent)
		{
			$_html .= '<option value="' . $cat_tree_arr[$i]['cat_id'] . '" ' . (($cat_tree_arr[$i]['cat_id'] == $selected) ? ' selected="selected"' : '');
			$_html .= '>' . $space . $cat_tree_arr[$i]['cat_name'] . "</option>\n";
			$_html .= make_form_select_cat_options($cat_tree_arr[$i]['cat_id'], $selected, $_menu_level);
		}
	}
	$_menu_level--;
	return $_html;
}

function make_user_form_select_cat($name = 'cat_id', $selected = 0, $multiple = false, $addnone = false)
{
	$_html = '<select name="' . $name . '"' . (($multiple) ? 'size="6" multiple' : '') . '>';
	$_html .= ($addnone) ? '<option value="0" '. (($selected == 0) ?  'selected="selected"' : '') . '>' . $msg['a_none'] . '</option>' : '';
	$_html .= make_user_form_select_cat_options(0,$selected);
	$_html .= '</select>';
	return $_html;
}

function make_user_form_select_cat_options($cat_parent = 0, $selected = 0, $_menu_level = 0)
{
	global $cat_tree_arr, $sys_tmp_vars, $curr_cp_user;
	
	$space = str_repeat('&nbsp;', $_menu_level*3);
	$_menu_level++;
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if (($curr_cp_user['superuser'] == 1) || ($curr_cp_user['canworkcategory'] == 0))
		{
			if ($cat_tree_arr[$i]['cat_subid'] == $cat_parent)
			{
				$_html .= '<option value="' . $cat_tree_arr[$i]['cat_id'] . '" ' . (($cat_tree_arr[$i]['cat_id'] == $selected) ? ' selected="selected"' : '');
				$_html .= '>'. $space . $cat_tree_arr[$i]['cat_name'] . "</option>\n";
				$_html .= make_user_form_select_cat_options($cat_tree_arr[$i]['cat_id'], $selected, $_menu_level);
			}
		}
		else
		{
			if ($cat_tree_arr[$i]['cat_id'] == $curr_cp_user['canworkcategory'])
			{
				$_html = '<option value="' . $cat_tree_arr[$i]['cat_id'] . '" ' . (($cat_tree_arr[$i]['cat_id'] == $selected) ? ' selected="selected"' : '');
				$_html .= '>' . $space . $cat_tree_arr[$i]['cat_name'] ."</option>\n";
				return $_html;
			}
		}
	}
	$_menu_level--;
	return $_html;
}

function make_cat_options_array($cat_parent = 0, $remove = '', $_menu_level = 0)
{
	global $cat_tree_arr, $sys_tmp_vars, $cat_options_array;
	
	$space = str_repeat('-', $_menu_level*3);
	$_menu_level++;
	for ($i = 0; $i < $sys_tmp_vars['k']; $i++)
	{
		if (($cat_tree_arr[$i]['cat_subid'] == $cat_parent) && ($cat_tree_arr[$i]['cat_id'] != $remove))
		{
			$cat_options_array[$cat_tree_arr[$i]['cat_id']] = $space . $cat_tree_arr[$i]['cat_name'];
			make_cat_options_array($cat_tree_arr[$i]['cat_id'], $remove, $_menu_level);
		}
	}
	$_menu_level--;
	return $cat_options_array;
}

function make_basic_cat_tree()
{
	global $DB_site, $cat_tree_arr, $sys_tmp_vars;
	
	$sql = " SELECT * FROM ". TBL_CARDS_CAT ." ORDER BY cat_order ";
	$data_arr = $DB_site->query($sql);
	$cat_tree_arr = array();
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$cat_tree_arr[] = array(
				'cat_id' => $row['cat_id'],
				'cat_subid' => $row['cat_subid'],
				'cat_name' => stripslashes($row['cat_name']),
				'cat_order' => $row['cat_order'],
				'cat_active' => $row['cat_active']
				);
	}
	$DB_site->free_result($data_arr);
	$sys_tmp_vars['k'] = sizeof($cat_tree_arr);
	return $cat_tree_arr;
}

function link_maker($url = '', $data = array(), $non_html_amp = false)
{
	//$data = array(array());
	$sep = ( $non_html_amp ) ? '&' : '&amp;';
	$url = (strpos($url, '?') != false ) ? $url . $sep : $url . '?';
	if (is_array($data))
	{
		foreach ($data as $key => $val)
		{
			if (!is_array($val))
			{
				$url .= $key . '=' . urlencode($val) . $sep;
			}
			else
			{
				foreach ($val as $k => $v)
				{
					$url .= $key . '[]=' . urlencode($v) . $sep;
				}
			}
		}
	}
	$url = ($non_html_amp) ? substr($url, 0, -1) : substr($url, 0, -5);
	return $url;
}

function make_dirs_form_options($base_dir='')
{
	global $cfg;
	static $level;
	
	$ignore_dirs = array();
	$max_sub_levels = 4;
	$level++;
	if ($level == 1)
	{
		$_html .= '<option value="'. $base_dir . '">'. $base_dir .'</option>';
	}
	if ($level > $max_sub_levels)
	{
		return false;
	}
	$base_dir = ((substr($base_dir, -1) == '/') || ($base_dir == '')) ? $base_dir : $base_dir . '/';
	$handle = @opendir($base_dir);
	while ($name = @readdir($handle))
	{
		$file_path = $base_dir . $name; 
		if (($name !='.') && ($name != '..'))
		{
			if ((@filetype($file_path) == 'dir') && !in_array($name, $ignore_dirs))
			{
				$_html .= '<option value="'. $file_path . '/">' . $file_path . '/</option>';
				$_html .= make_dirs_form_options($file_path);
			}
		}
	}
	$level--;
	@closedir($handle);
	return $_html;
}

function get_url2filepath($file = '', $up_to_dir)
{
	global $cfg;
	
	$file_path = $up_to_dir . $file;
	if (strpos($up_to_dir, $cfg['site_music_path']) === false)
	{
	   // not found == image
	   $subdir = str_replace($cfg['site_image_path'], '', $file_path);
	}
	else
	{
		// found == music
	   $subdir = str_replace($cfg['site_music_path'], '', $file_path);
	}
	return $subdir;
}
?>