<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('IN_VCARD', true);
define('CURR_PAGE','download.php');
$switch = 'print';
$chaceitemused = '';
$templatesused = 'page_print_card,';
include('./lib.inc.php');
include('./include/class/zip.inc.php');

function l_get_unique_files($matches, $unique_files, $allowed_exts = array())
{
	global $cfg;
	
	foreach ($matches as $file)
	{
		if (!is_invalid_file_extension($file, $allowed_exts))
		{
			$file = str_replace($cfg['site_prog_url'], '', $file);
			if (!in_array ($file, $unique_files)  && ($file != ''))
			{
				$unique_files[] = $file;
			}
		}
	}
}

function l_get_unique_dirs($matches, $unique_dirs)
{
	global $cfg;
	
	foreach ($matches as $key => $val)
	{
		$path_arr = split('/', $val);
		$t = sizeof($path_arr);
		$pos = $t - 1;
		$dir = '';
		for($i=0; $i < $pos; $i++)
		{
			$dir .= $path_arr[$i].'/';
		}
		if (!in_array ($dir, $unique_dirs) && $dir!='')
		{
			$unique_dirs[] = $dir;
		}
	}
}
$user['priv_canecarddownload'] = 0;
$user['priv_canvideodownload'] = 0;

if (empty($user['priv_canecarddownload']))
{
	usr_deniedpage_die();
}

$message_id = empty($id)? trim(my_htmlspecialchars(addslashes($message_id))) : trim(my_htmlspecialchars(addslashes($id)));
$sql = "SELECT * FROM ". TBL_USR_ECARD ." WHERE message_id='". $message_id ."' ";
$data_arr = $DB_site->query($sql);
$num_rows = $DB_site->num_rows($data_arr);
if ($num_rows == 0)
{
	usr_message_die(GENERAL_ERROR,$msg['error_notfound_user_ecard']);
}

$usercard_data = $DB_site->fetch_array($data_arr);
//extract($usercard_data);
if (!empty($usercard_data['card_id']))
{
	$sql = "SELECT * FROM ". TBL_CARDS_DATA ." WHERE card_id='". addslashes($usercard_data['card_id']) ."' ";
	$card_info = $DB_site->query_first($sql);
}
$card_info['card_file'] = empty($card_info['card_imgfile']) ? $usercard_data['card_file'] : $card_info['card_imgfile'];
$card_info['card_template'] = empty($card_info['card_template']) ? $usercard_data['card_template'] : $card_info['card_template'];
$usercard_data['card_stamp'] = ($user['priv_canstamp'] == 1) ? $usercard_data['card_stamp'] : $cfg['user_stamp_default'];

if ($type == 'f')
{
	$allowed_exts = array(
		'ram', 'ra', 'rm', 'rpm'
		,'asf', 'asx', 'wmv', 'wma'
		,'mov', 'qt'
		//,'jpeg', 'jpg', 'gif', 'png', 'bmp', 'swf'
	);
	if (is_invalid_file_extension($card_info['card_file'], $allowed_exts))
	{
		usr_message_die(GENERAL_ERROR, 'Hacking! No Donut for you!');
		exit;
	}
	if (file_exists($cfg['site_image_path'] . $card_info['card_file']))
	{
		//file_exists($cfg['site_music_path'] . $file) || 
		$zipfile = new zipfile();
		$data = fread(fopen($cfg['site_image_path'] . $card_info['card_file'], 'r'), filesize($cfg['site_image_path'] . $card_info['card_file']));
		$zipfile->add_file($data, 'video.'. get_file_extension($card_info['card_file']));
		
		$zip_stuff = $zipfile->file();
		
		header("Content-Length: ". strlen($zip_stuff));
		header('Content-Description: File Transfer');
		header('Content-Type: application/force-download');
		header("Content-Disposition: attachment; filename=video.zip");
		echo $zip_stuff;
		unset($zip_stuff);
	}
	else
	{
		usr_message_die(GENERAL_ERROR,$msg['error_unable_complete_request']);
	}
}

if ($type == 'e')
{
	$sql = "SELECT * FROM ". TBL_SMILIES ."";
	$data_arr = $DB_site->query($sql);
	while($row = $DB_site->fetch_array($data_arr))
	{
		$smilies_arr[] = array(
			'code' => stripslashes($row['code']),
			'url' => get_video_url($row['url']),
			'label' => stripslashes($row['label'])
		);
	}
	$BBCODE_site->set_smiles($smilies_arr);
	
	if (!empty($usercard_data['card_poem']))
	{
		$sql = "SELECT * FROM ". TBL_POEMS ." WHERE poem_id='". $usercard_data['card_poem'] ."' ";
		$poem_info = $DB_site->query_first($sql);
		if ($poem_info['poem_style'] == 1)
		{
			$poem_info['poem_title'] = stripslashes($poem_info['poem_title']);
			$poem_info['poem_text'] = stripslashes($poem_info['poem_text']);
		}
		else
		{
			$poem_info['poem_title'] = stripslashes(my_htmlspecialchars($poem_info['poem_title']));
			$poem_info['poem_text'] = stripslashes(my_htmlspecialchars($poem_info['poem_text']));
			$poem_info['poem_text'] = preg_replace("/(\015\012)|(\015)|(\012)/", '<br />', $poem_info['poem_text']); // new approach
		}
	}
	if (!empty($usercard_data['card_effect']))
	{
		$sql = "SELECT * FROM ". TBL_EFFECTS ." WHERE effect_id='". $usercard_data['card_effect'] ."' ";
		$effect_info = $DB_site->query_first($sql);
	}
	if (!empty($usercard_data['card_sound']))
	{
		$sql = "SELECT * FROM ". TBL_SOUNDS ." WHERE sound_file='". $usercard_data['card_sound'] ."' ";
		$sound_info_arr = $DB_site->query_first($sql);
		$sound_id = stripslashes($sound_info_arr['sound_id']);
		$sound_genre = stripslashes($sound_info_arr['sound_genre']);
		$sound_name = stripslashes($sound_info_arr['sound_name']);
		$sound_author = stripslashes($sound_info_arr['sound_author']);
		$sound_info_arr['sound_info'] = $msg['music'] . ' : ' . $sound_name . ' - ' . $sound_author;
	}
	
	if (!empty($card_info['card_template']))
	{
		$t = new Template(VCARD_ROOT_PATH.'templates');
		$t->set_file(array('clayout' => $card_info['card_template'] . '.ihtml'));
		$t->set_var(array(
			'SITE_NAME' => $cfg['site_name'],
			'SITE_URL' => $cfg['site_url'],
			'SITE_FONTFACE' => $cfg['site_font_face'],
			'SENDER_NAME' => stripslashes($usercard_data['sender_name']),
			'SENDER_EMAIL' => $usercard_data['sender_email'],
			'RECIP_NAME' => stripslashes($usercard_data['recip_name']),
			'RECIP_EMAIL' => $usercard_data['recip_email'],
			'POST_IMAGE' => get_html_image($card_info['card_file'], $card_info['card_width'], $card_info['card_height']),
			'POST_FILE' => $card_info['card_file'],
			'POST_WIDTH' => $card_info['card_width'],
			'POST_HEIGHT' => $card_info['card_height'],
			'POST_CAPTION' => stripslashes($card_info['card_caption']),
			'POST_MESSAGE' => $BBCODE_site->parse(stripslashes($usercard_data['card_message'])),
			'POST_SIGNATURE' => $BBCODE_site->parse(stripslashes($usercard_data['card_sig'])),
			'POST_HEADING' => $BBCODE_site->parse(stripslashes($usercard_data['card_heading'])),
			'POST_SOUND' => get_html_music($sound_info_arr['card_sound']),
			'POST_SOUNDCAPTION' => $sound_info_arr['sound_caption'],
			'POST_STAMP' => get_html_stamp($usercard_data['card_stamp']),
			'POST_COLOR' => $usercard_data['card_color'],
			'POST_FONTFACE' => $usercard_data['card_fontface'],
			'POST_FONTSIZE' => $usercard_data['card_fontsize'],
			'POST_FONTCOLOR' => $usercard_data['card_fontcolor'],
			'POST_POEMTITLE' => $poem_info['poem_title'],
			'POST_POEMBODY' => $poem_info['poem_text'],
			'POST_EFFECT' => stripslashes($effect_info['effect_text']),
			'MSG_SENTTO' => $msg['button_send_postcard_to'],
			'MSG_CLICKHERE' => $msg['button_click_here']
		));
		$t->parse('output','clayout');
		
		$outputcard = $t->getcard("output");
	}
	
	$link_printable_card = '<a href="' . PRINT_PAGE . '?id=' . $message_id . '"><img src="img/icon_print.gif" alt="" /><br /><font face="' . $cfg['site_font_face'] . '">' . $msg['view_version_printable'] . '</b></font></a>';
	$music_info = $sound_info_arr['sound_info'];
	$musicinfo = $music_info;
	$end_user_ecard = $outputcard;
	$htmlbody = html_body($usercard_data['card_background']);
	
	$output_form = '';
	$button = '';
	include(VCARD_ROOT_PATH.'include/user_header.inc.php');
	
	if ((strpos($card_info['card_file'], '.html') !== false)  && (get_file_extension($card_info['card_file']) == 'html'))
	{
		$t2 = new Template($cfg['site_image_path']);
		$t2->set_file(array('body' =>  str_replace('.html', '', $card_info['card_file']) . '.html'));
		$t2->set_var(array(
			'SITE_NAME' => $cfg['site_name'],
			'SITE_URL' => $cfg['site_url'],
			'SENDER_NAME' => stripslashes($usercard_data['sender_name']),
			'SENDER_EMAIL' => $usercard_data['sender_email'],
			'SITE_FONTFACE' => $cfg['site_font_face'],
			'RECIP_NAME' => stripslashes($usercard_data['recip_name']),
			'RECIP_EMAIL' => $usercard_data['recip_email'],
			'POST_IMAGE' => get_html_image($card_info['card_file'], $card_info['card_width'], $card_info['card_height']),
			'POST_FILE' => $card_info['card_file'],
			'POST_WIDTH' => $card_info['card_width'],
			'POST_HEIGHT' => $card_info['card_height'],
			'POST_CAPTION' => stripslashes($card_info['card_caption']),
			'POST_MESSAGE' => $BBCODE_site->parse(stripslashes($usercard_data['card_message'])),
			'POST_SIGNATURE' => $BBCODE_site->parse(stripslashes($usercard_data['card_sig'])),
			'POST_HEADING' => $BBCODE_site->parse(stripslashes($usercard_data['card_heading'])),
			'POST_SOUND' => get_html_music($sound_info_arr['card_sound']),
			'POST_SOUNDCAPTION' => $sound_info_arr['sound_caption'],
			'POST_STAMP' => get_html_stamp($usercard_data['card_stamp']),
			'POST_COLOR' => $usercard_data['card_color'],
			'POST_FONTFACE' => $usercard_data['card_fontface'],
			'POST_FONTSIZE' => $usercard_data['card_fontsize'],
			'POST_FONTCOLOR' => $usercard_data['card_fontcolor'],
			'POST_POEMTITLE' => $poem_info['poem_title'],
			'POST_POEMBODY' => $poem_info['poem_text'],
			'POST_EFFECT' => stripslashes($effect_info['effect_text']),
			'MSG_SENTTO' => $msg['button_send_postcard_to'],
			'MSG_CLICKHERE' => $msg['button_click_here'],
			'SOUND_INFO' => $sound_info_arr['sound_info'],
			'HEADER' => $page_header,
			'FOOTER' => $footer,
			'HEADINCLUDE' => $page_header_include,
			'CARDFORM' => $output_form,
			'BUTTON' => $button,
			'LINK_PRINTABLE_CARD' => $link_printable_card
		));
		$card_info = $t2->parse('output','body');
		//$t2->p('output');
	}
	else
	{
		eval("\$card_info = get_replaced_vars(\"".get_template('page_print_card')."\");");
	}
	
	preg_match_all("/<img.*?\s+src=\"(.*?)\"/", $card_info, $img_matches);
	preg_match_all("/<link.*\s+href=(\"|')(.*?)(\"|')/", $card_info, $css_matches);
	
	$unique_css = array();
	$unique_images = array();
	$unique_dirs = array();
	
	l_get_unique_files($css_matches[2], &$unique_css, array('css'));
	l_get_unique_dirs($unique_css, &$unique_dirs);
	l_get_unique_files($img_matches[1], &$unique_images, array('jpeg', 'jpg', 'gif', 'png', 'bmp'));
	// allow download video?
	// l_get_unique_files(array($card_info['card_file']), &$unique_images, array('ram', 'ra', 'rm', 'rpm', 'asf', 'asx', 'wmv', 'wma', 'mov', 'qt'));
	l_get_unique_dirs($unique_images, &$unique_dirs);
	
	// ZIP FILE
	$zipfile = new zipfile();
	foreach($unique_dirs as $k => $dir)
	{
		$zipfile->add_dir($dir);
	}
	foreach($unique_images as $k => $file)
	{
		if (file_exists($file))
		{
			$data = fread(fopen($file, 'r'), filesize($file));
			$zipfile->add_file($data, $file);
		}
	}
	foreach($unique_css as $k => $file)
	{
		if (file_exists($file))
		{
			$data = fread(fopen($file, 'r'), filesize($file));
			$zipfile->add_file($data, $file);
		}
	}
	
	$card_info = str_replace($cfg['site_prog_url'],'',$card_info);
	$zipfile->add_file($card_info, 'ecard.html');
	
	$zip_stuff = $zipfile->file();
	
	header("Content-Length: ". strlen($zip_stuff));
	header('Content-Description: File Transfer');
	header('Content-Type: application/force-download');
	header("Content-Disposition: attachment; filename=ecard.zip");
	echo $zip_stuff;
	unset($zip_stuff);
}

if (isset($DB_site))
{
	$DB_site->close();
}
if (USE_GZIP)
{
	ob_end_flush(); 
}
exit;
?>