<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('IN_VCARD', true);
define('CURR_FILE','style.php');
include('./lib.inc.php');

function fix_delimiter($text) {
	
	return str_replace('|||','|| |',$text);
}

check_lvl_access($canviewstyle);

// ############################# DB ACTION #############################
if ($action == 'download')
{

	if (function_exists('set_time_limit')==1 && get_cfg_var('safe_mode')==0)
	{
		@set_time_limit(1200);
	}
	$style['title'] = ' ';
	$sql = "SELECT * FROM ". TBL_REPLACE ." ";
	$replacements = $DB_site->query($sql);
	$sql = "SELECT * FROM ". TBL_TEMPLATES_DATA ." WHERE title<>'' ";
	$templates = $DB_site->query($sql);
	
	$plaintext_template = fix_delimiter(VCARD_PRO_TEMPLATE_VERSION).'|||';
	$plaintext_template .= fix_delimiter($style['title']) .'|||';
	$plaintext_template .= $DB_site->num_rows($replacements) .'|||'. $DB_site->num_rows($templates) .'|||';
	
	while ($row = $DB_site->fetch_array($replacements))
	{
		$plaintext_template .= fix_delimiter($row['findword']) .'|||'. fix_delimiter($row['replaceword']) .'|||';
	}
	$DB_site->free_result($replacements);
	
	while ($row = $DB_site->fetch_array($templates))
	{
		$row['template'] = stripslashes($row['template']);
		$plaintext_template .= fix_delimiter($row['title']) .'|||'. fix_delimiter($row['parent']) .'|||'. fix_delimiter($row['template']) .'|||';
	}
	$DB_site->free_result($templates);

	header("Content-disposition: filename=vcard.style");
	header("Content-Length: ".strlen($plaintext_template));
	header("Content-type: unknown/unknown");
	header("Pragma: no-cache");
	header("Expires: 0");
	echo $plaintext_template;
	exit;
}

include(VCARD_ROOT_PATH.'include/admin_header.inc.php');
// ###################### Import Style #######################
if ($action == 'import')
{
	if (function_exists('set_time_limit')==1 && get_cfg_var('safe_mode')==0)
	{
		@set_time_limit(1200);
	}
	switch($import_options)
	{
		case 0:
			$target_table_template = TBL_TEMPLATES_ORIG;
			break;
		case 1:
			$target_table_template = TBL_TEMPLATES_DATA;
			break;
	}
	$styletext = $FILE_site->get_file_content($stylefile);
	if (trim($styletext)=='')
	{
		message_die(GENERAL_ERROR,$msg['a_error_invalid_style_file']);
	}
	$stylebits = explode('|||',$styletext);
	list($devnul,$styleversion) = each($stylebits);
	if ($styleversion != VCARD_PRO_TEMPLATE_VERSION && $ignorestyle == 0)
	{
		$localmessage = "
		<p>". $msg['a_error_style_version'] ."</p>
		<p>". $msg['a_style_your_version'] .": ". VCARD_PRO_TEMPLATE_VERSION ."<br />
		". $msg['a_style_file_version']. ": $styleversion</p>";
		message_die(CRITICAL_ERROR,$localmessage);
	}
	if($import_options==1)
	{
		$sql = "DELETE FROM ". TBL_REPLACE ." ";
		$DB_site->query($sql);
	}
	$sql = "DELETE FROM ". $target_table_template ." ";
	$DB_site->query($sql);
	
	list($devnul,$style['title']) = each($stylebits);
	list($devnull,$numreplacements) = each($stylebits);
	list($devnull,$numtemplates) = each($stylebits);
	$counter = 0;
	while ($counter++<$numreplacements)
	{
		list($devnull,$findword) = each($stylebits);
		list($devnull,$replaceword) = each($stylebits);
		if (trim($findword) != '')
		{
			if($import_options==1)
			{
				$sql = "INSERT INTO ". TBL_REPLACE ." (replace_id,findword,replaceword) VALUES (NULL,'".addslashes($findword)."','".addslashes($replaceword)."') ";
				$DB_site->query($sql);
			}
		}
	}

	$counter = 0;
	while ($counter++<$numtemplates)
	{
		list($devnull,$title) = each($stylebits);
		list($devnull,$parent) = each($stylebits);
		list($devnull,$template) = each($stylebits);
		if (trim($title) != '')
		{
			$sql = "INSERT INTO ". $target_table_template ." (title,parent,template) VALUES ('".addslashes($title)."','".addslashes($parent)."','".addslashes($template)."') ";
			$DB_site->query($sql);
		}
	}
	$local_message = $msg['a_import'];
	message_die(GENERAL_MESSAGE,"<p>$style[title] ". $msg['a_imported'] ."!</p> <p>". $msg['a_note_style_01'] ."</p>");
}

if (empty($action))
{
	$HTML_site->form_header(CURR_FILE,'download');
	$HTML_site->table_header($msg['a_download']);
	$HTML_site->form_note($msg['a_style_download']);
	$HTML_site->form_footer($msg['a_download']);

	$HTML_site->form_header(CURR_FILE,'import');
	$HTML_site->table_header($msg['a_import']);
	$HTML_site->form_input($msg['a_file'],'stylefile','vcard.style');
	if (empty($msg['a_style_import_to_original']))
	{
		$options = array(
			0 => 'only to original templates set',
			1 => 'end-user template set'
		);
	}
	else
	{
		$options = array(
			0 => $msg['a_style_import_to_original'],
			1 => $msg['a_style_import_to_all']
		);
	}
	$HTML_site->form_select('','import_options',$options);
	$HTML_site->form_yesno($msg['a_note_style_02'],'ignorestyle',0);
	$HTML_site->form_footer($msg['a_import']);
}

include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
?>