<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.1 Build 4                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2005 Belchior Foundry                   //
//***************************************************************************//
define('IN_VCARD', true);
define('CURR_FILE','stats.php');
include('./lib.inc.php');

function show_pie_graph($title='',$data='') {
	if (@function_exists('imageline') && !empty($data)){
		echo "<div><p><br /></p><p class='center'><img src='statschart.php?title=". urlencode($title) ."&amp;type=pie&data=". urlencode(serialize($data)) ."' /></div>";
	}
}

// ############################# DB ACTION #############################
if ($action == 'stats_restart')
{
	$sql = "UPDATE ". TBL_CARDS_CAT ." SET hits='0' ";
	($tbl_cat==1)? $DB_site->query($sql) : '';
	$sql = "UPDATE ". TBL_BACKGROUNDS ." SET hits='0' ";
	($tbl_pattern==1)? $DB_site->query($sql) : '';
	$sql = "UPDATE ". TBL_POEMS ." SET hits='0' ";
	($tbl_poem==1)? $DB_site->query($sql) : '';
	$sql = "UPDATE ". TBL_STAMPS ." SET hits='0' ";
	($tbl_stamp==1)? $DB_site->query($sql) : '';
	$sql = "UPDATE ". TBL_SOUNDS ." SET hits='0' ";
	($tbl_sound==1)? $DB_site->query($sql) : '';
	$sql = "DELETE FROM ". TBL_STATS_ECARD ." ";
	($tbl_stats==1)? $DB_site->query($sql) : '';
	$sql = "UPDATE ". TBL_CARDS_DATA ." SET hits='0' ";
	($tbl_stats==1)? $DB_site->query($sql) : '';
	result_redirect(CURR_FILE);
}

include(VCARD_ROOT_PATH.'include/admin_header.inc.php');
// ############################# SCREENS #############################
$total_in_db = $DB_site->count_records(TBL_STATS_ECARD);

if ($top == 'post')
{
	$title = $msg['a_postcard'];
	$HTML_site->table_header($msg['a_postcard'],5);
	$total_in_site = $DB_site->count_records("". TBL_CARDS_DATA ."");
	$sql = "SELECT cd.card_id, cd.card_caption, cd.hits, ct.cat_id, ct.cat_name
	FROM ". TBL_CARDS_DATA ." AS cd, ". TBL_CARDS_CAT ." AS ct
	WHERE ct.cat_id=cd.cat_id AND cd.hits!=0
	ORDER BY cd.hits DESC
	LIMIT ". $cfg['admin_stats_toplist'];
	
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db > 0) ? ($row['hits']/$total_in_db) : 0;
		echo "<tr>
		<td>&nbsp;<a href='". $cfg['site_prog_url'] . CREATE_PAGE ."?card_id=". $row['card_id'] ."' target='_blank'><b> ". $row['card_id'] ."</td>
		<td>&nbsp;". stripslashes($row['card_caption']) ."</a></td>
		<td><a href='". $cfg['site_prog_url'] . GBROWSE_PAGE ."?cat_id=". $row['card_id'] ."' target='_blank'>". stripslashes(my_htmlspecialchars($row['cat_name'])) ."</a></td>
		<td>". get_percent($x * 100) . "%</td>
		<td class='stats-hits'>". $row['hits'] ."</td></tr>
		";
		$data["ecard $row[card_id]"] = $row['hits'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if ($top == 'cat')
{
	$title = $msg['a_category'];
	$HTML_site->table_header($msg['a_category'],3);
	$sql = "SELECT SUM(hits) AS sum FROM ". TBL_CARDS_CAT ."";
	$total_in_db = $DB_site->query_first($sql);
	$sql = " SELECT cat_id, cat_name,hits
	FROM ". TBL_CARDS_CAT ."
	WHERE hits!='0'
	ORDER BY hits DESC
	LIMIT ". $cfg['admin_stats_toplist'];
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db['sum'] > 0) ? ($row['hits']/$total_in_db['sum']) : 0;
		echo "<tr>
		<td><b>&nbsp;<a href='". $cfg['site_prog_url'] . GBROWSE_PAGE ."?cat_id=". $row['cat_id'] ."' target='_blank'>". stripslashes(my_htmlspecialchars($row['cat_name'])) ."</a></td>
		<td>". get_percent($x * 100) . "%</td>
		<td class='stats-hits'>". $row['hits'] ."</td></tr>
		";
		$data[$row['cat_name']] = $row['hits'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if ($top == 'template')
{
	$title = $msg['a_clayoutetemplate'];
	$HTML_site->table_header($msg['a_clayoutetemplate'],4);
	$sql = " SELECT count(*) AS count,card_template
		FROM ". TBL_STATS_ECARD ."
		WHERE card_template!=''
		GROUP BY card_template
		ORDER BY count DESC
		LIMIT ". $cfg['admin_stats_toplist'];
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db > 0) ? ($row['count']/$total_in_db) : 0;
		echo "<tr>
		<td>&nbsp;<a href='". $cfg['site_prog_url'] ."templates/". $row['card_template'] .".ihtml'>". $row['card_template'] ."</a></td>
		<td class='stats-hits'>". $row['count'] ."</td>
		<td>". get_percent($x*100) . "%</td>
		</tr>";
		$data["template $row[card_template]"] = $row['count'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if ($top == 'poem')
{
	$title = $msg['a_poem'];
	$HTML_site->table_header($msg['a_poem'],3);
	$total_in_db = $DB_site->query_first("SELECT SUM(hits) AS sum FROM ". TBL_POEMS ."");
	$sql = "SELECT *
		FROM ". TBL_POEMS ."
		WHERE hits!=''
		ORDER BY hits DESC
		LIMIT ". $cfg['admin_stats_toplist'];

	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db['sum'] > 0) ? ($row['hits']/$total_in_db['sum']) : 0;
		echo $row['total']. "<tr>
		<td>&nbsp;<a href='poem.php?action=view&poem_id=". $row['poem_id'] ."&s=$s'>". stripslashes(my_htmlspecialchars($row['poem_title'])) ."</a>
		<td class='stats-hits'>". $row['hits'] ."</td>
		<td>". get_percent($x*100) . "%</b></td>
		</tr>
		";
		$data[$row['poem_title']] = $row['hits'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if ($top == 'stamp')
{
	$title = $msg['a_stamp'];
	$HTML_site->table_header($msg['a_stamp'],3);
	$sql = "SELECT SUM(hits) AS sum FROM ". TBL_STAMPS ."";
	$total_in_db = $DB_site->query_first($sql);
	$sql = "SELECT *
		FROM ". TBL_STAMPS ."
		WHERE hits!=0
		ORDER BY hits DESC
		LIMIT ". $cfg['admin_stats_toplist'];
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db['sum'] > 0) ? ($row['hits']/$total_in_db['sum']) : 0;
		echo "<tr>
		<td>&nbsp;<a href='". $cfg['site_image_url'] . $row['stamp_file'] ."'>". stripslashes(my_htmlspecialchars($row['stamp_name'])) ."</a></td>
		<td class='stats-hits'>". $row['hits'] ."</td>
		<td>". get_percent($x*100) . "%</td>
		</tr>
		";
		$data[$row['stamp_name']] = $row['hits'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if ($top == 'music')
{
	$title = $msg['a_music'];
	$HTML_site->table_header($msg['a_music'],3);
	$sql = "SELECT SUM(hits) AS sum FROM ". TBL_SOUNDS ."";
	$total_in_db = $DB_site->query_first($sql);
	$sql = " SELECT *
		FROM ". TBL_SOUNDS ."
		WHERE hits!=0
		ORDER BY hits DESC
		LIMIT ". $cfg['admin_stats_toplist'];
	
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db['sum'] > 0) ? ($row['hits']/$total_in_db['sum']) : 0;
		echo "<tr>
		<td>&nbsp;<a href='". $cfg['site_music_url'] . $row['sound_file'] ."'>". stripslashes(my_htmlspecialchars($row['sound_name'])) ."</td>
		<td class='stats-hits'>". $row['hits'] ."</td>
		<td>". get_percent($x*100) . "%</b></td>
		</tr>
		";
		$data[$row['sound_name']] = $row['hits'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if ($top == 'pattern')
{
	$title = $msg['a_pattern'];
	$HTML_site->table_header($msg['a_pattern'],3);
	$sql = "SELECT SUM(hits) AS sum FROM ". TBL_BACKGROUNDS ."";
	$total_in_db = $DB_site->query_first($sql);
	$sql = " SELECT *
		FROM ". TBL_BACKGROUNDS ."
		WHERE hits!=''
		ORDER BY hits DESC
		LIMIT ". $cfg['admin_stats_toplist'];
	$data_arr = $DB_site->query($sql);
	
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$x = ($total_in_db['sum'] > 0) ? ($row['hits']/$total_in_db['sum']) : 0;
		echo "<tr>
		<td>&nbsp;<a href='". $cfg['site_image_url'] . $row['pattern_file'] ."'>". stripslashes(my_htmlspecialchars($row['pattern_name'])) . "</a></td>
		<td class='stats-hits'>". $row['hits'] ."</td>
		<td>". get_percent($x*100) . "%</td>
		</tr>
		";
		$data[$row['pattern_name']] = $row['hits'];
	}
	$DB_site->free_result($data_arr);
	$HTML_site->table_footer();
	show_pie_graph($title,$data);
}

if (empty($top))
{
	$total_in_site	= $DB_site->count_records(TBL_CARDS_DATA);
	$total_regusers	= $DB_site->count_records(TBL_USR_PROFILE);
	$total_ratings = $DB_site->count_records(TBL_CARDS_RATING);
	$total_uploadimages = $DB_site->count_records(TBL_ATTACH);
	
	$HTML_site->table_header($msg['a_summary']);
	$HTML_site->form_row($msg['a_stat_total_sent'], $total_in_db);
	$HTML_site->form_row($msg['a_stat_aval_total_cards'], $total_in_site);
	$HTML_site->form_row($msg['a_stat_total_endusers'], $total_regusers);
	$HTML_site->form_row($msg['a_stat_total_uploaded_images'], $total_uploadimages);
	$HTML_site->form_row($msg['a_rating_entries'], $total_ratings);
	$HTML_site->form_row($msg['a_stat_more'],$HTML_site->html_ahref('stats2.php',$msg['a_stat_show_details']));
	$HTML_site->form_row($msg['a_stat_more'],$HTML_site->html_ahref('stats2.php?period=month',$msg['a_month']));
	$HTML_site->form_row($msg['a_stat_more'],$HTML_site->html_ahref('stats2.php?period=day',$msg['a_day']));
	$HTML_site->form_row($msg['a_stat_more'],$HTML_site->html_ahref('stats2.php?period=week',$msg['a_week']));
	$HTML_site->form_row($msg['a_stat_more'],$HTML_site->html_ahref('stats3.php',$msg['a_external_file']));
	$HTML_site->form_row($msg['a_stat_more'],$HTML_site->html_ahref('stats4.php',$msg['a_rating']));
	$HTML_site->table_footer();
	
	$HTML_site->table_header($msg['a_top'] ." ". $cfg['admin_stats_toplist'] ."");
	$HTML_site->form_row($msg['a_postcard'] ,$HTML_site->html_ahref('stats.php?top=post',$msg['a_view']));
	$HTML_site->form_row($msg['a_category'] ,$HTML_site->html_ahref('stats.php?top=cat',$msg['a_view']));
	$HTML_site->form_row($msg['a_clayoutetemplate'] ,$HTML_site->html_ahref('stats.php?top=template',$msg['a_view']));
	$HTML_site->form_row($msg['a_poem'] ,$HTML_site->html_ahref('stats.php?top=poem',$msg['a_view']));
	$HTML_site->form_row($msg['a_stamp'] ,$HTML_site->html_ahref('stats.php?top=stamp',$msg['a_view']));
	$HTML_site->form_row($msg['a_music'] ,$HTML_site->html_ahref('stats.php?top=music',$msg['a_view']));
	$HTML_site->form_row($msg['a_pattern'] ,$HTML_site->html_ahref('stats.php?top=pattern',$msg['a_view']));
	$HTML_site->table_footer();

	$HTML_site->form_header(CURR_FILE,'stats_restart');
	$HTML_site->table_header($msg['a_restart']);
	$HTML_site->form_yesno($msg['a_postcard'] .'  '.' ','tbl_stats',0);
	$HTML_site->form_yesno($msg['a_category'],'tbl_cat',0);
	$HTML_site->form_yesno($msg['a_pattern'],'tbl_pattern',0);
	$HTML_site->form_yesno($msg['a_poem'],'tbl_poem',0);
	$HTML_site->form_yesno($msg['a_music'],'tbl_sound',0);
	$HTML_site->form_yesno($msg['a_stamp'],'tbl_stamp',0);
	$HTML_site->form_note($msg['a_note_stat']);
	$HTML_site->form_footer($msg['a_restart']);
	$HTML_site->table_footer();
}

include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
?>