<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Award System 1.0  by HacNho                         # ||
|| # Copyright (C) 2005 by HacNho, All rights reserved.               # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 3.x                               # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=78934            # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'awards.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'AWARDS',
	'awards_categorybit',
	'awards_category',
	'awards_awardbit',
	'awards_awardusers_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ###################### Start get award_cat_cache #######################

function cache_award_cats($award_cat_id = -1, $depth = 0, $display_award_cat_id=0)
{
	// returns an array of award cats with correct parenting and depth information
	// see makeforumchooser for an example of usage

	global $DB_site, $award_cat_cache, $count;
	static $fcache, $i;
	
	if (!is_array($fcache))
	{
	// check to see if we have already got the results from the database
		$fcache = array();
		$award_cats = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "award_cat
		" . iif($display_award_cat_id, "WHERE award_cat.award_cat_id = $display_award_cat_id", '') . "
			ORDER BY award_cat_displayorder
		");
		while ($award_cat = $DB_site->fetch_array($award_cats))
		{
			if ($display_award_cat_id)
			{
			$award_cat[award_cat_parentid] = -1;
			}
			$fcache["$award_cat[award_cat_parentid]"]["$award_cat[award_cat_displayorder]"]["$award_cat[award_cat_id]"] = $award_cat;
		}
	}

	// database has already been queried
	if (is_array($fcache["$award_cat_id"]))
	{
		foreach ($fcache["$award_cat_id"] AS $holder)
		{
			foreach ($holder AS $award_cat)
			{
				$award_cat_cache["$award_cat[award_cat_id]"] = $award_cat;
				$award_cat_cache["$award_cat[award_cat_id]"]['depth'] = $depth;
				unset($fcache["$award_cat_id"]);
				cache_award_cats($award_cat['award_cat_id'], $depth + 1, $display_award_cat_id);
			} // end foreach ($val1 AS $key2 => $forum)
		} // end foreach ($fcache["$forumid"] AS $key1 => $val1)
	} // end if (found $fcache["$forumid"])
}

// ###################### Start makedepthmark #######################
function construct_depth_mark($depth, $depthchar, $depthmark = '')
{
// repeats the supplied $depthmark for the number of times supplied by $depth
// and appends it onto $depthmark
	for ($i = 0; $i < $depth; $i++)
	{
		$depthmark .= $depthchar;
	}
	return $depthmark;
}
// end functions
// ************************************************************

	globalize($_REQUEST, array(
		'award_cat_id' => INT
	));
	
	//	echo "award_cat_id $award_cat_id";
	$getawards = $DB_site->query("
		SELECT award.*, award_cat.award_cat_title
		FROM " . TABLE_PREFIX . "award AS award
		LEFT JOIN " . TABLE_PREFIX . "award_cat as award_cat USING (award_cat_id)
		" . iif($award_cat_id, "WHERE award.award_cat_id = $award_cat_id", '') . "
		ORDER BY award_cat.award_cat_displayorder,award.award_displayorder
	");
	
		while ($aw = $DB_site->fetch_array($getawards))
	{
		if ($aw['award_cat_id'] == -1)
		{
			$globalaward[] = $aw;
		}
		else
		{
			$awardcache[$aw['award_cat_id']][$aw['award_id']] = $aw;
		}
	}

	$DB_site->free_result($getawards);

			// Obtain list of users of each award
			$allawardusers =  $DB_site->query("
			SELECT u.userid, u.username, au.award_id
			FROM " . TABLE_PREFIX . "award_user AS au
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = au.userid)
			GROUP BY u.userid, u.username, au.award_id
			ORDER BY u.userid
			");
			while( $au = $DB_site->fetch_array($allawardusers))
			{
				$awarduserscache[$au['award_id']][$au['userid']] = $au;
			}
			$DB_site->free_result($allawardusers);	
	
	cache_award_cats(-1,0,$award_cat_id);

	foreach($award_cat_cache AS $key => $award_cat)
	{
//		$award_categories = '';
		$award = array();
		$awardsbits = '';
		if (is_array($awardcache[$award_cat['award_cat_id']]))
		{
			foreach($awardcache[$award_cat['award_cat_id']] AS $award_id => $award)
			{
				$awarduserslist = '';
				if (is_array($awarduserscache[$award['award_id']]))
				{
					foreach($awarduserscache[$award['award_id']] AS $userid => $awardusers)
					{
						eval('$awarduserslist .= ", ' . fetch_template('awards_awardusers_bit') . '";');
					}
				}
				$awarduserslist = substr($awarduserslist , 2); // get rid of initial comma

				exec_switch_bg();
				eval('$awardsbits .= "' . fetch_template('awards_awardbit') . '";');
				
			} //foreach $awardcache
		} //if is_array

			eval('$award_categotybit = "'. construct_depth_mark($award_cat['depth'], '- - ', '') . fetch_template('awards_categorybit') . '";');
			eval('$award_categories .= "' . fetch_template('awards_category') . '";');
	} //foreach $award_cat_cache

$navbits = construct_navbits(array('' => $vbphrase['awards']));
eval('$navbar = "' . fetch_template('navbar') . '";');

construct_forum_jump();

eval('print_output("' . fetch_template('AWARDS') . '");');

?>