<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Award System 1.0  by HacNho                         # ||
|| # Copyright (C) 2005 by HacNho, All rights reserved.               # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 3.x                               # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=78934            # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'award.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['awards']);

// ************************************************************
// start functions

// ###################### Start showimage #######################
function construct_img_html($imagepath, $align = 'middle')
{
	// returns an image based on imagepath
	return '<img src="' . iif(substr($imagepath, 0, 7) != 'http://' AND substr($imagepath, 0, 1) != '/', '../', '') . "$imagepath\" alt=\"$imagepath\" align=\"$align\" border=\"0\"/>";
}

// ###################### Start getAwardCategoryParentOptions #######################

function fetch_award_parent_options($thisitem = '', $parentid = -1, $depth = 1)
{
	global $DB_site, $iawcache, $parentoptions;

	if (!is_array($iawcache))
	{
	// check to see if we have already got the results from the database
		$iawcache = array();
		$awcats = $DB_site->query("
			SELECT award_cat_id, award_cat_title, award_cat_parentid
			FROM " . TABLE_PREFIX . "award_cat
		");
		
		while ($awcat = $DB_site->fetch_array($awcats))
		{
			$iawcache["$awcat[award_cat_parentid]"]["$awcat[award_cat_id]"] = $awcat;
		}
		$DB_site->free_result($awcats);
	}

	if (!is_array($parentoptions))
	{
		$parentoptions = array();
	}

	foreach($iawcache["$parentid"] AS $cat)
	{
		if ($cat['award_cat_id'] != $thisitem)
		{
			$parentoptions["$cat[award_cat_id]"] = str_repeat('--', $depth) . ' ' . $cat['award_cat_title'];
			if (is_array($iawcache["$cat[award_cat_id]"]))
			{
				fetch_award_parent_options($thisitem, $cat['award_cat_id'], $depth + 1);
			}
		}
	}
}

// ###################### Start get award_cat_cache #######################

function cache_award_cats($award_cat_id = -1, $depth = 0, $display_award_cat_id=0)
{
	// returns an array of award cats with correct parenting and depth information

	global $DB_site, $award_cat_cache, $count;
	static $fcache, $i;
	
	if (!is_array($fcache))
	{
	// check to see if we have already got the results from the database
		$fcache = array();
		$award_cats = $DB_site->query("
			SELECT * FROM " . TABLE_PREFIX . "award_cat
			" . iif($display_award_cat_id, "WHERE award_cat_id = $display_award_cat_id", '') . "
			ORDER BY award_cat_displayorder
		");
		while ($award_cat = $DB_site->fetch_array($award_cats))
		{
			if ($display_award_cat_id)
			{
			$award_cat[award_cat_parentid] = -1;
			}
			$fcache["$award_cat[award_cat_parentid]"]["$award_cat[award_cat_displayorder]"]["$award_cat[award_cat_id]"] = $award_cat;
		}
	}

	// database has already been queried
	if (is_array($fcache["$award_cat_id"]))
	{
		foreach ($fcache["$award_cat_id"] AS $holder)
		{
			foreach ($holder AS $award_cat)
			{
				$award_cat_cache["$award_cat[award_cat_id]"] = $award_cat;
				$award_cat_cache["$award_cat[award_cat_id]"]['depth'] = $depth;
				unset($fcache["$award_cat_id"]);
				cache_award_cats($award_cat['award_cat_id'], $depth + 1, $display_award_cat_id);
			} // end foreach ($val1 AS $key2 => $forum)
		} // end foreach ($fcache["$forumid"] AS $key1 => $val1)
	} // end if (found $fcache["$forumid"])
}

// end functions
// ************************************************************

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

// ###################### Start insert #######################
if ($_POST['do'] == 'insert')
{
	globalize($_POST, array(
		'award_name' => STR, 
		'award_desc' => STR, 
		'award_icon_url' => STR, 
		'award_img_url' => STR,
		'award_cat_id' => INT,
		'award_displayorder' => INT
	));

	if (empty($award_name))
	{
		print_stop_message('invalid_award_name_specified');
	}

	$DB_site->query("
	INSERT INTO " . TABLE_PREFIX . "award 
		(award_name, award_desc, award_icon_url, award_img_url, award_cat_id, award_displayorder)	
	VALUES 
		('" . addslashes($award_name) . "','" . addslashes($award_desc) . "','" . addslashes($award_icon_url) . "','" . addslashes($award_img_url) . "'," . intval($award_cat_id) . ',' . intval($award_displayorder) . "
		)");

	define('CP_REDIRECT', 'award.php?do=manage');
	print_stop_message('saved_award_named_x_successfully', $title);
}

// ###################### Start add #######################
if ($_REQUEST['do'] == 'add')
{
	globalize($_REQUEST, array(
		'award_cat_id' => INT,
	));
	print_form_header('award', 'insert');
	print_table_header($vbphrase['add_new_award']);

	print_input_row($vbphrase['award_name'], 'award_name');
	print_input_row($vbphrase['award_description'], 'award_desc');
	print_input_row($vbphrase['award_icon_url'], 'award_icon_url');
	print_input_row($vbphrase['award_image_url'], 'award_img_url');

	$parentoptions = array('-1' => $vbphrase["no_one"]);
	fetch_award_parent_options($category['award_cat_id']);

	print_select_row($vbphrase["award_category"], 'award_cat_id', $parentoptions,  $award_cat_id);
	print_input_row($vbphrase['display_order'],'award_displayorder',1);

	print_submit_row($vbphrase['save']);
}

// ###################### Start do update #######################
if ($_POST['do'] == 'doupdate')
{
	globalize($_POST, array(
	'award_id', 
	'award_name', 
	'award_desc', 
	'award_icon_url', 
	'award_img_url',
	'award_cat_id',
	'award_displayorder'
	));

	if (empty($award_name))
	{
		print_stop_message('invalid_award_name_specified');
	}
	if (empty($award_id))
	{
		print_stop_message('no_awards_defined');
	}

	$DB_site->query("
		UPDATE " . TABLE_PREFIX . "award
		SET award_name = '" . addslashes($award_name) . "',
		award_desc = '" . addslashes($award_desc) . "',
		award_icon_url = '" . addslashes($award_icon_url) . "',
		award_img_url = '" . addslashes($award_img_url) . "',
		award_cat_id = '" . intval($award_cat_id) . "',
		award_displayorder = '" . intval($award_displayorder) . "'
		WHERE award_id = $award_id
	");

	define('CP_REDIRECT', 'award.php?do=manage');
	print_stop_message('saved_award_named_x_successfully', $award_name);

}

// ###################### Start edit #######################
if ($_REQUEST['do'] == 'edit')
{
	globalize($_REQUEST, array('award_id'));

	if (empty($award_id))
	{
		print_stop_message('no_awards_defined');
	}
		
	$award = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "award WHERE award_id = $award_id");

	print_form_header('award', 'doupdate');
	construct_hidden_code('award_id', $award_id);

	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['award_name'], $award['award_name'], $award_id), 2, 0);
	print_input_row($vbphrase['award_name'], 'award_name', $award['award_name']);
	print_input_row($vbphrase['award_description'], 'award_desc', $award['award_desc']);
	print_input_row($vbphrase['award_icon_url'], 'award_icon_url', $award['award_icon_url']);
	print_input_row($vbphrase['award_image_url'], 'award_img_url', $award['award_img_url']);
	
	$parentoptions = array('-1' => $vbphrase["no_one"]);
	fetch_award_parent_options($category['award_cat_id']);
	
	print_select_row($vbphrase["award_category"], 'award_cat_id', $parentoptions,  $award[award_cat_id]);
	print_input_row($vbphrase['display_order'],'award_displayorder',$award[award_displayorder]);
	
	print_submit_row($vbphrase['save']);
}

// ###################### Start Kill #######################

if ($_POST['do'] == 'kill')
{
	globalize($_POST, array('award_id' => INT));

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "award WHERE award_id = $award_id");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "award_user WHERE award_id = $award_id");

	define('CP_REDIRECT', 'award.php?do=manage');
	print_stop_message('deleted_award_successfully');
}

// ###################### Start Remove #######################

if ($_REQUEST['do'] == 'remove')
{
	print_form_header('award', 'kill');
	construct_hidden_code('award_id', $_REQUEST['award_id']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_you_want_to_delete_this_award']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);

}

// ###################### Start do REMOVE award #######################
if ($_POST['do'] == 'doremoveaward')
{
	globalize($_POST, array('award_id','issue_id' => INT));
	foreach($_POST['validate'] AS $issue_id => $status)
	{
	if ($status == -1)
	{
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "award_user WHERE issue_id = $issue_id");
	}
	}
	define('CP_REDIRECT', "award.php?do=awardusers&award_id=$award_id");
	print_stop_message('deleted_award_successfully');
}

// ###################### Start do give award #######################
if ($_POST['do'] == 'dogiveaward')
{
	globalize($_POST, array('award_id', 'awarduserid','awardusername', 'issue_reason'));

	if (empty($awarduserid) AND empty($awardusername))
	{
		print_stop_message('please_complete_required_fields');
	}

	if (!empty($awarduserid))
	{
		$countusers = $DB_site->query_first("
			SELECT COUNT(*) AS users
			FROM " . TABLE_PREFIX . "user
			WHERE userid = $awarduserid
		");
	
		if ($countusers['users'] > 1)
		{
			// show a user if there is just one found
			print_stop_message('invalid_ users_ specified');
		}
		else if ($countusers['users'] == 0)
		{
			// no users found!
			print_stop_message('no_users_matched_your_query');
		}
	}
	else if (!empty($awardusername))
	{
		$user = $DB_site->query_first("
			SELECT userid
			FROM " . TABLE_PREFIX . "user
			WHERE username = '$awardusername'
		");
	$awarduserid = $user['userid'];
	}

	$DB_site->query("
		INSERT INTO " . TABLE_PREFIX . "award_user
		(award_id, userid, issue_reason, issue_time) 
		VALUES ( '$award_id', '$awarduserid', '" . addslashes($issue_reason) . "', " . time() . ")
	");

	define('CP_REDIRECT', "award.php?do=awardusers&award_id=$award_id");
	print_stop_message('saved_award_named_x_successfully', $award_name);
}

// ###################### Start issue award #######################
if ($_REQUEST['do'] == 'awardusers')
{
	globalize($_REQUEST, array('award_id'));
	
	if (empty($award_id))
	{
		print_stop_message('no_awards_defined');
	}

	$award = $DB_site->query_first("
		SELECT award_name, award_desc, award_icon_url, award_img_url 
		FROM " . TABLE_PREFIX . "award 
		WHERE award_id = $award_id
	");

	if (empty($award['award_name']))
	{
		print_stop_message('no_awards_defined');
	}
// print award information

   print_form_header();
   print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['award_name'], $award['award_name'], $award_id), 5, 0);

   echo "
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col width=\"50%\" align=\"$stylevar[left]\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   ";

   print_cells_row(array(
           $vbphrase['award_name'],
           $vbphrase['award_description'],
           $vbphrase['award_icon'],
           $vbphrase['award_image'],
           $vbphrase['manage'],
   ), 1, '', -1);
   
  echo "
  <tr>
		<td class=\"$bgclass\"><strong>$award[award_name]</strong></td>
		<td class=\"$bgclass\"><dfn>{$award[award_desc]}</dfn></td>
		<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($award[award_icon_url], 0, 7) != 'http://' AND substr($award[award_icon_url], 0, 1) != '/', '../', '') . "$award[award_icon_url]\" border=\"0\"></td>
		<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($award[award_img_url], 0, 7) != 'http://' AND substr($award[award_img_url], 0, 1) != '/', '../', '') . "$award[award_img_url]\" border=\"0\"></td>
		<td class=\"$bgclass\">" .
				construct_link_code($vbphrase['edit'], "award.php?$session[sessionurl]do=edit&amp;award_id=$award_id") .
				construct_link_code($vbphrase['delete'], "award.php?$session[sessionurl]do=remove&award_id=$award_id") .
		"</td>

  </tr>";
	print_table_footer();

// print give award to user block
	print_form_header('award', 'dogiveaward');
	construct_hidden_code('award_id', $award_id);

	print_table_header("Give award to user", 2, 0);
	print_input_row($vbphrase['userid'], 'awarduserid');
	print_input_row($vbphrase['username'], 'awardusername');
	print_input_row($vbphrase['award_reason'], 'issue_reason');
	print_submit_row($vbphrase['save']);
	
// print remove user's award block
	print_form_header('award', 'doremoveaward');
	construct_hidden_code('award_id', $award_id);
	print_table_header($vbphrase['users_with_awards'], 4, 0);
   echo "
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col width=\"50%\" align=\"$stylevar[left]\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   ";
	print_cells_row(array(
		$vbphrase['member'],
		$vbphrase['award_reason'],
		$vbphrase['award_time'],
		$vbphrase['remove'],
		), 1, '', -1);

		$awardusers = $DB_site->query("
			SELECT au.*, u.username
			FROM " . TABLE_PREFIX . "award_user AS au
			LEFT JOIN " . TABLE_PREFIX . "user AS u USING (userid)
			WHERE au.award_id=$award_id
		");
		while ($awarduser = $DB_site->fetch_array($awardusers))
		{
		construct_hidden_code('issue_id', $awarduser[issueid]);
			$cell = array();
			$cell[] = "<a href=\"user.php?$session[sessionurl]do=edit&amp;userid=$awarduser[userid]\" target=\"_user\"><b>$awarduser[username]</b>";
			$cell[] = "$awarduser[issue_reason]";
			$cell[] = '<span class="smallfont">' . vbdate($vboptions['dateformat'], $awarduser['issue_time']) . ' ' . vbdate($vboptions['timeformat'], $awarduser['issue_time']) . '</span>';
			$cell[] = "
				<label for=\"d_$awarduser[issue_id]\"><input type=\"radio\" name=\"validate[$awarduser[issue_id]]\" value=\"-1\" id=\"d_$user[userid]\" tabindex=\"1\" />$vbphrase[delete]</label>
				<label for=\"i_$awarduser[issue_id]\"><input type=\"radio\" name=\"validate[$awarduser[issue_id]]\" value=\"0\" id=\"i_$user[userid]\" tabindex=\"1\" checked=\"checked\" />$vbphrase[ignore]</label>
			";
			print_cells_row($cell, 0, '', -4);
		}

    print_submit_row($vbphrase['remove'],0,4);
}

// ###################### Start Update Display Order #######################
if ($_POST['do'] == 'displayorder')
{
	globalize($_POST, array(
		'order',
		'category',
		'doorder' => STR,
		'award_cat_id' => INT,
		'massmove' => INT
	));

	// check that the correct submit button was pressed...
	if ($doorder)
	{
		if (!$massmove AND !is_array($order))
		{
			print_stop_message('please_complete_required_fields');
		}
		else if ($massmove)
		{
			foreach($category AS $id => $award_cat_id)
			{
				if ($award_cat_id)
				{
					$DB_site->query("UPDATE " . TABLE_PREFIX . "award SET award_cat_id = $award_cat_id WHERE award_id = $id");
				}
			}
		}
		else
		{
			$items = $DB_site->query("SELECT award_id,award_displayorder FROM " . TABLE_PREFIX . "award");
			$ordercache = array();
			while ($item = $DB_site->fetch_array($items))
			{
				$ordercache["$item[award_id]"] = $item['award_displayorder'];
			}
			unset($item);
			$DB_site->free_result($items);

			foreach($order AS $id => $award_displayorder)
			{
				$award_displayorder = intval($award_displayorder);
				if ($award_displayorder != $ordercache["$id"])
				{
					$DB_site->query("UPDATE " . TABLE_PREFIX . "award SET award_displayorder = $award_displayorder WHERE award_id = $id");
				}
			}
		}
	}

	define('CP_REDIRECT', "award.php?do=manage");
	print_stop_message('saved_display_order_successfully');
}


// ###################### Start manage awards #######################
if ($_REQUEST['do'] == 'manage')
{
	globalize($_REQUEST, array(
		'award_cat_id' => INT,
		'massmove' => INT
	));

// check award_cat_id
	if ($award_cat_id)
	{
				if (!$check = $DB_site->query_first("
					SELECT award_cat_id 
					FROM " . TABLE_PREFIX . "award_cat 
					WHERE award_cat_id=$award_cat_id
				"))
			{
					print_stop_message('no_awards_defined');
			}
	}
	
	$getawards = $DB_site->query("
		SELECT aw.*, aw_c.award_cat_title
		FROM " . TABLE_PREFIX . "award AS aw
		LEFT JOIN " . TABLE_PREFIX . "award_cat AS aw_c USING (award_cat_id)
		" . iif($award_cat_id, "WHERE aw.award_cat_id = $award_cat_id", '') . "
		ORDER BY aw_c.award_cat_displayorder,aw.award_displayorder
	");
		
	while ($aw = $DB_site->fetch_array($getawards))
	{
		if ($aw['award_cat_id'] == -1)
		{
			$globalaward[] = $aw;
		}
		else
		{
			$awardcache[$aw['award_cat_id']][$aw['award_id']] = $aw;
		}
	}
	$DB_site->free_result($getawards);

	// Obtain list of users of each award
	$allawardusers =  $DB_site->query("
		SELECT u.userid, u.username, au.award_id
		FROM " . TABLE_PREFIX . "award_user AS au
		LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = au.userid)
		GROUP BY u.userid, u.username, au.award_id
		ORDER BY u.userid
	");
	while( $au = $DB_site->fetch_array($allawardusers))
	{
		$awarduserscache[$au['award_id']][$au['userid']] = $au;
	}
	$DB_site->free_result($allawardusers);
	
	cache_award_cats(-1,0,$award_cat_id);

	// display category-specific awards
	print_form_header('award', 'displayorder');
	construct_hidden_code('award_catid', $award_catid);
	construct_hidden_code('massmove', $massmove);
	
	print_table_header($vbphrase['award_manager'], 6);

	// display global awards (awards has category -1)
	if (is_array($globalaward))
	{
		$award_cat_info =
			"\t\t<b>$vbphrase[unclassified_awards]</b> ".
			construct_link_code($vbphrase['add_new_award'], "award.php?$session[sessionurl]do=add&award_cat_id=-1")
			. "\n";
		print_description_row($award_cat_info, 0, 6);

		print_cells_row(array(
			$vbphrase['award_icon'],
			$vbphrase['award_image'],
			$vbphrase['award_name'],
			$vbphrase['users_with_awards'],
			$vbphrase['display_order'],
			$vbphrase['controls']
			), 1, '', -1);

		foreach($globalaward AS $award_id => $award)
		{
			$cell = array();

				$awarduserslist = '';
				if (is_array($awarduserscache[$award['award_id']]))
				{
					foreach($awarduserscache[$award['award_id']] AS $userid => $awardusers)
					{
						$awarduserslist .= ", <a href=\"user.php?do=edit&userid=$awardusers[userid]\">$awardusers[username]</a>";
					}
				}
				$awarduserslist = substr($awarduserslist , 2); // get rid of initial comma
	

		$cell[] = construct_img_html($award['award_icon_url']);
		$cell[] = construct_img_html($award['award_img_url']);
		$cell[] = "<strong>$award[award_name]<dfn>{$award[award_desc]}</dfn></strong>";
		$cell[] = "$awarduserslist";
		$cell[] = "
					<input style=\"text-align: center\" type=\"text\" class=\"bginput\" name=\"order[" . $award[award_id] . "]\" tabindex=\"1\" value=\"$award[award_displayorder]\" size=\"2\" title=\"" . $vbphrase['display_order'] . "\" class=\"smallfont\" />
		";
		$cell[] = "" .
				construct_link_code($vbphrase['edit'], "award.php?$session[sessionurl]do=edit&amp;award_id=$award[award_id]") .
				construct_link_code($vbphrase['delete'], "award.php?$session[sessionurl]do=remove&award_id=$award[award_id]") .
				construct_link_code($vbphrase['manage'], "award.php?$session[sessionurl]do=awardusers&award_id=$award[award_id]") .
				"";
		print_cells_row($cell, 0, '', 1);
		}
		print_table_footer(6, "\n\t <input type=\"submit\" class=\"button\" name=\"doorder\" value=\"" . $vbphrase['save_display_order'] . "\" tabindex=\"1\" />\n\t",'',false);
		print_table_break();
	}

	foreach($award_cat_cache AS $key => $award_cat)
	{
		$award_cat_info = "<b>" . 
			construct_depth_mark($award_cat['depth'], '- - ', '- - ') 
			. "<a href=\"award.php?$session[sessionurl]do=manage&award_cat_id=$award_cat[award_cat_id]\">$award_cat[award_cat_title]</a></b> <span class=\"normal\">".
			construct_link_code($vbphrase['mass_move'], "award.php?$session[sessionurl]do=manage&amp;massmove=1&amp;award_cat_id=$award_cat[award_cat_id]").
			construct_link_code($vbphrase['edit'], "award_cat.php?$session[sessionurl]do=editcat&award_cat_id=$award_cat[award_cat_id]").
			construct_link_code($vbphrase['delete'], "award_cat.php?$session[sessionurl]do=removecat&award_cat_id=$award_cat[award_cat_id]").
			construct_link_code($vbphrase['add_new_award'], "award.php?$session[sessionurl]do=add&award_cat_id=$award_cat[award_cat_id]").
		"</span>\n";

		print_table_header($award_cat_info, 6, 0,'','center');
		if (!empty($award_cat[award_cat_desc]))
		{
			print_description_row($award_cat[award_cat_desc], 0, 6,'','center');
		}
			if (!$massmove)
			{
				$action_title = $vbphrase['display_order'];
			} else {
				$action_title = $vbphrase['mass_move'];
			}		
		print_cells_row(array(
			$vbphrase['award_icon'],
			$vbphrase['award_image'],
			$vbphrase['award_name'],
			$vbphrase['users_with_awards'],
			$action_title,
			$vbphrase['controls']
			), 1, '', -1);

		if (is_array($awardcache[$award_cat['award_cat_id']]))
		{
			foreach($awardcache[$award_cat['award_cat_id']] AS $award_id => $award)
			{
				{
					$cell = array();
		
				$awarduserslist = '';
				if (is_array($awarduserscache[$award['award_id']]))
				{
					foreach($awarduserscache[$award['award_id']] AS $userid => $awardusers)
					{
						$awarduserslist .= ", <a href=\"user.php?do=edit&userid=$awardusers[userid]\">$awardusers[username]</a>";
					}
				}
				$awarduserslist = substr($awarduserslist , 2); // get rid of initial comma
				
				$cell[] = construct_img_html($award['award_icon_url']);
				$cell[] = construct_img_html($award['award_img_url']);
				$cell[] = "<strong>$award[award_name]<dfn>{$award[award_desc]}</dfn></strong>";
				$cell[] = "$awarduserslist";
				if (!$massmove)
				{
							$cell[] = "
										<input style=\"text-align: center\" type=\"text\" class=\"bginput\" name=\"order[" . $award[award_id] . "]\" tabindex=\"1\" value=\"$award[award_displayorder]\" size=\"2\" title=\"" . $vbphrase['display_order'] . "\" class=\"smallfont\" />
							";
				}
					else
				{
					if (!$options)
					{
						$parentoptions = array('-1' => $vbphrase["no_one"]);
						fetch_award_parent_options();
						$options = construct_select_options($parentoptions);
			 		}
					$cell[] = '
						<select name="category[' . $award[award_id] . ']" class="bginput">' . $options . '</select>
					';
				}
				$cell[] = "" .
						construct_link_code($vbphrase['edit'], "award.php?$session[sessionurl]do=edit&amp;award_id=$award[award_id]") .
						construct_link_code($vbphrase['delete'], "award.php?$session[sessionurl]do=remove&award_id=$award[award_id]") .
						construct_link_code($vbphrase['manage'], "award.php?$session[sessionurl]do=awardusers&award_id=$award[award_id]") .
						"";
				print_cells_row($cell, 0, '', 1);
				}
			}
		}
		else {
			print_description_row($vbphrase['no_awards_in_this_category'], 0, 6);
		}
		print_description_row(' ', 0, 6);
	}
	if ($massmove)
	{
		$categories = '<select name="selectall" class="bginput" onchange="js_select_all(this.form);">' . $options . '</select>';
		$buttontext = $vbphrase['mass_move'];
	}
	else
	{
		$buttontext = $vbphrase['save_display_order'];
	}

	print_table_footer(6, "\n\t $categories <input type=\"submit\" class=\"button\" name=\"doorder\" value=\"" . $buttontext . "\" tabindex=\"1\" />\n\t");
}

// #############################################################################

print_cp_footer();

?>