<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || =-=-=-=+_++_+_+_+_+_+_+_+__+_+_++_+_+__+_+_+_+_++_+_+_+_+_+_+_+_=-=-=-=-=-
// || You are downloading a Ripped/Scripts that is not made by http://club2share.com staff.
// || Anything that happen because of running the Ripped/Scripts is not a responsibility of
// || clubshare staff. Downloading and opening the Ripped/Scripts is at your own risk.  Thank
// ||  you very much!  
// ||----------------------------------------------------------------------------
// ||Ripped By : Vb_IPB_RIP Member Of Club2Share
// ||Download  : Club2Share.Com
// ||Price     : $59.99 
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ###################### Global Stuff #########################
$categoryopts = array(
	'open_for_images' => 1,
	'open_for_posts' => 2,
	'allow_post_html' => 4,
	'allow_post_bbcode' => 8,
	'allow_post_smilies' => 16,
	'allow_post_icons' => 32,
	'allow_post_bbimgcode' => 64,
	'allow_post_icons' => 128,
	'allow_custom_html' => 256,
	'allow_custom_bbcode' => 512,
	'allow_custom_smilies' => 1024,
	'allow_custom_bbimgcode' => 2048,
	'allow_desc_html' => 4096,
	'allow_desc_bbcode' => 8192,
	'allow_desc_smilies' => 16384,
	'allow_desc_icons' => 32768,
	'allow_desc_bbimgcode' => 65536,
	'canhavepassword' => 131072,
	'childpass' => 262144,
	'allow_ratings' => 524288,
	'allow_replies' => 1048576
);

$catuseropts = array(
	'allow_view' => 1,
	'allow_upload' => 2,
	'allow_reply' => 4,
	'allow_rating' => 8
);

// ########################## Construct Categories ############################
function construct_categories($catinfo, $cat = 0)
{
	global $counter;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$catarray[] = $cats;

				if ($subcat = construct_categories($catinfo, $cats['catid']))
				{
					$catarray = array_merge($catarray, $subcat);
				}
				$counter--;
			}
		}
	}
	return $catarray;
}

// ########################## Construct Categories ############################
function construct_category_counters($catinfo, $cat = 0, $stoplevel = 1)
{
	global $counter;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat AND $cats['active'])
			{
				$counter++;
				$cats['level'] = $counter;
				if (!$cats['hasimages'] AND $stoplevel != '-1')
				{
					$stopat = $stoplevel + 1;
				}
				if ($subcat = construct_category_counters($catinfo, $cats['catid'], $stoplevel))
				{
					foreach ($subcat AS $subs)
					{
						$cats['imagecount'] += $subs['imagecount'];
						$cats['postcount'] += $subs['postcount'];
						if ($subs['lastimagedateline'] > $cats['lastimagedateline'])
						{
							$cats['lastimagedateline'] = $subs['lastimagedateline'];
							$cats['lastimageid'] = $subs['lastimageid'];
							$cats['lastimageusername'] = $subs['lastimageusername'];
							$cats['lastimageuserid'] = $subs['lastimageuserid'];
							$cats['lastimagetitle'] = $subs['lastimagetitle'];
						}
						if ($subs['lastpostdateline'] > $cats['lastpostdateline'])
						{
							$cats['lastpostid'] = $subs['lastpostid'];
							$cats['lastpostuserid'] = $subs['lastpostuserid'];
							$cats['lastpostusername'] = $subs['lastpostusername'];
							$cats['lastpostimagetitle'] = $subs['lastpostimagetitle'];
							$cats['lastpostdateline'] = $subs['lastpostdateline'];
						}
					}
					$catarray[] = $cats;
					if ($counter < intval($stopat) OR $stoplevel == '-1')
					{
						$catarray = array_merge($catarray, $subcat);
					}
				}
				else
				{
					$catarray[] = $cats;
				}
				$counter--;
			}
		}
	}
	return $catarray;
}

// ################### Function to Print Categories ########################
function print_categories($cat = 0, $catinfo = '', $subscriptions = false)
{
	global $DB_site, $permissions, $categorycache, $vboptions, $vba_options, $vbcollapse, $bbuserinfo, $stylevar, $vbphrase, $show;

	if (!is_array($catinfo))
	{
		$getcats = $DB_site->query("
				SELECT catid, title, description, parent, hasimages, active, parentlist, catimage, imagecount, postcount, catuserid, useroptions, lastimageid, lastimagetitle, lastimageuserid, lastimageusername, lastimagedateline, lastpostid, lastpostuserid, lastpostusername, lastpostimagetitle, lastpostdateline
				FROM " . TABLE_PREFIX ."adv_gallery_categories
				ORDER BY displayorder ASC, hasimages
		");
		while ($categories = $DB_site->fetch_array($getcats))
		{
			$catinfo[] = $categories;
		}

		$DB_site->free_result($getcats);
		unset($categories);
	}

	if ($subscriptions OR $catinfo = construct_category_counters($catinfo, $cat, 1))
	{
		$gallery_modcache = cache_gallery_mods();

		$categoryperms = fetch_category_perms();

		foreach ($catinfo AS $catid => $cats)
		{
			if (!$categoryperms["$cats[catid]"]['canviewgallery'] OR !$cats['active'])
			{
				continue;
			}

			if ($cats['catuserid'])
			{
				if ($cats['catuserid'] != $bbuserinfo['userid'])
				{
					$catuseropts = construct_cat_user_opts($catid, $cats['useroptions']);
					if (!$catuseropts['allow_view'] AND !is_category_mod($cats['parentlist']))
					{
						continue;
					}
				}
				$cats['catusername'] = $categorycache["$cats[catid]"]['username'];
			}

			$catcount++;

			$cats['title'] = stripslashes($cats['title']);
			$cats['description'] = stripslashes($cats['description']);

			if ($cats['hasimages'] == 1)
			{
				if ($show['modcolumn'])
				{
					foreach (explode(',', $cats['parentlist']) AS $parentid)
					{
						if ($gallery_modcache["$parentid"])
						{
							foreach ($gallery_modcache["$parentid"] AS $moderator)
							{
								if (!$donemods["$cats[catid]"]["$moderator[userid]"])
								{
									$donemods["$cats[catid]"]["$moderator[userid]"] = true;

									$comma = '';
									if (!empty($cats['moderator']))
									{
										$comma = ', ';
									}
									eval('$cats[\'moderator\'] .= "$comma' . fetch_template('forumhome_moderator') . '";');
								}
							}
						}
					}
				}
				$cats['moderator'] = str_replace('"member.php', '"' . $vboptions['bburl'] . '/member.php', $cats['moderator']);

				if ($categoryperms["$cats[catid]"]['canviewimages'])
				{
					$cats['imagecount'] = number_format($cats['imagecount']);

					if ($cats['lastimagedateline'])
					{
						$cats['lastimagetitle'] = fetch_trimmed_title(stripslashes($cats['lastimagetitle']), $vba_options['gallery_lastimage_maxlength']);
						$cats['lastupdateddate'] = vbdate($vboptions['dateformat'], $cats['lastimagedateline']);
						$cats['lastupdatedtime'] = vbdate($vboptions['timeformat'], $cats['lastimagedateline']);
						$cats['lastimageusername'] = stripslashes($cats['lastimageusername']);
						$cats['lastimagetitle'] = stripslashes($cats['lastimagetitle']);
					}

				}
				else
				{
					$cats['imagecount'] = 0;
					$cats['lastimageid'] = 0;
				}

				if ($categoryperms["$cats[catid]"]['canviewreplies'])
				{
					$cats['postcount'] = number_format($cats['postcount']);

					if ($cats['lastpostid'])
					{
						$cats['lastpostimagetitle'] = fetch_trimmed_title(stripslashes($cats['lastpostimagetitle']), $vba_options['gallery_lastimage_maxlength']);
						$cats['lastpostusername'] = stripslashes($cats['lastpostusername']);
						$cats['lastpostdate'] = vbdate($vboptions['dateformat'], $cats['lastpostdateline']);
						$cats['lastposttime'] = vbdate($vboptions['timeformat'], $cats['lastpostdateline']);
					}

				}
				else
				{
					$cats['postcount'] = 0;
					$cats['lastpostid'] = 0;
				}

				if ($bbuserinfo['lastvisit'] < $cats['lastimagedateline'])
				{
					$onoff = 'new';
				}
				else
				{
					$onoff = 'old';
				}

				eval('$categorybits .= "' . fetch_template('adv_gallery_categorybit_level' . $cats['level']) . '";');
			}
			else
			{
				$catcollapse = $vbcollapse["collapseobj_catbit_" . $cats['catid'] . ""];
				$catimgcollapse = $vbcollapse["collapseimg_catbit_" . $cats['catid'] . ""];

				eval('$categorybits .= "' . fetch_template('adv_gallery_categorybit_main') . '";');
			}
		}
		unset($catinfo);
	}

	return $categorybits;
}

// ######################### Fetch Category Permissions #######################
function fetch_category_perms($catid = 0, $ugid = '')
{
	global $bbuserinfo, $_BITFIELD, $usergroupcache, $categorycache;

	if ($ugid)
	{
		$usergroupids = $ugid;
	}
	else
	{
		$usergroupids = fetch_membergroupids_array($bbuserinfo);
	}

	if ($catid == 0)
	{
		foreach (array_keys($categorycache) AS $catid)
		{
			foreach($usergroupids AS $usergroupid)
			{
				$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

				if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
				{
					$categoryperms["$catid"] = $usergroupcache["$usergroupid"]['gallerypermissions'];
				}
				else
				{
					$categoryperms["$catid"] |= $thiscatperms["$usergroupid"];
				}
				foreach ($_BITFIELD['usergroup']['gallerypermissions'] AS $option => $value)
				{
					if (!$catperms["$catid"]["$option"])
					{
						$catperms["$catid"]["$option"] = 0;
						if ($categoryperms["$catid"] & $value)
						{
							$catperms["$catid"]["$option"] = 1;
						}
					}
				}
			}
		}
	}
	else
	{
		$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

		foreach($usergroupids AS $usergroupid)
		{
			if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
			{
				$categoryperms = $usergroupcache["$usergroupid"]['gallerypermissions'];
			}
			else
			{
				$categoryperms |= $thiscatperms["$usergroupid"];
			}
		}
		foreach ($_BITFIELD['usergroup']['gallerypermissions'] AS $option => $value)
		{
			$catperms["$option"] = 0;
			if ($categoryperms & $value)
			{
				$catperms["$option"] = 1;
			}
		}
	}

	return $catperms;
}

// ######################## Fetch Private Categories ##########################
function fetch_private_categories()
{
	global $categorycache, $categoryperms, $bbuserinfo;

	$privatecats = array();

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	if (!empty($categoryperms))
	{
		foreach ($categoryperms AS $catid => $cperms)
		{
			if (is_category_mod($catid))
			{
				continue;
			}

			if ($categorycache["$catid"]['catuserid'])
			{
				$useroptions = construct_cat_user_opts($catid, $categorycache["$catid"]['useroptions']);
				if (!$useroptions['allow_view'])
				{
					$privatecats[] = $catid;
				}
			}
			else
			{
				$catopts = construct_cat_opts($catid, $categorycache["$catid"]['options']);

				if ($catopts['canhavepassword'] AND !$categorycache["$catid"]['password'])
				{
					$parentlist = explode(',', $categorycache["$catid"]['parentlist']);

					if (!empty($parentlist))
					{
						foreach ($parentlist AS $pcatid)
						{
							$catopts = construct_cat_opts($pcatid, $categorycache["$pcatid"]['options']);
							if ($categorycache["$pcatid"]['password'] AND $catopts['childpass'])
							{
								if (fetch_bbarray_cookie('catpassword', $pcatid) != md5($bbuserinfo['userid'] . $categorycache["$pcatid"]['password']))
								{
									$privatecats[] = $catid;
								}
							}
						}
					}
				}
			}

			if (($categorycache["$catid"]['password'] AND fetch_bbarray_cookie('catpassword', $catid) != md5($bbuserinfo['userid'] . $categorycache["$catid"]['password'])) OR ((!$cperms['canviewimages'] OR !$cperms['canviewgallery'] OR !$categorycache["$catid"]['active']) AND !is_category_mod($catid)))
			{
				$privatecats[] = $catid;
			}
		}
	}
	return implode(',', $privatecats);
}

// ###################### Function to Construct Categories #####################
function construct_category_perms($catinfo, $cat = 0, $catpermissions)
{
	global $catperms;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$catperms["$cats[catid]"] = $catpermissions["$cats[catid]"];

				if (!empty($catperms["$cats[parent]"]) AND empty($catperms["$cats[catid]"]))
				{
					$catperms["$cats[catid]"] = $catperms["$cats[parent]"];
				}

				construct_category_perms($catinfo, $cats['catid'], $catpermissions);
			}
		}
	}
	return $catperms;
}

// ############################## Update Category Cache ######################
function update_category_cache()
{
	global $DB_site;

	$catsinfo = array();
	$catpermissions = array();

	$permissions = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_permissions");
	while ($permission = $DB_site->fetch_array($permissions))
	{
		$catpermissions["$permission[catid]"]["$permission[usergroupid]"] = $permission['permissions'];
	}

	$DB_site->free_result($permissions);
	unset($permission);

	$users = array();

	$getcats = $DB_site->query("SELECT catid, title, allowusercats, catuserid, parent, parentlist, hasimages, password, active, options, useroptions FROM " . TABLE_PREFIX ."adv_gallery_categories ORDER BY displayorder ASC, hasimages");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		if ($categories['catuserid'])
		{
			$users[] = $categories['catuserid'];
		}
		$catsinfo[] = $categories;
	}

	if (!empty($catpermissions))
	{
		$catperms = construct_category_perms($catsinfo, 0, $catpermissions);
	}

	if (!empty($users))
	{
		$usernamecache = array();
		$getusers = $DB_site->query("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid IN(" . implode(',', $users) . ")");
		while ($user = $DB_site->fetch_array($getusers))
		{
			$usernamecache["$user[userid]"] = $user['username'];
		}
	}

	$categoryinfo = array();

	if ($catinfo = construct_categories($catsinfo, 0, -1))
	{
		foreach ($catinfo AS $cats)
		{
			$categoryinfo["$cats[catid]"] = $cats;
			if ($catperms["$cats[catid]"])
			{
				$categoryinfo["$cats[catid]"]['permissions'] = serialize($catperms["$cats[catid]"]);
			}
			if ($cats['catuserid'])
			{
				$categoryinfo["$cats[catid]"]['username'] = $usernamecache["$cats[catuserid]"];
			}
		}
	}

	$DB_site->free_result($getcats);
	build_datastore('gallery_c_cache', serialize($categoryinfo));
	unset($categories, $catinfo);
}

// ########################### Make Cat Select Field ##########################
function print_cat_select($selectedid = 0, $type)
{
	global $categorycache, $allowedparents, $bbuserinfo, $categoryperms;

	switch ($type)
	{
		case 'catjump':
			$permissions = 'canviewgallery';
			break;

		case 'upload':
			$permissions = 'canuploadimages';
			break;

		case 'search':
			$permissions = 'cansearchimages';
			break;

		case 'managecats':
			$permissions = 'cancreatecategories';
			break;

		case 'admin':
			break;
	}

	if (!is_array($allowedparents))
	{
		$allowedparents = array();
	}

	if (!empty($categorycache))
	{
		if (empty($categoryperms))
		{
			$categoryperms = fetch_category_perms();
		}

		foreach ($categorycache AS $cats)
		{
			if ($type != 'admin' AND $cats['catuserid'] AND $cats['catuserid'] != $bbuserinfo['userid'])
			{
				$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
				if ((!$useroptions['allow_upload'] AND $type == 'upload' OR !$useroptions['allow_view']))
				{
					continue;
				}
			}

			$catopts = construct_cat_opts($cats['catid'], $cats['options']);

			if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $bbuserinfo['userid']))
			{
				$cats['active'] = 0;
				$categorycache["$cats[catid]"]['active'] = 0;
			}

			if (($type == 'managecats' AND !$cats['allowusercats'] AND !in_array($cats['catid'], $allowedparents)) OR !$categoryperms["$cats[catid]"]["$permissions"] OR (!is_category_mod($cats['catid']) AND !$cats['active'] AND $type != 'admin' AND $cats['catid'] != $selectedid) OR (!$catopts['open_for_images'] AND $type == 'upload'))
			{
				continue;
			}

	    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
			$selected = '';
			if ($selectedid == $cats['catid'])
			{
				$selected = 'selected="selected"';
				$class = 'fjsel';
			}
			elseif ($cats['level'] <= 4)
			{
				$class = 'fjdpth' . $cats['level'];
			}
			else
			{
				$class = 'fjdpth';
			}
			if ((!$cats['hasimages'] AND $type == 'upload') OR (!$cats['allowusercats'] AND $cats['catuserid'] != $bbuserinfo['userid'] AND $type == 'managecats'))
			{
				if ($options)
				{
					$endgroup = true;
					$options .= '</optgroup>';
				}
				$options .= '<optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $dashes . '' . stripslashes($cats['title']) . '">';
			}
			else
			{
				$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . stripslashes($cats['title']) . '</option>';
			}
		}
		if ($endgroup)
		{
			$options .= '</optgroup>';
		}
		unset($cats, $catinfo);
	}
	return $options;
}

// ######################### Check Password ############################
function check_category_password($catinfo)
{
	global $bbuserinfo, $categorycache;

	$parentlist = explode(',', $catinfo['parentlist']);

	$catopts = construct_cat_opts($catinfo['catid'], $catinfo['options']);

	if ($catopts['canhavepassword'] AND !$catinfo['password'])
	{
		if (!empty($parentlist))
		{
			foreach ($parentlist AS $catid)
			{
				$catopts = construct_cat_opts($catid, $categorycache["$catid"]['options']);
				if ($categorycache["$catid"]['password'] AND $catopts['childpass'])
				{
					$parcookiepass = fetch_bbarray_cookie('catpassword', $catid);
					$cookiepass = fetch_bbarray_cookie('catpassword', $catid);

					if ($cookiepass == md5($bbuserinfo['userid'] . $categorycache["$catid"]['password']))
					{
						$passgood = true;
					}
				}
			}
		}
		if (!$passgood)
		{
			eval(print_standard_error('adv_gallery_categorypassword'));
		}
	}
	else
	{
		if ($catinfo['password'])
		{
			$cookiepass = fetch_bbarray_cookie('catpassword', $catinfo['catid']);

			if ($cookiepass != md5($bbuserinfo['userid'] . $catinfo['password']))
			{
				eval(print_standard_error('adv_gallery_categorypassword'));
			}
		}
	}
}

// ########################## Fetch Allowed Parents ###########################
function fetch_allowed_parents()
{
	global $bbuserinfo, $categorycache;

	$allowedparents = array();
	if (!empty($categorycache))
	{
		foreach ($categorycache AS $cats)
		{
			if ($cats['catuserid'] == $bbuserinfo['userid'])
			{
				foreach (explode(',', $cats['parentlist']) AS $parentid)
				{
					$allowedparents[] = $parentid;
				}
			}
		}
	}
	return $allowedparents;
}

// ####################### Insert Parentlist ###########################
function insert_category_parentlist($parentid)
{
	global $DB_site, $newcatid;

	if ($parentid)
	{
		$cat = $DB_site->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE catid = '$parentid'");
	}

	if ($cat['parentlist'])
	{
		$plist = $newcatid . ',' . $cat['parentlist'];
	}
	elseif ($parentid)
	{
		$plist = $newcatid . ',' . $parentid;
	}
	else
	{
		$plist = $newcatid;
	}

	$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET parentlist = '$plist' WHERE catid = '$newcatid'");
}

// ##################### Reconstruct Parents ######################
function reconstruct_parents($catid)
{
	rebuild_parents($catid);

	global $DB_site;

	$catarray = array();
	$getcats = $DB_site->query("SELECT catid, parent FROM " . TABLE_PREFIX . "adv_gallery_categories ORDER BY displayorder ASC, hasimages");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		$catarray[] = $categories;
	}

	$DB_site->free_result($getcats);
	unset($categories);

	$catinfo = construct_categories($catarray, $catid, -1);
	if (!empty($catinfo))
	{
		foreach ($catinfo as $cats)
		{
			rebuild_parents($cats['catid']);
		}
	}
}

// ############################## Rebuild Parents #############################
function rebuild_parents($catid = 0)
{
	global $DB_site, $parentlist;
	$getcats = $DB_site->query("SELECT catid, title, parent FROM " . TABLE_PREFIX . "adv_gallery_categories ORDER BY parent");
	while ($catinfo = $DB_site->fetch_array($getcats))
	{
		$cats[] = $catinfo;
	}
	foreach($cats AS $cat)
	{
		if ($catid != 0 AND $cat['catid'] != $catid)
		{
			continue;
		}
		$parentlist = array();
		$parentlist[] = $cat['catid'];
		construct_parents($cats, $cat['parent']);
		$plist = implode(',', $parentlist);

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET parentlist = '$plist' WHERE catid = '$cat[catid]'");

	}
}

// ################ Find Parent Directories ##################
function construct_parents($catinfo, $catid)
{
	global $parentlist;

	foreach ($catinfo AS $subs)
	{
		if ($subs['catid'] == $catid)
		{
			$parentlist[] = $subs['catid'];
			construct_parents($catinfo, $subs['parent']);
		}
	}
	return $parentlist;
}

// ####################### Construct Category Options ########################
function construct_cat_opts($catid, $catint)
{
	global $categoryopts;

	foreach ($categoryopts AS $option => $value)
	{
		$catopts["$option"] = 0;
		if ($catint & $value)
		{
			$catopts["$option"] = 1;
		}
	}
	return $catopts;
}

// ####################### Construct Category User Options ############################
function construct_cat_user_opts($catid, $catint)
{
	global $catuseropts;

	foreach ($catuseropts AS $option => $value)
	{
		$catuseropts["$option"] = 0;
		if ($catint & $value)
		{
			$catuseropts["$option"] = 1;
		}
	}
	return $catuseropts;
}

// ############################ Cache Moderators ############################
function cache_gallery_mods()
{
	global $datastore;

	if ($gallerymods = unserialize($datastore['gal_mod_cache']))
	{
		foreach ($gallerymods AS $moderator)
		{
			$moderator['musername'] = fetch_musername($moderator);
			$gallery_modcache["$moderator[catid]"]["$moderator[userid]"] = $moderator;
		}
	}
	return $gallery_modcache;
}

// ######################### Find Category Mods #########################
function is_category_mod($catarray)
{
	global $bbuserinfo, $permissions;

	if ($permissions['adminpermissions'] & CANCONTROLPANEL)
	{
		$ismoderator = true;
	}
	else
	{
		$gallery_modcache = cache_gallery_mods();

		foreach (explode(',', $catarray) AS $parentid)
		{
			if ($gallery_modcache["$parentid"])
			{
				foreach($gallery_modcache["$parentid"] AS $moderator)
				{
					if ($bbuserinfo['userid'] == $moderator['userid'])
					{
						$ismoderator = true;
					}
				}
			}
		}
	}
	return $ismoderator;
}

// #################### Construct Imagebits ######################
function construct_imagebits(&$images, $highlight = '')
{
	global $vboptions, $vba_options, $session, $stylevar, $bbuserinfo, $vbphrase, $show, $adv_sorturl, $catid, $counter, $cellwidth, $categoryperms, $showfields, $categorycache, $catopts;

	if ($counter > $vba_options['gallery_columns'])
	{
		$imagebits .= '</tr><tr>';
		$counter = 1;
	}

	$images['title'] = stripslashes($images['title']);

	if (!$images['title'])
	{
		$images['title'] = $images['filename'];
	}

	if (!$catopts["$images[catid]"])
	{
		$catopts["$images[catid]"] = construct_cat_opts($images['catid'], $categorycache["$images[catid]"]['options']);
	}

	$images['username'] = stripslashes($images['username']);
	$images['cattitle'] = stripslashes($images['cattitle']);
	$images['views'] = number_format($images['views']);
	$images['filesize'] = make_good_size($images['filesize']);
	$images['dateadded'] = vbdate($vboptions['dateformat'], $images['dateline']);
	$images['timeadded'] = vbdate($vboptions['timeformat'], $images['dateline']);
	$images['description'] = parse_bbcode2(stripslashes($images['description']), $catopts["$images[catid]"]['allow_desc_html'], $catopts["$images[catid]"]['allow_desc_bbimgcode'], $catopts["$images[catid]"]['allow_desc_smilies'], $catopts["$images[catid]"]['allow_desc_bbcode']);

	if ($images['originalfilesize'])
	{
		$images['originalfilesize'] = make_good_size($images['originalfilesize']);
	}

	if ($categoryperms["$images[catid]"]['canviewreplies'])
	{
		$images['lastpostdate'] = vbdate($vboptions['dateformat'], $images['lastpostdateline']);
		$images['lastposttime'] = vbdate($vboptions['timeformat'], $images['lastpostdateline']);
		$images['lastpostusername'] = stripslashes($images['lastpostusername']);
		$images['replies'] = number_format($images['posts']);
	}
	else
	{
		$images['replies'] = 0;
		$images['lastpostdateline'] = 0;
	}

	$images['url'] = construct_image_url($images, 'thumbname');

	$show['sticky'] = false;
	if ($images['sticky'])
	{
		$show['sticky'] = true;
	}

	$show['subscribed'] = false;
	if ($images['subid'])
	{
		$show['subscribed'] = true;
	}

	$images['rating'] = '';
	if ($images['votetotal'] AND $images['votenum'])
	{
		$images['truerating'] = number_format($images['votetotal'] / $images['votenum'], 2);
		$images['rating'] = round($images['truerating']);
	}

	eval('$imagebits .= "' . fetch_template('adv_gallery_imagebit') . '";');

	return $imagebits;
}

// ######################## Construct Empty Imagebits #########################
function construct_empty_imagebits()
{
	global $counter, $vba_options, $cellwidth;

	if ($counter AND $counter != $vba_options['gallery_columns'])
	{
		for ($i = $counter; $i < $vba_options['gallery_columns']; $i++)
		{
			$emptycells .= '<td class="alt1" width="' . $cellwidth . '"></td>';
		}
	}
	return $emptycells;
}

// ############################ Construct Image URL ###########################
function construct_image_url($image, $filename = 'filename', $fulllink = false)
{
	global $vba_options, $server, $userid;

	if (!in_array($image['extension'], array('gif', 'jpg', 'png', 'psd', 'bmp')) OR ($filename == 'thumbname' AND !$image['thumbname']))
	{
		if ($fulllink)
		{
			$url = '<a href="misc.php?' . $session['sessionurl'] . 'do=downloadfile&amp;i=' . $image['imageid'] . '"><img alt="" border="0" src="' . $vba_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif" /></a>';
		}
		else
		{
			$url = $vba_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif';
		}
	}
	else
	{
		if ($fulllink)
		{
			if ($filename == 'originalname')
			{
				$image['width'] = $image['originalwidth'];
				$image['height'] = $image['originalheight'];
			}

			$url = '<img alt="' . $image['title'] . '" border="0" height="' . $image['height'] . '" src="' . $vba_options['gallery_fileurl'] . '/' . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY)) . '/' . $image["$filename"] . '" width="' . $image['width'] . '" />';
		}
		else
		{
			$url = iif($server['upload'] AND $image['thumbname'] == $image['filename'], $vba_options['gallery_userfolderurl'] . '/' . $userid, $vba_options['gallery_fileurl'] . '/' . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY))) . '/' . $image["$filename"];
		}
	}
	return $url;
}

// #################### Check Image ID ##########################
function check_image_id($imageid)
{
	global $vbphrase;

	if (!$imageid)
	{
		$idname = $vbphrase['image'];
		eval(print_standard_error('error_noid'));
	}
}

// ############################## Delete Images ###############################
function delete_images($imageid, $imagearray = '')
{
	global $DB_site, $vba_options;

	if (!empty($imagearray))
	{
		$imageids = array_keys($imagearray);
		$delimages = implode(',', $imageids);
	}
	else
	{
		$delimages = $imageid;

		$imagearray = array();
		$getimages = $DB_site->query_first("SELECT catid, userid, filename, originalname, thumbname, posts FROM " . TABLE_PREFIX . "adv_gallery_images WHERE imageid = '$imageid'");
		$imagearray["$imageid"]['catid'] = $getimages['catid'];
		$imagearray["$imageid"]['userid'] = $getimages['userid'];
		$imagearray["$imageid"]['filename'] = $getimages['filename'];
		$imagearray["$imageid"]['originalname'] = $getimages['originalname'];
		$imagearray["$imageid"]['thumbname'] = $getimages['thumbname'];
		$imagearray["$imageid"]['posts'] = $getimages['posts'];

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET imagecount = imagecount-1, postcount = postcount-" . intval($imagearray['posts']) . " WHERE catid = '$imagearray[catid]'");
	}

	if ($delimages)
	{
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_images WHERE imageid IN ($delimages)");
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE imageid IN ($delimages)");
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_rate WHERE imageid IN ($delimages)");
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_favorites WHERE imageid IN ($delimages)");
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_subscribeimage WHERE imageid IN ($delimages)");

		foreach ($imagearray AS $imageid => $image)
		{
			$folders = preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY);
			$folderstring = implode('/', $folders);

			@unlink($vba_options['gallery_filedirectory'] . '/' . $folderstring . '/' . $image['filename']);

			if ($image['thumbname'])
			{
		  	@unlink($vba_options['gallery_filedirectory'] . '/' . $folderstring . '/' . $image['thumbname']);
			}
			if ($image['originalname'])
			{
		  	@unlink($vba_options['gallery_filedirectory'] . '/' . $folderstring . '/' . $image['originalname']);
			}
		}
	}
}

// ############################ Fetch Image Fields ############################
function fetch_image_fields()
{
	global $showfield, $show;

	$query['fields'] = ' ,images.userid';

	if (!empty($showfield))
	{
		foreach ($showfield AS $fields)
		{
			switch ($fields)
			{
				case 'user':
					$query['fields'] .= ' ,images.username';
					break;
				case 'dimensions':
					$query['fields'] .= ' ,width, height, originalwidth, originalheight';
					break;
				case 'filesize':
					$query['fields'] .= ' ,filesize, originalfilesize';
					break;
				case 'lastpost':
					$query['fields'] .= ', images.lastpostdateline, images.lastpostuserid, images.lastpostusername';
					break;
				case 'rating':
					$query['fields'] .= ', votenum, votetotal';
					break;
				default:
					$query['fields'] .= ', images.' . $fields;
			}
		}
	}

	if ($show['category'])
	{
		$query['fields'] .= ', categories.title AS cattitle';
		$query['tables'] .= 'INNER JOIN ' . TABLE_PREFIX . 'adv_gallery_categories AS categories USING (catid)';
	}

	return $query;
}

// ############################ Construct Orderby #############################
function construct_orderby()
{
	global $orderby, $vba_options, $direction;
	switch($orderby)
	{
		case 'title':
			break;
		case 'dateline':
			break;
		case 'lastpostdateline':
			break;
		case 'imageid':
			break;
		case 'posts':
			break;
		case 'rating':
			$doorderby = 'voteavg ' . $direction . ', votenum';
			break;
		case 'views':
			break;
		default:
			$doorderby = $vba_options['gallery_deforder'];
	}
	if (!$doorderby)
	{
		$doorderby = $orderby;
	}
	return $doorderby;
}

// ########################## Highlight Keywords #########################
function highlight_keywords($string, $keywords, $wholeword)
{
	if ($keywords)
	{
		$words = explode(' ', $keywords);

		foreach ($words as $word)
		{
			if ($wholeword)
			{
				$word = ' ' . $word . ' ';
			}
			$position = 0;

			while ($position !== false)
			{
				$position = strpos(strtolower($string), strtolower($word), $position);

				if ($position !== false)
				{
					$replace_string = substr($string, $position, strlen($word));

					$replace_string = '<span class="highlight">' . $replace_string . '</span>';

					$string = substr_replace($string, $replace_string, $position, strlen($word));

					$position = $position + strlen($replace_string);
				}
			}
		}
	}
	return $string;
}

// ######################### Create Custom Fields #######################
function construct_custom_fieldbits($imageinfo = '', $custominfo = '', $editing = false, $admin = false, $makearray = false)
{
	global $DB_site, $vbphrase, $show, $stylevar;

	if (empty($custominfo))
	{
		$custominfo = array();
		$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields ORDER BY displayorder");
		while ($field = $DB_site->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$DB_site->free_result($customfields);
		unset($field);
	}

	if (!empty($custominfo))
	{
		foreach ($custominfo AS $field)
		{

			if (!$field['required'] AND $show['quickupload'])
			{
				continue;
			}

			$fieldname = 'field' . $field['fieldid'];
			$fieldid = 'field' . $field['fieldid'] . iif($makearray, '[' . $imageinfo['imageid'] . ']');

			if ($field['options'])
			{
				$field['options'] = explode("\n", $field['options']);
			}

			switch($field['type'])
			{
				case 'textarea':
					$inputbox = '<textarea class="bginput" cols="40" name="' . $fieldid . '" rows="6">' . htmlspecialchars($imageinfo["$fieldname"]) . '</textarea>';
					break;

				case 'select':
					$imageinfo["$fieldname"] = htmlspecialchars($imageinfo["$fieldname"]);
					$inputbox = '<select name="' . $fieldid . '">';
					$inputbox .= '<option value="">' . $vbphrase['please_select_one'] . '</option>';
					foreach ($field['options'] AS $option)
					{
						$inputbox .= '<option ' . iif($imageinfo["$fieldname"] == $option, 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
					}
					$inputbox .= '</select>';
					break;

				case 'radio':

					$imageinfo["$fieldname"] = htmlspecialchars($imageinfo["$fieldname"]);

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldid . '" ' . iif($imageinfo["$fieldname"] == $option, 'checked="checked"') . ' type="radio" value="' . $option . '">' . $option . '</label>';
					}
					break;

				case 'checkbox':

					if (!is_array($imageinfo["$fieldname"]) AND !$editing)
					{
						$imageinfo["$fieldname"] = array();
					}
					if ($editing)
					{
						$imageinfo["$fieldname"] = explode(', ', $imageinfo["$fieldname"]);
					}

					$optarray = array();
					foreach ($imageinfo["$fieldname"] AS $okey => $ovalue)
					{
						$optarray[] = htmlspecialchars($ovalue);
					}

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldid . '[]" ' . iif(in_array($option, $optarray), 'checked="checked"') . ' type="checkbox" value="' . $option . '">' . $option . '</label><br />';
					}
					break;

				default:

					$inputbox = '<input class="bginput" name="' . $fieldid . '" size="40" value="' . htmlspecialchars($imageinfo["$fieldname"]) . '" />';

			}

			if ($admin)
			{
				print_label_row($field['title'], $inputbox);
			}
			else
			{
				eval('$cfbits .= "' . fetch_template('adv_gallery_upload_custombits') . '";');
			}
			unset($inputbox);
		}
	}
	return $cfbits;
}

// ######################## Sort custom fields to insert into the db ####################
function construct_customfields_sql($postfields = '', $imageid, $add = true, $makearray = false)
{
	global $DB_site;

	$cfields = array();
	$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields");
	while ($custom = $DB_site->fetch_array($customfields))
	{
		$cfields["$custom[fieldid]"] = $custom;
	}

	if ($cfields)
	{
		foreach ($cfields AS $field => $values)
		{
			$thisfield = 'field' . $field;

			if ($makearray)
			{
				$fieldname = $postfields["$thisfield"]["$imageid"];
			}
			else
			{
				$fieldname = $postfields["$thisfield"];
			}
			if (strlen($fieldname) > $values['maxlength'] AND $values['maxlength'])
			{
				$fieldname = substr($fieldname, 0, $values['maxlength']);
			}

			if (is_array($fieldname))
			{
				$fieldname = implode(', ', $fieldname);
			}

			if ($add)
			{
				$insert['fields'] .= ',' . $thisfield;
				$insert['values'] .= ', \'' . addslashes($fieldname) . '\'';
			}
			else
			{
				$insert['fields'] .= ', ' . $thisfield . ' = \'' . addslashes($fieldname) . '\'';
			}
		}
	}

	if (!empty($insert))
	{
		if ($add)
		{
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_customfields_entries (imgid $insert[fields]) VALUES ($imageid $insert[values])");
		}
		else
		{
			$insert['fields'] = substr($insert['fields'], 1);
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_customfields_entries SET $insert[fields] WHERE imgid = '$imageid'");
		}
	}
}

// ##################### Construct Navbar #################################
if (!function_exists('construct_adv_navbar'))
{
	function construct_adv_navbar($navbits)
	{
		global $vboptions, $vba_options, $vbphrase, $stylevar, $bbuserinfo, $show, $pmbox;

		if (!empty($navbits))
		{
			$navbits = construct_navbits($navbits);
		}
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$navbar = str_replace(
		array(
			'"memberlist.php',
			'"usercp.php',
			'"register.php',
			'"faq.php',
			'"calendar.php',
			'"search.php',
			'"login.php',
			'"forumdisplay.php',
			'"profile.php',
			'"private.php',
			'"subscription.php',
			'"member.php',
			'"online.php',
			'"clientscript',
			'\'misc.php',
			$vboptions['bbtitle'],
			'"' . $vboptions['forumhome'] . '.php'
		),
		array(
			'"' . $vboptions['bburl'] . '/memberlist.php',
			'"' . $vboptions['bburl'] . '/usercp.php',
			'"' . $vboptions['bburl'] . '/register.php',
			'"' . $vboptions['bburl'] . '/faq.php',
			'"' . $vboptions['bburl'] . '/calendar.php',
			'"' . $vboptions['bburl'] . '/search.php',
			'"' . $vboptions['bburl'] . '/login.php',
			'"' . $vboptions['bburl'] . '/forumdisplay.php',
			'"' . $vboptions['bburl'] . '/profile.php',
			'"' . $vboptions['bburl'] . '/private.php',
			'"' . $vboptions['bburl'] . '/subscription.php',
			'"' . $vboptions['bburl'] . '/member.php',
			'"' . $vboptions['bburl'] . '/online.php',
			'"' . $vboptions['bburl'] . '/clientscript',
			'\'' . $vboptions['bburl'] . '/misc.php',
			iif($vba_options['gallery_navbarhomelink'], $vboptions['hometitle'], $vba_options['gallery_title']),
			'"' . iif($vba_options['gallery_navbarhomelink'], $vboptions['homeurl'], $vba_options['gallery_url'])
		), $navbar);
		return $navbar;
	}
}

// ############################ Category Jump #################################
function print_category_jump($dcatid = 0)
{
	global $catid, $vba_options, $_REQUEST, $vbphrase, $stylevar, $gobutton;

	if ($vba_options['gallery_enablecatjump'])
	{
		switch ($_REQUEST['do'])
		{
			case 'favorites':
				break;
			case 'subscriptions':
				break;
			case 'newimages':
				break;
			case 'popimages':
				break;
			case 'search':
				break;
		}

		$action = $_REQUEST['do'];

		if ($_REQUEST['do'] == 'searchresults')
		{
			$action = 'search';
		}

		$doselect["$action"] = 'class="fjsel" selected="selected"';

		$options = print_cat_select($dcatid, 'catjump');

		eval('$categoryjump = "' . fetch_template('adv_gallery_categoryjump') . '";');

		return $categoryjump;
	}
}

// ################# Construct the navbits for browseimages ######################
function construct_dir_navbits($parentlist)
{
	global $categorycache, $vboptions, $navbits;

	foreach (array_reverse(explode(',', $parentlist)) AS $key => $parent)
	{
		foreach ($categorycache AS $cats)
		{
			if ($parent == $cats['catid'])
			{
				$navbits["browseimages.php?$session[sessionurl]c=$cats[catid]"] = stripslashes($cats['title']);
			}
		}
	}
	unset($parentlist);
	return $navbits;
}

// ############################# Adv Sorting URL ##############################
function construct_adv_sort_url($extra = '')
{
	global $_REQUEST;

	if ($_REQUEST['c'])
	{
		$_REQUEST['catid'] = $_REQUEST['c'];
	}

	if (in_array($_REQUEST['do'], array('favorites', 'popimages', 'newimages', 'newposts', 'member')))
	{
		$adv_sorturl = '&amp;catid=' . $_REQUEST['do'];
	}
	elseif ($_REQUEST['do'] == 'searchresults')
	{
		if ($extra)
		{
			$_REQUEST['searchid'] = $extra;
		}
		$adv_sorturl = '&amp;catid=searchresults';
	}
	else
	{
		$adv_sorturl = '&amp;c=' . $_REQUEST['catid'];
	}

	if ($_REQUEST['orderby'])
	{
		$adv_sorturl .= '&amp;orderby=' . $_REQUEST['orderby'];
	}
	if ($_REQUEST['direction'])
	{
		$adv_sorturl .= '&amp;direction=' . $_REQUEST['direction'];
	}
	if ($_REQUEST['searchid'])
	{
		$adv_sorturl .= '&amp;searchid=' . $_REQUEST['searchid'];
	}
	if ($_REQUEST['imageuser'])
	{
		$adv_sorturl .= '&amp;imageuser=' . $_REQUEST['imageuser'];
	}
	if ($_REQUEST['cutoffdate'])
	{
		$adv_sorturl .= '&amp;cutoffdate=' . $_REQUEST['cutoffdate'];
	}

	return $adv_sorturl;
}

// ###################### Initial Update Counters Function ##################
function update_count($catid = 0, $imagecounters = true, $postcounters = true, $licounters = true)
{
	global $DB_site;

	if ($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}

	$getdirs = $DB_site->query("SELECT catid FROM " . TABLE_PREFIX . "adv_gallery_categories $catquery");
	while ($dirs = $DB_site->fetch_array($getdirs))
	{
		if ($licounters)
		{
			$llfields = ', title, dateline, username, userid';
		}
		$imageids = array();
		$getimages = $DB_site->query("SELECT imageid $llfields FROM " . TABLE_PREFIX . "adv_gallery_images WHERE catid = '$dirs[catid]' AND valid = 1 ORDER BY dateline DESC");
		$imagecount = $DB_site->num_rows($getimages);
		$counter = 0;
		while ($images = $DB_site->fetch_array($getimages))
		{
			$counter++;
			if ($counter == 1 AND $licounters)
			{
				$dirs['lastimageid'] = $images['imageid'];
				$dirs['lastimagedate'] = $images['dateline'];
				$dirs['lastimageuser'] = $images['username'];
				$dirs['lastimagetitle'] = $images['title'];
				$dirs['lastimageuserid'] = $images['userid'];
			}
			$imageids[] = $images['imageid'];
		}
		$DB_site->free_result($getimages);
		unset($images);

		$dirs['imagecount'] = $imagecount;

		if (!empty($imageids) AND $postcounters)
		{
			$imageids = implode(',', $imageids);

			$pcounter = 0;
			$getposts = $DB_site->query("
					SELECT postid, posts.userid, posts.username, posts.dateline, images.title
					FROM " . TABLE_PREFIX . "adv_gallery_posts AS posts
					LEFT JOIN " . TABLE_PREFIX . "adv_gallery_images AS images ON (posts.imageid = images.imageid)
					WHERE posts.imageid IN ($imageids) AND visible = 1
					ORDER BY dateline DESC
			");
			$postcount = $DB_site->num_rows($getposts);
			while ($posts = $DB_site->fetch_array($getposts))
			{
				$pcounter++;
				if ($pcounter == 1)
				{
					$dirs['lastpostid'] = $posts['postid'];
					$dirs['lastpostuserid'] = $posts['userid'];
					$dirs['lastpostusername'] = $posts['username'];
					$dirs['lastpostdateline'] = $posts['dateline'];
					$dirs['lastpostimagetitle'] = $posts['title'];
				}

				$postids[] = $posts['postid'];
			}
			$dirs['pcount'] = $postcount;
			unset($imageids);
		}
		else
		{
			$dirs['pcount'] = 0;
		}

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET " . iif($imagecounters, "imagecount = '$dirs[imagecount]'") . "" . iif($postcounters, "" . iif($imagecounters, ',') . "postcount = '$dirs[pcount]' ") . " " . iif($licounters, "" . iif($postcounters OR $imagecounters, ',') . "lastimageid = '$dirs[lastimageid]', lastimagedateline = '$dirs[lastimagedate]', lastimagetitle = '" . addslashes($dirs['lastimagetitle']) . "', lastimageusername = '" . addslashes($dirs['lastimageuser']) . "', lastimageuserid = '$dirs[lastimageuserid]'") . " ,lastpostid = '$dirs[lastpostid]', lastpostuserid = '$dirs[lastpostuserid]', lastpostusername = '" . addslashes($dirs['lastpostusername']) . "', lastpostdateline = '$dirs[lastpostdateline]', lastpostimagetitle = '" . addslashes($dirs['lastpostimagetitle']) . "'
 WHERE catid = '$dirs[catid]' AND hasimages = 1");
	}
}

// ##################### No Permission Page #######################
if (!function_exists('print_adv_no_permission'))
{
	function print_adv_no_permission()
	{
		global $header, $footer, $headinclude, $vboptions, $vba_options, $vbphrase, $bbuserinfo, $stylevar, $url, $session;

		if ($bbuserinfo['userid'])
		{
			eval('$errormessage = "' . fetch_phrase('nopermission_loggedin', PHRASETYPEID_ERROR) . '";');
		}
		else
		{
			$logincode = construct_login_code();
			$scriptpath = htmlspecialchars_uni(SCRIPTPATH);
			$show['permission_error'] = true;
		}
		eval('$content = "' . fetch_template('STANDARD_ERROR') . '";');

		$content = str_replace(
			array(
				'"register.php',
				'"login.php'
			),
			array(
				'"' . $vboptions['bburl'] . '/register.php',
				'"' . $vboptions['bburl'] . '/login.php'
			),
			$content
		);

		eval(print_output($content));
		exit;
	}
}

// ########################### Make Good Size ##########################
function make_good_size($tosize, $dec = '2')
{
	global $vbphrase;
	if (!$tosize)
	{
		$endsize = 0 . ' ' . $vbphrase['bytes'];
	}
	elseif ($tosize >= 1073741824 OR $tosize <= -1073741824)
	{
		$endsize = number_format(($tosize / 1073741824), $dec) . ' GB';
	}
	elseif ($tosize >= 1048576 OR $tosize <= -1048576)
	{
		$endsize = number_format(($tosize / 1048576), $dec) . ' MB';
	}
	elseif ($tosize >= 1024 OR $tosize <= -1024)
	{
		$endsize = number_format(($tosize / 1024), $dec) . ' KB';
	}
	else
	{
		$endsize = number_format($tosize,  $dec) . ' ' . $vbphrase['bytes'];
	}
	return $endsize;
}

// ########################## Validate New Images #############################
function validate_new_images($validateimage)
{
	global $DB_site, $vba_options, $vboptions, $email, $dateline, $username, $userid, $title, $desc, $catid, $keywords, $views, $sendmail, $validateimage, $notes, $imagecat, $thumbname, $filename;

	if (is_array($validateimage))
	{
		$deletearray = array();
		foreach ($validateimage AS $key => $val)
		{
			if ($validateimage["$key"] == 2)
			{
				$deletearray["$key"]['catid'] = $catid["$key"];
				$deletearray["$key"]['filename'] = $filename["$key"];
				$deletearray["$key"]['thumbname'] = $thumbname["$key"];
				$deletearray["$key"]['userid'] = $userid["$key"];

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$mailusername = $username["$key"];
					$imagetitle = $title["$key"];
					$imageid = $key;

					eval(fetch_email_phrases('adv_gallery_deletion', 0));

					vbmail($email["$key"], $subject, $message);
				}
			}
			if ($validateimage["$key"] == 1)
			{

				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET title = '" . addslashes(htmlspecialchars($title["$key"])) . "', description = '" . addslashes(htmlspecialchars($desc["$key"])) . "', keywords = '" . addslashes(htmlspecialchars($keywords["$key"])) . "', views = '$views[$key]', catid = '$catid[$key]', notes = '" . addslashes($notes["$key"]) . "', valid = 1 WHERE imageid = '$key'");

				construct_customfields_sql('', $key, false, true);

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$mailusername = $username["$key"];
					$imagetitle = $title["$key"];
					$imageid = $key;

					eval(fetch_email_phrases('adv_gallery_validation', 0));

					vbmail($email["$key"], $subject, $message);
				}

				$cat = $DB_site->query_first("SELECT lastimagedateline FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE catid = '$catid[$key]'");

				if ($dateline["$key"] > $cat['lastimagedateline'])
				{
					$extrafields = ", lastimageid = '$key', lastimageusername = '" . addslashes($username["$key"]) . "', lastimagetitle = '" . addslashes(htmlspecialchars($title["$key"])) . "', lastimageuserid = '$userid[$key]', lastimagedateline = '$dateline[$key]'";
				}

				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET imagecount = imagecount+1 $extrafields WHERE catid = '$catid[$key]'");

			}
		}
		if (!empty($deletearray))
		{
			delete_images('', $deletearray);
		}
	}
}

// ####################### Validate New Posts ######################
function validate_new_posts()
{
	global $DB_site, $vba_options, $title, $message, $validatepost, $catid, $imageid, $userid, $username, $dateline;

	if (is_array($validatepost))
	{
		foreach ($validatepost AS $key => $val)
		{
			if ($validatepost["$key"] == 2)
			{
				$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE postid = '$key'");
			}

			if ($validatepost["$key"] == 1)
			{

				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_posts SET title = '" . addslashes(htmlspecialchars($title["$key"])) . "', pagetext = '" . addslashes($message["$key"]) . "', visible = 1 WHERE postid = '$key'");

				// Update image info
				$image = $DB_site->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "adv_gallery_images WHERE imageid = '$imageid[$key]'");
				if ($image['lastpostdateline'] < $dateline["$key"])
				{
					$lastpostquery = ", lastpostuserid = '$userid[$key]', lastpostusername = '" . addslashes($username["$key"]) . "', lastpostdateline = '$dateline[$key]'";
				}
				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET posts = posts+1 $lastpostquery WHERE imageid = '$imageid[$key]'");

				// Send email to subscribed users
				send_subscribed_posts($imageid["$key"], true, $userid["$key"], $username["$key"], $message["$key"]);

				// Update directory info
				$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET postcount = postcount+1 WHERE catid = '$catid[$key]'");

				// Update user post counts
				if ($vba_options['gallery_updatepostcount'])
				{
					$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = '$userid[$key]'");
				}
			}
		}
	}
}

// ############################# Subscribed Posts #########################
function send_subscribed_posts($imageid, $moderation = false, $userid = '', $username = '', $message = '')
{
	global $DB_site, $vba_options, $bbuserinfo, $vboptions, $post;

	if ($vba_options['gallery_allowsubscribe'])
	{
		$image = $DB_site->query_first("
				SELECT images.imageid, images.title, posts.dateline, categories.title AS cattitle
				FROM " . TABLE_PREFIX . "adv_gallery_posts AS posts
				INNER JOIN " . TABLE_PREFIX . "adv_gallery_images AS images USING (imageid)
				INNER JOIN " . TABLE_PREFIX . "adv_gallery_categories AS categories USING (catid)
				WHERE images.imageid = '$imageid' ORDER BY dateline DESC LIMIT 1
		");

		if (!$moderation)
		{
			$userid = $bbuserinfo['userid'];
		}
		else
		{
			$post['message'] = $message;
			$bbuserinfo['username'] = $username;
		}

		$image['title'] = stripslashes($image['title']);
		$image['category'] = stripslashes($image['cattitle']);

		$subscriptions = $DB_site->query("
				SELECT subscriptions.userid, username, email
				FROM " . TABLE_PREFIX . "adv_gallery_subscribeimage AS subscriptions
				INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
				WHERE imageid = '$imageid' AND user.lastactivity > '$image[dateline]' AND subscriptions.userid != '$userid'
		");
		while ($subscription = $DB_site->fetch_array($subscriptions))
		{
			eval(fetch_email_phrases('adv_gallery_subscribe_image', 0));
			vbmail($subscription['email'], $subject, $message);
		}
	}
}

?>