/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class KoatBu6
extends MIDlet
implements CommandListener {
    public Game game;
    public static Display display;
    public RecordStore stats;
    public static Command okCommand;
    public static Command okClearCommand;
    public static Command cancelCommand;
    public static Command startCommand;
    public static Command menuCommand;
    public static List mainMenu;

    public KoatBu6() {
        block3: {
            block2: {
                this.game = new Game(this);
                display = Display.getDisplay((MIDlet)this);
                this.game.addCommand(menuCommand);
                if (Game.prevState == Game.STATE_DOT) break block2;
                if (Game.prevState != Game.STATE_INTRO) break block3;
            }
            this.game.addCommand(startCommand);
        }
        mainMenu.append("Back", null);
        mainMenu.append("Restart", null);
        mainMenu.append("Game Stats", null);
        mainMenu.append("Total Stats", null);
        mainMenu.append("Clear Stats", null);
        mainMenu.append("About", null);
        mainMenu.append("Save & Exit", null);
        mainMenu.setCommandListener((CommandListener)new MenuCommandListener());
        this.game.setCommandListener(this);
        this.loadStats();
    }

    public void startApp() {
        Game.state = Game.prevState;
        display.setCurrent((Displayable)this.game);
    }

    public void commandAction(Command c, Displayable s) {
        if (c == menuCommand) {
            display.setCurrent((Displayable)mainMenu);
        } else if (c == startCommand) {
            this.game.startGame();
        }
    }

    public void pauseApp() {
        if (Game.state != Game.STATE_PAUSE) {
            Game.prevState = Game.state;
        }
        Game.state = Game.STATE_PAUSE;
        display.setCurrent(null);
    }

    public void destroyApp(boolean unconditional) {
        this.saveStats();
        int i = 0;
        while (i < 6) {
            Game.player[i].saveState();
            ++i;
        }
        Game.floor.saveState();
        this.game.saveState();
        try {
            this.stats.closeRecordStore();
            Game.playerSaveGame.closeRecordStore();
            Game.floorSaveGame.closeRecordStore();
            Game.gameSaveGame.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        display.setCurrent(null);
        this.game.destroy();
    }

    public void loadStats() {
        Game.statHandsWon = 0;
        Game.statHandsLost = 0;
        Game.statDasWon = 0;
        Game.statDasLost = 0;
        Game.statPointsWon = 0;
        Game.statPointsLost = 0;
        try {
            this.stats = RecordStore.openRecordStore((String)"koatbu6statistics", (boolean)true);
            int numberOfRecords = this.stats.getNumRecords();
            if (numberOfRecords < 1) {
                this.stats.addRecord(Integer.toString(0).getBytes(), 0, 1);
                this.saveStats();
                return;
            }
            byte[] record = this.stats.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(record);
            DataInputStream dis = new DataInputStream(bais);
            Game.statHandsWon = dis.readInt();
            Game.statHandsLost = dis.readInt();
            Game.statDasWon = dis.readInt();
            Game.statDasLost = dis.readInt();
            Game.statPointsWon = dis.readInt();
            Game.statPointsLost = dis.readInt();
            Game.statAklasWon = dis.readInt();
            Game.statAklasLost = dis.readInt();
            Game.statGamesPlayed = dis.readInt();
            Game.statPlayerAklasWon = dis.readInt();
            int i = 0;
            while (i < 5) {
                Game.statPlayerRohas[i] = dis.readInt();
                ++i;
            }
            i = 0;
            while (i < 5) {
                Game.statPlayerRohasWon[i] = dis.readInt();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveStats() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(Game.statHandsWon);
            dos.writeInt(Game.statHandsLost);
            dos.writeInt(Game.statDasWon);
            dos.writeInt(Game.statDasLost);
            dos.writeInt(Game.statPointsWon);
            dos.writeInt(Game.statPointsLost);
            dos.writeInt(Game.statAklasWon);
            dos.writeInt(Game.statAklasLost);
            dos.writeInt(Game.statGamesPlayed);
            dos.writeInt(Game.statPlayerAklasWon);
            int i = 0;
            while (i < 5) {
                dos.writeInt(Game.statPlayerRohas[i]);
                ++i;
            }
            i = 0;
            while (i < 5) {
                dos.writeInt(Game.statPlayerRohasWon[i]);
                ++i;
            }
            byte[] b = baos.toByteArray();
            this.stats.setRecord(1, b, 0, b.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        okCommand = new Command("OK", 4, 1);
        okClearCommand = new Command("OK", 4, 1);
        cancelCommand = new Command("Cancel", 3, 1);
        startCommand = new Command("Start", 4, 1);
        menuCommand = new Command("Menu", 1, 1);
        mainMenu = new List("Menu", 3);
    }

    class MenuCommandListener
    extends Thread
    implements CommandListener {
        MenuCommandListener() {
        }

        public void commandAction(Command c, Displayable d) {
            if (c == List.SELECT_COMMAND) {
                int i;
                if (mainMenu.getSelectedIndex() == 0) {
                    display.setCurrent((Displayable)KoatBu6.this.game);
                } else if (mainMenu.getSelectedIndex() == 1) {
                    Game.prevState = Game.STATE_DOT;
                    Game.state = Game.STATE_DOT;
                    KoatBu6.this.game.endGame();
                    display.setCurrent((Displayable)KoatBu6.this.game);
                } else if (mainMenu.getSelectedIndex() == 2) {
                    String statsString = new String();
                    Form stats = new Form("Game Stats");
                    statsString = statsString + "Your Score: " + Game.score0 + "\n";
                    statsString = statsString + "CPU Score: " + Game.score1 + "\n";
                    statsString = statsString + "Hands Won: " + Game.dasHandsWon + "\n";
                    statsString = statsString + "Hands Lost: " + Game.dasHandsLost + "\n";
                    statsString = statsString + "Aklas Won: " + Game.dasAklasWon + "\n";
                    statsString = statsString + "By Player: " + Game.dasPlayerAklasWon + "\n";
                    statsString = statsString + "Aklas Lost: " + Game.dasAklasLost + "\n\n";
                    statsString = statsString + "Player Team\n";
                    i = 0;
                    while (i < 5) {
                        statsString = statsString + "Roha" + (i + 5) + ": " + Game.dasPlayerRohas[i] + " Won: " + Game.dasPlayerRohasWon[i] + "\n";
                        ++i;
                    }
                    statsString = statsString + "\nCPU Team\n";
                    int i2 = 0;
                    while (i2 < 5) {
                        statsString = statsString + "Roha" + (i2 + 5) + ": " + Game.dasComputerRohas[i2] + " Won: " + Game.dasComputerRohasWon[i2] + "\n";
                        ++i2;
                    }
                    stats.append(statsString);
                    stats.addCommand(okCommand);
                    stats.setCommandListener((CommandListener)this);
                    display.setCurrent((Displayable)stats);
                } else if (mainMenu.getSelectedIndex() == 3) {
                    Form viewStats = new Form("Total Stats");
                    String statsString = new String();
                    statsString = statsString + "Games Played: " + Integer.toString(Game.statGamesPlayed) + "\n";
                    statsString = statsString + "Games Finished: " + Integer.toString(Game.statDasWon + Game.statDasLost) + "\n";
                    statsString = statsString + "Games Won: " + Integer.toString(Game.statDasWon) + "\n";
                    statsString = statsString + "Games Lost: " + Integer.toString(Game.statDasLost) + "\n";
                    statsString = statsString + "Points Won: " + Integer.toString(Game.statPointsWon) + "\n";
                    statsString = statsString + "Points Lost: " + Integer.toString(Game.statPointsLost) + "\n";
                    statsString = statsString + "Hands Won: " + Integer.toString(Game.statHandsWon) + "\n";
                    statsString = statsString + "Hands Lost: " + Integer.toString(Game.statHandsLost) + "\n\n";
                    statsString = statsString + "Rohas by player\n";
                    i = 0;
                    while (i < 5) {
                        statsString = statsString + "Roha" + (i + 5) + ": " + Game.statPlayerRohas[i] + " Won: " + Game.statPlayerRohasWon[i] + "\n";
                        ++i;
                    }
                    statsString = statsString + "Aklas Won: " + Integer.toString(Game.statAklasWon) + "\n";
                    statsString = statsString + "By Player: " + Integer.toString(Game.statPlayerAklasWon) + "\n";
                    statsString = statsString + "Aklas Lost: " + Integer.toString(Game.statAklasLost) + "\n\n";
                    viewStats.append(statsString);
                    viewStats.addCommand(okCommand);
                    viewStats.setCommandListener((CommandListener)this);
                    display.setCurrent((Displayable)viewStats);
                } else if (mainMenu.getSelectedIndex() == 4) {
                    Form clearStats = new Form("Clear Statistics");
                    clearStats.append("Do you want to clear the statistics?");
                    clearStats.addCommand(okClearCommand);
                    clearStats.addCommand(cancelCommand);
                    clearStats.setCommandListener((CommandListener)this);
                    display.setCurrent((Displayable)clearStats);
                } else if (mainMenu.getSelectedIndex() == 5) {
                    Form about = new Form("About");
                    String aboutString = new String();
                    aboutString = aboutString + "Koat Bu 6 v1.0\n";
                    aboutString = aboutString + "By Dot Design\n";
                    aboutString = aboutString + "www.dotdesign.ws\n\n";
                    aboutString = aboutString + "Programming\n";
                    aboutString = aboutString + "Sami AlAwadhi\n\n";
                    aboutString = aboutString + "Graphics\n";
                    aboutString = aboutString + "Eng. Faisal AlAwadhi\n\n";
                    aboutString = aboutString + "Management & Marketing\n";
                    aboutString = aboutString + "Eng. Manar AlHashash\n\n";
                    aboutString = aboutString + "Testing\n";
                    aboutString = aboutString + "Abdullah AlAwadhi\n";
                    aboutString = aboutString + "Khaled AlAwadhi\n";
                    aboutString = aboutString + "Ahmed AlAnbaei\n";
                    aboutString = aboutString + "Othman AlHashash\n\n";
                    aboutString = aboutString + "This game is dedicated to the former members of the Kuwaiti Programming Group (1998-2000).\n";
                    aboutString = aboutString + "We did it first this time!\n\n";
                    aboutString = aboutString + "(c) 2003 Dot Design, All Rights Reserved";
                    about.append(aboutString);
                    about.addCommand(okCommand);
                    about.setCommandListener((CommandListener)this);
                    display.setCurrent((Displayable)about);
                } else if (mainMenu.getSelectedIndex() == 6) {
                    KoatBu6.this.destroyApp(true);
                    KoatBu6.this.notifyDestroyed();
                }
            }
            if (c == okClearCommand) {
                Game.statGamesPlayed = 0;
                Game.statAklasWon = 0;
                Game.statAklasLost = 0;
                Game.statHandsWon = 0;
                Game.statHandsLost = 0;
                Game.statDasWon = 0;
                Game.statDasLost = 0;
                Game.statPointsWon = 0;
                Game.statPointsLost = 0;
                Game.statPlayerAklasWon = 0;
                int i = 0;
                while (i < 5) {
                    Game.statPlayerRohas[i] = 0;
                    Game.statPlayerRohasWon[i] = 0;
                    ++i;
                }
                display.setCurrent((Displayable)KoatBu6.this.game);
            } else if (c == okCommand || c == cancelCommand) {
                display.setCurrent((Displayable)KoatBu6.this.game);
            }
        }
    }
}

