/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;

public class Floor {
    public static int[] px = new int[6];
    public static int[] py = new int[6];
    public static int cardWidth;
    public static int cardHeight;
    public static int firstCard;
    public static int[] card;
    public static int[] player;
    public static int playerCounter;
    public int[] rohas = new int[6];

    public Floor() {
        firstCard = 0;
        playerCounter = 0;
        int w = GUI.clipWidth;
        int h = GUI.clipHeight;
        cardWidth = Images.joker.getWidth();
        cardHeight = Images.joker.getHeight();
        int i = 0;
        while (i < 6) {
            Floor.card[i] = 0;
            Floor.player[i] = 0;
            this.rohas[i] = -1;
            ++i;
        }
        Floor.px[0] = (w >> 1) + GUI.clipWidthOffset;
        Floor.py[0] = (h >> 1) + GUI.clipHeightOffset;
        Floor.px[1] = w - (w >> 2) + GUI.clipWidthOffset;
        Floor.py[1] = (h >> 1) + GUI.clipHeightOffset;
        Floor.px[2] = w - w / 3 + GUI.clipWidthOffset;
        Floor.py[2] = h / 3 + GUI.clipHeightOffset;
        Floor.px[3] = (w >> 1) + GUI.clipWidthOffset;
        Floor.py[3] = (h >> 2) + GUI.clipHeightOffset;
        Floor.px[4] = w / 3 + GUI.clipWidthOffset;
        Floor.py[4] = h / 3 + GUI.clipHeightOffset;
        Floor.px[5] = (w >> 2) + GUI.clipWidthOffset;
        Floor.py[5] = (h >> 1) + GUI.clipHeightOffset;
    }

    public boolean isLegal(int[] hand, int i) {
        int firstCardSign = firstCard & 0xF0;
        int playerCardSign = hand[i] & 0xF0;
        int count = 0;
        boolean jokflag = false;
        boolean mokflag = false;
        int j = 0;
        while (j < 9) {
            if (hand[j] != 0) {
                ++count;
                if (hand[j] == 95) {
                    jokflag = true;
                } else if (hand[j] == 79) {
                    mokflag = true;
                }
            }
            ++j;
        }
        if (card[player[0]] == 0 && (hand[i] == 79 || hand[i] == 95)) {
            if (count == 1) {
                return true;
            }
            return count == 2 && jokflag && mokflag;
        }
        if (card[player[0]] == 0) {
            return true;
        }
        if (card[player[0]] == 95 || card[player[0]] == 79) {
            return true;
        }
        if ((hand[i] & 0xF0) == 64 || (hand[i] & 0xF0) == 80) {
            return true;
        }
        if (firstCardSign == playerCardSign) {
            return true;
        }
        int j2 = 0;
        while (j2 < 9) {
            if (hand[j2] != 0 && (hand[j2] & 0xF0) == firstCardSign) {
                return false;
            }
            ++j2;
        }
        return true;
    }

    public int checkWinner(int hokom) {
        int currentWinner = 0;
        int currentValue = 0;
        int[] cardValues = new int[6];
        int nazla = firstCard & 0xF0;
        if (nazla == 80 || nazla == 64) {
            nazla = card[player[1]] & 0xF0;
        }
        if (nazla == 80 || nazla == 64) {
            nazla = card[player[2]] & 0xF0;
        }
        int i = 0;
        while (i < 6) {
            cardValues[i] = (card[i] & 0xF0) == hokom ? (card[i] & 0xF) * 10 : (card[i] == 79 ? 135 : (card[i] == 95 ? 150 : card[i] & 0xF));
            ++i;
        }
        if (Game.roha == 8 && card[player[0]] == 79) {
            cardValues[Floor.player[0]] = 0;
        }
        if (Game.roha < 8 && (card[player[0]] == 79 || card[player[0]] == 95)) {
            cardValues[Floor.player[0]] = 0;
        }
        if (player[0] != Game.rohaPlayer && (card[player[0]] == 79 || card[player[0]] == 95)) {
            cardValues[Floor.player[0]] = 0;
        }
        int i2 = 0;
        while (i2 < 6) {
            int c = card[i2] & 0xF0;
            if (c != nazla && c != hokom && c != 64 && c != 80) {
                cardValues[i2] = 0;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 6) {
            if (cardValues[i3] > currentValue) {
                currentValue = cardValues[i3];
                currentWinner = i3;
            }
            ++i3;
        }
        return currentWinner;
    }

    public boolean playCard(int _card, int _player) {
        if (firstCard == 0 || firstCard == 79 || firstCard == 95) {
            firstCard = _card;
        }
        Floor.card[_player] = _card;
        Floor.player[Floor.playerCounter] = _player;
        ++playerCounter;
        return false;
    }

    public void clear(Deck deck) {
        firstCard = 0;
        playerCounter = 0;
        int i = 0;
        while (i < 6) {
            deck.insertCard(card[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < 6) {
            Floor.card[i2] = 0;
            Floor.player[i2] = 0;
            this.rohas[i2] = -1;
            ++i2;
        }
    }

    public void clear(Deck deck, Player[] _player) {
        firstCard = 0;
        playerCounter = 0;
        int i = 0;
        while (i < 6) {
            deck.insertCard(card[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < 6) {
            int j = 0;
            while (j < 9) {
                if (_player[i2].hand[j] != 0) {
                    deck.insertCard(_player[i2].hand[j]);
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 6) {
            Floor.card[i3] = 0;
            Floor.player[i3] = 0;
            this.rohas[i3] = -1;
            ++i3;
        }
    }

    public void paint(Graphics g) {
        int[] order = new int[]{0, 1, 2, 3, 5, 4};
        int i = 0;
        while (i < 6) {
            if (card[order[i]] != 0) {
                if ((card[order[i]] & 0xF0) == 80) {
                    g.drawImage(Images.joker, px[order[i]], py[order[i]], 3);
                } else if ((card[order[i]] & 0xF0) == 64) {
                    g.drawImage(Images.moker, px[order[i]], py[order[i]], 3);
                } else {
                    g.drawImage(Images.symbol[(card[order[i]] & 0xF0) >> 4], px[order[i]], py[order[i]], 3);
                    if (this.getColor(card[order[i]]) == 0) {
                        g.setColor(0);
                    } else {
                        g.setColor(0xFF0000);
                    }
                    if (Deck.value[card[order[i]] & 0xF] == "10" && Images.joker.getWidth() < 15) {
                        g.drawString("1", px[order[i]] - (cardWidth >> 1) + 1, py[order[i]] + (cardHeight >> 1) - 2, 36);
                        g.drawString("0", px[order[i]] - (cardWidth >> 1) + 6, py[order[i]] + (cardHeight >> 1) - 2, 36);
                    } else {
                        g.drawString(Deck.value[card[order[i]] & 0xF], px[order[i]] - (cardWidth >> 1) + 2, py[order[i]] + (cardHeight >> 1) - 2, 36);
                    }
                }
            }
            ++i;
        }
    }

    public int getColor(int card) {
        int symbol = card & 0xF0;
        if (symbol == 0 || symbol == 16) {
            return 1;
        }
        if (symbol == 32 || symbol == 48) {
            return 0;
        }
        return 0;
    }

    public void saveState() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(firstCard);
            int i = 0;
            while (i < 6) {
                dos.writeInt(card[i]);
                ++i;
            }
            i = 0;
            while (i < 6) {
                dos.writeInt(player[i]);
                ++i;
            }
            dos.writeInt(playerCounter);
            i = 0;
            while (i < 6) {
                dos.writeInt(this.rohas[i]);
                ++i;
            }
            byte[] b = baos.toByteArray();
            Game.floorSaveGame.setRecord(1, b, 0, b.length);
            baos = null;
            dos = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadState() {
        try {
            byte[] record = Game.floorSaveGame.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(record);
            DataInputStream dis = new DataInputStream(bais);
            firstCard = dis.readInt();
            int i = 0;
            while (i < 6) {
                Floor.card[i] = dis.readInt();
                ++i;
            }
            i = 0;
            while (i < 6) {
                Floor.player[i] = dis.readInt();
                ++i;
            }
            playerCounter = dis.readInt();
            i = 0;
            while (i < 6) {
                this.rohas[i] = dis.readInt();
                ++i;
            }
            record = null;
            bais = null;
            dis = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        card = new int[6];
        player = new int[6];
    }
}

