<?php
/* ******************* Page Messages ******************** */
function message_die($msg_case,$msg_text) {
	global $cfg,$s,$msg,$HTML_site;
	$page_title = $msg['page_error'];
	if (!defined('HEADER_INC'))
	{
		if (!defined('IN_ADMIN'))
		{
			include(VCARD_ROOT_PATH.'include/user_header.inc.php');
		} else {
			include(VCARD_ROOT_PATH.'include/admin_header.inc.php');
		}
	}
	switch($msg_case)
	{
		case GENERAL_MESSAGE:
			$msg_title = $msg['a_information'];
			break;
		case CRITICAL_MESSAGE:
			$msg_title = $msg['a_critical_information'];
			break;
		case GENERAL_ERROR:
			$msg_text = empty($msg_text)? $msg['a_an_error_occured'] : $msg_text;
			$msg_title = $msg['a_general_error'];
			break;
		case CRITICAL_ERROR:
			$msg_text = empty($msg_text)? $msg['a_critical_error'] : $msg_text;
			$msg_title = '<b>' . $msg['a_critical_error'] . '</b>';
			break;
	}
	$HTML_site->table_header($msg_title,1);
	$HTML_site->table_row($msg_text);
	$HTML_site->table_footer();
	if (!defined('FOOTER_INC'))
	{
		if (!defined('IN_ADMIN'))
		{
			include(VCARD_ROOT_PATH.'include/user_footer.inc.php');
		} else {
			include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
		}
	}
	exit;
}
function message_confirm($case,$value='',$extra_txt='') {
	global $msg,$cfg,$HTML_site;
	if (!defined('HEADER_INC'))
	{
		if (!defined('IN_ADMIN'))
		{
			include(VCARD_ROOT_PATH.'include/user_header.inc.php');
		} else {
			include(VCARD_ROOT_PATH.'include/admin_header.inc.php');
		}
	}
	$msg_title = $msg['a_confirm_operation_title'];
	switch($case)
	{
		case ACTION_ADD:
			$msg_text = $msg['a_information'];
			$action = 'add2';
			break;
		case ACTION_EDIT:
			$msg_text = $msg['a_critical_information'];
			$action = 'edit2';
			break;
		case ACTION_DELETE:
			$msg_text = $msg['a_confirm_operation_delete'];
			$action = 'delete2';
			break;
		case ACTION_REINDEX;
			$msg_text = $msg['a_confirm_operation_reindex'];
			$action = 'reindex2';
			break;
	}
	$L_SUBMIT = $msg['a_confirm_operation_imsure'];
	
	$HTML_site->table_border_header();
	$HTML_site->form_header(CURR_FILE,$action);
	$HTML_site->table_header($msg_text);
	$HTML_site->table_row($extra_txt,2);
	foreach ($value as $k => $v)
	{
		$HTML_site->form_hidden($k,$v);
	}
	$HTML_site->form_footer($L_SUBMIT);
	$HTML_site->table_footer();
	$HTML_site->table_border_footer();
	if (!defined('FOOTER_INC'))
	{
		if (!defined('IN_ADMIN'))
		{
			include(VCARD_ROOT_PATH.'include/user_footer.inc.php');
		} else {
			include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
		}
	}
	exit;
}

function redirect_die($url,$parent=false){
	global $msg;
	if (defined('HEADER_INC'))
	{
		echo '<script type="text/javascript">'.( ($parent)?'parent.':'').'window.location="'.$url.'";</script>';
		echo '<p><a href="'.$url.'">'.$msg['a_continue'].'</a></p>';
	} else {
		if (defined('IN_ADMIN'))
		{
			$url = append_sid($url,1);
		}
		@header("Location: $url");
	}
	exit;
}
function result_redirect($url,$action='',$time=4000){
	global $msg,$HTML_site;
	if (!defined('HEADER_INC'))
	{
		if (!defined('IN_ADMIN'))
		{
			include(VCARD_ROOT_PATH.'include/user_header.inc.php');
		} else {
			include(VCARD_ROOT_PATH.'include/admin_header.inc.php');
		}
	}
	switch($action)
	{
		case 'insert':
			$text = $msg['a_result_insert'];
			break;
		case 'delete2':
			$text = $msg['a_result_delete'];
			break;
		case 'update':
			$text = $msg['a_result_update'];
			break;
		case 'resend':
			$text = $msg['a_result_resend'];
			break;
		case 'activate':
			$text = $msg['a_result_activate'];
			break;
		case 'deactivate':
			$text = $msg['a_result_deactivate'];
			break;
		case 'active':
			$text = $msg['a_result_activate'];
			break;
		case 'deactive':
			$text = $msg['a_result_deactivate'];
			break;
		case 'do_upload':
			$text = $msg['a_result_do_upload'];
			break;
		default:
			$text = $msg['a_result_default'];
			break;
	}
	echo '<script type="text/javascript">window.setTimeout(\'redirect2page();\','. $time .');';
	echo 'function redirect2page(url) {';
	echo 'window.location="'. append_sid($url) .'";';
	echo '}</script>';
	echo '<p><br /></p><center><p>'. $text .'</p>';
	echo '<p><a href="'. append_sid($url) .'">'.$msg['a_continue'].'</a></p></center>';
	exit;
	if (!defined('FOOTER_INC'))
	{
		if (!defined('IN_ADMIN'))
		{
			include(VCARD_ROOT_PATH.'include/user_footer.inc.php');
		} else {
			include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
		}
	}
}




?>