<?php
define('IN_VCARD', true);
define('CURR_FILE','backup.php');
include('./lib.inc.php');
include(VCARD_ROOT_PATH.'include/define.inc.php');

if (function_exists("set_time_limit")==1 and get_cfg_var("safe_mode")==0)
{
	@set_time_limit(0);
}

check_lvl_access($curr_cp_user['superuser']);

function tosql_addslashes($str = '', $is_like = FALSE)
{
	if ($is_like)
	{
		$str = str_replace('\\', '\\\\\\\\', $str);
	} else {
		$str = str_replace('\\', '\\\\', $str);
	}
	$str = str_replace('\'', '\\\'', $str);
	return $str;
}

// data dump functions
function sqldumptable($table) {
	global $DB_site;

	$nline = "\n";
	$dump = 'DROP TABLE IF EXISTS ' . $table . ';' . $nline;
	$dump .= 'CREATE TABLE ' . $table . '(' . $nline;
	$firstfield = 1;
	$fields_array = $DB_site->query("SHOW FIELDS FROM $table");
	
	while ($field = $DB_site->fetch_array($fields_array))
	{
		if (!$firstfield)
		{
			$dump .= ",\n";
		} else {
			$firstfield = 0;
		}
		$dump .= " $field[Field] $field[Type]";
		if (isset($field['Default']) && $field['Default'] != '')
		{
			$dump .= ' default \'' . tosql_addslashes($field['Default']) . '\'';
		}
		if ($field['Null'] != 'YES')
		{
			$dump .= ' NOT NULL';
		}
		if (!empty($field[Extra]))
		{
			$dump .= " $field[Extra]";
		}
	}
	$DB_site->free_result($fields_array);

	$keysindex_array = $DB_site->query("SHOW KEYS FROM $table");
	while ($key = $DB_site->fetch_array($keysindex_array))
	{
		$kname=$key['Key_name'];
		if ($kname != "PRIMARY" and $key['Non_unique'] == 0)
		{
			$kname = "UNIQUE|$kname";
		}
		if (!is_array($index[$kname]))
		{
			$index[$kname] = array();
		}
		$index[$kname][] = $key['Column_name'];
	}
	$DB_site->free_result($keysindex_array);
	
	while(list($kname, $columns) = @each($index))
	{
		$dump .= ",\n";
		$colnames = implode($columns,',');
		if ($kname == 'PRIMARY')
		{
			$dump .= " PRIMARY KEY ($colnames)";
		} else {
			if (substr($kname,0,6) == 'UNIQUE')
			{
				$kname = substr($kname,7);
			}
			$dump .= " KEY $kname ($colnames)";
		}
	}
	
	$dump .= "\n);\n\n";

	$rows = $DB_site->query("SELECT * FROM $table");
	$numfields = $DB_site->num_fields($rows);
	
	while ($row = $DB_site->fetch_array($rows))
	{
		$dump .= "INSERT INTO $table VALUES(";
		$fieldcounter=-1;
		$firstfield=1;
		while (++$fieldcounter<$numfields)
		{
			if (!$firstfield)
			{
				$dump .= ',';
			} else {
				$firstfield=0;
			}
			if (!isset($row[$fieldcounter]))
			{
				$dump .= 'NULL';
			} else {
				$dump .= "'". mysql_escape_string($row[$fieldcounter]) ."'";
			}
		}
		$dump .= ");\n";
	}
	$DB_site->free_result($rows);
	return $dump;
}

function checktable($table,$loops=0) {
	global $DB_site,$HTML_site;
	
	$sql = "CHECK TABLE $table ";
	$data_arr = $DB_site->query($sql);
	$HTML_site->table_header("Checking table $table",4);
	echo "<tr><th>Table</th><th>Operation</th><th>Type</th><th>Text</th></tr>\n";
	$error = 0;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		if ($row[2]=='error')
		{
			if ($row[3]=="The handler for the table doesn't support check/repair")
			{
				$row[2] = 'status';
				$row[3] = 'This table does not support check/repair/optimize';
				unset($bgcolor);
				$nooptimize = 1;
			} else {
				$error = 1;
				$bgcolor = 'red';
				unset($nooptimize);
			}
		} else {
			unset($bgcolor);
			unset($nooptimize);
		}
		echo "<tr><td>$row[0]</td><td>$row[1]</td><td bgcolor='$bgcolor'>$row[2]</td><td>$row[3]</td></tr>\n";
	}
	if ($error)
	{
		echo "<tr><th colspan='4' align='center'>Repairing table $table</th></tr>\n";
		$sql = "REPAIR TABLE $table ";
		$row2 = $DB_site->query_first($sql);
		if ($row2[3]!='OK'){
			$bgcolor = 'red';
		} else {
			unset($bgcolor);
		}
		echo "<tr><td>$row2[0]</td><td>$row2[1]</td><td>$row2[2]</td><td bgcolor='$bgcolor'>$row2[3]</td></tr>\n";
	}
	if (($row2[3]=='OK' || !$error) && !$nooptimize)
	{
		echo "<tr><th colspan='4' align='center'>Optimizing table $table</th></tr>\n";
		$sql = "OPTIMIZE TABLE $table ";
		$data_arr = $DB_site->query($sql);
		$error = 0;
		while ($row3 = $DB_site->fetch_array($data_arr))
		{
			if ($row3[2]=='error')
			{
				$error = 1;
				$bgcolor = 'red';
			} else {
				unset($bgcolor);
			}
			echo "<tr><td>$row3[0]</td><td>$row3[1]</td><td bgcolor='$bgcolor'>$r3[2]</td><td>$row3[3]</td></tr>\n";
		}
	}
	if ($error && $loops)
	{
		checktable($table,($loops-1));
	}
	$HTML_site->table_footer();
}


if ($action == 'sqltable')
{
	$data_arr = $DB_site->query("SHOW tables");
	unset($temp_buffer);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		if (!empty($row[0]) && in_array($row[0],$table_arr))
		{
			$temp_buffer .= sqldumptable($row[0])."\n\n\n";
		}
	}
	/* show content */
	// zip file
	$file_name = 'vcardbackup-'.date("Y-m-d");
	if ($compress_type == 'zip') {
	// zip file
		if (VC_PHP_INT_VERSION >= 40000 && @function_exists('gzcompress'))
		{
			$zipfile = new zipfile();
			$zipfile->add_file($temp_buffer, $file_name .'.sql');
			header("Content-disposition: filename=$file_name.zip");
			header("Content-type: unknown/unknown");
			echo $zipfile->file();
		}
	} elseif ($compress_type == 'bzip') {
	// bzipped file
		if (VC_PHP_INT_VERSION >= 40004 && @function_exists('bzcompress'))
		{
			header("Content-disposition: filename=$file_name.bz2");
			header("Content-type: unknown/unknown");
			echo bzcompress($temp_buffer);
		} 
	} elseif ( $compress_type == 'gzip') {
	// gzipped file
		if (VC_PHP_INT_VERSION >= 40004 && @function_exists('gzencode'))
		{
			header("Content-disposition: filename=$file_name.gz");
			header("Content-type: unknown/unknown");
			// without the optional parameter level because it bug
			echo gzencode($temp_buffer);
		}
	// screen
	} else {
		header("Content-disposition: filename=$file_name.sql");
		header("Content-type: unknown/unknown");
		echo $temp_buffer;
	}
	exit;
}

include(VCARD_ROOT_PATH.'include/admin_header.inc.php');

if ($action=='optimize_do')
{
	$sql = "SHOW TABLES ";
	$tables = $DB_site->query($sql);
	if ($iterations)
	{
		$iterations--;
	}
	while ($table=$DB_site->fetch_array($tables))
	{
		$answer = checktable($table[0],$iterations);
		echo '<br /><br />';
		flush();
	}
}

if ($action=='sqlfile')
{
	$filehandle = fopen($filename,"w");
	$result = $DB_site->query("SHOW tables");
	while ($row = $DB_site->fetch_array($result))
	{
		fwrite($filehandle,sqldumptable($row[0])."\n\n\n");
		echo "<p>Dumping $row[0]</p>";
	}
	fclose($filehandle);
	message_die(GENERAL_MESSAGE,$msg['a_dbase_sucess_dumping']);
}


if ($action=='optimize')
{
	$HTML_site->form_header(CURR_FILE,'optimize_do');
	$HTML_site->table_header($msg['a_dboptimize_optimize_db'] .' : '.$dbName );
	$HTML_site->form_note($msg['a_dboptimize_note']);
	if (VC_MYSQL_INT_VERSION > 32314)
	{
		$HTML_site->form_footer($msg['a_dboptimize_start_optimization']);
	} else {
		$HTML_site->form_note($msg['a_dboptimize_mysql_error']. $HTML_site->html_ahref('http://www.mysql.com/doc/en/Repair.html','[HELP]') );
		$HTML_site->table_footer();
	}
}


if (empty($action))
{
	$HTML_site->form_header(CURR_FILE,"sqltable");
	$HTML_site->table_header($msg['a_dbase_tables_to_include']);
	$data_arr = $DB_site->query("SHOW tables");
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$HTML_site->form_checkbox($row[0],'table_arr[]',$row[0],true);
	}
	$options = array();
	if (VC_PHP_INT_VERSION >= 40004)
	{
		$is_zip = (@function_exists('gzcompress'))?1:0;
		$is_gzip = (@function_exists('gzencode'))?1:0;
		$is_bzip = (@function_exists('bzcompress'))?1:0;
		if ($is_zip || $is_gzip || $is_bzip)
		{
			if ($is_zip==1)
			{
				$options['zip'] = '<b>zip</b>ped';
			}
			if ($is_gzip==1)
			{
				$options['gzip'] = '<b>gzip</b>ped';
			}
			if ($is_bzip==1)
			{
				$options['bzip'] = '<b>bizpped</b>ped';
			}
		}
	}
	$HTML_site->form_radio('Save as file','compress_type',$options);
	$HTML_site->form_note($msg['a_note_download_by_browser']);
	$HTML_site->form_footer($msg['a_download']);
	
	$HTML_site->form_header(CURR_FILE,"sqlfile");
	$HTML_site->table_header($msg['a_save_on_server']);
	$HTML_site->form_input("Path and filename on server","filename","./vcardbackup-".date("Y-m-d",time()).".sql",0,60);
	$HTML_site->form_note("<b>PHP must have access to write in THIS directory (vcard/admin/)</b> (chmod 0777)</p> This tool will create a backup file into your webserver from database name: <b>$dbName</b>");
	$HTML_site->form_footer("Save File");

}

include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
?>
