﻿<?php
// ----------------------------------------------------------------------
// Copyright (C) 2006 by Khaled Al-Shamaa.
// http://www.al-shamaa.com/
// ----------------------------------------------------------------------
// LICENSE

// This program is open source product; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Class Name: English-Arabic Transliteration
// Filename:   ArTransliteration.class.php
// Original    Author(s): Khaled Al-Sham'aa <khaled.alshamaa@gmail.com>
// Purpose:    Transliterate English words into Arabic by render them 
//             in the orthography of the Arabic language
// ----------------------------------------------------------------------

class ArTransliteration {
      var $enPatterns     = array();
      var $enReplacements = array();

      function ArTransliteration(){
          array_push($this->enPatterns, '/^au/'); array_push($this->enReplacements, 'ا');
          array_push($this->enPatterns, '/^a/'); array_push($this->enReplacements, 'ا');
          array_push($this->enPatterns, '/^e/'); array_push($this->enReplacements, 'ا');
          array_push($this->enPatterns, '/^i/'); array_push($this->enReplacements, 'ا');
          array_push($this->enPatterns, '/^mc/'); array_push($this->enReplacements, 'ماك');
          array_push($this->enPatterns, '/^o/'); array_push($this->enReplacements, 'او');
          array_push($this->enPatterns, '/^u/'); array_push($this->enReplacements, 'ا');
          array_push($this->enPatterns, '/^wr/'); array_push($this->enReplacements, 'ر');
          array_push($this->enPatterns, '/ough$/'); array_push($this->enReplacements, 'ه');
          array_push($this->enPatterns, '/ough/'); array_push($this->enReplacements, 'او');
          array_push($this->enPatterns, '/alk/'); array_push($this->enReplacements, 'وك');
          array_push($this->enPatterns, '/ois/'); array_push($this->enReplacements, 'وا');
          array_push($this->enPatterns, '/sch/'); array_push($this->enReplacements, 'ش');
          array_push($this->enPatterns, '/tio/'); array_push($this->enReplacements, 'ش');
          array_push($this->enPatterns, '/ai/'); array_push($this->enReplacements, 'اي');
          array_push($this->enPatterns, '/au/'); array_push($this->enReplacements, 'او');
          array_push($this->enPatterns, '/bb/'); array_push($this->enReplacements, 'ب');
          array_push($this->enPatterns, '/cc/'); array_push($this->enReplacements, 'ك');
          array_push($this->enPatterns, '/ce/'); array_push($this->enReplacements, 'س');
          array_push($this->enPatterns, '/ci/'); array_push($this->enReplacements, 'سي');
          array_push($this->enPatterns, '/cy/'); array_push($this->enReplacements, 'سي');
          array_push($this->enPatterns, '/ch/'); array_push($this->enReplacements, 'تش');
          array_push($this->enPatterns, '/ck/'); array_push($this->enReplacements, 'ك');
          array_push($this->enPatterns, '/dd/'); array_push($this->enReplacements, 'د');
          array_push($this->enPatterns, '/ea/'); array_push($this->enReplacements, 'ي');
          array_push($this->enPatterns, '/ee/'); array_push($this->enReplacements, 'ي');
          array_push($this->enPatterns, '/ey/'); array_push($this->enReplacements, 'اي');
          array_push($this->enPatterns, '/ff/'); array_push($this->enReplacements, 'ف');
          array_push($this->enPatterns, '/ge/'); array_push($this->enReplacements, 'ج');
          array_push($this->enPatterns, '/gi/'); array_push($this->enReplacements, 'جي');
          array_push($this->enPatterns, '/gg/'); array_push($this->enReplacements, 'غ');
          array_push($this->enPatterns, '/gh/'); array_push($this->enReplacements, 'ف');
          array_push($this->enPatterns, '/gn/'); array_push($this->enReplacements, 'جن');
          array_push($this->enPatterns, '/ie/'); array_push($this->enReplacements, 'ي');
          array_push($this->enPatterns, '/kk/'); array_push($this->enReplacements, 'ك');
          array_push($this->enPatterns, '/kh/'); array_push($this->enReplacements, 'خ');
          array_push($this->enPatterns, '/ll/'); array_push($this->enReplacements, 'ل');
          array_push($this->enPatterns, '/mm/'); array_push($this->enReplacements, 'م');
          array_push($this->enPatterns, '/nn/'); array_push($this->enReplacements, 'ن');
          array_push($this->enPatterns, '/oo/'); array_push($this->enReplacements, 'و');
          array_push($this->enPatterns, '/ou/'); array_push($this->enReplacements, 'و');
          array_push($this->enPatterns, '/ph/'); array_push($this->enReplacements, 'ف');
          array_push($this->enPatterns, '/pp/'); array_push($this->enReplacements, 'ب');
          array_push($this->enPatterns, '/qu/'); array_push($this->enReplacements, 'كو');
          array_push($this->enPatterns, '/rr/'); array_push($this->enReplacements, 'ر');
          array_push($this->enPatterns, '/sh/'); array_push($this->enReplacements, 'ش');
          array_push($this->enPatterns, '/ss/'); array_push($this->enReplacements, 'س');
          array_push($this->enPatterns, '/th/'); array_push($this->enReplacements, 'ذ');
          array_push($this->enPatterns, '/tt/'); array_push($this->enReplacements, 'ت');
          array_push($this->enPatterns, '/ue$/'); array_push($this->enReplacements, '');
          array_push($this->enPatterns, '/wr/'); array_push($this->enReplacements, 'ر');
          array_push($this->enPatterns, '/a$/'); array_push($this->enReplacements, 'ه');
          array_push($this->enPatterns, '/a/'); array_push($this->enReplacements, 'ا');
          array_push($this->enPatterns, '/b/'); array_push($this->enReplacements, 'ب');
          array_push($this->enPatterns, '/c/'); array_push($this->enReplacements, 'ك');
          array_push($this->enPatterns, '/d/'); array_push($this->enReplacements, 'د');
          array_push($this->enPatterns, '/e/'); array_push($this->enReplacements, '');
          array_push($this->enPatterns, '/f/'); array_push($this->enReplacements, 'ف');
          array_push($this->enPatterns, '/g/'); array_push($this->enReplacements, 'غ');
          array_push($this->enPatterns, '/h/'); array_push($this->enReplacements, 'ه');
          array_push($this->enPatterns, '/i/'); array_push($this->enReplacements, 'ي');
          array_push($this->enPatterns, '/j/'); array_push($this->enReplacements, 'ج');
          array_push($this->enPatterns, '/k/'); array_push($this->enReplacements, 'ك');
          array_push($this->enPatterns, '/l/'); array_push($this->enReplacements, 'ل');
          array_push($this->enPatterns, '/m/'); array_push($this->enReplacements, 'م');
          array_push($this->enPatterns, '/n/'); array_push($this->enReplacements, 'ن');
          array_push($this->enPatterns, '/o/'); array_push($this->enReplacements, 'و');
          array_push($this->enPatterns, '/p/'); array_push($this->enReplacements, 'ب');
          array_push($this->enPatterns, '/q/'); array_push($this->enReplacements, 'ك');
          array_push($this->enPatterns, '/r/'); array_push($this->enReplacements, 'ر');
          array_push($this->enPatterns, '/s$/'); array_push($this->enReplacements, 'س');
          array_push($this->enPatterns, '/s/'); array_push($this->enReplacements, 'س');
          array_push($this->enPatterns, '/t/'); array_push($this->enReplacements, 'ت');
          array_push($this->enPatterns, '/u/'); array_push($this->enReplacements, 'و');
          array_push($this->enPatterns, '/v/'); array_push($this->enReplacements, 'ف');
          array_push($this->enPatterns, '/w/'); array_push($this->enReplacements, 'و');
          array_push($this->enPatterns, '/x/'); array_push($this->enReplacements, 'كس');
          array_push($this->enPatterns, '/y/'); array_push($this->enReplacements, 'ي');
          array_push($this->enPatterns, '/z/'); array_push($this->enReplacements, 'ز');

          array_push($this->enPatterns, '/6/'); array_push($this->enReplacements, 'ط');
          array_push($this->enPatterns, '/t/'); array_push($this->enReplacements, 'ط');
          array_push($this->enPatterns, '/3/'); array_push($this->enReplacements, 'ع');
          array_push($this->enPatterns, '/9/'); array_push($this->enReplacements, 'ص');
          array_push($this->enPatterns, '/7/'); array_push($this->enReplacements, 'ح');
          array_push($this->enPatterns, '/5/'); array_push($this->enReplacements, 'خ');

      }

      function en2ar($string){
          $string = strtolower($string);
          $words  = explode(' ', $string);
          $string = '';

          foreach($words as $word){
              $string .= ' '.preg_replace($this->enPatterns, $this->enReplacements, $word);
          }

          return $string;
      }
}
?>